/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.geometry.Rectangles;
import com.sas.table.Column;
import com.sas.table.ColumnSelection;
import com.sas.table.DataCell;
import com.sas.table.Row;
import com.sas.table.RowSelection;
import com.sas.table.Selection;
import com.sas.table.SelectionChangedEvent;
import com.sas.table.TableElement;
import com.sas.table.TableView;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CellSelection
extends Selection {
    public CellSelection(DataCell anchor) {
        this(anchor, anchor);
    }

    public CellSelection(DataCell anchor, DataCell end) {
        super(anchor, end);
    }

    @Override
    public int count() {
        DataCell anchor = (DataCell)this.getAnchor();
        DataCell end = (DataCell)this.getEnd();
        return (Math.abs(anchor.getColumn().getIndex() - end.getColumn().getIndex()) + 1) * (Math.abs(anchor.getRow().getIndex() - end.getRow().getIndex()) + 1);
    }

    @Override
    public boolean contains(Object item) {
        DataCell cell = (DataCell)item;
        DataCell anchor = (DataCell)this.getAnchor();
        DataCell end = (DataCell)this.getEnd();
        int colIndex = cell.getColumn().getIndex();
        int rowIndex = cell.getRow().getIndex();
        return !(colIndex > anchor.getColumn().getIndex() && colIndex > end.getColumn().getIndex() || colIndex < anchor.getColumn().getIndex() && colIndex < end.getColumn().getIndex() || rowIndex > anchor.getRow().getIndex() && rowIndex > end.getRow().getIndex() || rowIndex < anchor.getRow().getIndex() && rowIndex < end.getRow().getIndex());
    }

    private Rectangle getBounds(DataCell anchor, DataCell end) {
        int bottom;
        int top;
        int right;
        int left;
        int anchorColIndex = anchor.getColumn().getIndex();
        int anchorRowIndex = anchor.getRow().getIndex();
        int endColIndex = end.getColumn().getIndex();
        int endRowIndex = end.getRow().getIndex();
        if (anchorColIndex < endColIndex) {
            left = anchorColIndex;
            right = endColIndex;
        } else {
            left = endColIndex;
            right = anchorColIndex;
        }
        if (anchorRowIndex < endRowIndex) {
            top = anchorRowIndex;
            bottom = endRowIndex;
        } else {
            top = endRowIndex;
            bottom = anchorRowIndex;
        }
        return new Rectangle(left, top, right - left + 1, bottom - top + 1);
    }

    public ColumnSelection getColumns() {
        DataCell anchor = (DataCell)this.getAnchor();
        DataCell end = (DataCell)this.getEnd();
        return new ColumnSelection(anchor.getColumn(), end.getColumn());
    }

    @Override
    public Rectangle getDisplayedBounds() {
        Rectangle bounds = this.getColumns().getDisplayedBounds();
        if (!bounds.isEmpty()) {
            bounds = bounds.intersection(this.getRows().getDisplayedBounds());
        }
        return bounds;
    }

    @Override
    public Enumeration getItems() {
        return new CellSelectionEnumeration();
    }

    public RowSelection getRows() {
        DataCell anchor = (DataCell)this.getAnchor();
        DataCell end = (DataCell)this.getEnd();
        return new RowSelection(anchor.getRow(), end.getRow());
    }

    private CellSelection getSelection(Rectangle bounds) {
        TableView tv = this.getTableView();
        return new CellSelection(tv.getCell(tv.getRow(bounds.y), tv.getColumn(bounds.x)), tv.getCell(tv.getRow(bounds.y + bounds.height - 1), tv.getColumn(bounds.x + bounds.width - 1)));
    }

    @Override
    public void setEnd(Object newValue) {
        super.setEnd((DataCell)newValue);
    }

    @Override
    protected Selection newSelection(TableElement anchor, TableElement end) {
        return new CellSelection((DataCell)anchor, (DataCell)end);
    }

    @Override
    protected void onEndChanged(TableElement oldValue, TableElement newValue) {
        int i;
        DataCell anchor = (DataCell)this.getAnchor();
        Rectangle oldRect = this.getBounds(anchor, (DataCell)oldValue);
        Rectangle newRect = this.getBounds(anchor, (DataCell)newValue);
        Rectangle[] r1 = new Rectangle[4];
        Rectangle[] r2 = new Rectangle[4];
        int[] nr1 = new int[]{0};
        int[] nr2 = new int[]{0};
        Rectangles.intersect((Rectangle)oldRect, (Rectangle)newRect, null, (Rectangle[])r1, (int[])nr1, (Rectangle[])r2, (int[])nr2);
        Selection[] additions = null;
        Selection[] deletions = null;
        if (nr2[0] != 0) {
            additions = new Selection[nr2[0]];
            for (i = 0; i < nr2[0]; ++i) {
                additions[i] = this.getSelection(r2[i]);
            }
        }
        if (nr1[0] != 0) {
            deletions = new Selection[nr1[0]];
            for (i = 0; i < nr1[0]; ++i) {
                deletions[i] = this.getSelection(r1[i]);
            }
        }
        this.fireContentsChanged(new SelectionChangedEvent(this, additions, deletions));
    }

    private class CellSelectionEnumeration
    implements Enumeration {
        private Column m_col;
        private Column m_startCol;
        private Column m_endCol;
        private Row m_row;
        private Row m_startRow;
        private Row m_endRow;

        public CellSelectionEnumeration() {
            DataCell anchor = (DataCell)CellSelection.this.getAnchor();
            DataCell end = (DataCell)CellSelection.this.getEnd();
            Column anchorCol = anchor.getColumn();
            Row anchorRow = anchor.getRow();
            Column endCol = end.getColumn();
            Row endRow = end.getRow();
            if (anchorCol.getIndex() < endCol.getIndex()) {
                this.m_startCol = anchorCol;
                this.m_endCol = endCol;
            } else {
                this.m_startCol = endCol;
                this.m_endCol = anchorCol;
            }
            this.m_col = this.m_startCol;
            if (anchorRow.getIndex() < endRow.getIndex()) {
                this.m_startRow = anchorRow;
                this.m_endRow = endRow;
            } else {
                this.m_startRow = endRow;
                this.m_endRow = anchorRow;
            }
            this.m_row = this.m_startRow;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_row != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.m_row == null) {
                throw new NoSuchElementException();
            }
            DataCell nextElement = this.m_row.getCell(this.m_col.getIndex());
            if (this.m_col.equals(this.m_endCol)) {
                if (this.m_row.equals(this.m_endRow)) {
                    this.m_row = null;
                } else {
                    this.m_row = this.m_row.nextRow();
                    this.m_col = this.m_startCol;
                }
            } else {
                this.m_col = this.m_col.nextColumn();
            }
            return nextElement;
        }
    }
}

