/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.wizard;

import com.sas.collection.Dictionary;
import com.sas.swing.visuals.wizard.RB;
import com.sas.swing.visuals.wizard.Wizard;
import com.sas.swing.visuals.wizard.WizardPageInterface;
import com.sas.text.Message;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public class WizardPageDeck
extends JPanel {
    public static final String RB_KEY = "WizardPageDeck.";
    protected Vector path;
    protected Dictionary pageTable;
    protected Vector pageShownList;
    protected String currentPageName;
    protected CardLayout cardLayout;
    protected Wizard wizard;

    public WizardPageDeck(Wizard wizard) {
        this.wizard = wizard;
        this.path = new Vector();
        this.pageTable = new Dictionary();
        this.pageShownList = new Vector();
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
    }

    public String getFirstPageName() {
        if (this.path.isEmpty()) {
            return null;
        }
        return (String)this.path.firstElement();
    }

    public String getLastPageName() {
        if (this.path.isEmpty()) {
            return null;
        }
        return (String)this.path.lastElement();
    }

    public String getPreviousPageName() {
        int currentPageIndex = this.path.indexOf(this.currentPageName);
        if (currentPageIndex == this.path.indexOf(this.path.firstElement())) {
            return null;
        }
        return (String)this.path.elementAt(--currentPageIndex);
    }

    public String getNextPageName() {
        int currentPageIndex = this.path.indexOf(this.currentPageName);
        if (currentPageIndex == this.path.indexOf(this.path.lastElement())) {
            return null;
        }
        return (String)this.path.elementAt(++currentPageIndex);
    }

    public String getCurrentPageName() {
        return this.currentPageName;
    }

    public void showPage(String pageName, int directionFlag) {
        WizardPageInterface page;
        if (this.path.contains(pageName)) {
            if ((directionFlag & 8) != 0 && this.currentPageName != null) {
                WizardPageInterface currentPage = (WizardPageInterface)this.pageTable.get((Object)this.currentPageName);
                currentPage.hidePage(directionFlag);
            }
            this.currentPageName = pageName;
            if (this.wizard.whenToCreatePage == 1 && this.pageTable.get((Object)pageName) == null) {
                page = this.wizard.createNamedPage(pageName);
                this.pageTable.set((Object)pageName, (Object)page);
                this.addPagesToDeck(new String[]{pageName});
            }
            this.firePropertyChange("currentPageNumber", null, new Integer(this.getCurrentPageNumber()));
            page = (WizardPageInterface)this.pageTable.get((Object)pageName);
            if (!this.pageShownList.contains(pageName)) {
                page.showPage(directionFlag | 4);
                this.pageShownList.addElement(pageName);
            } else {
                page.showPage(directionFlag);
            }
        } else {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"showPage.ex.txt"), (Object)pageName));
        }
        this.wizard.setImage(page.getStatusImage());
        this.wizard.enableButtons();
        this.cardLayout.show(this, pageName);
    }

    public void clearPath() {
        this.path.removeAllElements();
    }

    public void addToPath(String[] pageNames) {
        if (pageNames == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"addToPath.ex.txt"));
        }
        for (int i = 0; i < pageNames.length; ++i) {
            this.path.addElement(pageNames[i]);
        }
        this.firePropertyChange("pageCount", null, new Integer(this.getPageCount()));
        if (this.wizard.whenToCreatePage == 2) {
            this.addPagesToDeck(pageNames);
        }
    }

    protected void addPagesToDeck(String[] pageNames) {
        for (int i = 0; i < pageNames.length; ++i) {
            WizardPageInterface page = this.getPage(pageNames[i]);
            this.add((Component)page, pageNames[i]);
        }
    }

    public void appendPath(String[] pageNames) {
        int i;
        if (pageNames == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"appendPath.ex.txt"));
        }
        int tailSize = this.path.indexOf(this.path.lastElement()) - this.path.indexOf(this.currentPageName);
        for (i = 0; i < tailSize; ++i) {
            String name = (String)this.path.lastElement();
            WizardPageInterface page = this.getPage(name);
            if (page != null) {
                this.remove((Component)page);
            }
            this.path.removeElement(name);
        }
        for (i = 0; i < pageNames.length; ++i) {
            if (this.path.contains(pageNames[i])) {
                throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"appendPath2.ex.txt"), (Object)pageNames[i]));
            }
            this.path.addElement(pageNames[i]);
        }
        this.firePropertyChange("pageCount", null, new Integer(this.getPageCount()));
        if (this.wizard.whenToCreatePage == 2) {
            this.addPagesToDeck(pageNames);
        }
        this.wizard.buttonPanel.enableButtons();
    }

    public void addPage(String pageName, WizardPageInterface page) {
        if (!(this.pageTable.containsKey((Object)pageName) || page != null && this.pageTable.contains((Object)page))) {
            this.pageTable.set((Object)pageName, (Object)page);
        } else {
            if (this.pageTable.containsKey((Object)pageName)) {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"addPage.ex.txt"), (Object)pageName));
            }
            if (page != null && this.pageTable.contains((Object)page)) {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"addPage2.ex.txt"));
            }
        }
    }

    public void removePage(String pageName) {
        if (this.path.contains(pageName)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"removePage.ex.txt"), (Object)pageName));
        }
        WizardPageInterface page = this.getPage(pageName);
        if (page != null) {
            this.remove((Component)page);
        }
        if (this.pageTable.containsKey((Object)pageName)) {
            this.pageTable.removeAt((Object)pageName);
        }
        this.pageShownList.removeElement(pageName);
    }

    public String getPageName(WizardPageInterface page) {
        if (this.pageTable.contains((Object)page)) {
            return (String)this.pageTable.getKey((Object)page);
        }
        throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"getPageName.ex.txt"), (Object)page));
    }

    public WizardPageInterface getPage(String pageName) {
        if (this.pageTable.containsKey((Object)pageName)) {
            Object page = this.pageTable.get((Object)pageName);
            if (page != null) {
                return (WizardPageInterface)page;
            }
            return null;
        }
        throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"getPage.ex.txt"), (Object)pageName));
    }

    public WizardPageInterface[] getPages() {
        WizardPageInterface[] pages = new WizardPageInterface[this.pageTable.count()];
        int pagesIndex = 0;
        Enumeration e = this.pageTable.getItems();
        while (e.hasMoreElements()) {
            Object page = e.nextElement();
            if (page == null) continue;
            pages[pagesIndex++] = (WizardPageInterface)page;
        }
        return pages;
    }

    public int getCurrentPageNumber() {
        int currentPageNumber;
        if (this.currentPageName != null) {
            int currentPageIndex = this.path.indexOf(this.currentPageName);
            currentPageNumber = ++currentPageIndex;
        } else {
            currentPageNumber = -1;
        }
        return currentPageNumber;
    }

    public int getPageCount() {
        return this.path.size();
    }

    public String[] getPath() {
        int size = this.path.size();
        Object[] pageNames = new String[size];
        this.path.copyInto(pageNames);
        return pageNames;
    }
}

