/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.models.BoundedDouble;
import com.sas.models.BoundedLong;
import com.sas.swing.visuals.util.JTextFieldValidator;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.validators.ValidationInterface;
import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public abstract class ValidationUtil {
    public static JTextFieldValidator addJTextFieldValidator(JTextField textField) {
        return ValidationUtil.addJTextFieldValidator(textField, Integer.MIN_VALUE, Integer.MAX_VALUE, (String)null);
    }

    public static JTextFieldValidator addJTextFieldValidator(JTextField textField, double minValue, double maxValue) {
        return ValidationUtil.addJTextFieldValidator(textField, minValue, maxValue, (String)null);
    }

    public static JTextFieldValidator addJTextFieldValidator(JTextField textField, double minValue, double maxValue, String errorMessage) {
        return ValidationUtil.addJTextFieldValidator(textField, (ValidationInterface)new BoundedDouble(minValue, minValue, maxValue), errorMessage);
    }

    public static JTextFieldValidator addJTextFieldValidator(JTextField textField, int minValue, int maxValue) {
        return ValidationUtil.addJTextFieldValidator(textField, minValue, maxValue, (String)null);
    }

    public static JTextFieldValidator addJTextFieldValidator(JTextField textField, int minValue, int maxValue, String errorMessage) {
        return ValidationUtil.addJTextFieldValidator(textField, (ValidationInterface)new BoundedLong((long)minValue, (long)minValue, (long)maxValue), errorMessage);
    }

    public static JTextFieldValidator addJTextFieldValidator(JTextField textField, ValidationInterface validator) {
        return ValidationUtil.addJTextFieldValidator(textField, validator, (String)null);
    }

    public static JTextFieldValidator addJTextFieldValidator(JTextField textField, ValidationInterface validator, String errorMessage) {
        return ValidationUtil.addJTextFieldValidator(textField, validator, (GenericErrorHandlerInterface)new JOptionPaneErrorHandler((Component)textField, errorMessage));
    }

    public static JTextFieldValidator addJTextFieldValidator(JTextField textField, ValidationInterface validator, GenericErrorHandlerInterface errorHandler) {
        JTextFieldValidator fieldValidator = new JTextFieldValidator(textField, validator, errorHandler);
        return fieldValidator;
    }

    public static boolean validate(Object obj) {
        return ValidationUtil.validate(obj, Integer.MIN_VALUE, Integer.MAX_VALUE, (String)null);
    }

    public static boolean validate(Object obj, double minValue, double maxValue) {
        return ValidationUtil.validate(obj, minValue, maxValue, (String)null);
    }

    public static boolean validate(Object obj, double minValue, double maxValue, String errorMessage) {
        return ValidationUtil.validate(obj, (ValidationInterface)new BoundedDouble(minValue, minValue, maxValue), errorMessage);
    }

    public static boolean validate(Object obj, int minValue, int maxValue) {
        return ValidationUtil.validate(obj, minValue, maxValue, (String)null);
    }

    public static boolean validate(Object obj, int minValue, int maxValue, String errorMessage) {
        return ValidationUtil.validate(obj, (ValidationInterface)new BoundedLong((long)minValue, (long)minValue, (long)maxValue), errorMessage);
    }

    public static boolean validate(Object obj, ValidationInterface validator) {
        return ValidationUtil.validate(obj, validator, (String)null);
    }

    public static boolean validate(Object obj, ValidationInterface validator, String errorMessage) {
        if (obj instanceof Component) {
            return ValidationUtil.validate(obj, validator, (GenericErrorHandlerInterface)new JOptionPaneErrorHandler((Component)obj, errorMessage));
        }
        return ValidationUtil.validate(obj, validator, (GenericErrorHandlerInterface)new JOptionPaneErrorHandler(errorMessage));
    }

    public static boolean validate(Object obj, ValidationInterface validator, GenericErrorHandlerInterface errorHandler) {
        if (obj instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)obj;
            if (validator.validateValue((Object)textComponent, (Object)textComponent.getText())) {
                return true;
            }
            errorHandler.handleError(obj, validator.getValidationMessage(), validator.getValidationMessageCode());
            return false;
        }
        return false;
    }
}

