/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.models.BoundedDouble;
import com.sas.models.BoundedLong;
import com.sas.swing.visuals.util.ValidationUtil;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.validators.ValidationInterface;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;

public class JTextFieldValidator
implements FocusListener,
ActionListener {
    JTextField textField;
    ValidationInterface validator;
    GenericErrorHandlerInterface errorHandler;
    String text;
    boolean valid = true;
    boolean validating = false;
    protected SwingPropertyChangeSupport spcs;

    public JTextFieldValidator(JTextField textField) {
        this(textField, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public JTextFieldValidator(JTextField textField, double minValue, double maxValue) {
        this(textField, minValue, maxValue, (String)null);
    }

    public JTextFieldValidator(JTextField textField, double minValue, double maxValue, String errorMessage) {
        this(textField, (ValidationInterface)new BoundedDouble(minValue, minValue, maxValue), errorMessage);
    }

    public JTextFieldValidator(JTextField textField, int minValue, int maxValue) {
        this(textField, minValue, maxValue, (String)null);
    }

    public JTextFieldValidator(JTextField textField, int minValue, int maxValue, String errorMessage) {
        this(textField, (ValidationInterface)new BoundedLong((long)minValue, (long)minValue, (long)maxValue), errorMessage);
    }

    public JTextFieldValidator(JTextField textField, ValidationInterface validator) {
        this(textField, validator, (String)null);
    }

    public JTextFieldValidator(JTextField textField, ValidationInterface validator, String errorMessage) {
        this(textField, validator, (GenericErrorHandlerInterface)new JOptionPaneErrorHandler((Component)textField, errorMessage));
    }

    public JTextFieldValidator(JTextField textField, ValidationInterface validator, GenericErrorHandlerInterface errorHandler) {
        this.textField = textField;
        this.validator = validator;
        this.errorHandler = errorHandler;
        this.text = this.textField.getText();
        this.textField.addFocusListener(this);
        this.textField.addActionListener(this);
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    public void removeListenersOnTextField() {
        this.textField.removeFocusListener(this);
        this.textField.removeActionListener(this);
    }

    public void setErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldErrorHandler = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("errorHandler", oldErrorHandler, this.errorHandler);
        }
    }

    public GenericErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public void setValidator(ValidationInterface validator) {
        if (this.validator != validator) {
            ValidationInterface oldValidator = this.validator;
            this.validator = validator;
            this.firePropertyChange("validator", oldValidator, this.validator);
        }
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void setTextOnComponent() {
        this.textField.setText(this.text);
        this.validating = false;
    }

    private void validateAndUpdate() {
        if (this.validating) {
            return;
        }
        try {
            this.validating = true;
            this.valid = ValidationUtil.validate((Object)this.textField, this.validator, this.errorHandler);
            if (this.valid) {
                this.text = this.textField.getText();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextFieldValidator.this.setTextOnComponent();
                    }
                });
            }
        }
        finally {
            if (this.valid) {
                this.validating = false;
            }
            this.firePropertyChange("valid", null, new Boolean(this.isValid()));
        }
    }

    @Override
    public void focusGained(FocusEvent ev) {
        if (!(this.validating || this.text != null && this.text.equals(this.textField.getText()))) {
            this.text = this.textField.getText();
        }
    }

    @Override
    public void focusLost(FocusEvent ev) {
        this.validateAndUpdate();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.validateAndUpdate();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.spcs == null) {
            this.spcs = new SwingPropertyChangeSupport(this);
        }
        this.spcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.spcs == null) {
            this.spcs = new SwingPropertyChangeSupport(this);
        }
        this.spcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.spcs != null) {
            this.spcs.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.spcs != null) {
            this.spcs.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.spcs == null) {
            this.spcs = new SwingPropertyChangeSupport(this);
        }
        this.spcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        if (this.spcs == null) {
            this.spcs = new SwingPropertyChangeSupport(this);
        }
        this.spcs.firePropertyChange(evt);
    }
}

