/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.beans.PropertyChangeListenerList;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.StaticCollectionInterface;
import com.sas.models.SelectionInterface;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.TableElement;
import com.sas.swing.visuals.table.TableElementInterface;
import com.sas.util.ApplyInterface;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;

public abstract class Selection
implements TableElementInterface,
SelectionInterface,
StaticCollectionInterface {
    private static Refresher m_refresher;
    private TableElement m_anchor;
    private TableElement m_end;
    private ContentsChangedListenerList m_contentsChangedListeners;
    private PropertyChangeListenerList m_propertyChangeListeners;

    public Selection(TableElement anchor) {
        this(anchor, anchor);
    }

    public Selection(TableElement anchor, TableElement end) {
        if (anchor.getTableView() != end.getTableView()) {
            throw new IllegalArgumentException();
        }
        this.m_anchor = anchor;
        this.m_end = end;
    }

    public synchronized void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.m_contentsChangedListeners == null) {
            this.m_contentsChangedListeners = new ContentsChangedListenerList();
        }
        this.m_contentsChangedListeners.add(listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_propertyChangeListeners == null) {
            this.m_propertyChangeListeners = new PropertyChangeListenerList();
        }
        this.m_propertyChangeListeners.add(listener);
    }

    public void apply(ApplyInterface action) {
        Enumeration items = this.getItems();
        while (items.hasMoreElements() && action.apply(items.nextElement()) == 0) {
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return this.newSelection((TableElement)this.getAnchor(), (TableElement)this.getEnd());
    }

    @Override
    public abstract boolean contains(Object var1);

    public abstract int count();

    @Override
    public Object getAnchor() {
        return this.m_anchor;
    }

    public abstract Rectangle getDisplayedBounds();

    @Override
    public Object getEnd() {
        return this.m_end;
    }

    public abstract Enumeration getItems();

    @Override
    public BaseTableView getTableView() {
        return this.m_anchor.getTableView();
    }

    @Override
    public final boolean isDisplayed() {
        return !this.getDisplayedBounds().isEmpty();
    }

    @Override
    public boolean isModified() {
        Enumeration items = this.getItems();
        while (items.hasMoreElements()) {
            if (!((TableElement)items.nextElement()).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelected() {
        Enumeration items = this.getItems();
        while (items.hasMoreElements()) {
            if (!((TableElement)items.nextElement()).isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void refresh(int flags) {
        if (m_refresher == null) {
            m_refresher = new Refresher();
        }
        Selection.m_refresher.flags = flags;
        this.apply(m_refresher);
    }

    @Override
    public void repaint() {
        Rectangle bounds = this.getDisplayedBounds();
        if (!bounds.isEmpty()) {
            this.getTableView().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.m_contentsChangedListeners != null) {
            this.m_contentsChangedListeners.remove(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_propertyChangeListeners != null) {
            this.m_propertyChangeListeners.remove(listener);
        }
    }

    @Override
    public void setEnd(Object newValue) {
        if (newValue.equals(this.m_end)) {
            return;
        }
        TableElement oldValue = this.m_end;
        this.m_end = (TableElement)newValue;
        this.firePropertyChange("end", oldValue, newValue);
        if (this.m_contentsChangedListeners != null && this.m_contentsChangedListeners.count() != 0) {
            this.onEndChanged(oldValue, (TableElement)newValue);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.m_contentsChangedListeners != null) {
            ContentsChangedListener[] listenerList = this.m_contentsChangedListeners.getListeners();
            int maxi = listenerList.length;
            for (int i = 0; i < maxi; ++i) {
                listenerList[i].contentsChanged(event);
            }
        }
        this.firePropertyChange((PropertyChangeEvent)event);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        if (this.m_propertyChangeListeners != null) {
            PropertyChangeListener[] listenerList = this.m_propertyChangeListeners.getListeners();
            int maxi = listenerList.length;
            for (int i = 0; i < maxi; ++i) {
                listenerList[i].propertyChange(event);
            }
        }
    }

    protected final void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.m_propertyChangeListeners != null && this.m_propertyChangeListeners.count() != 0) {
            this.firePropertyChange(new PropertyChangeEvent(this, name, oldValue, newValue));
        }
    }

    protected abstract Selection newSelection(TableElement var1, TableElement var2);

    protected void onEndChanged(TableElement oldValue, TableElement newValue) {
        this.fireContentsChanged(new ContentsChangedEvent((Object)this));
    }

    private class Refresher
    implements ApplyInterface {
        public int flags;

        private Refresher() {
        }

        public int apply(Object item) {
            ((TableElement)item).refresh(this.flags);
            return 0;
        }
    }
}

