/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.CellVector;
import com.sas.swing.visuals.table.CellVectorSelection;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.Row;
import com.sas.swing.visuals.table.Selection;
import com.sas.swing.visuals.table.TableElement;
import java.awt.Rectangle;

public class RowSelection
extends CellVectorSelection {
    public RowSelection(Row anchor) {
        this(anchor, anchor);
    }

    public RowSelection(Row anchor, Row end) {
        super(anchor, end);
    }

    @Override
    public boolean contains(Object item) {
        Row row = item instanceof DataCell ? ((DataCell)item).getRow() : (Row)item;
        return super.contains(row);
    }

    @Override
    public Rectangle getDisplayedBounds() {
        BaseTableView table = this.getTableView();
        Rectangle bounds = table.getTableBounds();
        StaticOrderedCollectionInterface rows = table.getDisplayedRows();
        int count = rows.count();
        if (count == 0) {
            bounds.width = 0;
            bounds.height = 0;
        } else {
            CellVector first = null;
            CellVector last = null;
            for (int i = 0; i < count; ++i) {
                CellVector cv = (CellVector)rows.get(i);
                if (!this.contains(cv)) continue;
                if (first == null) {
                    first = cv;
                }
                last = cv;
            }
            if (first == null) {
                bounds.height = 0;
                bounds.width = 0;
            } else {
                int lpos;
                int fpos = first.getPosition();
                if (fpos <= (lpos = last.getPosition())) {
                    bounds.y = fpos;
                    bounds.height = lpos + last.getDisplayedSize() - 1 - fpos + 1;
                } else {
                    bounds.y = lpos;
                    bounds.height = fpos + first.getDisplayedSize() - 1 - lpos + 1;
                }
            }
        }
        return bounds;
    }

    @Override
    public void setEnd(Object newValue) {
        Row row = newValue instanceof DataCell ? ((DataCell)newValue).getRow() : (Row)newValue;
        super.setEnd(row);
    }

    @Override
    protected Selection newSelection(TableElement anchor, TableElement end) {
        return new RowSelection((Row)anchor, (Row)end);
    }
}

