/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.collection.LongKeyDictionary;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.Cell;
import com.sas.swing.visuals.table.CellVector;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.LabelCell;
import com.sas.table.TableException;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Row
extends CellVector {
    private Row m_self = this;
    private LabelCell m_label;
    private LongKeyDictionary m_cells;

    public Row(BaseTableView table, int index) {
        super(table, index);
        this.m_version = this.tableView.getRowVersion();
    }

    @Override
    public boolean contains(DataCell cell) {
        return cell.getRow().equals(this);
    }

    @Override
    public int count(int maxCount) {
        return this.tableView.countColumns(maxCount);
    }

    @Override
    public final boolean equals(CellVector obj) {
        return obj instanceof Row && this.equals((Row)obj);
    }

    public boolean equals(Row other) {
        return other != null && this.getIndex() == other.getIndex() && this.tableView == other.tableView;
    }

    public int getBottomEdge() {
        return this.getPosition() + this.getSize() - 1;
    }

    @Override
    public DataCell getCell(int colIndex) {
        Row self = this.getThisRow();
        if (self.m_cells == null) {
            self.m_cells = new LongKeyDictionary();
        }
        if (self.m_cells.containsKey((long)colIndex)) {
            return (DataCell)self.m_cells.get((long)colIndex);
        }
        DataCell cell = this.tableView.createCell(self, this.tableView.getColumn(colIndex));
        self.m_cells.set((long)colIndex, (Object)cell);
        return cell;
    }

    @Override
    public StaticPropertyBagInterface getDefaultStyle() {
        return this.tableView.getDefaultRowStyle();
    }

    public final int getHeight() {
        return this.getSize();
    }

    @Override
    public int getIndex() {
        return this.tableView.getRowIndex(this.m_index, this.m_version);
    }

    @Override
    public LabelCell getLabel() {
        Row self = this.getThisRow();
        if (self.m_label == null) {
            self.m_label = this.tableView.createRowLabel(self);
        }
        return self.m_label;
    }

    @Override
    public int getMaxPosition() {
        Rectangle r = this.tableView.getTableBounds();
        return r.y + r.height - 1;
    }

    @Override
    public StaticPropertyBagInterface getModelDefaultStyle() {
        return this.tableView.m_modelDefaultRowStyle;
    }

    @Override
    public String getPixelUnit() {
        return "py";
    }

    @Override
    protected final CellVector getThisCellVector() {
        return this.getThisRow();
    }

    protected final Row getThisRow() {
        if (this.m_self != this) {
            this.m_self = this.m_self == null ? this.tableView.getRow(this.getIndex()) : this.m_self.getThisRow();
        }
        return this.m_self;
    }

    @Override
    public boolean isHeld() {
        return this.tableView.isHeld(this.getThisRow());
    }

    @Override
    public boolean isSelected() {
        return this.tableView.isRowSelected(this);
    }

    @Override
    public boolean isTransient() {
        if (this.m_self != this) {
            throw new IllegalStateException("isTransient called on obsolete Row.");
        }
        if (!super.isTransient()) {
            return false;
        }
        if (this.m_label != null && !this.m_label.isTransient()) {
            return false;
        }
        if (this.m_cells != null) {
            Object[] cells = this.m_cells.getValues();
            for (int i = 0; i < cells.length; ++i) {
                if (((DataCell)cells[i]).isTransient()) continue;
                return false;
            }
        }
        return true;
    }

    public Row nextRow() {
        try {
            return this.tableView.getRow(this.getIndex() + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    protected int onComputePreferredSize(Graphics g) {
        int size = 0;
        if (this.tableView.isRowLabelsVisible()) {
            size = this.getLabel().getPreferredHeight(g);
        }
        int maxColIndex = this.getCellsToSizeCount();
        int index = this.getIndex();
        for (int colIndex = 1; colIndex <= maxColIndex; ++colIndex) {
            Cell cell = index == 0 ? this.tableView.getColumn(colIndex).getLabel() : this.getCell(colIndex);
            int height = cell.getPreferredHeight(g);
            if (height <= size) continue;
            size = height;
        }
        return size;
    }

    @Override
    protected StaticPropertyBagInterface onGetModelStyle() throws TableException {
        if (this.tableView.m_modelSupportsRowStyles) {
            return this.tableView.m_staticTableStyleModel.getRowStyle(this.getIndex());
        }
        return null;
    }

    @Override
    protected CellVector onNext() {
        return this.nextRow();
    }

    @Override
    protected CellVector onPrevious() {
        return this.previousRow();
    }

    @Override
    protected void onResized() {
        this.tableView.noteRowResized(this);
    }

    public Row previousRow() {
        if (this.getIndex() == 1) {
            return null;
        }
        return this.tableView.getRow(this.getIndex() - 1);
    }

    @Override
    public void refresh(int flags) {
        int tempFlags;
        Row self = this.getThisRow();
        if ((flags & 0xA) != 0 && self.m_label != null) {
            tempFlags = 0;
            if ((flags & 2) != 0) {
                tempFlags |= 1;
            }
            if ((flags & 8) != 0) {
                tempFlags |= 0x10;
            }
            self.m_label.refresh(tempFlags);
        }
        if ((flags & 5) != 0 && self.m_cells != null) {
            tempFlags = 0;
            if ((flags & 1) != 0) {
                tempFlags |= 1;
            }
            if ((flags & 4) != 0) {
                tempFlags |= 0x10;
            }
            Object[] cells = self.m_cells.getValues();
            for (int i = 0; i < cells.length; ++i) {
                ((DataCell)cells[i]).refresh(tempFlags);
            }
        }
        super.refresh(flags);
        if (flags != 0 && !this.isResized()) {
            this.remeasure();
        }
    }

    void refreshCells(int startColIndex, int endColIndex, int flags, boolean makeCellsObsolete) {
        Row self = this.getThisRow();
        if (self.m_cells == null) {
            return;
        }
        if (endColIndex < 0) {
            long[] keys = self.m_cells.getKeys();
            for (int k = 0; k < keys.length; ++k) {
                long key = keys[k];
                if (key < (long)startColIndex) continue;
                if (makeCellsObsolete) {
                    ((DataCell)self.m_cells.get(key)).setObsolete();
                    self.m_cells.removeAt(key);
                    continue;
                }
                ((DataCell)self.m_cells.get(key)).refresh(flags);
            }
            return;
        }
        if (makeCellsObsolete) {
            for (int c = startColIndex; c <= endColIndex; ++c) {
                if (self.m_cells.containsKey((long)c)) {
                    ((DataCell)self.m_cells.get((long)c)).setObsolete();
                    self.m_cells.removeAt((long)c);
                    continue;
                }
                while (c <= endColIndex) {
                    if (self.m_cells.containsKey((long)c)) {
                        ((DataCell)self.m_cells.get((long)c)).refresh(flags);
                    }
                    ++c;
                }
            }
        }
    }

    @Override
    public void repaint() {
        if (this.isDisplayed()) {
            Rectangle r = this.tableView.getTableBounds();
            this.tableView.repaint(r.x, this.getPosition(), r.width, this.getSize());
        }
    }

    @Override
    public void setObsolete() {
        if (this.m_self != this) {
            throw new IllegalStateException("setObsolete called on obsolete row!");
        }
        if (this.m_label != null) {
            this.m_label.setObsolete();
            this.m_label = null;
        }
        if (this.m_cells != null) {
            Object[] cells = this.m_cells.getValues();
            for (int i = 0; i < cells.length; ++i) {
                ((DataCell)cells[i]).setObsolete();
            }
            this.m_cells = null;
        }
        this.m_self = null;
    }

    @Override
    void copyTo(CellVector cv, double scaleFactor) throws CloneNotSupportedException {
        super.copyTo(cv, scaleFactor);
        if (this.m_cells != null) {
            Object[] cells = this.m_cells.getValues();
            for (int i = 0; i < cells.length; ++i) {
                DataCell cell = (DataCell)cells[i];
                StaticPropertyBagInterface style = cell.getStyle();
                if (style == null) continue;
                cv.getCell(cell.getColumn().getIndex()).setStyle((StaticPropertyBagInterface)style.clone());
            }
        }
    }
}

