/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.Cell;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.CellVector;
import com.sas.swing.visuals.table.LabelCellTypeInterface;
import com.sas.table.TableException;

public class LabelCell
extends Cell {
    public static final LabelCellTypeInterface COLUMN_LABEL = new ColumnLabelCellType();
    public static final LabelCellTypeInterface ROW_LABEL = new RowLabelCellType();
    public static final LabelCellTypeInterface ORIGIN_LABEL = new OriginLabelCellType();
    private static PropertyBag m_tempPropertyBag = new PropertyBag();
    private Object m_child;
    private LabelCell m_self = this;
    private LabelCellTypeInterface type;

    public LabelCell(BaseTableView table, LabelCellTypeInterface labelType, Object child) {
        super(table);
        this.type = labelType;
        this.m_child = child;
    }

    @Override
    public final boolean equals(Cell obj) {
        return obj instanceof LabelCell && this.equals((LabelCell)obj);
    }

    public boolean equals(LabelCell other) {
        return other != null && (this.getChild() == other.getChild() || this.getChild() != null && this.getChild().equals(other.getChild())) && this.tableView == other.tableView;
    }

    private CellVector getCellVector() {
        CellVector cv = (CellVector)this.m_child;
        cv = cv.getThisCellVector();
        this.m_child = cv;
        return cv;
    }

    public final Object getChild() {
        return this.m_child;
    }

    @Override
    public StaticPropertyBagInterface getDefaultStyle() {
        return this.tableView.getDefaultLabelStyle();
    }

    @Override
    public int getDisplayedHeight() {
        return this.type.getDisplayedHeight(this);
    }

    @Override
    public int getDisplayedWidth() {
        return this.type.getDisplayedWidth(this);
    }

    @Override
    public int getHeight() {
        return this.type.getHeight(this);
    }

    @Override
    public int getHorizontalPosition() {
        return this.type.getHorizontalPosition(this);
    }

    @Override
    public Class getObjectDataClass() {
        return String.class;
    }

    @Override
    public StaticPropertyBagInterface getModelDefaultStyle() {
        return this.tableView.m_modelDefaultLabelStyle;
    }

    @Override
    protected final Cell getThisCell() {
        return this.getThisLabelCell();
    }

    protected LabelCell getThisLabelCell() {
        if (this.m_self != this) {
            this.m_self = this.m_self == null ? this.type.getThisLabelCell(this) : this.m_self.getThisLabelCell();
        }
        return this.m_self;
    }

    public final LabelCellTypeInterface getLabelType() {
        return this.type;
    }

    @Override
    public int getVerticalPosition() {
        return this.type.getVerticalPosition(this);
    }

    @Override
    public int getWidth() {
        return this.type.getWidth(this);
    }

    public int hashCode() {
        if (this.m_child != null) {
            return this.m_child.hashCode();
        }
        return super.hashCode();
    }

    public final boolean isColumnLabel() {
        return this.type == COLUMN_LABEL;
    }

    @Override
    public boolean isDisplayed() {
        return this.type.isDisplayed(this);
    }

    @Override
    public final boolean isLabel() {
        return true;
    }

    public final boolean isOriginLabel() {
        return this.type == ORIGIN_LABEL;
    }

    public final boolean isRowLabel() {
        return this.type == ROW_LABEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onGetEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag) {
        if (this.m_child instanceof CellVector) {
            PropertyBag propertyBag = m_tempPropertyBag;
            synchronized (propertyBag) {
                this.getCellVector().getEffectiveStylePropertyBag("defaultLabelStyle", (PropertyBagInterface)m_tempPropertyBag, true);
                if (m_tempPropertyBag.containsKey(propertyID)) {
                    bag.merge((StaticPropertyBagInterface)m_tempPropertyBag.get(propertyID));
                }
            }
        }
        super.onGetEffectiveStylePropertyBag(propertyID, bag);
        CellStyle cellStyle = this.tableView.getDefaultCellStyle();
        if (cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cellStyle = this.tableView.m_modelDefaultCellStyle) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object onGetEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        Object value;
        if (this.m_child instanceof CellVector) {
            PropertyBag propertyBag = m_tempPropertyBag;
            synchronized (propertyBag) {
                this.getCellVector().getEffectiveStylePropertyBag("defaultLabelStyle", (PropertyBagInterface)m_tempPropertyBag, true);
                if (m_tempPropertyBag.containsKey(propertyID)) {
                    return m_tempPropertyBag.get(propertyID);
                }
            }
        }
        if ((value = super.onGetEffectiveStylePropertyValue(propertyID, PropertyBag.NO_SUCH_ELEMENT)) != PropertyBag.NO_SUCH_ELEMENT) {
            return value;
        }
        CellStyle cellStyle = this.tableView.getDefaultCellStyle();
        if (cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cellStyle = this.tableView.m_modelDefaultCellStyle;
        if (cellStyle != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        return defaultValue;
    }

    @Override
    protected Object onGetObjectData() throws TableException {
        return this.type.onGetObjectData(this);
    }

    @Override
    protected StaticPropertyBagInterface onGetModelStyle() throws TableException {
        return this.type.onGetModelStyle(this);
    }

    @Override
    protected String[] onGetTypes() throws TableException {
        return this.type.onGetTypes(this);
    }

    @Override
    protected void onWriteObjectData() throws TableException {
        this.type.onWriteObjectData(this);
    }

    @Override
    public void setObsolete() {
        super.setObsolete();
        this.m_self = null;
    }

    private static final class OriginLabelCellType
    implements LabelCellTypeInterface {
        private OriginLabelCellType() {
        }

        @Override
        public int getDisplayedHeight(LabelCell cell) {
            return cell.tableView.getColumnLabelsRow().getDisplayedSize();
        }

        @Override
        public int getDisplayedWidth(LabelCell cell) {
            return cell.tableView.getColumnLabelsRow().getDisplayedSize();
        }

        @Override
        public int getHeight(LabelCell cell) {
            return cell.tableView.getColumnLabelsRow().getSize();
        }

        @Override
        public int getWidth(LabelCell cell) {
            return cell.tableView.getRowLabelsColumn().getSize();
        }

        @Override
        public int getHorizontalPosition(LabelCell cell) {
            return cell.tableView.getRowLabelsColumn().getPosition();
        }

        @Override
        public int getVerticalPosition(LabelCell cell) {
            return cell.tableView.getColumnLabelsRow().getPosition();
        }

        @Override
        public LabelCell getThisLabelCell(LabelCell cell) {
            return cell.tableView.getOriginCell();
        }

        @Override
        public boolean isDisplayed(LabelCell cell) {
            return cell.tableView.getRowLabelsColumn().isDisplayed() && cell.tableView.getColumnLabelsRow().isDisplayed();
        }

        @Override
        public Object onGetObjectData(LabelCell cell) throws TableException {
            if (cell.tableView.m_staticRowLabelModel.isRowsLabelSupported()) {
                return cell.tableView.m_staticRowLabelModel.getRowLabel(0);
            }
            if (cell.tableView.m_staticColumnLabelModel.isColumnsLabelSupported()) {
                return cell.tableView.m_staticColumnLabelModel.getColumnLabel(0);
            }
            return null;
        }

        @Override
        public void onWriteObjectData(LabelCell cell) throws TableException {
        }

        @Override
        public StaticPropertyBagInterface onGetModelStyle(LabelCell cell) throws TableException {
            return null;
        }

        @Override
        public String[] onGetTypes(LabelCell cell) throws TableException {
            return null;
        }
    }

    private static final class RowLabelCellType
    extends CellVectorLabelCellType {
        private RowLabelCellType() {
        }

        @Override
        public int getDisplayedWidth(LabelCell cell) {
            return cell.tableView.getRowLabelsColumn().getDisplayedSize();
        }

        @Override
        public int getWidth(LabelCell cell) {
            return cell.tableView.getRowLabelsColumn().getSize();
        }

        @Override
        public int getHorizontalPosition(LabelCell cell) {
            return cell.tableView.getRowLabelsColumn().getPosition();
        }

        @Override
        public LabelCell getThisLabelCell(LabelCell cell) {
            return cell.tableView.getRow(this.getIndex(cell)).getLabel();
        }

        @Override
        public boolean isDisplayed(LabelCell cell) {
            return cell.getCellVector().isDisplayed() && cell.tableView.isRowLabelsVisible();
        }

        @Override
        public Object onGetObjectData(LabelCell cell) throws TableException {
            return cell.tableView.m_staticRowLabelModel.getRowLabel(cell.getCellVector().getIndex());
        }

        @Override
        public void onWriteObjectData(LabelCell cell) throws TableException {
            cell.tableView.m_rowLabelModel.setRowLabel(cell.getCellVector().getIndex(), cell.getObjectData());
        }

        @Override
        public StaticPropertyBagInterface onGetModelStyle(LabelCell cell) throws TableException {
            if (cell.tableView.m_modelSupportsRowLabelStyles) {
                return cell.tableView.m_staticTableStyleModel.getRowLabelStyle(this.getIndex(cell));
            }
            return null;
        }

        @Override
        public String[] onGetTypes(LabelCell cell) throws TableException {
            return cell.tableView.m_staticTableTypeModel.getRowLabelType(this.getIndex(cell));
        }
    }

    private static final class ColumnLabelCellType
    extends CellVectorLabelCellType {
        private ColumnLabelCellType() {
        }

        @Override
        public int getDisplayedHeight(LabelCell cell) {
            return cell.tableView.getColumnLabelsRow().getDisplayedSize();
        }

        @Override
        public int getHeight(LabelCell cell) {
            return cell.tableView.getColumnLabelsRow().getSize();
        }

        @Override
        public int getVerticalPosition(LabelCell cell) {
            return cell.tableView.getColumnLabelsRow().getPosition();
        }

        @Override
        public LabelCell getThisLabelCell(LabelCell cell) {
            return cell.tableView.getColumn(this.getIndex(cell)).getLabel();
        }

        @Override
        public boolean isDisplayed(LabelCell cell) {
            return cell.getCellVector().isDisplayed() && cell.tableView.isColumnLabelsVisible();
        }

        @Override
        public Object onGetObjectData(LabelCell cell) throws TableException {
            return cell.tableView.m_staticColumnLabelModel.getColumnLabel(cell.getCellVector().getIndex());
        }

        @Override
        public void onWriteObjectData(LabelCell cell) throws TableException {
            cell.tableView.m_columnLabelModel.setColumnLabel(cell.getCellVector().getIndex(), cell.getObjectData());
        }

        @Override
        public StaticPropertyBagInterface onGetModelStyle(LabelCell cell) throws TableException {
            if (cell.tableView.m_modelSupportsColumnLabelStyles) {
                return cell.tableView.m_staticTableStyleModel.getColumnLabelStyle(this.getIndex(cell));
            }
            return null;
        }

        @Override
        public String[] onGetTypes(LabelCell cell) throws TableException {
            return cell.tableView.m_staticTableTypeModel.getColumnLabelType(this.getIndex(cell));
        }
    }

    private static abstract class CellVectorLabelCellType
    implements LabelCellTypeInterface {
        private CellVectorLabelCellType() {
        }

        @Override
        public int getDisplayedHeight(LabelCell cell) {
            return cell.getCellVector().getDisplayedSize();
        }

        @Override
        public int getDisplayedWidth(LabelCell cell) {
            return cell.getCellVector().getDisplayedSize();
        }

        @Override
        public int getHeight(LabelCell cell) {
            return cell.getCellVector().getSize();
        }

        @Override
        public int getWidth(LabelCell cell) {
            return cell.getCellVector().getSize();
        }

        @Override
        public int getHorizontalPosition(LabelCell cell) {
            return cell.getCellVector().getPosition();
        }

        @Override
        public int getVerticalPosition(LabelCell cell) {
            return cell.getCellVector().getPosition();
        }

        public final int getIndex(LabelCell cell) {
            return cell.getCellVector().getIndex();
        }
    }
}

