/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.awt.util.FontStyles;
import com.sas.awt.util.FontWeights;
import com.sas.awt.util.FontWidths;
import com.sas.collection.Dictionary;
import com.sas.collection.PropertyBag;
import java.awt.Font;

public class FontStyle
extends PropertyBag {
    static final long serialVersionUID = 6057796436158717025L;
    public static final String NAME = "name";
    public static final String SIZE = "size";
    public static final String STYLE = "style";
    public static final String WEIGHT = "weight";
    public static final String WIDTH = "width";
    private static final Dictionary m_fontCache = new Dictionary();

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.set(NAME, newValue);
    }

    public boolean isNameSet() {
        return this.containsKey(NAME);
    }

    public void unsetName() {
        this.remove(NAME);
    }

    public double getSize() {
        return (Double)this.get(SIZE);
    }

    public void setSize(double newValue) {
        if (newValue <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.set(SIZE, new Double(newValue));
    }

    public boolean isSizeSet() {
        return this.containsKey(SIZE);
    }

    public void unsetSize() {
        this.remove(SIZE);
    }

    public int getStyle() {
        return (Integer)this.get(STYLE);
    }

    public void setStyle(int newValue) {
        if (!FontStyles.validate(newValue)) {
            throw new IllegalArgumentException();
        }
        this.set(STYLE, new Integer(newValue));
    }

    public boolean isStyleSet() {
        return this.containsKey(STYLE);
    }

    public void unsetStyle() {
        this.remove(STYLE);
    }

    public int getWeight() {
        return (Integer)this.get(WEIGHT);
    }

    public void setWeight(int newValue) {
        if (!FontWeights.validate(newValue)) {
            throw new IllegalArgumentException();
        }
        this.set(WEIGHT, new Integer(newValue));
    }

    public boolean isWeightSet() {
        return this.containsKey(WEIGHT);
    }

    public void unsetWeight() {
        this.remove(WEIGHT);
    }

    public int getWidth() {
        return (Integer)this.get(WIDTH);
    }

    public void setWidth(int newValue) {
        if (!FontWidths.validate(newValue)) {
            throw new IllegalArgumentException();
        }
        this.set(WIDTH, new Integer(newValue));
    }

    public boolean isWidthSet() {
        return this.containsKey(WIDTH);
    }

    public void unsetWidth() {
        this.remove(WIDTH);
    }

    public Font getFont() {
        FontStruct fontStyleKey = this.toStruct();
        if (m_fontCache.containsKey((Object)fontStyleKey)) {
            return (Font)m_fontCache.get((Object)fontStyleKey);
        }
        int style = this.isWeightSet() && this.getWeight() > 5 ? 1 : 0;
        if (this.isStyleSet() && this.getStyle() == 1) {
            style |= 2;
        }
        Font font = new Font(this.getName(), style, (int)(this.getSize() + 0.5));
        m_fontCache.set((Object)fontStyleKey, (Object)font);
        return font;
    }

    public void setFont(Font font) {
        this.setName(font.getName());
        this.setSize(font.getSize());
        this.setStyle(font.isItalic() ? 1 : 3);
        this.setWeight(font.isBold() ? 7 : 5);
        this.setWidth(5);
    }

    private FontStruct toStruct() {
        FontStruct s = new FontStruct();
        s.name = this.getName();
        s.weight = this.getWeight();
        s.style = this.getStyle();
        s.size = this.getSize();
        s.width = this.getWidth();
        return s;
    }

    private final class FontStruct {
        String name;
        int weight;
        int style;
        int width;
        double size;

        private FontStruct() {
        }

        public boolean equals(Object o) {
            FontStruct s = (FontStruct)o;
            return this.weight == s.weight && this.style == s.style && this.size == s.size && this.width == s.width && this.name.equals(s.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

