/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.Cell;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.Column;
import com.sas.swing.visuals.table.Row;
import com.sas.table.TableException;
import java.awt.Graphics;

public class DataCell
extends Cell {
    private Column m_col;
    private Row m_row;
    private DataCell m_self;

    public DataCell(BaseTableView table, Row row, Column column) {
        super(table);
        if (row == null || column == null) {
            throw new IllegalArgumentException();
        }
        this.m_row = row.getThisRow();
        this.m_col = column.getThisColumn();
        this.m_self = this;
    }

    @Override
    public final boolean equals(Cell obj) {
        return obj instanceof DataCell && this.equals((DataCell)obj);
    }

    public boolean equals(DataCell other) {
        return other != null && this.getColumn().equals(other.getColumn()) && this.getRow().equals(other.getRow()) && this.tableView == other.tableView;
    }

    public final Column getColumn() {
        this.m_col = this.m_col.getThisColumn();
        return this.m_col;
    }

    @Override
    public StaticPropertyBagInterface getDefaultStyle() {
        return this.tableView.getDefaultCellStyle();
    }

    @Override
    public int getDisplayedHeight() {
        return this.getRow().getDisplayedSize();
    }

    @Override
    public int getDisplayedWidth() {
        return this.getColumn().getDisplayedSize();
    }

    @Override
    public int getHeight() {
        return this.getRow().getSize();
    }

    @Override
    public int getHorizontalPosition() {
        return this.getColumn().getPosition();
    }

    @Override
    public StaticPropertyBagInterface getModelDefaultStyle() {
        return this.tableView.m_modelDefaultCellStyle;
    }

    @Override
    public Class getObjectDataClass() throws TableException {
        return this.tableView.m_staticTableModel.getCellClass(this.getRow().getIndex(), this.getColumn().getIndex());
    }

    public final Row getRow() {
        this.m_row = this.m_row.getThisRow();
        return this.m_row;
    }

    @Override
    protected final Cell getThisCell() {
        return this.getThisDataCell();
    }

    protected final DataCell getThisDataCell() {
        if (this.m_self != this) {
            this.m_self = this.m_self == null ? this.tableView.getCell(this.getRow(), this.getColumn()) : this.m_self.getThisDataCell();
        }
        return this.m_self;
    }

    @Override
    public int getVerticalPosition() {
        return this.getRow().getPosition();
    }

    @Override
    public int getWidth() {
        return this.getColumn().getSize();
    }

    @Override
    public boolean isDisplayed() {
        return this.getColumn().isDisplayed() && this.getRow().isDisplayed();
    }

    @Override
    public final boolean isLabel() {
        return false;
    }

    @Override
    protected void onGetEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag) {
        CellStyle cellStyle;
        Column column = this.getColumn();
        Row row = this.getRow();
        StaticPropertyBagInterface cvStyle = column.getStyle();
        if (cvStyle != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cvStyle = row.getStyle()) != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cvStyle = column.getModelStyle()) != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cvStyle = row.getModelStyle()) != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cellStyle = (CellStyle)((Object)column.getDefaultStyle().get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cellStyle = (CellStyle)((Object)row.getDefaultStyle().get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cvStyle = column.getModelDefaultStyle()) != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        if ((cvStyle = row.getModelDefaultStyle()) != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)cellStyle.get(propertyID));
        }
        super.onGetEffectiveStylePropertyBag(propertyID, bag);
    }

    @Override
    protected Object onGetEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        CellStyle cellStyle;
        Column column = this.getColumn();
        Row row = this.getRow();
        StaticPropertyBagInterface cvStyle = column.getStyle();
        if (cvStyle != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cvStyle = row.getStyle();
        if (cvStyle != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cvStyle = column.getModelStyle();
        if (cvStyle != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cvStyle = row.getModelStyle();
        if (cvStyle != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cellStyle = (CellStyle)((Object)column.getDefaultStyle().get("defaultCellStyle", null));
        if (cellStyle != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cellStyle = (CellStyle)((Object)row.getDefaultStyle().get("defaultCellStyle", null));
        if (cellStyle != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cvStyle = column.getModelDefaultStyle();
        if (cvStyle != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        cvStyle = row.getModelDefaultStyle();
        if (cvStyle != null && (cellStyle = (CellStyle)((Object)cvStyle.get("defaultCellStyle", null))) != null && cellStyle.containsKey(propertyID)) {
            return cellStyle.get(propertyID);
        }
        return super.onGetEffectiveStylePropertyValue(propertyID, defaultValue);
    }

    @Override
    protected String onGetFormattedData() throws TableException {
        if (this.tableView.m_staticFormattedDataModel != null) {
            return this.tableView.m_staticFormattedDataModel.getFormattedCell(this.getRow().getIndex(), this.getColumn().getIndex());
        }
        return super.onGetFormattedData();
    }

    @Override
    protected Object onGetObjectData() throws TableException {
        return this.tableView.m_staticTableModel.getCell(this.getRow().getIndex(), this.getColumn().getIndex());
    }

    @Override
    protected StaticPropertyBagInterface onGetModelStyle() throws TableException {
        if (this.tableView.m_modelSupportsCellStyles) {
            return this.tableView.m_staticTableStyleModel.getCellStyle(this.getRow().getIndex(), this.getColumn().getIndex());
        }
        return null;
    }

    @Override
    protected String[] onGetTypes() throws TableException {
        return this.tableView.m_staticTableTypeModel.getCellType(this.getRow().getIndex(), this.getColumn().getIndex());
    }

    @Override
    protected void onPaintForeground(Graphics g, int width, int height) throws TableException {
        if (this.tableView.isGridVisible()) {
            g.setColor(this.tableView.getGridColor());
            if (!this.getRow().isPartiallyDisplayed()) {
                g.drawLine(0, height - 1, width - 1, height - 1);
            }
            if (!this.getColumn().isPartiallyDisplayed()) {
                g.drawLine(width - 1, 0, width - 1, height - 1);
            }
        }
        super.onPaintForeground(g, width, height);
    }

    @Override
    protected void onWriteObjectData() throws TableException {
        if (this.tableView.m_formattedDataModel != null && this.getView().getPreferredOutputType() == 1) {
            this.tableView.m_formattedDataModel.setFormattedCell(this.getRow().getIndex(), this.getColumn().getIndex(), this.getView().getFormattedData());
        } else {
            this.tableView.m_tableModel.setCell(this.getRow().getIndex(), this.getColumn().getIndex(), this.getView().getObjectData());
        }
    }

    @Override
    public void setObsolete() {
        super.setObsolete();
        this.m_self = null;
    }
}

