/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.CellVector;
import com.sas.swing.visuals.table.CellVectorSelection;
import com.sas.swing.visuals.table.Column;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.Selection;
import com.sas.swing.visuals.table.TableElement;
import java.awt.Rectangle;

public class ColumnSelection
extends CellVectorSelection {
    public ColumnSelection(Column anchor) {
        this(anchor, anchor);
    }

    public ColumnSelection(Column anchor, Column end) {
        super(anchor, end);
    }

    @Override
    public boolean contains(Object item) {
        Column col = item instanceof DataCell ? ((DataCell)item).getColumn() : (Column)item;
        return super.contains(col);
    }

    @Override
    public Rectangle getDisplayedBounds() {
        BaseTableView table = this.getTableView();
        Rectangle bounds = table.getTableBounds();
        StaticOrderedCollectionInterface cols = table.getDisplayedColumns();
        int count = cols.count();
        if (count == 0) {
            bounds.width = 0;
            bounds.height = 0;
        } else {
            CellVector first = null;
            CellVector last = null;
            for (int i = 0; i < count; ++i) {
                CellVector cv = (CellVector)cols.get(i);
                if (!this.contains(cv)) continue;
                if (first == null) {
                    first = cv;
                }
                last = cv;
            }
            if (first == null) {
                bounds.height = 0;
                bounds.width = 0;
            } else {
                int lpos;
                int fpos = first.getPosition();
                if (fpos <= (lpos = last.getPosition())) {
                    bounds.x = fpos;
                    bounds.width = lpos + last.getDisplayedSize() - 1 - fpos + 1;
                } else {
                    bounds.x = lpos;
                    bounds.width = fpos + first.getDisplayedSize() - 1 - lpos + 1;
                }
            }
        }
        return bounds;
    }

    @Override
    public void setEnd(Object newValue) {
        Column col = newValue instanceof DataCell ? ((DataCell)newValue).getColumn() : (Column)newValue;
        super.setEnd(col);
    }

    @Override
    protected Selection newSelection(TableElement anchor, TableElement end) {
        return new ColumnSelection((Column)anchor, (Column)end);
    }
}

