/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.Cell;
import com.sas.swing.visuals.table.CellVector;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.LabelCell;
import com.sas.table.TableException;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Column
extends CellVector {
    private Column m_self = this;
    private LabelCell m_label;

    public Column(BaseTableView table, int index) {
        super(table, index);
        this.m_version = this.tableView.getColumnVersion();
    }

    @Override
    public boolean contains(DataCell cell) {
        return cell.getColumn().equals(this);
    }

    @Override
    public int count(int maxCount) {
        return this.tableView.countRows(maxCount);
    }

    @Override
    public final boolean equals(CellVector obj) {
        return obj instanceof Column && this.equals((Column)obj);
    }

    public boolean equals(Column other) {
        return other != null && this.getIndex() == other.getIndex() && this.tableView == other.tableView;
    }

    @Override
    public DataCell getCell(int rowIndex) {
        return this.tableView.getCell(this.tableView.getRow(rowIndex), this);
    }

    @Override
    public StaticPropertyBagInterface getDefaultStyle() {
        return this.tableView.getDefaultColumnStyle();
    }

    @Override
    public int getIndex() {
        return this.tableView.getColumnIndex(this.m_index, this.m_version);
    }

    @Override
    public LabelCell getLabel() {
        Column self = this.getThisColumn();
        if (self.m_label == null) {
            self.m_label = this.tableView.createColumnLabel(self);
        }
        return self.m_label;
    }

    @Override
    public int getMaxPosition() {
        Rectangle r = this.tableView.getTableBounds();
        return r.x + r.width - 1;
    }

    @Override
    public StaticPropertyBagInterface getModelDefaultStyle() {
        return this.tableView.m_modelDefaultColumnStyle;
    }

    @Override
    public String getPixelUnit() {
        return "px";
    }

    public int getRightEdge() {
        return this.getPosition() + this.getSize() - 1;
    }

    @Override
    protected final CellVector getThisCellVector() {
        return this.getThisColumn();
    }

    protected final Column getThisColumn() {
        if (this.m_self != this) {
            this.m_self = this.m_self == null ? this.tableView.getColumn(this.getIndex()) : this.m_self.getThisColumn();
        }
        return this.m_self;
    }

    public final int getWidth() {
        return this.getSize();
    }

    @Override
    public boolean isHeld() {
        return this.tableView.isHeld(this.getThisColumn());
    }

    @Override
    public boolean isSelected() {
        return this.tableView.isColumnSelected(this);
    }

    @Override
    public boolean isTransient() {
        if (this.m_self != this) {
            throw new IllegalStateException("isTransient called on obsolete Column.");
        }
        if (!super.isTransient()) {
            return false;
        }
        return this.m_label == null || this.m_label.isTransient();
    }

    public Column nextColumn() {
        try {
            return this.tableView.getColumn(this.getIndex() + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    protected int onComputePreferredSize(Graphics g) {
        int size = 0;
        if (this.tableView.isColumnLabelsVisible()) {
            size = this.getLabel().getPreferredWidth(g);
        }
        int maxRowIndex = this.getCellsToSizeCount();
        int index = this.getIndex();
        for (int rowIndex = 1; rowIndex <= maxRowIndex; ++rowIndex) {
            Cell cell = index == 0 ? this.tableView.getRow(rowIndex).getLabel() : this.getCell(rowIndex);
            int width = cell.getPreferredWidth(g);
            if (width <= size) continue;
            size = width;
        }
        return size;
    }

    @Override
    protected StaticPropertyBagInterface onGetModelStyle() throws TableException {
        if (this.tableView.m_modelSupportsColumnStyles) {
            return this.tableView.m_staticTableStyleModel.getColumnStyle(this.getIndex());
        }
        return null;
    }

    @Override
    protected CellVector onNext() {
        return this.nextColumn();
    }

    @Override
    protected CellVector onPrevious() {
        return this.previousColumn();
    }

    @Override
    protected void onResized() {
        this.tableView.noteColumnResized(this);
    }

    public Column previousColumn() {
        if (this.getIndex() == 1) {
            return null;
        }
        return this.tableView.getColumn(this.getIndex() - 1);
    }

    @Override
    public void refresh(int flags) {
        int tempFlags;
        Column self = this.getThisColumn();
        if ((flags & 0xA) != 0 && self.m_label != null) {
            tempFlags = 0;
            if ((flags & 2) != 0) {
                tempFlags |= 1;
            }
            if ((flags & 8) != 0) {
                tempFlags |= 0x10;
            }
            self.m_label.refresh(tempFlags);
        }
        if ((flags & 5) != 0) {
            tempFlags = 0;
            if ((flags & 1) != 0) {
                tempFlags |= 1;
            }
            if ((flags & 4) != 0) {
                tempFlags |= 0x10;
            }
            int index = this.getIndex();
            this.tableView.refreshColumns(index, index, tempFlags, false);
        }
        super.refresh(flags);
        if (flags != 0 && !this.isResized()) {
            this.remeasure();
        }
    }

    @Override
    public void repaint() {
        if (this.isDisplayed()) {
            Rectangle r = this.tableView.getTableBounds();
            this.tableView.repaint(this.getPosition(), r.y, this.getSize(), r.height);
        }
    }

    @Override
    public void setObsolete() {
        if (this.m_label != null) {
            this.m_label.setObsolete();
            this.m_label = null;
        }
        this.m_self = null;
    }
}

