/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.GlobalInfoTable;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.measures.Length;
import com.sas.swing.visuals.BaseBorder;
import com.sas.swing.visuals.table.BaseTableView;
import com.sas.swing.visuals.table.BorderStyle;
import com.sas.swing.visuals.table.CellActiveStates;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.CellViewInterface;
import com.sas.swing.visuals.table.FontStyle;
import com.sas.swing.visuals.table.TableElement;
import com.sas.swing.visuals.table.TablePainterInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.table.TableException;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.visuals.EmptyComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;

public abstract class Cell
extends TableElement {
    private static BorderStyle m_tempBorderStyle = new BorderStyle();
    private static FontStyle m_tempFontStyle = new FontStyle();
    private static final String m_defaultViewClassName = "com.sas.swing.visuals.table.TextCell";
    private static final int MOUSE_CAPTURED = 1;
    private static final int KEY_HANDLED = 2;
    private static final int VIEW_DATA_INITIALIZED = 4;
    private int m_activeState;
    private int m_flags;
    private int m_typeStylesVersion = -1;
    private StaticPropertyBagInterface[] m_typeStyles;
    private CellViewInterface m_view;
    private String m_viewClassName;
    protected BaseTableView tableView;

    protected Cell(BaseTableView table) {
        super(table);
        this.tableView = table;
        this.m_activeState = 0;
    }

    @Override
    public final boolean equals(TableElement obj) {
        return obj instanceof Cell && this.equals((Cell)obj);
    }

    public abstract boolean equals(Cell var1);

    public int getActiveState() {
        return this.getThisCell().m_activeState;
    }

    private int getMargin(String name, int defaultValue, String pixelType) {
        Length margin;
        block3: {
            block2: {
                margin = (Length)this.getEffectiveStylePropertyValue(name, null);
                if (margin == null) break block2;
                if (margin.getUnitType() != Length.FONT_UNITS) break block3;
            }
            return defaultValue;
        }
        return (int)(margin.getMagnitude((Object)pixelType) + 0.5);
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.getHorizontalPosition(), this.getVerticalPosition(), this.getWidth(), this.getHeight());
    }

    public final Rectangle getDisplayedBounds() {
        return new Rectangle(this.getHorizontalPosition(), this.getVerticalPosition(), this.getDisplayedWidth(), this.getDisplayedHeight());
    }

    public abstract int getDisplayedHeight();

    public abstract int getDisplayedWidth();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getEffectiveFont() {
        FontStyle fontStyle = m_tempFontStyle;
        synchronized (fontStyle) {
            this.getEffectiveStylePropertyBag("fontStyle", (PropertyBagInterface)m_tempFontStyle, true);
            return m_tempFontStyle.getFont();
        }
    }

    @Override
    public void getEffectiveStylePropertyBag(String propertyID, PropertyBagInterface bag, boolean clearBag) {
        CellStyle style;
        if (clearBag) {
            bag.removeAll();
        }
        if (this.isDataInvalid() && (style = this.tableView.getDefaultInvalidCellStyle()).containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
        super.getEffectiveStylePropertyBag(propertyID, bag, false);
    }

    @Override
    public Object getEffectiveStylePropertyValue(String propertyID, Object defaultValue) {
        CellStyle style;
        if (this.isDataInvalid() && (style = this.tableView.getDefaultInvalidCellStyle()).containsKey(propertyID)) {
            return style.get(propertyID);
        }
        return super.getEffectiveStylePropertyValue(propertyID, defaultValue);
    }

    public Graphics getGraphics() {
        if (!this.isDisplayed()) {
            return null;
        }
        Graphics g = this.getTableView().getGraphics();
        if (g == null) {
            return null;
        }
        return g.create(this.getHorizontalPosition(), this.getVerticalPosition(), this.getWidth(), this.getHeight());
    }

    public abstract int getHeight();

    public abstract int getHorizontalPosition();

    public Insets getInsets() {
        return new Insets(this.getMargin("topMargin", 2, "py"), this.getMargin("leftMargin", 3, "px"), this.getMargin("bottomMargin", 2, "py"), this.getMargin("rightMargin", 3, "px"));
    }

    public int getMinimumHeight(Graphics g) {
        int height;
        try {
            height = this.getView().getMinimumHeight(g);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            height = 0;
        }
        Insets insets = this.getInsets();
        return insets.top + height + insets.bottom;
    }

    public int getMinimumWidth(Graphics g) {
        int width;
        try {
            width = this.getView().getMinimumWidth(g);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            width = 0;
        }
        Insets insets = this.getInsets();
        return insets.left + width + insets.right;
    }

    public Object getObjectData() throws TableException {
        CellViewInterface view = this.getView();
        if (view.getPreferredOutputType() == 0) {
            return view.getObjectData();
        }
        return view.getFormattedData();
    }

    public abstract Class getObjectDataClass() throws TableException;

    public final int getPreferredHeight(Graphics g) {
        return this.getPreferredHeight(g, -1);
    }

    public int getPreferredHeight(Graphics g, int width) {
        int height;
        try {
            height = this.getView().getPreferredHeight(g, width);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            height = 0;
        }
        Insets insets = this.getInsets();
        return insets.top + height + insets.bottom;
    }

    public final int getPreferredWidth(Graphics g) {
        return this.getPreferredWidth(g, -1);
    }

    public int getPreferredWidth(Graphics g, int height) {
        int width;
        try {
            width = this.getView().getPreferredWidth(g, height);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            width = 0;
        }
        Insets insets = this.getInsets();
        return insets.left + width + insets.right;
    }

    @Override
    protected final TableElement getThis() {
        return this.getThisCell();
    }

    protected abstract Cell getThisCell();

    @Override
    public String[] getModelTypes() {
        StaticPropertyBagInterface[] typeStyles = this.getModelTypeStyles();
        if (typeStyles.length == 0) {
            return emptyModelTypesArray;
        }
        String[] types = new String[typeStyles.length];
        StaticDictionaryInterface tableTypeStyles = this.tableView.getCellTypeStyles();
        for (int i = 0; i < types.length; ++i) {
            types[i] = (String)tableTypeStyles.getKey((Object)typeStyles[i]);
        }
        return types;
    }

    @Override
    public StaticPropertyBagInterface[] getModelTypeStyles() {
        Cell self = this.getThisCell();
        if (self.m_typeStylesVersion != this.tableView.m_cellTypesVersion) {
            self.m_typeStylesVersion = this.tableView.m_cellTypesVersion;
            self.m_typeStyles = emptyModelTypeStylesArray;
            String[] types = null;
            StaticDictionaryInterface tableTypeStyles = this.tableView.m_staticTableTypeModel != null ? this.tableView.getCellTypeStyles() : null;
            if (tableTypeStyles != null && tableTypeStyles.count() > 0) {
                try {
                    types = this.onGetTypes();
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                }
            }
            if (types != null && types.length != 0) {
                self.m_typeStyles = new StaticPropertyBagInterface[types.length];
                for (int i = 0; i < types.length; ++i) {
                    self.m_typeStyles[i] = (StaticPropertyBagInterface)tableTypeStyles.get((Object)types[i]);
                }
            }
        }
        return self.m_typeStyles;
    }

    public abstract int getVerticalPosition();

    public final CellViewInterface getView() throws TableException {
        Cell self = this.getThisCell();
        String viewClassName = (String)this.getEffectiveStylePropertyValue("viewClass", m_defaultViewClassName);
        if (viewClassName != m_defaultViewClassName) {
            viewClassName = viewClassName.intern();
        }
        if (self.m_view != null && self.m_viewClassName != viewClassName && !this.isModified()) {
            self.m_view = null;
            self.m_flags &= 0xFFFFFFFB;
        }
        if (self.m_view == null) {
            try {
                Class viewClass = GlobalInfoTable.loadClass((String)viewClassName);
                self.m_view = (CellViewInterface)viewClass.newInstance();
            }
            catch (Exception ex) {
                throw new TableException(ex);
            }
            self.m_viewClassName = viewClassName;
            self.m_view.setCell(self);
            if (self.m_activeState != 0) {
                self.m_view.onActiveStateChanged(0, self.m_activeState, null);
            }
        }
        if ((self.m_flags & 4) == 0) {
            if (self.m_view.getPreferredInputType() == 0) {
                self.m_view.setObjectData(this.onGetObjectData());
            } else {
                self.m_view.setFormattedData(this.onGetFormattedData());
            }
            self.m_flags |= 4;
        }
        return self.m_view;
    }

    public abstract int getWidth();

    public boolean isActivated() {
        return this.getActiveState() > 1;
    }

    public boolean isDataInvalid() {
        return this.tableView.getInvalidCells().contains((Object)this.getThisCell());
    }

    public boolean isKeyHandled() {
        return (this.getThisCell().m_flags & 2) != 0;
    }

    public abstract boolean isLabel();

    @Override
    public boolean isModified() {
        return this.tableView.getModifiedCells().contains((Object)this.getThisCell());
    }

    public boolean isMouseCaptured() {
        return (this.getThisCell().m_flags & 1) != 0;
    }

    @Override
    public boolean isSelected() {
        return this.tableView.isCellSelected(this);
    }

    protected String onGetFormattedData() throws TableException {
        Object data = this.onGetObjectData();
        return data == null ? null : (String)ObjectToStringTransform.defaultInstance.transform(data);
    }

    protected abstract Object onGetObjectData() throws TableException;

    protected abstract String[] onGetTypes() throws TableException;

    protected void onPaintBackground(Graphics g, int width, int height) {
        int opacity;
        Integer Opacity = (Integer)this.getEffectiveStylePropertyValue("opacity", null);
        int n = opacity = Opacity != null ? Opacity : 0;
        if (opacity != 2) {
            TablePainterInterface painter = (TablePainterInterface)this.getEffectiveStylePropertyValue("background", null);
            if (painter != null) {
                painter.paintCell(this, g, 0, 0, width, height);
                return;
            }
            g.setColor((Color)this.getEffectiveStylePropertyValue("backgroundColor", SystemColor.window));
            g.fillRect(0, 0, width, height);
        } else {
            this.tableView.setScrollingSmooth(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPaintBorder(Graphics g, int width, int height) {
        BorderStyle borderStyle = m_tempBorderStyle;
        synchronized (borderStyle) {
            int border_type;
            this.getEffectiveStylePropertyBag("borderStyle", (PropertyBagInterface)m_tempBorderStyle, true);
            Integer borderType = (Integer)m_tempBorderStyle.get("type", null);
            EmptyComponent comp = new EmptyComponent();
            Color fore = (Color)this.getEffectiveStylePropertyValue("foregroundColor", null);
            if (fore == null) {
                fore = this.tableView.getForeground();
            }
            if (fore != null) {
                comp.setForeground(fore);
            } else {
                comp.setForeground(Color.black);
            }
            Color back = (Color)this.getEffectiveStylePropertyValue("backgroundColor", null);
            if (back == null) {
                back = this.tableView.getBackground();
            }
            if (back != null) {
                comp.setBackground(back);
            } else {
                comp.setBackground(Color.white);
            }
            if (borderType != null && (border_type = borderType.intValue()) != 0) {
                if (border_type == 1) {
                    int baseBorder_type;
                    Length borderWidth = (Length)m_tempBorderStyle.get("width", null);
                    Color highlightColor = (Color)m_tempBorderStyle.get("highlightColor", null);
                    Color shadowColor = (Color)m_tempBorderStyle.get("shadowColor", null);
                    Integer borderSides = (Integer)m_tempBorderStyle.get("sides", null);
                    Integer lightSource = (Integer)m_tempBorderStyle.get("lightSource", null);
                    Integer baseBorderType = (Integer)m_tempBorderStyle.get("baseBorderType", null);
                    int light_source = lightSource == null ? 5 : lightSource;
                    int border_sides = borderSides == null ? 15 : borderSides;
                    int border_width = borderWidth == null ? 1 : (int)borderWidth.getMagnitude((Object)"px");
                    int n = baseBorder_type = baseBorderType == null ? 0 : baseBorderType;
                    if (highlightColor == null && (highlightColor = (Color)this.getEffectiveStylePropertyValue("foregroundColor", null)) == null) {
                        highlightColor = this.tableView.getForeground();
                    }
                    if (shadowColor == null) {
                        shadowColor = highlightColor;
                    }
                    if (highlightColor != null) {
                        BaseBorder.paintBorder((Graphics)g, (int)0, (int)0, (int)width, (int)height, (Color)highlightColor, (Color)shadowColor, (int)baseBorder_type, (int)border_width, (int)light_source, (int)border_sides);
                    }
                } else if (border_type == 2 || border_type == 8) {
                    Color highlightOuterColor = (Color)m_tempBorderStyle.get("highlightOuterColor", null);
                    Color highlightInnerColor = (Color)m_tempBorderStyle.get("highlightInnerColor", null);
                    Color shadowOuterColor = (Color)m_tempBorderStyle.get("shadowOuterColor", null);
                    Color shadowInnerColor = (Color)m_tempBorderStyle.get("shadowInnerColor", null);
                    Integer bevelType = (Integer)m_tempBorderStyle.get("bevelType", null);
                    if (bevelType == null) {
                        bevelType = new Integer(0);
                    }
                    if (highlightOuterColor == null) {
                        highlightOuterColor = SystemColor.controlLtHighlight;
                    }
                    if (highlightInnerColor == null) {
                        highlightInnerColor = SystemColor.controlHighlight;
                    }
                    if (shadowOuterColor == null) {
                        shadowOuterColor = SystemColor.controlDkShadow;
                    }
                    if (shadowInnerColor == null) {
                        shadowInnerColor = SystemColor.controlShadow;
                    }
                    if (border_type == 2) {
                        BevelBorder border = (BevelBorder)BorderFactory.createBevelBorder(bevelType, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
                        border.paintBorder(comp, g, 0, 0, width, height);
                    } else {
                        SoftBevelBorder border = new SoftBevelBorder(bevelType, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
                        border.paintBorder(comp, g, 0, 0, width, height);
                    }
                } else if (border_type == 6) {
                    Color lineColor = (Color)m_tempBorderStyle.get("lineColor", null);
                    Integer thickness = (Integer)m_tempBorderStyle.get("thickness", null);
                    Boolean rounded = (Boolean)m_tempBorderStyle.get("roundedCorners", null);
                    if (lineColor == null) {
                        lineColor = Color.lightGray;
                    }
                    if (thickness == null) {
                        thickness = new Integer(1);
                    }
                    LineBorder border = null;
                    border = rounded == null ? (LineBorder)BorderFactory.createLineBorder(lineColor, thickness) : new LineBorder(lineColor, thickness, rounded);
                    border.paintBorder(comp, g, 0, 0, width, height);
                } else if (border_type == 3) {
                    Border outsideBorder = (Border)m_tempBorderStyle.get("outsideBorder", null);
                    Border insideBorder = (Border)m_tempBorderStyle.get("insideBorder", null);
                    CompoundBorder border = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
                    border.paintBorder(comp, g, 0, 0, width, height);
                } else if (border_type == 5) {
                    Insets insets = (Insets)m_tempBorderStyle.get("insets", null);
                    if (insets == null) {
                        insets = new Insets(2, 2, 2, 2);
                    }
                    EmptyBorder border = (EmptyBorder)BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
                    border.paintBorder(comp, g, 0, 0, width, height);
                } else if (border_type == 4) {
                    Color highlightColor = (Color)m_tempBorderStyle.get("highlightColor", null);
                    Color shadowColor = (Color)m_tempBorderStyle.get("shadowColor", null);
                    Integer etchType = (Integer)m_tempBorderStyle.get("etchType", null);
                    if (etchType == null) {
                        etchType = new Integer(0);
                    }
                    if (highlightColor == null) {
                        highlightColor = SystemColor.controlHighlight;
                    }
                    if (shadowColor == null) {
                        shadowColor = SystemColor.controlShadow;
                    }
                    EtchedBorder border = (EtchedBorder)BorderFactory.createEtchedBorder(etchType, highlightColor, shadowColor);
                    border.paintBorder(comp, g, 0, 0, width, height);
                } else if (border_type == 7) {
                    Insets insets = (Insets)m_tempBorderStyle.get("insets", null);
                    Color color = (Color)m_tempBorderStyle.get("lineColor", null);
                    if (color == null) {
                        color = Color.lightGray;
                    }
                    if (insets == null) {
                        insets = new Insets(2, 2, 2, 2);
                    }
                    MatteBorder border = BorderFactory.createMatteBorder(insets.top, insets.left, insets.bottom, insets.right, color);
                    border.paintBorder(comp, g, 0, 0, width, height);
                } else if (border_type == 9) {
                    Color titleColor = (Color)m_tempBorderStyle.get("titleColor", null);
                    Font titleFont = (Font)m_tempBorderStyle.get("titleFont", null);
                    Border titleBorder = (Border)m_tempBorderStyle.get("titleBorder", null);
                    Integer justification = (Integer)m_tempBorderStyle.get("titleJustification", null);
                    Integer position = (Integer)m_tempBorderStyle.get("titlePosition", null);
                    String titleText = (String)m_tempBorderStyle.get("titleText", null);
                    if (titleColor == null) {
                        titleColor = SystemColor.textText;
                    }
                    if (titleFont == null) {
                        titleFont = new Font("Dialog", 1, 12);
                    }
                    if (justification == null) {
                        justification = new Integer(0);
                    }
                    if (position == null) {
                        position = new Integer(0);
                    }
                    TitledBorder border = BorderFactory.createTitledBorder(titleBorder, titleText, justification, position, titleFont, titleColor);
                    border.paintBorder(comp, g, 0, 0, width, height);
                }
            }
        }
    }

    protected void onPaintForeground(Graphics g, int width, int height) throws TableException {
        this.getView().paint(g);
    }

    protected abstract void onWriteObjectData() throws TableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        int cx = this.getHorizontalPosition();
        int cy = this.getVerticalPosition();
        int cw = this.getWidth();
        int ch = this.getHeight();
        Graphics cg = g.create(cx, cy, cw, ch);
        try {
            this.onPaintBackground(cg, cw, ch);
            this.onPaintForeground(cg, cw, ch);
            this.onPaintBorder(cg, cw, ch);
            if (this.isSelected()) {
                Util.invertRect((Graphics)cg, (int)0, (int)0, (int)cw, (int)ch);
            }
            if (this.isCurrent() && !this.isActivated() && this.tableView.isCurrentElementHighlighted()) {
                Util.drawFocusRect((Graphics)cg, (int)0, (int)0, (int)(cw - 1), (int)(ch - 1));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            cg.dispose();
        }
    }

    public void processFocusEvent(FocusEvent event) {
        this.m_view.processFocusEvent(event);
    }

    public void processKeyEvent(KeyEvent event) {
        this.setKeyHandled(true);
        this.m_view.processKeyEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMouseEvent(MouseEvent event) {
        int xOffset = this.getHorizontalPosition();
        int yOffset = this.getVerticalPosition();
        int id = event.getID();
        if (id == 501) {
            this.setMouseCaptured(true);
        } else if (id == 502) {
            this.setMouseCaptured(false);
        }
        try {
            event.translatePoint(-xOffset, -yOffset);
            this.m_view.processMouseEvent(event);
        }
        finally {
            event.translatePoint(xOffset, yOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMouseMotionEvent(MouseEvent event) {
        int xOffset = this.getHorizontalPosition();
        int yOffset = this.getVerticalPosition();
        try {
            event.translatePoint(-xOffset, -yOffset);
            this.m_view.processMouseMotionEvent(event);
        }
        finally {
            event.translatePoint(xOffset, yOffset);
        }
    }

    @Override
    public void refresh(int flags) {
        Cell self = this.getThisCell();
        if ((flags & 1) != 0) {
            self.m_flags &= 0xFFFFFFFB;
            this.setModified(false);
        }
        self.m_typeStylesVersion = -1;
        super.refresh(flags);
    }

    @Override
    public final void repaint() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void repaint(int x, int y, int width, int height) {
        if (!this.isDisplayed()) {
            return;
        }
        int x1 = this.getHorizontalPosition();
        int y1 = this.getVerticalPosition();
        int x2 = x1 + this.getWidth() - 1;
        int y2 = y1 + this.getHeight() - 1;
        x = x > 0 ? x1 + x : x1;
        y = y > 0 ? y1 + y : y1;
        if (x2 - width < x) {
            width = x2 - x + 1;
        }
        if (y2 - height < y) {
            height = y2 - y + 1;
        }
        if (width > 0 && height > 0) {
            this.tableView.repaint(x, y, width, height);
        }
    }

    public final void setActiveState(int newValue) {
        this.setActiveState(newValue, null);
    }

    public void setActiveState(int newValue, Point point) {
        if (this.getActiveState() == newValue) {
            return;
        }
        if (!CellActiveStates.validate(newValue)) {
            throw new IllegalArgumentException();
        }
        Cell self = this.getThisCell();
        int oldValue = self.m_activeState;
        if (point != null) {
            point = new Point(point.x - this.getHorizontalPosition(), point.y - this.getVerticalPosition());
        }
        self.m_activeState = newValue;
        if (self.m_view != null) {
            self.m_view.onActiveStateChanged(oldValue, newValue, point);
        }
    }

    public void setKeyHandled(boolean newValue) {
        this.getThisCell().m_flags = newValue ? (this.getThisCell().m_flags |= 2) : (this.getThisCell().m_flags &= 0xFFFFFFFD);
    }

    public void setModified(boolean newValue) {
        if (newValue) {
            if ((this.getThisCell().m_flags & 4) == 0) {
                return;
            }
            this.tableView.noteCellModified(this.getThisCell());
        } else {
            this.tableView.noteCellRefreshed(this.getThisCell());
        }
    }

    public void setMouseCaptured(boolean newValue) {
        this.getThisCell().m_flags = newValue ? (this.getThisCell().m_flags |= 1) : (this.getThisCell().m_flags &= 0xFFFFFFFE);
    }

    @Override
    public void setObsolete() {
        this.refresh(31);
        this.m_view = null;
    }

    public void writeObjectData() throws TableException {
        this.onWriteObjectData();
    }
}

