/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.table;

import com.sas.ComponentException;
import com.sas.swing.property.PropertyEditorHost;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.CustomizerHost;
import com.sas.swing.visuals.table.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AppearanceCustomizerPanel
extends SwingCustomizerPanel
implements PropertyChangeListener {
    public static final String RB_KEY = "AppearanceCustomizerPanel.";
    private transient CellStyle _cellStyle;
    protected CustomizerHost _opacityHost;
    protected PropertyEditorHost _bgHost;
    protected PropertyEditorHost _fgHost;
    protected PropertyEditorHost _fontHost;
    protected PropertyEditorHost _borderHost;
    protected PropertyEditorHost _topHost;
    protected PropertyEditorHost _leftHost;
    protected PropertyEditorHost _bottomHost;
    protected PropertyEditorHost _rightHost;
    protected CustomizerHost _horzHost;
    protected CustomizerHost _vertHost;
    protected PropertyEditorHost _splitHost;
    protected CustomizerHost _wrappedHost;
    private PropertyEditor _opacityEditor;
    private PropertyEditor _bgEditor;
    private PropertyEditor _fgEditor;
    private PropertyEditor _fontEditor;
    private PropertyEditor _borderEditor;
    private PropertyEditor _topEditor;
    private PropertyEditor _leftEditor;
    private PropertyEditor _bottomEditor;
    private PropertyEditor _rightEditor;
    private PropertyEditor _horzEditor;
    private PropertyEditor _vertEditor;
    private PropertyEditor _splitEditor;
    private PropertyEditor _wrappedEditor;

    public AppearanceCustomizerPanel() {
        this(RB.getStringResource(RB_KEY, "appearanceTab.txt"));
    }

    public AppearanceCustomizerPanel(String tabName) {
        super(tabName);
        this.createGUI();
    }

    public void initialize() {
    }

    protected void createGUI() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout asgl = new AutoSizingGridLayout(3, 2, 5, 5);
        asgl.setFillCell(true);
        asgl.setUseColumnRemainder(true);
        asgl.setRemainderColumn(2);
        this.setLayout((LayoutManager)asgl);
        JPanel c = new JPanel();
        c.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "colorLabel.txt"), (int)5, (int)5, (int)5, (int)5));
        this.add(c);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(3, 2);
        mainLayout.setHgap(5);
        mainLayout.setVgap(5);
        mainLayout.setFillCell(true);
        c.setLayout((LayoutManager)mainLayout);
        this._opacityHost = new CustomizerHost();
        this._opacityHost.setStyleProperty("opacity");
        this._bgHost = new PropertyEditorHost();
        this._fgHost = new PropertyEditorHost();
        c.add(new JLabel(RB.getStringResource(RB_KEY, "transparencyLabel.txt")));
        c.add(this._opacityHost);
        c.add(new JLabel(RB.getStringResource(RB_KEY, "backgroundLabel.txt")));
        c.add(this._bgHost);
        c.add(new JLabel(RB.getStringResource(RB_KEY, "foregroundLabel.txt")));
        c.add(this._fgHost);
        c = new JPanel();
        c.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "fontLabel.txt"), (int)5, (int)5, (int)5, (int)5));
        this.add(c);
        mainLayout = new AutoSizingGridLayout(1, 1);
        mainLayout.setHgap(5);
        mainLayout.setVgap(5);
        mainLayout.setFillCell(true);
        mainLayout.setUseColumnRemainder(true);
        mainLayout.setRemainderColumn(1);
        c.setLayout((LayoutManager)mainLayout);
        this._fontHost = new PropertyEditorHost();
        c.add(this._fontHost);
        c = new JPanel();
        c.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "marginsLabel.txt"), (int)5, (int)5, (int)5, (int)5));
        this.add(c);
        JLabel left = new JLabel(RB.getStringResource(RB_KEY, "leftLabel.txt"));
        this._leftHost = new PropertyEditorHost();
        JLabel right = new JLabel(RB.getStringResource(RB_KEY, "rightLabel.txt"));
        this._rightHost = new PropertyEditorHost();
        JLabel top = new JLabel(RB.getStringResource(RB_KEY, "topLabel.txt"));
        this._topHost = new PropertyEditorHost();
        JLabel bottom = new JLabel(RB.getStringResource(RB_KEY, "bottomLabel.txt"));
        this._bottomHost = new PropertyEditorHost();
        GridBagLayout gbl = new GridBagLayout();
        c.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbl.setConstraints(left, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbl.setConstraints(this._leftHost, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbl.setConstraints(right, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbl.setConstraints(this._rightHost, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbl.setConstraints(top, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbl.setConstraints(this._topHost, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbl.setConstraints(bottom, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(this._bottomHost, gbc);
        c.add(left);
        c.add(this._leftHost);
        c.add(right);
        c.add(this._rightHost);
        c.add(top);
        c.add(this._topHost);
        c.add(bottom);
        c.add(this._bottomHost);
        c = new JPanel();
        c.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "justificationLabel.txt"), (int)5, (int)5, (int)5, (int)5));
        this.add(c);
        mainLayout = new AutoSizingGridLayout(2, 2);
        mainLayout.setHgap(5);
        mainLayout.setVgap(5);
        mainLayout.setFillCell(true);
        mainLayout.setUseColumnRemainder(true);
        mainLayout.setRemainderColumn(2);
        c.setLayout((LayoutManager)mainLayout);
        this._horzHost = new CustomizerHost();
        this._horzHost.setStyleProperty("horizontalJustification");
        this._vertHost = new CustomizerHost();
        this._vertHost.setStyleProperty("verticalJustification");
        c.add(new JLabel(RB.getStringResource(RB_KEY, "horizontalLabel.txt")));
        c.add(this._horzHost);
        c.add(new JLabel(RB.getStringResource(RB_KEY, "verticalLabel.txt")));
        c.add(this._vertHost);
        c = new JPanel();
        c.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "borderLabel.txt"), (int)5, (int)5, (int)5, (int)5));
        this.add(c);
        mainLayout = new AutoSizingGridLayout(1, 1);
        mainLayout.setFillCell(true);
        c.setLayout((LayoutManager)mainLayout);
        this._borderHost = new PropertyEditorHost();
        c.add(this._borderHost);
        c = new JPanel();
        c.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "textLabel.txt"), (int)5, (int)5, (int)5, (int)5));
        this.add(c);
        mainLayout = new AutoSizingGridLayout(2, 2);
        mainLayout.setHgap(5);
        mainLayout.setVgap(5);
        mainLayout.setFillCell(true);
        mainLayout.setUseColumnRemainder(true);
        mainLayout.setRemainderColumn(2);
        c.setLayout((LayoutManager)mainLayout);
        this._splitHost = new PropertyEditorHost();
        this._wrappedHost = new CustomizerHost();
        this._wrappedHost.setStyleProperty("wrapped");
        c.add(new JLabel(RB.getStringResource(RB_KEY, "splitCharacterLabel.txt")));
        c.add(this._splitHost);
        c.add(new JLabel(RB.getStringResource(RB_KEY, "wrapTextLabel.txt")));
        c.add(this._wrappedHost);
        this.addLinks();
    }

    private void addLinks() {
    }

    @Override
    public void customizerClosing() {
        this._opacityEditor.removePropertyChangeListener(this);
        this._bgEditor.removePropertyChangeListener(this);
        this._fgEditor.removePropertyChangeListener(this);
        this._fontEditor.removePropertyChangeListener(this);
        this._borderEditor.removePropertyChangeListener(this);
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (!(bean instanceof CellStyle)) {
            throw new ComponentException(com.sas.visuals.RB.getStringResource((String)RB_KEY, (String)"InvalidInterface.ex.txt"));
        }
        this._cellStyle = (CellStyle)((Object)bean);
        this.setup();
    }

    private void setup() {
        Object value = this._cellStyle.get("opacity", null);
        Class cls = CellStyle.getPropertyClass("opacity");
        this._opacityHost.setPropertyValue(value, cls);
        this._opacityEditor = this._opacityHost.getPropertyEditor();
        this._opacityEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("backgroundColor", null);
        cls = CellStyle.getPropertyClass("backgroundColor");
        this._bgHost.setPropertyValue(value, cls);
        this._bgEditor = this._bgHost.getPropertyEditor();
        this._bgEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("foregroundColor", null);
        cls = CellStyle.getPropertyClass("foregroundColor");
        this._fgHost.setPropertyValue(value, cls);
        this._fgEditor = this._fgHost.getPropertyEditor();
        this._fgEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("fontStyle", null);
        cls = CellStyle.getPropertyClass("fontStyle");
        this._fontHost.setPropertyValue(value, cls);
        this._fontEditor = this._fontHost.getPropertyEditor();
        this._fontEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("borderStyle", null);
        cls = CellStyle.getPropertyClass("borderStyle");
        this._borderHost.setPropertyValue(value, cls);
        this._borderEditor = this._borderHost.getPropertyEditor();
        this._borderEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("leftMargin", null);
        cls = CellStyle.getPropertyClass("leftMargin");
        this._leftHost.setPropertyValue(value, cls);
        this._leftEditor = this._leftHost.getPropertyEditor();
        this._leftEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("rightMargin", null);
        cls = CellStyle.getPropertyClass("rightMargin");
        this._rightHost.setPropertyValue(value, cls);
        this._rightEditor = this._rightHost.getPropertyEditor();
        this._rightEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("topMargin", null);
        cls = CellStyle.getPropertyClass("topMargin");
        this._topHost.setPropertyValue(value, cls);
        this._topEditor = this._topHost.getPropertyEditor();
        this._topEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("bottomMargin", null);
        cls = CellStyle.getPropertyClass("bottomMargin");
        this._bottomHost.setPropertyValue(value, cls);
        this._bottomEditor = this._bottomHost.getPropertyEditor();
        this._bottomEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("horizontalJustification", null);
        cls = CellStyle.getPropertyClass("horizontalJustification");
        this._horzHost.setPropertyValue(value, cls);
        this._horzEditor = this._horzHost.getPropertyEditor();
        this._horzEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("verticalJustification", null);
        cls = CellStyle.getPropertyClass("verticalJustification");
        this._vertHost.setPropertyValue(value, cls);
        this._vertEditor = this._vertHost.getPropertyEditor();
        this._vertEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("splitCharacter", null);
        cls = CellStyle.getPropertyClass("splitCharacter");
        this._splitHost.setPropertyValue(value, cls);
        this._splitEditor = this._splitHost.getPropertyEditor();
        this._splitEditor.addPropertyChangeListener(this);
        value = this._cellStyle.get("wrapped", null);
        cls = CellStyle.getPropertyClass("wrapped");
        this._wrappedHost.setPropertyValue(value, cls);
        this._wrappedEditor = this._wrappedHost.getPropertyEditor();
        this._wrappedEditor.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof PropertyEditor)) {
            return;
        }
        String propertyId = null;
        if (source == this._borderEditor) {
            propertyId = "borderStyle";
        } else if (source == this._bgEditor) {
            propertyId = "backgroundColor";
        } else if (source == this._fgEditor) {
            propertyId = "foregroundColor";
        } else if (source == this._fontEditor) {
            propertyId = "fontStyle";
        } else if (source == this._opacityEditor) {
            propertyId = "opacity";
        } else if (source == this._leftEditor) {
            propertyId = "leftMargin";
        } else if (source == this._rightEditor) {
            propertyId = "rightMargin";
        } else if (source == this._topEditor) {
            propertyId = "topMargin";
        } else if (source == this._bottomEditor) {
            propertyId = "bottomMargin";
        } else if (source == this._horzEditor) {
            propertyId = "horizontalJustification";
        } else if (source == this._vertEditor) {
            propertyId = "verticalJustification";
        } else if (source == this._splitEditor) {
            propertyId = "splitCharacter";
        } else if (source == this._wrappedEditor) {
            propertyId = "wrapped";
        }
        Object value = ((PropertyEditor)source).getValue();
        if (value != null) {
            this._cellStyle.set(propertyId, value);
        } else if (this._cellStyle.containsKey(propertyId)) {
            this._cellStyle.remove(propertyId);
        }
    }
}

