/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.mdtable;

import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.NodeInterface;
import com.sas.mdtable.StaticNodeStyleInterface;
import com.sas.table.TableException;

final class Node {
    private static final PropertyBag PLACEHOLDER_STYLE = new PropertyBag();
    private NodeInterface node;
    private StaticPropertyBagInterface m_defaultCellStyle;
    private StaticPropertyBagInterface m_defaultLabelStyle;
    private StaticPropertyBagInterface m_modelDefaultCellStyle;
    private StaticPropertyBagInterface m_modelDefaultLabelStyle;

    public Node(NodeInterface node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.node = node;
        this.m_modelDefaultCellStyle = PLACEHOLDER_STYLE;
        this.m_modelDefaultLabelStyle = PLACEHOLDER_STYLE;
    }

    public final NodeInterface getMetaNode() {
        return this.node;
    }

    public String getLabel() {
        try {
            return this.node.getLabel();
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public String getName() {
        try {
            return this.node.getName();
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public StaticPropertyBagInterface getDefaultCellStyle() {
        return this.m_defaultCellStyle;
    }

    public void setDefaultCellStyle(StaticPropertyBagInterface newValue) {
        this.m_defaultCellStyle = newValue;
    }

    public StaticPropertyBagInterface getDefaultLabelStyle() {
        return this.m_defaultLabelStyle;
    }

    public void setDefaultLabelStyle(StaticPropertyBagInterface newValue) {
        this.m_defaultLabelStyle = newValue;
    }

    public StaticPropertyBagInterface getModelDefaultCellStyle() {
        if (this.m_modelDefaultCellStyle == PLACEHOLDER_STYLE) {
            this.m_modelDefaultCellStyle = null;
            if (this.node instanceof StaticNodeStyleInterface) {
                StaticNodeStyleInterface model = (StaticNodeStyleInterface)((Object)this.node);
                try {
                    this.m_modelDefaultCellStyle = model.getDefaultCellStyle();
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.m_modelDefaultCellStyle;
    }

    public StaticPropertyBagInterface getModelDefaultLabelStyle() {
        if (this.m_modelDefaultLabelStyle == PLACEHOLDER_STYLE) {
            this.m_modelDefaultLabelStyle = null;
            if (this.node instanceof StaticNodeStyleInterface) {
                StaticNodeStyleInterface model = (StaticNodeStyleInterface)((Object)this.node);
                try {
                    this.m_modelDefaultLabelStyle = model.getDefaultLabelStyle();
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.m_modelDefaultLabelStyle;
    }

    public Object getEffectiveCellStylePropertyValue(String propertyID, Object defaultValue) {
        StaticPropertyBagInterface style = this.getDefaultCellStyle();
        if (style != null && style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        style = this.getModelDefaultCellStyle();
        if (style != null && style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        return defaultValue;
    }

    public Object getEffectiveLabelStylePropertyValue(String propertyID, Object defaultValue) {
        StaticPropertyBagInterface style = this.getDefaultLabelStyle();
        if (style != null && style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        style = this.getModelDefaultLabelStyle();
        if (style != null && style.containsKey(propertyID)) {
            return style.get(propertyID);
        }
        return defaultValue;
    }

    public void getEffectiveCellStylePropertyBag(String propertyID, PropertyBagInterface bag) {
        StaticPropertyBagInterface style = this.getDefaultCellStyle();
        if (style != null && style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
        if ((style = this.getModelDefaultCellStyle()) != null && style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
    }

    public void getEffectiveLabelStylePropertyBag(String propertyID, PropertyBagInterface bag) {
        StaticPropertyBagInterface style = this.getDefaultLabelStyle();
        if (style != null && style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
        if ((style = this.getModelDefaultLabelStyle()) != null && style.containsKey(propertyID)) {
            bag.merge((StaticPropertyBagInterface)style.get(propertyID));
        }
    }
}

