/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.mdtable;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.Dictionary;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.mdtable.StaticFormattedDataInterface;
import com.sas.mdtable.StaticMultidimensionalTableInterface;
import com.sas.mdtable.StaticMultidimensionalTableStyleInterface;
import com.sas.mdtable.StaticMultidimensionalTableTypeInterface;
import com.sas.mdtable.StaticMultidimensionalTableTypeStylesInterface;
import com.sas.models.TreeInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.TotalInterface;
import com.sas.swing.visuals.mdtable.Label;
import com.sas.swing.visuals.mdtable.MultidimensionalTableView;
import com.sas.swing.visuals.mdtable.RB;
import com.sas.table.FormatInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticColumnTemplateTableInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.StaticTableInterfaceSupport;
import com.sas.table.StaticTableStyleInterface;
import com.sas.table.StaticTableTypeStylesInterface;
import com.sas.table.TableException;
import com.sas.util.PreorderTreeIterator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class MdTo2dTable
extends Component
implements StaticTableInterface,
StaticRowLabelInterface,
StaticColumnLabelInterface,
StaticTableStyleInterface,
StaticTableTypeStylesInterface,
StaticRowTemplateTableInterface,
StaticColumnTemplateTableInterface,
ContentsChangedSource,
PropertyChangeListener,
FormatInterface {
    static final long serialVersionUID = -67313863468593430L;
    public static final String RB_KEY = "MdTo2dTable.";
    public static final int ROW_LABELS_AS_LABELS_LAYOUT = 0;
    public static final int ROW_LABELS_AS_COLUMNS_LAYOUT = 1;
    static final int ROW_LABELS_OUTLINE_LAYOUT = 2;
    private static final String[] requiredInterfacesString = new String[]{"com.sas.mdtable.StaticMultidimensionalTableInterface"};
    private static final int UNDEFINED_COUNT = -1;
    private transient ModelListener m_modelListener;
    private transient StaticMultidimensionalTableStyleInterface m_styles;
    private transient StaticMultidimensionalTableInterface m_table;
    private transient StaticMultidimensionalTableTypeInterface m_staticTableTypeModel;
    private transient StaticMultidimensionalTableTypeStylesInterface m_staticTableTypeStylesModel;
    private transient StaticFormattedDataInterface m_formattedDataModel;
    private transient FormatInterface m_formatInterface;
    private transient AxisInterface[] m_axes;
    private transient int m_colCount;
    private transient int m_rowCount;
    private transient LayoutStrategy m_layoutStrategy;
    private transient int[] m_rowMap;
    private boolean m_colLabelsConcatenated;
    private boolean m_rowLabelsConcatenated;
    private int m_layout;
    private boolean m_transposed;
    private boolean m_totalRowsHidden;
    private transient ContentsChangedListenerList allContentsChangedListeners;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "cellStylesSupported"}, {"Hidden", "true"}}, {{"Name", "cellTypeStyles"}, {"Hidden", "true"}}, {{"Name", "cellTypes"}, {"Hidden", "true"}}, {{"Name", "columnAxis"}, {"Hidden", "true"}}, {{"Name", "columnCount"}, {"Hidden", "true"}}, {{"Name", "columnLabelStylesSupported"}, {"Hidden", "true"}}, {{"Name", "columnLabelsSupported"}, {"Hidden", "true"}}, {{"Name", "columnStylesSupported"}, {"Hidden", "true"}}, {{"Name", "columnTypeStyles"}, {"Hidden", "true"}}, {{"Name", "columnTypes"}, {"Hidden", "true"}}, {{"Name", "columnsLabelSupported"}, {"Hidden", "true"}}, {{"Name", "defaultCellStyle"}, {"Hidden", "true"}}, {{"Name", "defaultColumnStyle"}, {"Hidden", "true"}}, {{"Name", "defaultLabelStyle"}, {"Hidden", "true"}}, {{"Name", "defaultRowStyle"}, {"Hidden", "true"}}, {{"Name", "designTime"}, {"Hidden", "true"}}, {{"Name", "rowAxis"}, {"Hidden", "true"}}, {{"Name", "rowCount"}, {"Hidden", "true"}}, {{"Name", "rowLabelStylesSupported"}, {"Hidden", "true"}}, {{"Name", "rowLabelsSupported"}, {"Hidden", "true"}}, {{"Name", "rowStylesSupported"}, {"Hidden", "true"}}, {{"Name", "rowTypeStyles"}, {"Hidden", "true"}}, {{"Name", "rowTypes"}, {"Hidden", "true"}}, {{"Name", "rowsLabelSupported"}, {"Hidden", "true"}}, {{"Name", "rowLabelsLayout"}, {"Property editor class", "com.sas.beans.editors._SwingMdTo2dTableRowLabelsLayoutEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public MdTo2dTable() {
        this.setDefaultValues();
        this.initializeTransients();
    }

    private void initializeTransients() {
        if (this.m_layout != 2) {
            this.setRowLabelsLayout(this.m_layout);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            stream.defaultReadObject();
        }
        finally {
            this.initializeTransients();
        }
    }

    public void setModel(StaticMultidimensionalTableInterface model) {
        StaticMultidimensionalTableInterface oldModel = this.getModel();
        if (oldModel == model) {
            return;
        }
        if (model == null) {
            this.refresh((StaticMultidimensionalTableInterface)null);
            if (oldModel instanceof ContentsChangedSource) {
                ((ContentsChangedSource)oldModel).removeContentsChangedListener((ContentsChangedListener)this.m_modelListener);
            }
            if (oldModel != null) {
                Util.removePropertyChangeListener((Object)oldModel, (PropertyChangeListener)this);
            }
            this.m_table = null;
            this.m_styles = null;
            this.m_staticTableTypeModel = null;
            this.m_staticTableTypeStylesModel = null;
            this.m_formattedDataModel = null;
            this.m_formatInterface = null;
        } else {
            if (this.m_table != null) {
                this.setModel(null);
            }
            this.m_table = model;
            this.refresh(model);
            if (model instanceof ContentsChangedSource) {
                if (this.m_modelListener == null) {
                    this.m_modelListener = new ModelListener();
                }
                ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this.m_modelListener);
            }
            Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)this);
            if (model instanceof StaticMultidimensionalTableStyleInterface) {
                this.m_styles = (StaticMultidimensionalTableStyleInterface)((Object)model);
            }
            if (model instanceof StaticMultidimensionalTableTypeInterface) {
                this.m_staticTableTypeModel = (StaticMultidimensionalTableTypeInterface)((Object)model);
                if (model instanceof StaticMultidimensionalTableTypeStylesInterface) {
                    this.m_staticTableTypeStylesModel = (StaticMultidimensionalTableTypeStylesInterface)((Object)model);
                }
            }
            if (model instanceof StaticFormattedDataInterface) {
                this.m_formattedDataModel = (StaticFormattedDataInterface)((Object)model);
            }
        }
        if (model instanceof FormatInterface) {
            this.m_formatInterface = (FormatInterface)model;
        }
        this.firePropertyChange("model", oldModel, this.m_table);
    }

    public StaticMultidimensionalTableInterface getModel() {
        return this.m_table;
    }

    public synchronized int convertToOrdinal(int rowIndex, int colIndex) {
        return this.convertToOrdinal(rowIndex, colIndex, this.getRowCount(), this.getColumnCount());
    }

    private int convertToOrdinalInternal(int rowIndex, int colIndex) {
        return this.convertToOrdinal(rowIndex, colIndex, this.getRowCountInternal(), this.getColumnCountInternal());
    }

    private int convertToOrdinal(int rowIndex, int colIndex, int rowCount, int colCount) {
        if (rowIndex <= 0 || rowIndex > rowCount) {
            throw new IndexOutOfBoundsException();
        }
        if (colIndex <= 0 || colIndex > colCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isTransposed()) {
            return (colIndex - 1) * rowCount + (rowIndex - 1);
        }
        return (rowIndex - 1) * colCount + (colIndex - 1);
    }

    public synchronized void setDefaultValues() {
        this.m_colLabelsConcatenated = true;
        this.m_layout = 1;
    }

    private AxisInterface[] getAxes() {
        if (this.m_axes == null) {
            if (this.m_table != null) {
                try {
                    if (this.m_table.getAxisCount() == 2) {
                        this.m_axes = this.m_table.getAxes(0, 2);
                    }
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.m_axes == null) {
                this.m_axes = new AxisInterface[2];
                this.m_axes[0] = null;
                this.m_axes[1] = null;
            }
        }
        return this.m_axes;
    }

    public synchronized AxisInterface getColumnAxis() {
        return this.isTransposed() ? this.getAxes()[1] : this.getAxes()[0];
    }

    public synchronized Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public synchronized AxisInterface getRowAxis() {
        return this.isTransposed() ? this.getAxes()[0] : this.getAxes()[1];
    }

    public synchronized boolean isColumnLabelsConcatenated() {
        return this.m_colLabelsConcatenated;
    }

    public synchronized void setColumnLabelsConcatenated(boolean newValue) {
        if (newValue != this.m_colLabelsConcatenated) {
            this.m_colLabelsConcatenated = newValue;
            this.refresh();
        }
    }

    public synchronized boolean isRowLabelsConcatenated() {
        return this.m_rowLabelsConcatenated;
    }

    public synchronized void setRowLabelsConcatenated(boolean newValue) {
        if (newValue != this.m_rowLabelsConcatenated) {
            this.m_rowLabelsConcatenated = newValue;
            this.refresh();
        }
    }

    public synchronized int getRowLabelsLayout() {
        return this.m_layout;
    }

    public synchronized void setRowLabelsLayout(int newValue) {
        LayoutStrategy ls = this.m_layoutStrategy;
        if (this.m_layout == newValue && ls != null) {
            return;
        }
        if (newValue == 0) {
            this.m_layoutStrategy = new LayoutStrategy(this);
        } else if (newValue == 1) {
            this.m_layoutStrategy = new RowLabelsAsColumnsLayout(this);
        } else {
            throw new IllegalArgumentException();
        }
        this.m_layout = newValue;
        if (ls != null) {
            this.refresh();
        }
    }

    final void setRowLabelsLayout(int newValue, MultidimensionalTableView tableView) {
        if (newValue == 2) {
            this.m_layoutStrategy = new RowLabelsOutlineLayout(this, tableView);
            this.m_layout = newValue;
            this.refresh();
        } else {
            this.setRowLabelsLayout(newValue);
        }
    }

    public synchronized boolean isTotalRowsHidden() {
        return this.m_totalRowsHidden;
    }

    public synchronized void setTotalRowsHidden(boolean newValue) {
        if (this.m_totalRowsHidden == newValue) {
            return;
        }
        this.m_totalRowsHidden = newValue;
        this.refresh();
    }

    public synchronized boolean isTransposed() {
        return this.m_transposed;
    }

    public synchronized boolean isColumnSummable(int colIndex) {
        try {
            return this.m_layoutStrategy.isColumnSummable(colIndex);
        }
        catch (TableException tex) {
            return false;
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent e) {
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public final void refresh() {
        StaticMultidimensionalTableInterface model = this.getModel();
        if (model != null) {
            this.refresh(model);
        }
    }

    public void refresh(StaticMultidimensionalTableInterface model) {
        this.refresh(new ContentsChangedEvent((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(ContentsChangedEvent event) {
        MdTo2dTable mdTo2dTable = this;
        synchronized (mdTo2dTable) {
            this.m_axes = null;
            this.m_colCount = -1;
            this.m_rowCount = -1;
            this.m_rowMap = null;
            if (this.m_layoutStrategy != null) {
                this.m_layoutStrategy.refresh();
            }
        }
        this.fireContentsChanged(event);
    }

    public synchronized void setTransposed(boolean newValue) {
        if (this.m_transposed == newValue) {
            return;
        }
        this.m_transposed = newValue;
        this.refresh();
        this.firePropertyChange("transposed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized int countColumns(int maxCount) throws TableException {
        return this.m_layoutStrategy.countColumns(maxCount);
    }

    public synchronized int countRows(int maxCount) throws TableException {
        return this.m_layoutStrategy.countRows(maxCount);
    }

    public synchronized Object getCell(int rowIndex, int colIndex) throws TableException {
        if (this.getRowMap() != null) {
            rowIndex = this.getRowMap()[rowIndex - 1];
        }
        return this.m_layoutStrategy.getCell(rowIndex, colIndex);
    }

    public synchronized Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        if (this.getRowMap() != null) {
            return this.m_layoutStrategy.getCellsOneByOne(startRowIndex, startColumnIndex, rowCount, columnCount);
        }
        return this.m_layoutStrategy.getCells(startRowIndex, startColumnIndex, rowCount, columnCount);
    }

    public synchronized Class getCellClass(int rowIndex, int colIndex) throws TableException {
        if (this.getRowMap() != null) {
            rowIndex = this.getRowMap()[rowIndex - 1];
        }
        return this.m_layoutStrategy.getCellClass(rowIndex, colIndex);
    }

    public synchronized Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        return StaticTableInterfaceSupport.getCellClasses(this, startRowIndex, startColumnIndex, rowCount, columnCount);
    }

    public synchronized Object[] getColumn(int index) throws TableException {
        int rowCount = this.getRowCount();
        return this.reshapeArray(this.getCells(1, index, rowCount, 1), rowCount, 1);
    }

    private Object[] reshapeArray(Object[][] array, int rowCount, int colCount) {
        return this.reshapeArray(array, rowCount, colCount, new Object[rowCount * colCount]);
    }

    private String[] reshapeArray(String[][] array, int rowCount, int colCount) {
        return (String[])this.reshapeArray(array, rowCount, colCount, new String[rowCount * colCount]);
    }

    private Object[] reshapeArray(Object[][] array, int rowCount, int colCount, Object[] newArray) {
        int i = 0;
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                newArray[i++] = array[r][c];
            }
        }
        return newArray;
    }

    private Object[][] reshapeArray(Object[] array, int rowCount, int colCount) {
        return this.reshapeArray(array, rowCount, colCount, new Object[rowCount][colCount]);
    }

    private String[][] reshapeArray(String[] array, int rowCount, int colCount) {
        return (String[][])this.reshapeArray(array, rowCount, colCount, new String[rowCount][colCount]);
    }

    private Object[][] reshapeArray(Object[] array, int rowCount, int colCount, Object[][] newArray) {
        int i = 0;
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                newArray[r][c] = array[i++];
            }
        }
        return newArray;
    }

    public synchronized int getColumnCount() {
        return this.m_layoutStrategy.getColumnCount();
    }

    private int getColumnCountInternal() {
        if (this.m_colCount == -1) {
            this.m_colCount = 0;
            AxisInterface axis = this.getColumnAxis();
            if (axis != null) {
                try {
                    this.m_colCount = axis.getMagnitude();
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.m_colCount;
    }

    public synchronized Object[] getRow(int index) throws TableException {
        int colCount = this.getColumnCount();
        return this.reshapeArray(this.getCells(index, 1, 1, colCount), 1, colCount);
    }

    public synchronized int getRowCount() {
        if (this.getRowMap() != null) {
            return this.getRowMap().length;
        }
        return this.m_layoutStrategy.getRowCount();
    }

    private int getRowCountInternal() {
        if (this.m_rowCount == -1) {
            this.m_rowCount = 0;
            AxisInterface axis = this.getRowAxis();
            if (axis != null) {
                try {
                    this.m_rowCount = axis.getMagnitude();
                }
                catch (TableException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.isTotalRowsHidden() && this.totalRowsEnabled()) {
                int[] rowMap = new int[this.m_rowCount];
                int i = 0;
                for (int r = 0; r < this.m_rowCount; ++r) {
                    boolean hide = false;
                    try {
                        AxisLabelInterface[] labels = axis.getLabels(r);
                        for (int l = labels.length - 1; l >= 0; --l) {
                            TotalInterface total = (TotalInterface)((Object)labels[l].getMember().getLevel());
                            if (!total.getTotalState() || !labels[l].getLabel().equals(total.getTotalLabel())) continue;
                            hide = true;
                            break;
                        }
                    }
                    catch (TableException tableException) {
                        // empty catch block
                    }
                    if (hide) continue;
                    rowMap[i] = r + 1;
                    ++i;
                }
                this.m_rowMap = new int[i];
                for (int j = 0; j < i; ++j) {
                    this.m_rowMap[j] = rowMap[j];
                }
            }
        }
        return this.m_rowCount;
    }

    private int[] getRowMap() {
        if (this.m_rowMap == null) {
            if (this.isTotalRowsHidden()) {
                this.m_layoutStrategy.getRowCount();
            }
            if (this.m_rowMap == null) {
                this.m_rowMap = new int[0];
            }
        }
        if (this.m_rowMap.length == 0) {
            return null;
        }
        return this.m_rowMap;
    }

    private boolean totalRowsEnabled() {
        if (this.m_table instanceof MultidimensionalTableInterface) {
            try {
                AxisInterface rowAxis = this.getRowAxis();
                int dCount = rowAxis.getDimensionCount();
                for (int d = 0; d < dCount; ++d) {
                    DimensionInterface dim = rowAxis.getDimension(d);
                    int lCount = dim.getLevelCount();
                    for (int l = 0; l < lCount; ++l) {
                        if (!((TotalInterface)((Object)dim.getLevel(l))).getTotalState()) continue;
                        return true;
                    }
                }
            }
            catch (TableException tex) {
                tex.printStackTrace();
            }
        }
        return false;
    }

    public synchronized Object getRowLabel(int index) throws TableException {
        if (this.getRowMap() != null) {
            index = this.getRowMap()[index - 1];
        }
        return this.m_layoutStrategy.getRowLabel(index);
    }

    public synchronized Object[] getRowLabels(int startIndex, int count) throws TableException {
        Object[] labels = new Object[count];
        int i = 0;
        int row = startIndex;
        while (i < count) {
            labels[i] = this.getRowLabel(row);
            ++i;
            ++row;
        }
        return labels;
    }

    public boolean isRowsLabelSupported() throws TableException {
        return false;
    }

    public boolean isRowLabelsSupported() throws TableException {
        return true;
    }

    public synchronized Object getColumnLabel(int index) throws TableException {
        return this.m_layoutStrategy.getColumnLabel(index);
    }

    public synchronized Object[] getColumnLabels(int startIndex, int count) throws TableException {
        Object[] labels = new Object[count];
        int i = 0;
        int col = startIndex;
        while (i < count) {
            labels[i] = this.getColumnLabel(col);
            ++i;
            ++col;
        }
        return labels;
    }

    public boolean isColumnsLabelSupported() throws TableException {
        return false;
    }

    public boolean isColumnLabelsSupported() throws TableException {
        return true;
    }

    @Override
    public synchronized StaticPropertyBagInterface getDefaultCellStyle() throws TableException {
        return this.m_styles != null ? this.m_styles.getDefaultCellStyle() : null;
    }

    @Override
    public StaticPropertyBagInterface getDefaultColumnStyle() throws TableException {
        return null;
    }

    @Override
    public synchronized StaticPropertyBagInterface getDefaultLabelStyle() throws TableException {
        return this.m_styles != null ? this.m_styles.getDefaultLabelStyle() : null;
    }

    @Override
    public StaticPropertyBagInterface getDefaultRowStyle() throws TableException {
        return null;
    }

    @Override
    public synchronized StaticPropertyBagInterface getCellStyle(int rowIndex, int colIndex) throws TableException {
        if (this.getRowMap() != null) {
            rowIndex = this.getRowMap()[rowIndex - 1];
        }
        return this.m_layoutStrategy.getCellStyle(rowIndex, colIndex);
    }

    @Override
    public StaticPropertyBagInterface getColumnStyle(int colIndex) throws TableException {
        throw new IllegalStateException();
    }

    @Override
    public StaticPropertyBagInterface getColumnLabelStyle(int colIndex) throws TableException {
        throw new IllegalStateException();
    }

    @Override
    public StaticPropertyBagInterface getRowStyle(int rowIndex) throws TableException {
        throw new IllegalStateException();
    }

    @Override
    public StaticPropertyBagInterface getRowLabelStyle(int rowIndex) throws TableException {
        throw new IllegalStateException();
    }

    @Override
    public synchronized boolean isCellStylesSupported() throws TableException {
        return this.m_styles != null ? this.m_styles.isCellStylesSupported() : false;
    }

    @Override
    public boolean isColumnStylesSupported() throws TableException {
        return false;
    }

    @Override
    public boolean isColumnLabelStylesSupported() throws TableException {
        return false;
    }

    @Override
    public boolean isRowStylesSupported() throws TableException {
        return false;
    }

    @Override
    public boolean isRowLabelStylesSupported() throws TableException {
        return false;
    }

    public synchronized String[] getCellTypes() throws TableException {
        if (this.m_staticTableTypeModel != null) {
            return this.m_staticTableTypeModel.getCellTypes();
        }
        return null;
    }

    public synchronized String[] getCellType(int rowIndex, int colIndex) throws TableException {
        if (this.getRowMap() != null) {
            rowIndex = this.getRowMap()[rowIndex - 1];
        }
        return this.m_layoutStrategy.getCellType(rowIndex, colIndex);
    }

    public synchronized String[] getColumnLabelType(int colIndex) throws TableException {
        return this.m_layoutStrategy.getColumnLabelType(colIndex);
    }

    public synchronized String[] getRowLabelType(int rowIndex) throws TableException {
        if (this.getRowMap() != null) {
            rowIndex = this.getRowMap()[rowIndex - 1];
        }
        return this.m_layoutStrategy.getRowLabelType(rowIndex);
    }

    public String[] getColumnTypes() throws TableException {
        return null;
    }

    public String[] getColumnType(int colIndex) throws TableException {
        return null;
    }

    public String[] getRowTypes() throws TableException {
        return null;
    }

    public String[] getRowType(int rowIndex) throws TableException {
        return null;
    }

    @Override
    public synchronized StaticPropertyBagInterface[] getCellTypeStyles() throws TableException {
        if (this.m_staticTableTypeStylesModel != null) {
            return this.m_staticTableTypeStylesModel.getCellTypeStyles();
        }
        return null;
    }

    @Override
    public synchronized StaticPropertyBagInterface getCellTypeStyle(String type) throws TableException {
        if (this.m_staticTableTypeStylesModel != null) {
            return this.m_staticTableTypeStylesModel.getCellTypeStyle(type);
        }
        return null;
    }

    @Override
    public StaticPropertyBagInterface[] getColumnTypeStyles() throws TableException {
        return null;
    }

    @Override
    public StaticPropertyBagInterface getColumnTypeStyle(String type) throws TableException {
        return null;
    }

    @Override
    public StaticPropertyBagInterface[] getRowTypeStyles() throws TableException {
        return null;
    }

    @Override
    public StaticPropertyBagInterface getRowTypeStyle(String type) throws TableException {
        return null;
    }

    public synchronized Class getColumnClass(int index) throws TableException {
        return this.getCellClass(1, index);
    }

    public synchronized Class[] getColumnClasses(int startIndex, int count) throws TableException {
        Class[] classes = new Class[count];
        int i = 0;
        int col = startIndex;
        while (i < count) {
            classes[i] = this.getColumnClass(col);
            ++i;
            ++col;
        }
        return classes;
    }

    public synchronized Class getRowClass(int index) throws TableException {
        return this.getCellClass(index, 1);
    }

    public synchronized Class[] getRowClasses(int startIndex, int count) throws TableException {
        Class[] classes = new Class[count];
        int i = 0;
        int row = startIndex;
        while (i < count) {
            classes[i] = this.getRowClass(row);
            ++i;
            ++row;
        }
        return classes;
    }

    public synchronized String getFormattedCell(int rowIndex, int colIndex) throws TableException {
        if (this.getRowMap() != null) {
            rowIndex = this.getRowMap()[rowIndex - 1];
        }
        return this.m_layoutStrategy.getFormattedCell(rowIndex, colIndex);
    }

    public synchronized String[][] getFormattedCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        if (this.getRowMap() != null) {
            return this.m_layoutStrategy.getFormattedCellsOneByOne(startRowIndex, startColumnIndex, rowCount, columnCount);
        }
        return this.m_layoutStrategy.getFormattedCells(startRowIndex, startColumnIndex, rowCount, columnCount);
    }

    public synchronized String[] getFormattedColumn(int index) throws TableException {
        int rowCount = this.getRowCount();
        return this.reshapeArray(this.getFormattedCells(1, index, rowCount, 1), rowCount, 1);
    }

    public synchronized String[] getFormattedRow(int index) throws TableException {
        int colCount = this.getColumnCount();
        return this.reshapeArray(this.getFormattedCells(index, 1, 1, colCount), 1, colCount);
    }

    public synchronized String[] formatValues(int colIndex, Object[] values) throws TableException {
        return this.m_layoutStrategy.formatValues(colIndex, values);
    }

    public synchronized void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public synchronized void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.allContentsChangedListeners != null) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
        this.firePropertyChange((PropertyChangeEvent)event);
    }

    private final class RowLabelsOutlineLayout
    extends LayoutStrategy {
        private MultidimensionalTableView _tableView;
        private PreorderTreeIterator _treeIterator;
        private int _count;

        RowLabelsOutlineLayout(MdTo2dTable table, MultidimensionalTableView tableView) {
            super(table);
            this._tableView = tableView;
            this._count = -1;
        }

        @Override
        void refresh() {
            super.refresh();
            this._treeIterator = null;
            this._count = -1;
        }

        @Override
        int getRowCount() {
            return this._count;
        }

        @Override
        int countRows(int maxCount) throws TableException {
            int count;
            if (this._count != -1) {
                return this._count;
            }
            if (maxCount < 0) {
                throw new IllegalArgumentException();
            }
            if (maxCount != 0 && (count = super.getRowCount()) > maxCount) {
                return count;
            }
            if (this._treeIterator == null) {
                AxisInterface tree = this._tableView.getRowAxis();
                if (tree == null) {
                    return 0;
                }
                this._treeIterator = new PreorderTreeIterator((TreeInterface)tree);
            }
            while ((maxCount > this._treeIterator.getNodeIndex() || maxCount == 0) && this._treeIterator.hasMoreElements()) {
                this._treeIterator.nextElement();
            }
            count = this._treeIterator.getNodeIndex();
            if (!this._treeIterator.hasMoreElements()) {
                this._count = count;
            }
            return count;
        }

        @Override
        Object getRowLabel(int rowIndex) throws TableException {
            return this.getRowLabel_(rowIndex).getLabel();
        }

        private Label getRowLabel_(int rowIndex) {
            return (Label)this._tableView.getRow(rowIndex).getLabel();
        }

        @Override
        Object getCell(int rowIndex, int colIndex) throws TableException {
            Label label = this.getRowLabel_(rowIndex);
            if (!label.isLeafNode()) {
                return "";
            }
            rowIndex = label.getMinimumCoordinate() + 1;
            return super.getCell(rowIndex, colIndex);
        }

        @Override
        Object[][] getCells(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            return this.getCellsOneByOne(startRowIndex, startColIndex, rowCount, colCount);
        }

        @Override
        Class getCellClass(int rowIndex, int colIndex) throws TableException {
            Label label = this.getRowLabel_(rowIndex);
            if (!label.isLeafNode()) {
                return String.class;
            }
            rowIndex = label.getMinimumCoordinate() + 1;
            return super.getCellClass(rowIndex, colIndex);
        }

        @Override
        StaticPropertyBagInterface getCellStyle(int rowIndex, int colIndex) throws TableException {
            Label label = this.getRowLabel_(rowIndex);
            if (!label.isLeafNode()) {
                return null;
            }
            rowIndex = label.getMinimumCoordinate() + 1;
            return super.getCellStyle(rowIndex, colIndex);
        }

        @Override
        String[] getCellType(int rowIndex, int colIndex) throws TableException {
            Label label = this.getRowLabel_(rowIndex);
            if (!label.isLeafNode()) {
                return null;
            }
            rowIndex = label.getMinimumCoordinate() + 1;
            return super.getCellType(rowIndex, colIndex);
        }

        @Override
        String getFormattedCell(int rowIndex, int colIndex) throws TableException {
            Label label = this.getRowLabel_(rowIndex);
            if (!label.isLeafNode()) {
                return "";
            }
            rowIndex = label.getMinimumCoordinate() + 1;
            return super.getFormattedCell(rowIndex, colIndex);
        }

        @Override
        String[][] getFormattedCells(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            return this.getFormattedCellsOneByOne(startRowIndex, startColIndex, rowCount, colCount);
        }

        @Override
        String[] getRowLabelType(int rowIndex) throws TableException {
            AxisLabelInterface axisLabel;
            String type;
            if (MdTo2dTable.this.m_staticTableTypeModel != null && (type = (axisLabel = this.getRowLabel_(rowIndex).getMetaLabel()).getNodeType()) != null) {
                String[] types = new String[]{type};
                return types;
            }
            return null;
        }
    }

    private final class RowLabelsAsColumnsLayout
    extends LayoutStrategy {
        private Vector m_rowLevelLabels;
        private int m_prevRowIndex;
        private AxisLabelInterface[] m_prevRowLabels;

        RowLabelsAsColumnsLayout(MdTo2dTable table) {
            super(table);
            this.m_rowLevelLabels = new Vector();
        }

        @Override
        void refresh() {
            super.refresh();
            this.m_rowLevelLabels.removeAllElements();
            this.m_prevRowIndex = 0;
            this.m_prevRowLabels = null;
        }

        @Override
        int getColumnCount() {
            return super.getColumnCount() + this.getRowDepth();
        }

        @Override
        Object getColumnLabel(int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return this.m_rowLevelLabels.elementAt(colIndex - 1);
            }
            return super.getColumnLabel(colIndex - rowDepth);
        }

        @Override
        Object getRowLabel(int rowIndex) throws TableException {
            return String.valueOf(rowIndex);
        }

        private int getRowDepth() {
            AxisInterface rowAxis;
            if (this.m_rowLevelLabels.size() == 0 && (rowAxis = MdTo2dTable.this.getRowAxis()) != null) {
                try {
                    if (this._table.isRowLabelsConcatenated()) {
                        StringBuffer label = new StringBuffer();
                        int maxd = rowAxis.getDimensionCount();
                        for (int d = 0; d < maxd; ++d) {
                            DimensionInterface dim = rowAxis.getDimension(d);
                            int maxl = dim.getLevelCount();
                            for (int l = 0; l < maxl; ++l) {
                                if (d != 0 || l != 0) {
                                    label.append('.');
                                }
                                label.append(dim.getLevel(l).getLabel());
                            }
                        }
                        this.m_rowLevelLabels.addElement(label.toString());
                    } else {
                        int maxd = rowAxis.getDimensionCount();
                        for (int d = 0; d < maxd; ++d) {
                            DimensionInterface dim = rowAxis.getDimension(d);
                            int maxl = dim.getLevelCount();
                            for (int l = 0; l < maxl; ++l) {
                                this.m_rowLevelLabels.addElement(dim.getLevel(l).getLabel());
                            }
                        }
                    }
                }
                catch (TableException tex) {
                    tex.printStackTrace();
                    this.m_rowLevelLabels.removeAllElements();
                }
            }
            return this.m_rowLevelLabels.size();
        }

        @Override
        Object getCell(int rowIndex, int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                if (rowIndex != this.m_prevRowIndex) {
                    this.m_prevRowLabels = MdTo2dTable.this.getRowAxis().getLabels(rowIndex - 1);
                }
                if (this._table.isRowLabelsConcatenated()) {
                    return this.getLabel(this.m_prevRowLabels, true);
                }
                if (colIndex > this.m_prevRowLabels.length) {
                    return "";
                }
                return this.m_prevRowLabels[colIndex - 1].getLabel();
            }
            return super.getCell(rowIndex, colIndex - rowDepth);
        }

        @Override
        Object[][] getCells(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            int rowDepth = this.getRowDepth();
            if (startColIndex <= rowDepth) {
                return this.getCellsOneByOne(startRowIndex, startColIndex, rowCount, colCount);
            }
            return super.getCells(startRowIndex, startColIndex - rowDepth, rowCount, colCount);
        }

        @Override
        Class getCellClass(int rowIndex, int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return String.class;
            }
            return super.getCellClass(rowIndex, colIndex - rowDepth);
        }

        @Override
        StaticPropertyBagInterface getCellStyle(int rowIndex, int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return null;
            }
            return super.getCellStyle(rowIndex, colIndex - rowDepth);
        }

        @Override
        String[] getCellType(int rowIndex, int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return null;
            }
            return super.getCellType(rowIndex, colIndex - rowDepth);
        }

        @Override
        String getFormattedCell(int rowIndex, int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return this.getCell(rowIndex, colIndex).toString();
            }
            return super.getFormattedCell(rowIndex, colIndex - rowDepth);
        }

        @Override
        String[][] getFormattedCells(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            int rowDepth = this.getRowDepth();
            if (startColIndex <= rowDepth) {
                return this.getFormattedCellsOneByOne(startRowIndex, startColIndex, rowCount, colCount);
            }
            return super.getFormattedCells(startRowIndex, startColIndex - rowDepth, rowCount, colCount);
        }

        @Override
        String[] getColumnLabelType(int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return null;
            }
            return super.getColumnLabelType(colIndex - rowDepth);
        }

        @Override
        String[] getRowLabelType(int rowIndex) throws TableException {
            return null;
        }

        @Override
        String[] formatValues(int colIndex, Object[] values) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return this.defaultFormatValues(values);
            }
            return super.formatValues(colIndex - rowDepth, values);
        }

        @Override
        boolean isColumnSummable(int colIndex) throws TableException {
            int rowDepth = this.getRowDepth();
            if (colIndex <= rowDepth) {
                return false;
            }
            return super.isColumnSummable(colIndex - rowDepth);
        }
    }

    private class LayoutStrategy {
        protected MdTo2dTable _table;

        LayoutStrategy(MdTo2dTable table) {
            this._table = table;
        }

        void refresh() {
        }

        int countColumns(int maxCount) throws TableException {
            return this._table.getColumnCount();
        }

        int countRows(int maxCount) throws TableException {
            return this._table.getRowCount();
        }

        int getColumnCount() {
            return this._table.getColumnCountInternal();
        }

        int getRowCount() {
            return this._table.getRowCountInternal();
        }

        protected String getLabel(AxisLabelInterface[] labels, boolean concatenate) throws TableException {
            if (!concatenate) {
                return labels[labels.length - 1].getLabel();
            }
            StringBuffer label = new StringBuffer();
            for (int i = 0; i < labels.length; ++i) {
                if (i != 0) {
                    label.append('.');
                }
                label.append(labels[i].getLabel());
            }
            return label.toString();
        }

        Object getColumnLabel(int colIndex) throws TableException {
            return this.getLabel(this._table.getColumnAxis().getLabels(colIndex - 1), MdTo2dTable.this.isColumnLabelsConcatenated());
        }

        Object getRowLabel(int rowIndex) throws TableException {
            return this.getLabel(this._table.getRowAxis().getLabels(rowIndex - 1), MdTo2dTable.this.isRowLabelsConcatenated());
        }

        Object getCell(int rowIndex, int colIndex) throws TableException {
            return this._table.m_table.getCell(this._table.convertToOrdinalInternal(rowIndex, colIndex));
        }

        Object[][] getCells(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            return this._table.reshapeArray(this._table.m_table.getCells(this._table.convertToOrdinalInternal(startRowIndex, startColIndex), this._table.convertToOrdinalInternal(startRowIndex + rowCount - 1, startColIndex + colCount - 1)), rowCount, colCount);
        }

        protected Object[][] getCellsOneByOne(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            return StaticTableInterfaceSupport.getCells(this._table, startRowIndex, startColIndex, rowCount, colCount);
        }

        protected String[][] getFormattedCellsOneByOne(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            String[][] cells = new String[rowCount][colCount];
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < colCount; ++c) {
                    cells[r][c] = this.getFormattedCell(startRowIndex + r, startColIndex + c);
                }
            }
            return cells;
        }

        Class getCellClass(int rowIndex, int colIndex) throws TableException {
            return this._table.m_table.getCellClass(this._table.convertToOrdinalInternal(rowIndex, colIndex));
        }

        StaticPropertyBagInterface getCellStyle(int rowIndex, int colIndex) throws TableException {
            return this._table.m_styles.getCellStyle(this._table.convertToOrdinalInternal(rowIndex, colIndex));
        }

        String[] getCellType(int rowIndex, int colIndex) throws TableException {
            if (this._table.m_staticTableTypeModel != null) {
                return this._table.m_staticTableTypeModel.getCellType(this._table.convertToOrdinalInternal(rowIndex, colIndex));
            }
            return null;
        }

        String getFormattedCell(int rowIndex, int colIndex) throws TableException {
            return this._table.m_formattedDataModel.getFormattedCell(this._table.convertToOrdinalInternal(rowIndex, colIndex));
        }

        String[][] getFormattedCells(int startRowIndex, int startColIndex, int rowCount, int colCount) throws TableException {
            return this._table.reshapeArray(this._table.m_formattedDataModel.getFormattedCells(this._table.convertToOrdinalInternal(startRowIndex, startColIndex), this._table.convertToOrdinalInternal(startRowIndex + rowCount - 1, startColIndex + colCount - 1)), rowCount, colCount);
        }

        String[] getColumnLabelType(int colIndex) throws TableException {
            return this.getLabelType(colIndex, this._table.getColumnAxis());
        }

        String[] getRowLabelType(int rowIndex) throws TableException {
            return this.getLabelType(rowIndex, this._table.getRowAxis());
        }

        private String[] getLabelType(int index, AxisInterface axis) throws TableException {
            AxisLabelInterface[] labels;
            String type;
            if (MdTo2dTable.this.m_staticTableTypeModel != null && (type = (labels = axis.getLabels(index - 1))[labels.length - 1].getNodeType()) != null) {
                String[] types = new String[]{type};
                return types;
            }
            return null;
        }

        String[] formatValues(int colIndex, Object[] values) throws TableException {
            if (MdTo2dTable.this.m_formatInterface != null) {
                return MdTo2dTable.this.m_formatInterface.formatValues(colIndex - 1, values);
            }
            return this.defaultFormatValues(values);
        }

        String[] defaultFormatValues(Object[] values) {
            if (values instanceof String[]) {
                return (String[])values;
            }
            String[] s = new String[values.length];
            int iCount = values.length;
            for (int i = 0; i < iCount; ++i) {
                s[i] = values[i].toString();
            }
            return s;
        }

        boolean isColumnSummable(int colIndex) throws TableException {
            AxisLabelInterface[] labels = this._table.getColumnAxis().getLabels(colIndex - 1);
            AxisLabelInterface label = labels[labels.length - 1];
            MemberInterface member = label.getMember();
            if (!member.getLevel().getName().equals("_STATS_")) {
                Dictionary levels = ((MultidimensionalTableInterface)MdTo2dTable.this.m_table).getAllLevels();
                LevelInterface statLevel = (LevelInterface)levels.get((Object)"_STATS_");
                member = statLevel.getMember(0);
            }
            String stat = member.getName();
            return stat.equals("SUM");
        }
    }

    private final class ModelListener
    implements ContentsChangedListener {
        private ModelListener() {
        }

        public void contentsChanged(ContentsChangedEvent event) {
            MdTo2dTable.this.refresh(event);
        }
    }
}

