/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.mdtable;

import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.swing.visuals.mdtable.AbstractNode;
import com.sas.table.TableException;
import java.util.NoSuchElementException;

public abstract class AbstractLevel
extends AbstractNode
implements LevelInterface {
    private DimensionInterface m_dimension;

    public AbstractLevel(DimensionInterface dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        this.m_dimension = dimension;
    }

    @Override
    public final DimensionInterface getDimension() {
        return this.m_dimension;
    }

    @Override
    public MemberInterface[] getMembers(int index, int count) throws TableException {
        int maxCount = this.getMemberCount();
        if (index + count > maxCount) {
            count = maxCount - index;
        }
        MemberInterface[] array = new MemberInterface[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getMember(index + i);
        }
        return array;
    }

    public final SimpleNodeInterface getNodeChild(int index) {
        try {
            return this.getMember(index);
        }
        catch (TableException tex) {
            throw new NoSuchElementException();
        }
    }

    public final int getNodeChildCount() {
        try {
            return this.getMemberCount();
        }
        catch (TableException tex) {
            return 0;
        }
    }

    public final SimpleNodeInterface[] getNodeChildren(int index, int count) {
        try {
            return this.getMembers(index, count);
        }
        catch (TableException tex) {
            return new SimpleNodeInterface[0];
        }
    }

    public String getNodeType() {
        return "level";
    }

    public final boolean isLeafNode() {
        return false;
    }
}

