/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.ComponentException;
import com.sas.awt.ActionSource;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticDictionary;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.geometry.Rectangles;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticTreeNodeStyleInterface;
import com.sas.models.Tree;
import com.sas.models.TreeDnDDelegateInterface;
import com.sas.models.TreeInterface;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.BaseBorder;
import com.sas.swing.visuals.ImageView;
import com.sas.swing.visuals.NodeActionEvent;
import com.sas.swing.visuals.NodeState;
import com.sas.swing.visuals.NodeView;
import com.sas.swing.visuals.NodeViewTextEditor;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.ScrollTray;
import com.sas.swing.visuals.Spacer;
import com.sas.swing.visuals.TreeLine;
import com.sas.swing.visuals.TreeLines;
import com.sas.swing.visuals.table.FontStyle;
import com.sas.text.Message;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmListener;
import com.sas.util.Command;
import com.sas.util.CommandManager;
import com.sas.util.ContextCommandsInterface;
import com.sas.util.ContextInterface;
import com.sas.util.NthPredicate;
import com.sas.util.PredicateInterface;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.IconView;
import com.sas.visuals.NodeStyle;
import com.sas.visuals.Resources;
import com.sas.visuals.ScrollbarVisibilityInterface;
import com.sas.visuals.ScrollingInterface;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.border.Border;

public class TreeView
extends JComponent
implements AdjustmentListener,
PropertyChangeListener,
ActionSource,
ContentsChangedListener,
ContextCommandsInterface,
ContextInterface,
ItemSelectable,
ScrollingInterface,
ScrollbarVisibilityInterface,
ViewDefaultModel {
    static final long serialVersionUID = 2032688628607192119L;
    transient StaticPropertyBagInterface _modelDefaultNodeStyle;
    private transient Color _buttonColor;
    private transient Color _lineColor;
    private transient Color _plusMinusColor;
    private transient boolean _initCalled;
    private transient int m_horizontalOffset;
    private transient int _nodeHitLocation;
    private transient int m_verticalOffset;
    private transient int _dragAlarmDelay;
    private transient Cursor waitCursor;
    private transient Cursor prevCursor;
    private transient NodeView root;
    private transient NodeView currentNode;
    private transient NodeView selectedNode;
    private transient OrderedCollection selectedNodes;
    private transient NodeView guiSelectNode;
    private transient Dictionary icons;
    private transient ActionListener actionListener;
    private transient ItemListener itemListener;
    private transient Image m_memImage;
    private transient JPopupMenu popup;
    private transient IconView iconView;
    private transient IconInterface DEFAULT_ICON;
    private transient IconInterface DEFAULT_INVALID_ICON;
    private transient Insets m_insets;
    private transient Insets m_borderInsets;
    private transient int m_visibleNodeCount;
    private transient int m_drawableHeight;
    transient int m_drawableWidth;
    private transient int _lineLength;
    private transient int m_visibleRowCount;
    private transient int m_hbarHeight;
    private transient int m_vbarWidth;
    private transient int m_flags;
    private transient boolean _lightWeightPopupEnabled;
    private transient char _searchChar;
    private transient int _searchCnt;
    private transient Alarm m_hbarAlarm;
    private transient Alarm m_vbarAlarm;
    private transient Alarm _dragAlarm;
    private transient HScrollListener m_hbarAlarmListener;
    private transient VScrollListener m_vbarAlarmListener;
    private transient SimpleNodeInterface[] dragNodePath;
    private transient SimpleNodeInterface[] dropNodePath;
    private transient NodeView dragNode;
    private transient NodeView dropNode;
    private transient NodeView overNode;
    private transient int dropIndex;
    private transient int locationOnNode;
    private transient boolean inBetween;
    private transient boolean dragInProgress;
    private transient boolean mouseExited;
    private transient IconInterface dragIcon;
    private transient DnDMouseListener m_dndListener;
    private transient boolean dropSiteValid;
    private transient boolean _shiftedOver;
    private transient Rectangle bounds;
    private transient TreeLines _lines;
    private transient FontStyle _defaultFontStyle;
    private transient NodeStyleListener _nodeStyleListener;
    private transient StaticDictionary _staticNodeTypeStyles;
    private transient VisibleNodeTreeViewIterator _iterator;
    private transient TreeViewIterator _allNodesIterator;
    transient NodeViewTextEditor _editableNode;
    private double versionID;
    private int buttonSize;
    private int indentSize;
    private int imageGap;
    private int textGap;
    private int buttonVisibility;
    private int displayStyle;
    private int hScrollVisibility;
    private int lineStyle;
    private int lineVisibility;
    private int scrollStyle;
    private int textPad;
    private int vScrollVisibility;
    private boolean extendedSelectionAllowed;
    private boolean keyboardSelectable;
    private boolean nodeExpandedTextDisplayed;
    private boolean _rootNodeVisible;
    private boolean _popupMenuVisible;
    private boolean _nodeTypeStylesSaved;
    private JScrollBar verticalScroll;
    private JScrollBar horizontalScroll;
    Dictionary imagePaths;
    private Dimension imageSize;
    private ScrollTray panel;
    private Spacer spacer;
    private TreeInterface m_defaultModel;
    private TreeInterface m_model;
    private TreeDnDDelegateInterface dndDelegate;
    private PropertyBagInterface _defaultNodeStyle;
    private transient NodeView _topNode;
    private Dictionary _nodeTypeStyles;
    private static final int TV_UPDATE_HORZ_SCROLL = 1;
    private static final int TV_UPDATE_VERT_SCROLL = 2;
    private static final int TV_NODE_BEING_EDITED = 4;
    private static final int TV_RESIZED = 16;
    private static final int TV_LINE_LENGTH = 32;
    private static final int TV_HORZ_OFFSET = 64;
    private static final int TV_VERT_OFFSET = 128;
    private static final int TV_HOLD_UPDATE = 256;
    private static final int TV_VISIBLE_NODE_COUNT = 512;
    private static final int TV_NODE_UPDATE_ALL = 1024;
    private static final int TV_UPDATE_INSETS = 2048;
    private static final int TV_UPDATE_PAINT_SHIFT = 8192;
    private static final int TV_WAIT_CURSOR_SET = 16384;
    private static final int TV_UPDATE_DISPLAYED_NODES = 32768;
    private static final int TV_UPDATE_VISIBLE_ROW_CNT = 65536;
    private static final int TV_UPDATE_DISP_NODES_LOC = 131072;
    private static final int TV_UPDATE_NODE_LINES = 262144;
    private static final int TV_SCROLL_TO_NODE = 524288;
    private static final int TV_UPDATE_NODE_TYPES = 0x100000;
    private transient NodeView _scrollToNode;
    private static final int IN_VIEW = -1;
    private static final int TOP = 0;
    private static final int CENTER = 1;
    private static final int BOTTOM = 2;
    private static final int TOP_CENTER = 3;
    private static final int BOTTOM_CENTER = 4;
    private static final int NOT_ON_A_NODE = -1;
    private static final int BUTTON = 0;
    private static final int IMAGE_TEXT = 1;
    private static final int RIGHT = 2;
    private static final int LEFT = 3;
    static int defaultWidth = 148;
    static int defaultHeight = 148;
    public static final String RB_KEY = "TreeView.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.models.TreeInterface"};
    public static final int SOLID_LINES = 0;
    public static final int DOTTED_LINES = 1;
    public static final int NO_LINES = 2;
    public static final int ALL_VISIBLE = 0;
    public static final int ALL_HIDDEN = 1;
    public static final int ROOT_HIDDEN = 2;
    public static final int NO_IMAGES = 0;
    public static final int IMAGES = 1;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "buttonSize"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"buttonSize.pd.txt")}}, {{"Name", "buttonVisibility"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"buttonVisibility.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingTreeViewVisibilityEditor"}}, {{"Name", "lineVisibility"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"lineVisibility.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingTreeViewVisibilityEditor"}}, {{"Name", "currentNode"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"currentNode.pd.txt")}, {"Expert", "true"}}, {{"Name", "imageGap"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"imageGap.pd.txt")}}, {{"Name", "displayStyle"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"displayStyle.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingTreeViewDisplayStyleEditor"}}, {{"Name", "dnDDelegate"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"dnDDelegate.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingTreeViewDnDDelegateEditor"}}, {{"Name", "horizontalScrollbarVisibility"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"horizontalScrollbarVisibility.pd.txt")}, {"Property editor class", "com.sas.beans.editors._ScrollbarVisibilityEditor"}}, {{"Name", "imageSize"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"imageSize.pd.txt")}}, {{"Name", "indentSize"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"indentSize.pd.txt")}}, {{"Name", "lineStyle"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"lineStyle.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingTreeViewLineStyleEditor"}}, {{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"swingModel.pd.txt")}}, {{"Name", "nodeExpandedTextDisplayed"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"nodeExpandedTextDisplayed.pd.txt")}}, {{"Name", "root"}, {"Hidden", "true"}}, {{"Name", "selectedItem"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedItem.pd.txt")}}, {{"Name", "selectedNode"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedNode.pd.txt")}, {"Expert", "true"}}, {{"Name", "textGap"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"textGap.pd.txt")}}, {{"Name", "textPad"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"textPad.pd.txt")}, {"Expert", "true"}}, {{"Name", "verticalScrollbarVisibility"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"verticalScrollbarVisibility.pd.txt")}, {"Property editor class", "com.sas.beans.editors._ScrollbarVisibilityEditor"}}, {{"Name", "opaque"}, {"Hidden", "false"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        return ebi;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newValue) {
        if (newValue > 0) {
            defaultWidth = newValue;
        }
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newValue) {
        if (newValue > 0) {
            defaultHeight = newValue;
        }
    }

    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        return com.sas.awt.util.Util.isLeftMouseButton(anEvent);
    }

    public static boolean isMiddleMouseButton(MouseEvent anEvent) {
        return com.sas.awt.util.Util.isMiddleMouseButton(anEvent);
    }

    public static boolean isRightMouseButton(MouseEvent anEvent) {
        return com.sas.awt.util.Util.isRightMouseButton(anEvent);
    }

    public TreeView() {
        this.setDefaultValues();
        this.enableEvents(60L);
        this.initializeComponent();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, listener);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        Object source = event.getSource();
        if (source == this.verticalScroll) {
            this.onVScroll(event);
        } else if (source == this.horizontalScroll) {
            this.onHScroll(event);
        }
    }

    public void setModel(TreeInterface model) {
        TreeInterface oldModel = this.getModel();
        if (oldModel == model) {
            return;
        }
        if (model == null) {
            if (this.m_defaultModel != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)this.m_defaultModel, (PropertyChangeListener)this);
            }
            this.currentNode = null;
            this.guiSelectNode = null;
            this.selectedNode = null;
            this.root = null;
            if (this.m_defaultModel != null && this.m_defaultModel instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.m_defaultModel).removeContentsChangedListener((ContentsChangedListener)this);
            }
            if (this.m_model != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)this.m_model, (PropertyChangeListener)this);
            }
            if (this.m_model != null && this.m_model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.m_model).removeContentsChangedListener((ContentsChangedListener)this);
            }
            this.m_model = null;
            if (this.m_defaultModel != null) {
                this.setModel(this.m_defaultModel);
            }
        } else {
            if (this.isDefaultModelAttached() && this.getDefaultModel() != null) {
                this.setModel(null);
            }
            this.m_model = model;
            if (this.m_model != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.m_model, (PropertyChangeListener)this);
            }
            if (this.m_model != null && this.m_model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
            }
        }
        this.firePropertyChange("model", oldModel, this.m_model);
        this.refresh();
    }

    public Dimension computePreferredSize() {
        return new Dimension(TreeView.getDefaultWidth(), TreeView.getDefaultHeight());
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event.getSource() == this.getModel()) {
            this.refresh();
        }
    }

    public TreeInterface getModel() {
        return this.m_model;
    }

    public int getButtonSize() {
        return this.buttonSize;
    }

    public int getButtonVisibility() {
        return this.buttonVisibility;
    }

    public Object getContext(int x, int y) {
        return this.getNodeView(new Point(x, y));
    }

    public Command[] getContextCommands(Object object, int x, int y) {
        NodeView node = this.internalNodeHitTest(x -= this.m_insets.left, y -= this.m_insets.top);
        if (node == null) {
            return null;
        }
        if (this._nodeHitLocation == 1) {
            return node.getCommands();
        }
        return null;
    }

    public NodeView getCurrentNode() {
        return this.currentNode;
    }

    public TreeInterface getDefaultModel() {
        return this.m_defaultModel;
    }

    public PropertyBagInterface getDefaultNodeStyle() {
        return this._defaultNodeStyle;
    }

    public int getDisplayStyle() {
        return this.displayStyle;
    }

    public TreeDnDDelegateInterface getDnDDelegate() {
        return this.dndDelegate;
    }

    @Override
    public int getHorizontalScrollbarVisibility() {
        return this.hScrollVisibility;
    }

    public int getImageGap() {
        return this.imageGap;
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public synchronized StaticDictionaryInterface getNodeTypeStyles() {
        if (this.isFlagSet(0x100000)) {
            this.unsetFlag(0x100000);
            this.refreshNodeTypeStyles();
            this.setFlag(1024);
            this.repaint();
        }
        if (this._staticNodeTypeStyles == null) {
            this._staticNodeTypeStyles = new StaticDictionary((StaticDictionaryInterface)this._nodeTypeStyles);
        }
        return this._staticNodeTypeStyles;
    }

    public int getLineVisibility() {
        return this.lineVisibility;
    }

    public NodeView getNodeView(Point point) {
        NodeView node = this.internalNodeHitTest(point);
        return this._nodeHitLocation == 1 ? node : null;
    }

    public NodeView getNodeView(String selectedString, int count) {
        SelectedStringPredicate ssp = new SelectedStringPredicate(selectedString);
        return this.getNodeView((PredicateInterface)new NthPredicate((PredicateInterface)ssp, count));
    }

    public NodeView getNodeView(NodeInterface nodeI, int count) {
        NodeInterfacePredicate nip = new NodeInterfacePredicate(nodeI);
        if (count <= 0) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidCount.ex.txt"), (Object)new Integer(count)));
        }
        NodeView nodeView = this.getNodeView((PredicateInterface)new NthPredicate((PredicateInterface)nip, count));
        if (nodeView == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"unmatchedNodeInterface.ex.txt"));
        }
        return nodeView;
    }

    public NodeView getNodeView(PredicateInterface predicate) {
        this.setWaitCursor();
        if (this.root == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"nullRoot.ex.txt"));
        }
        if (!this.isRootNodeVisible() && this._iterator.getChildNode(this.root, false) == null) {
            throw new IllegalStateException("Root node has no children");
        }
        if (predicate == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullPredicate.ex.txt"));
        }
        NodeView retNode = null;
        if (predicate.predicate((Object)this.root)) {
            retNode = this.root;
        } else if (!this.root.isLeafNode()) {
            retNode = this.internalGetNodeView(this.root, predicate);
        }
        this.restoreCursor();
        return retNode;
    }

    public NodeView getNodeView(NodeInterface[] path) {
        if (this.root == null) {
            throw new ComponentException(RB.getStringResource((String)RB_KEY, (String)"nullRoot.ex.txt"));
        }
        if (path == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullPathArray.ex.txt"));
        }
        if (path.length == 1) {
            if (this.root.getNode() != path[0]) {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidPathArray.ex.txt"));
            }
            return this.root;
        }
        NodeView node = this.root;
        NodeView parent = this.root;
        for (int i = 1; i < path.length; ++i) {
            if (node.isLeafNode()) {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidPathArray.ex.txt"));
            }
            int j = 0;
            node = (NodeView)parent.getNodeChild(j);
            while (node != null && node.getNode() != path[i]) {
                node = (NodeView)parent.getNodeChild(j);
                ++j;
            }
            if (node == null) {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidPathArray.ex.txt"));
            }
            parent = node;
        }
        return parent;
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public NodeView getRoot() {
        return this.root;
    }

    public String getSelectedItem() {
        return this.selectedNode != null ? this.selectedNode.getNodeExpandedText() : null;
    }

    public NodeView getSelectedNode() {
        return this.selectedNode;
    }

    public NodeView[] getSelectedNodes() {
        if (!this.extendedSelectionAllowed) {
            return null;
        }
        int cnt = this.selectedNodes.count();
        NodeView[] nodeArray = new NodeView[cnt];
        for (int i = 0; i < cnt; ++i) {
            nodeArray[i] = (NodeView)this.selectedNodes.get(i);
        }
        return nodeArray;
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.extendedSelectionAllowed) {
            return this.getSelectedNodes();
        }
        if (this.selectedNode == null) {
            return null;
        }
        Object[] obj = new Object[]{this.selectedNode};
        return obj;
    }

    public String getText() {
        return this.getSelectedItem();
    }

    public int getTextGap() {
        return this.textGap;
    }

    public int getTextPad() {
        return this.textPad / 2;
    }

    @Override
    public int getVerticalScrollbarVisibility() {
        return this.vScrollVisibility;
    }

    public void initialize() {
        if (!this._initCalled) {
            this.init();
        }
        if (com.sas.beans.Util.isDesignTime()) {
            this.repaint();
        }
    }

    public void initializeComponent() {
        if (com.sas.beans.Util.isDesignTime()) {
            this.m_defaultModel = null;
            if (this.getModel() == null) {
                this.setModel(this.getDefaultModel());
            }
            if (this.getRoot() != null) {
                NodeView root = this.getRoot();
                this.setNodeExpanded(root, true, false);
                if (!root.isLeafNode()) {
                    NodeView ch2 = (NodeView)root.getNodeChild(1);
                    this.setNodeExpanded(ch2, true, false);
                }
                root.setSelected(true);
            }
        }
    }

    public boolean isDefaultModelAttached() {
        return this.getDefaultModel() == this.getModel();
    }

    public boolean isExtendedSelectionAllowed() {
        return this.extendedSelectionAllowed;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isKeyboardSelectable() {
        return this.keyboardSelectable;
    }

    public boolean isNodeExpandedTextDisplayed() {
        return this.nodeExpandedTextDisplayed;
    }

    public boolean isPopupMenuVisible() {
        return this._popupMenuVisible;
    }

    public boolean isRootNodeVisible() {
        return this._rootNodeVisible;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        this.setWaitCursor();
        this.updateAll(g);
        if (this.isFlagSet(524288)) {
            this.unsetFlag(524288);
            this.setNodeInView(this._scrollToNode);
            this._scrollToNode = null;
        }
        if (this.isOpaque()) {
            g.setClip(0, 0, this.bounds.width, this.bounds.height);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.bounds.width, this.bounds.height);
        }
        g.setFont(this.getFont());
        g.setClip(this.m_insets.left, this.m_insets.top, this.m_drawableWidth, this.m_drawableHeight);
        this.render(g);
        this.restoreCursor();
        g.setClip(0, 0, this.bounds.width, this.bounds.height);
        super.paintComponent(g);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (event.getSource() == this.getModel()) {
            if (Util.equal((Object)propertyName, (Object)"root")) {
                this.refresh();
            } else if (Util.equal((Object)propertyName, (Object)"nodeTypes")) {
                this.setFlag(0x100000);
                this.repaint();
            }
        }
    }

    public void refresh() {
        this.refresh(this.getModel());
    }

    public void refresh(TreeInterface model) {
        NodeView oldRoot = this.getRoot();
        NodeView oldSelected = this.getSelectedNode();
        String oldItem = this.getSelectedItem();
        if (model == null) {
            this.currentNode = null;
            this.guiSelectNode = null;
            this.selectedNode = null;
            this.root = null;
            this.selectedNodes.removeAll();
        } else {
            TreeInterface ti = this.getModel();
            NodeInterface rootInterface = ti.getRoot();
            this.root = rootInterface != null ? this.createNodeView(rootInterface) : null;
            this.m_horizontalOffset = 0;
            this.m_verticalOffset = 0;
            this.selectedNode = null;
            this.selectedNodes.removeAll();
            if (!this.isRootNodeVisible()) {
                this.setNodeExpanded(this.root, true, false);
            }
            if (this._modelDefaultNodeStyle != null) {
                this._modelDefaultNodeStyle.removePropertyBagChangedListener((PropertyBagChangedListener)this._nodeStyleListener);
                this._modelDefaultNodeStyle = null;
            }
            if (ti instanceof StaticTreeNodeStyleInterface) {
                this._modelDefaultNodeStyle = ((StaticTreeNodeStyleInterface)ti).getDefaultNodeStyle();
                if (this._modelDefaultNodeStyle != null) {
                    if (this._nodeStyleListener == null) {
                        this._nodeStyleListener = new NodeStyleListener();
                    }
                    this._modelDefaultNodeStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this._nodeStyleListener);
                }
            }
            this.setFlag(0x100000);
        }
        if (oldRoot != this.getRoot()) {
            this.firePropertyChange("root", oldRoot, this.getRoot());
        }
        if (oldSelected != this.getSelectedNode()) {
            this.firePropertyChange("selectedNode", oldSelected, this.getSelectedNode());
        }
        if (this.isExtendedSelectionAllowed()) {
            this.firePropertyChange("selectedNodes", null, null);
        }
        if (Util.unequal((Object)oldItem, (Object)this.getSelectedItem())) {
            this.firePropertyChange("selectedItem", oldItem, this.getSelectedItem());
        }
        this._topNode = null;
        this.setVerticalOffset(0);
        this.setFlag(41472);
        this.repaint();
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, listener);
    }

    @Override
    public void repaint() {
        this.setFlag(2048);
        super.repaint();
    }

    @Override
    public void scrollHorizontally(int numUnits, int unit) {
        if (unit == 5) {
            this.scrollNodeHorizontally(numUnits);
        } else if (unit == 1) {
            this.scrollPageHorizontally(numUnits);
        } else if (unit == 4) {
            this.scrollNodeHorizontally(numUnits * 5);
        } else if (unit == 3) {
            this.scrollHorizontalExtent(numUnits < 0);
        } else if (unit == 2) {
            this.scrollHalfPageHorizontally(numUnits);
        } else {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"unsupportedScrollUnit.ex.txt"), (Object)new Integer(unit)));
        }
    }

    public void scrollToNode(NodeView node, boolean selectNode) {
        node.setVisible();
        this.setFlag(524288);
        this._scrollToNode = node;
        if (selectNode) {
            this.setCurrentNode(node);
            node.setSelected(true);
        } else {
            this.repaint();
        }
    }

    @Override
    public void scrollVertically(int numUnits, int unit) {
        if (unit == 5) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"scrollPixelNotSupported.ex.txt"));
        }
        if (unit == 1) {
            this.scrollPageVertically(numUnits);
        } else if (unit == 4) {
            this.scrollNodeVertically(numUnits);
        } else if (unit == 3) {
            this.scrollVerticalExtent(numUnits < 0);
        } else if (unit == 2) {
            this.scrollHalfPageVertically(numUnits);
        } else {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"unsupportedScrollUnit.ex.txt"), (Object)new Integer(unit)));
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.bounds.width != width || this.bounds.height != height) {
            this.setFlag(16);
            this.bounds.width = width;
            this.bounds.height = height;
        }
        super.setBounds(x, y, width, height);
    }

    public void setButtonSize(int newValue) {
        if (newValue <= 0) {
            return;
        }
        if (newValue == this.buttonSize) {
            return;
        }
        Integer oldValue = new Integer(this.buttonSize);
        this.buttonSize = newValue;
        this.firePropertyChange("buttonSize", oldValue, new Integer(newValue));
        this.setFlag(1024);
        this.repaint();
    }

    public void setButtonVisibility(int newValue) {
        if (this.buttonVisibility == newValue) {
            return;
        }
        Integer oldValue = new Integer(this.buttonVisibility);
        this.buttonVisibility = newValue;
        this.setFlag(8192);
        this.firePropertyChange("buttonVisibility", oldValue, new Integer(newValue));
        this.repaint();
    }

    public void setCurrentNode(NodeView newValue) {
        if (this.currentNode == newValue) {
            return;
        }
        NodeView oldValue = this.currentNode;
        this.currentNode = newValue;
        this.firePropertyChange("currentNode", oldValue, newValue);
        this.repaint();
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.isFlagSet(16384)) {
            this.prevCursor = cursor;
        }
        super.setCursor(cursor);
    }

    public void setDefaultModel(TreeInterface newValue) {
        if (newValue == this.m_defaultModel) {
            return;
        }
        TreeInterface oldValue = this.m_defaultModel;
        this.m_defaultModel = newValue;
        this.firePropertyChange("defaultModel", oldValue, newValue);
        TreeInterface model = this.getModel();
        if (model == oldValue || model == null) {
            this.setModel(this.m_defaultModel);
        }
        this.refresh();
    }

    public void setDefaultNodeStyle(PropertyBagInterface newValue) {
        PropertyBagInterface oldValue = this.getDefaultNodeStyle();
        this._defaultNodeStyle = newValue;
        newValue = this.getDefaultNodeStyle();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            if (this._nodeStyleListener == null) {
                this._nodeStyleListener = new NodeStyleListener();
            }
            if (oldValue != null) {
                oldValue.removePropertyBagChangedListener((PropertyBagChangedListener)this._nodeStyleListener);
            }
            if (newValue != null) {
                newValue.addPropertyBagChangedListener((PropertyBagChangedListener)this._nodeStyleListener);
            }
            this.firePropertyChange("defaultNodeStyle", oldValue, newValue);
            this.setFlag(1024);
            this.repaint();
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (border instanceof BaseBorder) {
            ((BaseBorder)border).setComponent((Component)this);
        }
    }

    public void setDefaultValues() {
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.setButtonSize(8);
        this.setImageSize(new Dimension(-1, -1));
        this.setImageGap(7);
        this.setTextPad(6);
        this.setTextGap(4);
        this.internalSetIndentSize(this.getImageSize().width / 2 + this.getButtonSize() / 2 + this.getImageGap());
        this.scrollStyle = -1;
        this.hScrollVisibility = 0;
        this.vScrollVisibility = 0;
        this.imagePaths = new Dictionary();
        this.imagePaths.initialize();
        this.displayStyle = 1;
        this.extendedSelectionAllowed = false;
        this.dndDelegate = null;
        this.lineStyle = 1;
        this.setBackground(SystemColor.window);
        this.m_insets = new Insets(2, 2, 2, 2);
        BaseBorder border = new BaseBorder();
        border.setComponent((Component)this);
        border.setStyle(4);
        border.setLightSource(10);
        this.setBorder((Border)border);
        this.m_borderInsets = new Insets(0, 0, 0, 0);
        this.lineVisibility = 0;
        this.buttonVisibility = 0;
        this._rootNodeVisible = true;
        this._popupMenuVisible = true;
        if (this.getDefaultNodeStyle() == null) {
            this.setDefaultNodeStyle((PropertyBagInterface)new NodeStyle());
        }
        this.initializeNodeStyle(this.getDefaultNodeStyle());
        this._lightWeightPopupEnabled = true;
        this.versionID = 2.0;
        this.init();
    }

    public void setDisplayStyle(int newValue) {
        if (newValue != 0 && newValue != 1) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"unsupportedDisplayStyle.ex.txt"), (Object)new Integer(newValue)));
        }
        if (this.displayStyle == newValue) {
            return;
        }
        Integer oldValue = new Integer(this.displayStyle);
        this.displayStyle = newValue;
        Object pbi = this.getDefaultNodeStyle();
        if (pbi == null) {
            pbi = new NodeStyle();
            this.setDefaultNodeStyle((PropertyBagInterface)pbi);
        }
        pbi.set("imageVisible", (Object)(this.displayStyle == 1 ? Boolean.TRUE : Boolean.FALSE));
        this.setFlag(1024);
        this.firePropertyChange("displayStyle", oldValue, new Integer(newValue));
        this.repaint();
    }

    public void setDnDDelegate(TreeDnDDelegateInterface newValue) {
        if (this.dndDelegate == newValue) {
            return;
        }
        TreeDnDDelegateInterface oldValue = this.dndDelegate;
        this.dndDelegate = newValue;
        if (newValue != null) {
            if (this.m_dndListener == null) {
                this.m_dndListener = new DnDMouseListener();
                ImageView imgView = new ImageView(Resources.getImage((String)"graybox"));
                imgView.setDisplayMode(1);
                this.DEFAULT_ICON = imgView;
                imgView = new ImageView(Resources.getImage((String)"Invalid"));
                imgView.setDisplayMode(1);
                this.DEFAULT_INVALID_ICON = imgView;
            }
            this.addMouseMotionListener(this.m_dndListener);
        } else {
            this.removeMouseMotionListener(this.m_dndListener);
        }
        this.firePropertyChange("DnDDelegate", oldValue, newValue);
    }

    public void setExtendedSelectionAllowed(boolean newValue) {
        if (newValue == this.extendedSelectionAllowed) {
            return;
        }
        this.extendedSelectionAllowed = newValue;
        if (this.extendedSelectionAllowed) {
            if (this.selectedNode != null) {
                this.selectedNodes.add((Object)this.selectedNode);
                this.selectedNode = null;
            }
        } else {
            this.clearSelectedNodes();
        }
        this.repaint();
        this.firePropertyChange("extendedSelectionAllowed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setFont(Font newValue) {
        super.setFont(newValue);
        if (this._defaultFontStyle == null) {
            this._defaultFontStyle = new FontStyle();
        }
        this._defaultFontStyle.setFont(this.getFont());
        this.setFlag(1024);
        this.repaint();
    }

    @Override
    public void setHorizontalScrollbarVisibility(int newValue) {
        if (newValue == this.hScrollVisibility) {
            return;
        }
        Integer oldValue = new Integer(this.hScrollVisibility);
        this.hScrollVisibility = newValue;
        this.updateHorizontalScrollbar();
        this.firePropertyChange("horizontalScrollbarVisibility", oldValue, new Integer(newValue));
    }

    public void setIcon(String nodeType, IconInterface icon) {
        if (icon == null) {
            return;
        }
        this.icons.set((Object)nodeType, (Object)icon);
    }

    public void setIcon(String nodeType, String path) {
        ImageView imgView = new ImageView(path);
        imgView.setDisplayMode(1);
        this.setIcon(nodeType, (IconInterface)imgView);
        this.imagePaths.set((Object)nodeType, (Object)path);
    }

    public void setImageGap(int newValue) {
        if (newValue <= 0) {
            return;
        }
        if (newValue == this.imageGap) {
            return;
        }
        Integer oldValue = new Integer(this.imageGap);
        this.imageGap = newValue;
        this.setFlag(131104);
        this.repaint();
        this.firePropertyChange("imageGap", oldValue, new Integer(newValue));
    }

    public void setImageSize(Dimension newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullImageSize.ex.txt"));
        }
        if (newValue.width <= 0 && newValue.width != -1 || newValue.height <= 0 && newValue.height != -1) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidImageSize.ex.txt"), (Object)newValue));
        }
        if (Util.equal((Object)newValue, (Object)this.imageSize)) {
            return;
        }
        Dimension oldValue = this.imageSize;
        this.imageSize = newValue;
        Object pbi = this.getDefaultNodeStyle();
        if (pbi == null) {
            pbi = new NodeStyle();
            this.setDefaultNodeStyle((PropertyBagInterface)pbi);
        }
        pbi.set("imageSize", (Object)this.imageSize);
        this.setFlag(1024);
        this.repaint();
        this.firePropertyChange("imageSize", oldValue, newValue);
    }

    public void setIndentSize(int newValue) {
        if (newValue < 0) {
            return;
        }
        if (newValue == this.indentSize) {
            return;
        }
        Integer oldValue = new Integer(this.indentSize);
        this.indentSize = newValue;
        this.setFlag(131104);
        this.repaint();
        this.firePropertyChange("indentSize", oldValue, new Integer(newValue));
    }

    public void setKeyboardSelectable(boolean newValue) {
        if (newValue == this.keyboardSelectable) {
            return;
        }
        this.keyboardSelectable = newValue;
        this.repaint();
        this.firePropertyChange("keyboardSelectable", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setLineStyle(int newValue) {
        if (newValue != 0 && newValue != 1 && newValue != 2) {
            return;
        }
        if (this.lineStyle == newValue) {
            return;
        }
        Integer oldValue = new Integer(this.lineStyle);
        this.lineStyle = newValue;
        this.repaint();
        this.firePropertyChange("lineStyle", oldValue, new Integer(newValue));
        if (this.lineStyle == 2) {
            this.setLineVisibility(1);
        }
    }

    public void setLineVisibility(int newValue) {
        if (this.lineVisibility == newValue) {
            return;
        }
        Integer oldValue = new Integer(this.lineVisibility);
        this.lineVisibility = newValue;
        this.setFlag(8192);
        this.firePropertyChange("lineVisibility", oldValue, new Integer(newValue));
        this.repaint();
    }

    public void setNodeExpandedTextDisplayed(boolean newValue) {
        if (newValue == this.nodeExpandedTextDisplayed) {
            return;
        }
        this.nodeExpandedTextDisplayed = newValue;
        this.firePropertyChange("nodeExpandedTextDisplayed", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        Object pbi = this.getDefaultNodeStyle();
        if (pbi == null) {
            pbi = new NodeStyle();
            this.setDefaultNodeStyle((PropertyBagInterface)pbi);
        }
        pbi.set("expandedTextDisplayed", (Object)(this.nodeExpandedTextDisplayed ? Boolean.TRUE : Boolean.FALSE));
        this.setFlag(32);
        this.repaint();
    }

    public void setPopupMenuVisible(boolean newValue) {
        if (newValue != this._popupMenuVisible) {
            this._popupMenuVisible = newValue;
            this.firePropertyChange("popupMenuVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setRoot(NodeInterface newRoot) {
        if (newRoot == this.getModel()) {
            return;
        }
        if (newRoot instanceof TreeInterface) {
            this.setModel((TreeInterface)newRoot);
        } else {
            this.setModel((TreeInterface)new Tree(newRoot));
        }
        NodeView root = this.getRoot();
        if (root != null) {
            root.setSelected(true);
        }
    }

    public void setRootNodeVisible(boolean newValue) {
        if (this._rootNodeVisible == newValue) {
            return;
        }
        this._rootNodeVisible = newValue;
        this.setFlag(256);
        if (!this._rootNodeVisible && this.root != null) {
            if (!this.root.isLeafNode()) {
                this.setNodeExpanded(this.root, true, false);
            }
            if (this.root.isSelected()) {
                this.root.setSelected(false);
            }
            if (this.getCurrentNode() == this.root) {
                this.setCurrentNode(null);
            }
        }
        this._topNode = null;
        this.setVerticalOffset(this.validateVerticalOffset(this.isRootNodeVisible() ? this.m_verticalOffset + 1 : this.m_verticalOffset - 1, false));
        this.setFlag(41472);
        this._searchCnt = 0;
        this.unsetFlag(256);
        this.firePropertyChange("rootNodeVisible", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        this.repaint();
    }

    public void setSelectedItem(String text) {
        NodeView node;
        if (text != null && (node = this.getNodeView(text, 1)) != null) {
            String oldText = null;
            NodeView selected = this.getSelectedNode();
            if (selected != null) {
                oldText = selected.getNodeExpandedText();
            }
            node.setSelected(true);
            this.firePropertyChange("selectedItem", oldText, text);
            this.repaint();
        }
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    public void setTextGap(int gap) {
        if (gap < 0) {
            return;
        }
        if (gap == this.textGap) {
            return;
        }
        int oldGap = this.textGap;
        this.textGap = gap;
        Object pbi = this.getDefaultNodeStyle();
        if (pbi == null) {
            pbi = new NodeStyle();
            this.setDefaultNodeStyle((PropertyBagInterface)pbi);
        }
        pbi.set("textGap", (Object)new Integer(this.textGap));
        this.setFlag(1024);
        this.repaint();
        this.firePropertyChange("textGap", new Integer(oldGap), new Integer(gap));
    }

    public void setTextPad(int pad) {
        if (pad <= 0) {
            return;
        }
        if (this.textPad == pad * 2) {
            return;
        }
        int oldPad = this.textPad;
        this.textPad = pad * 2;
        Object pbi = this.getDefaultNodeStyle();
        if (pbi == null) {
            pbi = new NodeStyle();
            this.setDefaultNodeStyle((PropertyBagInterface)pbi);
        }
        pbi.set("textPad", (Object)new Integer(pad));
        this.setFlag(1024);
        this.repaint();
        this.firePropertyChange("textPad", new Integer(oldPad), new Integer(pad));
    }

    @Override
    public void setVerticalScrollbarVisibility(int newValue) {
        if (newValue == this.vScrollVisibility) {
            return;
        }
        Integer oldValue = new Integer(this.vScrollVisibility);
        this.vScrollVisibility = newValue;
        this.updateVerticalScrollbar();
        this.firePropertyChange("verticalScrollbarVisibility", oldValue, new Integer(newValue));
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    protected IconInterface getIcon(String nodeType) {
        if (this.icons.containsKey((Object)nodeType)) {
            return (IconInterface)this.icons.get((Object)nodeType);
        }
        return null;
    }

    protected NodeView getVisibleNode(int index) {
        return this._iterator.getNodeAtIndex(index);
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        if (this.isEnabled()) {
            super.processEvent(e);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(event);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent event) {
        super.processFocusEvent(event);
        switch (event.getID()) {
            case 1004: {
                this.focusGained(event);
                break;
            }
            case 1005: {
                this.focusLost(event);
            }
        }
    }

    public void focusGained(FocusEvent e) {
        if (this.getSelectedItem() != null) {
            this.repaint();
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.getSelectedItem() != null) {
            this.repaint();
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        if (this.isFlagSet(4) && this._editableNode.getNodeView().processKeyEvent(event)) {
            super.processKeyEvent(event);
            return;
        }
        int id = event.getID();
        if (id == 400) {
            if (this.isKeyboardSelectable()) {
                this.keyTyped(event);
            }
            super.processKeyEvent(event);
            return;
        }
        if (id != 401) {
            super.processKeyEvent(event);
            return;
        }
        NodeView node = this.getCurrentNode();
        if (node != null) {
            switch (event.getKeyCode()) {
                case 40: {
                    this.downKeyPressed(event);
                    break;
                }
                case 38: {
                    this.upKeyPressed(event);
                    break;
                }
                case 37: {
                    this.leftKeyPressed(event);
                    break;
                }
                case 39: {
                    this.rightKeyPressed(event);
                    break;
                }
                case 10: {
                    this.enterKeyPressed(event);
                    break;
                }
                case 32: {
                    this.spaceKeyPressed(event);
                    break;
                }
                case 34: {
                    this.pageDownKeyPressed(event);
                    break;
                }
                case 33: {
                    this.pageUpKeyPressed(event);
                    break;
                }
                case 36: {
                    this.homeKeyPressed(event);
                    break;
                }
                case 35: {
                    this.endKeyPressed(event);
                    break;
                }
                case 109: {
                    this.subtractKeyPressed(event);
                    break;
                }
                case 107: {
                    this.addKeyPressed(event);
                    break;
                }
                case 106: {
                    this.multiplyKeyPressed(event);
                    break;
                }
                case 111: {
                    this.divideKeyPressed(event);
                }
            }
        } else {
            switch (event.getKeyCode()) {
                case 10: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 106: 
                case 107: 
                case 109: 
                case 111: {
                    node = this.getVisibleNode(0);
                    if (node == null) break;
                    this.setCurrentNode(node);
                    this.scrollToNode(node, true);
                }
            }
        }
        super.processKeyEvent(event);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if (this.isFlagSet(4) && this._editableNode.getNodeView().processMouseEvent(event)) {
            super.processMouseEvent(event);
            return;
        }
        boolean mouseDrop = false;
        switch (event.getID()) {
            case 501: {
                this.requestFocus();
                if (this.isFlagSet(4)) {
                    this._editableNode.getNodeView().setEditable(false);
                }
                if (this.isFlagSet(4)) {
                    super.processMouseEvent(event);
                    return;
                }
                if (!TreeView.isLeftMouseButton(event) && (!TreeView.isRightMouseButton(event) || event.isConsumed())) break;
                this.mouseDown(event);
                break;
            }
            case 502: {
                mouseDrop = this.processDrop();
                if (this.m_hbarAlarm != null) {
                    this.m_hbarAlarm.stop();
                }
                if (this.m_vbarAlarm != null) {
                    this.m_vbarAlarm.stop();
                }
                if (this._dragAlarm == null) break;
                this._dragAlarm.stop();
                break;
            }
            case 505: {
                this.mouseExited = true;
                break;
            }
            case 504: {
                this.mouseExited = false;
            }
        }
        if (event.isPopupTrigger() && this._popupMenuVisible && !mouseDrop && !event.isConsumed()) {
            this.displayPopup(event);
        }
        super.processMouseEvent(event);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent event) {
        if (this.isFlagSet(4) && event.getID() == 506 && this._editableNode.getNodeView().processMouseMotionEvent(event)) {
            super.processMouseMotionEvent(event);
            return;
        }
        if (event.getID() == 506 && this.getDnDDelegate() != null && !this.isFlagSet(4)) {
            Point point = event.getPoint();
            TreeDnDDelegateInterface dndDelegate = this.getDnDDelegate();
            if (this._dragAlarm != null) {
                this._dragAlarm.stop();
            }
            NodeView node = this.internalNodeHitTest(point);
            if (!this.dragInProgress) {
                SimpleNodeInterface[] path;
                this.dragInProgress = true;
                if (node != null && this._nodeHitLocation == 1 && dndDelegate.isDraggable(path = this.getPath(node))) {
                    this.dragNode = node;
                    this.dragNodePath = path;
                    this.overNode = this.dragNode;
                }
            } else if (this.dragNode != null) {
                this.dropNode = node;
                if (this.dropNode != null && (this._nodeHitLocation == 1 || this._nodeHitLocation == 0)) {
                    if (this.dropNode == this.dragNode) {
                        this.overNode = this.dropNode;
                        this.dropNode = null;
                        this.dropSiteValid = false;
                    } else {
                        if (this._nodeHitLocation == 1) {
                            this.getDropIndex();
                        } else {
                            this.dropIndex = -1;
                            this.inBetween = false;
                            this.overNode = this.dropNode;
                        }
                        this.dropNodePath = this.getPath(this.dropNode);
                        this.dropSiteValid = dndDelegate.isDropSite(this.dragNodePath, this.dropNodePath, this.dropIndex);
                        if (!this.dropSiteValid) {
                            this.dropNode = null;
                        }
                    }
                } else {
                    this.dropNode = null;
                    this.overNode = null;
                    this.dropNodePath = null;
                    this.dropSiteValid = false;
                }
                this.repaint();
            }
            if (this.overNode != null && (this._nodeHitLocation == 1 || this._nodeHitLocation == 0)) {
                this.checkDragAlarm(this.overNode);
            }
            this.updateHPowerScroll(point);
            this.updateVPowerScroll(point);
        }
        super.processMouseMotionEvent(event);
    }

    protected void render(Graphics g) {
        if (g == null) {
            return;
        }
        if (g.getClip() == null) {
            g.setClip(new Rectangle(0, 0, 3000, 3000));
        }
        NodeView node = null;
        NodeView nextNode = null;
        boolean _paintDrag = false;
        if (this.isLinesDrawn()) {
            this.paintLines(g);
        }
        int end = this.m_verticalOffset + this.m_visibleRowCount;
        for (int i = this.m_verticalOffset; i < end && (node = i == this.m_verticalOffset ? this._topNode : nextNode) != null; ++i) {
            nextNode = this._iterator.getNextNode(node, true);
            node.paint(g);
            if (!node.isLeafNode()) {
                this.paintExpandable(g, node);
            }
            if (node != this.overNode) continue;
            _paintDrag = true;
        }
        if (_paintDrag) {
            this.paintDrag(g);
        }
    }

    private void addKeyPressed(KeyEvent event) {
        NodeView node = this.getCurrentNode();
        if (!node.isExpanded() && !node.isLeafNode()) {
            this.setNodeExpanded(node, true, false);
        }
    }

    private void checkDragAlarm(NodeView node) {
        if (!node.isDragExpandEnabled()) {
            return;
        }
        if (node != null && !node.isLeafNode() && !node.isExpanded()) {
            if (this._dragAlarm == null) {
                this._dragAlarm = new Alarm((AlarmListener)new DragListener(), (long)this._dragAlarmDelay, 0L, 0);
            }
            this._dragAlarm.start();
        }
    }

    private void clearSelectedNodes() {
        if (this.selectedNodes.count() > 0) {
            this.selectedNode = this.getCurrentNode();
            if (!this.selectedNode.isSelected()) {
                this.selectedNode.setSelected(true);
            }
            this.selectedNodes.removeAll();
            this.deselectAll(this.selectedNode);
        }
    }

    private NodeView createNodeView(NodeInterface nodeInterface) {
        return new NodeView(this, nodeInterface);
    }

    private void deselectAll(NodeView remainSelected) {
        NodeView node = this._allNodesIterator.getNodeAtIndex(0);
        while (node != null) {
            if (!Util.equal((Object)node, (Object)remainSelected) && node.isSelected()) {
                node.setSelected(false);
            }
            node = this._allNodesIterator.getNextNode(node, true);
        }
        this.selectedNode = this.extendedSelectionAllowed ? null : remainSelected;
    }

    private void displayPopup(MouseEvent e) {
        Point p = e.getPoint();
        Command[] commands = this.getContextCommands(this, p.x, p.y);
        if (commands != null && commands.length > 0) {
            this.updatePopup(commands, e.getComponent(), p.x, p.y);
        }
    }

    private void divideKeyPressed(KeyEvent event) {
        NodeView node = this.getCurrentNode();
        if (node != null && !node.isLeafNode()) {
            this.setNodeExpanded(node, false, true);
        }
    }

    private void downKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (this.isExtendedSelectionAllowed()) {
            NodeView curNode = this.getCurrentNode();
            NodeView nextNode = this._iterator.getNextNode(curNode, true);
            if (!this.isVisitable(nextNode)) {
                nextNode = curNode;
            }
            if (controlDown && shiftDown) {
                this.setNodeInView(nextNode);
                this.setCurrentNode(nextNode);
            } else if (controlDown) {
                this.scrollNodeVertically(1);
            } else {
                this.setNodeInView(nextNode);
                this.setCurrentNode(nextNode);
                this.updateGUISelection(nextNode, 0);
            }
        } else if (controlDown) {
            this.scrollNodeVertically(1);
        } else {
            this.selectNextItem();
        }
    }

    private final void drawDottedLine(Graphics g, TreeLine line) {
        block3: {
            int increment;
            block2: {
                increment = 2;
                if (line.x1 != line.x2) break block2;
                for (int index = line.y1; index <= line.y2; index += increment) {
                    g.drawLine(line.x1, index, line.x1, index);
                }
                break block3;
            }
            if (line.y1 != line.y2) break block3;
            for (int index = line.x1; index <= line.x2; index += increment) {
                g.drawLine(index, line.y1, index, line.y1);
            }
        }
    }

    private void endKeyPressed(KeyEvent event) {
        NodeView node = null;
        if (this.m_visibleNodeCount > 0) {
            node = this._iterator.getNodeAtIndex(this.m_visibleNodeCount - 1);
        }
        if (node != null) {
            this.setCurrentNode(node);
            this.scrollVerticalExtent(false);
            this.updateGUISelection(node, 0);
        }
    }

    private void enterKeyPressed(KeyEvent event) {
        this.fireNodeActionEvent("defaultAction", this.getCurrentNode());
    }

    private boolean fireNodeActionEvent(String actionCmd, NodeView node) {
        if (this.actionListener == null) {
            return false;
        }
        NodeActionEvent event = new NodeActionEvent((Object)this, 1001, actionCmd, node);
        this.processEvent(event);
        return event.isConsumed();
    }

    private void fullUpdate(int offset) {
        this._topNode = null;
        this.setVerticalOffset(offset);
        this.setFlag(41472);
        this.repaint();
    }

    private int getBottom(int y, int height) {
        return y + height - 1;
    }

    private int getDepth(NodeView node) {
        int indent = node.getDepth();
        if (!this.isRootNodeVisible()) {
            --indent;
        }
        return indent;
    }

    private int getDrawableHeight() {
        int height = this.bounds.height - (this.m_insets.top + this.m_insets.bottom);
        if (this.horizontalScroll.isVisible()) {
            height -= this.m_hbarHeight;
        }
        return height;
    }

    private int getDrawableWidth() {
        int width = this.bounds.width - (this.m_insets.left + this.m_insets.right);
        if (this.verticalScroll.isVisible()) {
            width -= this.m_vbarWidth;
        }
        return width;
    }

    private int getDropIndex() {
        this.dropIndex = -1;
        this.inBetween = false;
        this.overNode = this.dropNode;
        if (this.locationOnNode == 0) {
            NodeView parent = null;
            if (this.dropNode != null) {
                parent = this.dropNode.getParent();
            }
            if (parent != null) {
                NodeView above;
                this.dropIndex = parent.getIndex(this.dropNode, 0);
                this.dropNode = parent;
                if (this.overNode != null && (above = this._iterator.getPrevNode(this.overNode, true)) != null && above.getDepth() == this.overNode.getDepth()) {
                    this.locationOnNode = 3;
                }
                this.inBetween = true;
            } else {
                this.inBetween = false;
            }
        } else if (this.locationOnNode == 2) {
            NodeView parent = null;
            if (this.dropNode != null) {
                parent = this.dropNode.getParent();
            }
            if (parent != null) {
                NodeView below;
                this.dropIndex = parent.getIndex(this.dropNode, 0) + 1;
                if (this.dropIndex == this._iterator.getVisibleNodeChildCount(parent)) {
                    this.dropIndex = -1;
                }
                this.dropNode = parent;
                if (this.overNode != null && (below = this._iterator.getNextNode(this.overNode, true)) != null && below.getDepth() == this.overNode.getDepth()) {
                    this.locationOnNode = 4;
                }
                this.inBetween = true;
            } else {
                this.inBetween = false;
            }
        }
        return this.dropIndex;
    }

    private int getFullyVisibleRowCount(boolean ignoreScroll) {
        int nodeBottom;
        int height = ignoreScroll ? this.bounds.height : this.m_drawableHeight + this.m_insets.bottom;
        int vRC = this.m_visibleRowCount;
        NodeView node = this._iterator.getNodeAtIndexFrom(this._topNode, vRC - 1);
        if (node != null && (nodeBottom = node.getY() + node.getHeight()) > height) {
            --vRC;
        }
        return vRC > 0 ? vRC : 1;
    }

    private void getLines(Graphics g, NodeView node, int i, NodeView prevNode, NodeView nextNode) {
        int indent = this.getDepth(node);
        int x = this.getNodeXLoc(node, indent, true);
        int y = this.getNodeYLoc(node);
        if (this.isLinesDrawn()) {
            if (prevNode != null && (this.isLinesAtRoot() ? this.getDepth(prevNode) >= 0 : indent != 0)) {
                if (node == this._topNode) {
                    this._lines.add(new TreeLine(x, this.m_insets.top, x, y));
                } else {
                    this._lines.add(new TreeLine(x, this.getNodeYLoc(prevNode), x, y));
                }
            }
            if (indent != 0 || !this._shiftedOver && (this.isLinesAtRoot() || !node.isLeafNode())) {
                this._lines.add(new TreeLine(x, y, node.getX(), y));
            }
            if (this._iterator.getNextVisibleSibling(node) != null && (this.isLinesAtRoot() || indent != 0)) {
                this._lines.add(new TreeLine(x, y, x, y + node.getHeight() / 2));
            }
            if (indent != 0) {
                NodeView parent = node;
                int y1 = node.getY();
                int y2 = y1 + node.getHeight();
                while ((parent = parent.getParent()) != null && --indent >= 0) {
                    if (this._iterator.getNextVisibleSibling(parent) == null || indent <= 0 && !this.isLinesAtRoot()) continue;
                    x = this.getNodeXLoc(indent);
                    this._lines.add(new TreeLine(x, y1, x, y2));
                }
            }
        }
    }

    private int getNewYLoc(int index) {
        int rowHeight = 0;
        int i = 0;
        NodeView node = this._topNode;
        while (node != null && i++ < index) {
            rowHeight += node.getHeight();
            node = this._iterator.getNextNode(node, true);
        }
        return rowHeight + this.m_insets.top;
    }

    private int getNodeXLoc(NodeView node, int indent, boolean ignoreIndent) {
        int x = node.getX();
        if (!this._shiftedOver || indent > 0) {
            x -= this.buttonSize / 2 + this.imageGap;
        }
        if (!ignoreIndent) {
            x -= indent * this.indentSize;
        }
        return x;
    }

    private int getNodeXLoc(NodeView node, boolean ignoreIndent) {
        return this.getNodeXLoc(node, this.getDepth(node), ignoreIndent);
    }

    private int getNodeXLoc(int indent) {
        return this.getNodeXLoc(indent, true);
    }

    private int getNodeXLoc(int indent, boolean useShifted) {
        useShifted = true;
        int anchor = this.buttonSize / 2 + 2;
        int xLoc = anchor - this.m_horizontalOffset + indent * this.indentSize + this.m_insets.left;
        return xLoc;
    }

    private int getNodeYLoc(int index) {
        NodeView node = this._topNode;
        if (index > 0) {
            for (int i = 0; i < index; ++i) {
                node = this._iterator.getNextNode(node, true);
            }
        }
        return this.getNodeYLoc(node);
    }

    private int getNodeYLoc(NodeView node) {
        if (node == null) {
            return this.m_insets.top;
        }
        int ht = node.getHeight() / 2;
        if (ht % 2 == 1) {
            --ht;
        }
        return node.getY() + ht;
    }

    private SimpleNodeInterface[] getPath(NodeView node) {
        if (node == null) {
            return null;
        }
        NodeInterface nodeI = node.getNode();
        if (nodeI == null) {
            return null;
        }
        SimpleNodeInterface[] sni = new SimpleNodeInterface[node.getDepth() + 1];
        for (int i = sni.length - 1; i >= 0; --i) {
            sni[i] = nodeI;
            if ((node = node.getParent()) == null) break;
            nodeI = node.getNode();
        }
        return sni;
    }

    private int getRight(int x, int width) {
        return x + width - 1;
    }

    private long getTimeOutInterval(int d) {
        return (long)(d >= 140 ? 1.0 : Math.pow(2.0, 7.0 - (double)d / 20.0));
    }

    private NodeView getTopNode() {
        if (this._topNode == null) {
            if (this.isRootNodeVisible()) {
                this._topNode = this.getRoot();
            } else if (this.getRoot() != null && this.getRoot().countNodeChildren(1) >= 1) {
                this._topNode = this._iterator.getVisibleNodeChild(this.getRoot(), 0);
            }
        }
        return this._topNode;
    }

    private int getVisibleNodeCount() {
        int vnc;
        int n = vnc = this.root != null ? this.root.getVisibleNodeCount() : 0;
        if (!this.isRootNodeVisible() && vnc > 0) {
            --vnc;
        }
        return vnc;
    }

    private void guiDeselectAll(NodeView remainSelected) {
        NodeView node = this._allNodesIterator.getNodeAtIndex(0);
        while (node != null) {
            if (!Util.equal((Object)node, (Object)remainSelected) && node.isSelected()) {
                this.guiSelectNode = node;
                node.setSelected(false);
            }
            node = this._allNodesIterator.getNextNode(node, true);
        }
        this.selectedNode = this.extendedSelectionAllowed ? null : remainSelected;
    }

    private void handleDrag(MouseEvent event) {
        if (this.dragNode != null) {
            if (this.dropSiteValid || this.dragNode == this.overNode) {
                IconInterface i = this.dragNode.getIcon();
                if (i == null) {
                    i = this.getIcon(this.dragNode.getNodeType());
                }
                if (i == null) {
                    i = this.DEFAULT_ICON;
                }
                if (i != null) {
                    this.dragIcon = i;
                }
            } else {
                this.dragIcon = this.DEFAULT_INVALID_ICON;
            }
            Point p = event.getPoint();
            int x = p.x + 12;
            int y = p.y + 12;
            Dimension iconSize = this.imageSize;
            if (iconSize.width == -1 || iconSize.height == -1) {
                iconSize = this.dragNode.getEffectiveImageSize();
            }
            if (this.dragIcon == this.DEFAULT_INVALID_ICON || this.dragIcon == this.DEFAULT_ICON) {
                iconSize = this.dragIcon.getPreferredSize();
            }
            if (x + iconSize.width > this.m_drawableWidth + this.m_insets.left) {
                x = this.m_drawableWidth + this.m_insets.left - iconSize.width;
            } else if (x < this.m_insets.left) {
                x = this.m_insets.left;
            }
            if (y + iconSize.height > this.m_drawableHeight + this.m_insets.top) {
                y = this.m_drawableHeight + this.m_insets.top - iconSize.height;
            } else if (y < this.m_insets.top) {
                y = this.m_insets.top;
            }
            this.iconView.setLocation(x, y);
            this.iconView.setSize(iconSize);
            if (this.iconView.getIcon() != this.dragIcon) {
                this.iconView.setIcon(this.dragIcon);
            }
            if (!this.iconView.isVisible()) {
                this.iconView.setVisible(true);
            }
        }
    }

    private void homeKeyPressed(KeyEvent event) {
        NodeView node = this._iterator.getNodeAtIndex(0);
        if (node != null) {
            this.setCurrentNode(node);
            this.scrollVerticalExtent(true);
            this.updateGUISelection(node, 0);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this._buttonColor = this._lineColor = SystemColor.controlShadow;
        this._plusMinusColor = SystemColor.textText;
        this.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
        this.popup = new JPopupMenu();
        this.waitCursor = new Cursor(3);
        if (this.scrollStyle == 1) {
            this.setHorizontalScrollbarVisibility(2);
            this.setVerticalScrollbarVisibility(2);
        } else {
            if (this.verticalScroll == null) {
                this.verticalScroll = new JScrollBar();
                this.verticalScroll.setVisible(true);
                this.verticalScroll.setUnitIncrement(1);
                this.verticalScroll.setBlockIncrement(10);
            }
            this.add("East", this.verticalScroll);
            this.verticalScroll.removeAdjustmentListener(this);
            this.verticalScroll.addAdjustmentListener(this);
            if (this.panel == null) {
                this.panel = new ScrollTray();
                this.panel.setLayout(new BorderLayout());
            }
            if (this.horizontalScroll == null) {
                this.horizontalScroll = new JScrollBar(0);
                this.horizontalScroll.setVisible(true);
                this.horizontalScroll.setUnitIncrement(10);
                this.horizontalScroll.setBlockIncrement(20);
            }
            this.panel.add("Center", this.horizontalScroll);
            if (this.iconView == null) {
                this.iconView = new IconView();
                this.iconView.initialize();
            }
            this.iconView.setVisible(false);
            this.iconView.setPreferredSize(new Dimension(0, 0));
            this.add("North", this.iconView);
            if (this.spacer == null) {
                this.spacer = new Spacer(this.verticalScroll.getSize().width, this.horizontalScroll.getSize().height);
            }
            this.horizontalScroll.setVisible(false);
            this.verticalScroll.setVisible(false);
            this.panel.add("East", this.spacer);
            this.add("South", this.panel);
            this.panel.setVisible(false);
            this.horizontalScroll.removeAdjustmentListener(this);
            this.horizontalScroll.addAdjustmentListener(this);
        }
        this.bounds = new Rectangle();
        this.m_insets = new Insets(1, 1, 1, 1);
        Rectangle r = this.getBounds();
        this.setBounds(r.x, r.y, TreeView.getDefaultWidth(), TreeView.getDefaultHeight());
        if (this.icons == null) {
            this.icons = new Dictionary();
            this.icons.initialize();
        }
        if (this.imagePaths == null) {
            this.imagePaths = new Dictionary();
            this.imagePaths.initialize();
        } else {
            Enumeration enumer = this.imagePaths.getKeys();
            while (enumer.hasMoreElements()) {
                String type = (String)enumer.nextElement();
                String path = (String)this.imagePaths.get((Object)type);
                this.setIcon(type, path);
            }
        }
        this._lineLength = 0;
        this.selectedNodes = new OrderedCollection();
        this._dragAlarmDelay = 1500;
        if (this.versionID == 0.0) {
            this.initPreVersion1_2();
        }
        this._lines = new TreeLines();
        if (this._nodeTypeStyles != null) {
            Enumeration e = this._nodeTypeStyles.getItems();
            while (e.hasMoreElements()) {
                NodeStyle ns = (NodeStyle)((Object)e.nextElement());
                if (this._nodeStyleListener == null) {
                    this._nodeStyleListener = new NodeStyleListener();
                }
                ns.addPropertyBagChangedListener(this._nodeStyleListener);
            }
        }
        if (this._iterator == null) {
            this._iterator = new VisibleNodeTreeViewIterator(this);
        }
        if (this._allNodesIterator == null) {
            this._allNodesIterator = new TreeViewIterator(this);
        }
        if (this._defaultNodeStyle != null) {
            if (this._nodeStyleListener == null) {
                this._nodeStyleListener = new NodeStyleListener();
            }
            this._defaultNodeStyle.addPropertyBagChangedListener((PropertyBagChangedListener)this._nodeStyleListener);
        }
        this._initCalled = true;
        this.setFlag(1051282);
    }

    private void initializeNodeStyle(PropertyBagInterface nodeStyle) {
        if (nodeStyle == null) {
            return;
        }
        nodeStyle.set("selectedBackgroundColor", (Object)SystemColor.textHighlight);
        nodeStyle.set("selectedForegroundColor", (Object)SystemColor.textHighlightText);
        nodeStyle.set("textGap", (Object)new Integer(this.getTextGap()));
        nodeStyle.set("textPad", (Object)new Integer(this.getTextPad()));
        nodeStyle.set("imageSize", (Object)this.getImageSize());
        nodeStyle.set("imageVisible", (Object)(this.getDisplayStyle() == 1 ? Boolean.TRUE : Boolean.FALSE));
        nodeStyle.set("dragExpandEnabled", (Object)Boolean.TRUE);
        if (this.isNodeExpandedTextDisplayed()) {
            nodeStyle.set("expandedTextDisplayed", (Object)Boolean.TRUE);
        }
    }

    private void initPreVersion1_2() {
        if (this.getLineStyle() == 2) {
            this.setLineVisibility(1);
        }
        this.buttonVisibility = 0;
        this._rootNodeVisible = true;
        PropertyBag pb = this.internalGetDefaultNodeStyle();
        this.setDefaultNodeStyle((PropertyBagInterface)pb);
        this._popupMenuVisible = true;
    }

    private PropertyBag internalGetDefaultNodeStyle() {
        NodeStyle nodeStyle = new NodeStyle();
        this.initializeNodeStyle((PropertyBagInterface)nodeStyle);
        return nodeStyle;
    }

    private NodeView internalGetNodeView(NodeView node, NodeInterface nodeToMatch, int occurrence, int[] occurrenceIndex) {
        SimpleNodeInterface sni;
        NodeView foundNode = null;
        int cnt = node.getNodeChildCount();
        if (cnt == 0) {
            return null;
        }
        OrderedCollection oc = null;
        if (cnt != -1) {
            sni = node.getNodeChildren(0, cnt);
            oc = new OrderedCollection((Object[])sni, 5);
        } else {
            oc = new OrderedCollection();
            sni = node.getNodeChild(0);
            int i = 1;
            while (sni != null) {
                oc.add((Object)sni);
                sni = node.getNodeChild(i++);
            }
        }
        int len = oc.count();
        for (int i = 0; i < len; ++i) {
            NodeView tempNode = (NodeView)oc.get(i);
            if (Util.equal((Object)tempNode.getNode(), (Object)nodeToMatch)) {
                occurrenceIndex[0] = occurrenceIndex[0] + 1;
                if (occurrenceIndex[0] == occurrence) {
                    foundNode = tempNode;
                    break;
                }
            }
            if (!tempNode.isLeafNode()) {
                foundNode = this.internalGetNodeView(tempNode, nodeToMatch, occurrence, occurrenceIndex);
            }
            if (foundNode != null) break;
        }
        return foundNode;
    }

    private NodeView internalGetNodeView(NodeView node, PredicateInterface predicate) {
        int i;
        SimpleNodeInterface sni;
        int cnt = node.getNodeChildCount();
        if (cnt == 0) {
            return null;
        }
        OrderedCollection oc = null;
        if (cnt != -1) {
            sni = node.getNodeChildren(0, cnt);
            oc = new OrderedCollection((Object[])sni, 5);
        } else {
            oc = new OrderedCollection();
            sni = node.getNodeChild(0);
            i = 1;
            while (sni != null) {
                oc.add((Object)sni);
                sni = node.getNodeChild(i++);
            }
        }
        NodeView foundNode = null;
        int len = oc.count();
        for (i = 0; i < len; ++i) {
            NodeView tempNode = (NodeView)oc.get(i);
            if (predicate.predicate((Object)tempNode)) {
                return tempNode;
            }
            if (!tempNode.isLeafNode()) {
                foundNode = this.internalGetNodeView(tempNode, predicate);
            }
            if (foundNode != null) break;
        }
        return foundNode;
    }

    private NodeView internalNodeHitTest(Point p) {
        return this.internalNodeHitTest(p.x, p.y);
    }

    private NodeView internalNodeHitTest(int x, int y) {
        NodeView node = null;
        this._nodeHitLocation = -1;
        if (x < this.m_insets.left || x > this.getRight(this.m_insets.left, this.m_drawableWidth)) {
            return null;
        }
        if (y < this.m_insets.top || y > this.getBottom(this.m_insets.top, this.m_drawableHeight)) {
            return null;
        }
        int nodeIndex = this._iterator.getNodeIndex(y, this._topNode, this.m_verticalOffset);
        node = this._iterator.getNodeAtIndexFrom(this._topNode, nodeIndex - this.m_verticalOffset);
        if (node == null) {
            return null;
        }
        int x1 = this.getNodeXLoc(node, true) - this.buttonSize / 2;
        int y1 = this.getNodeYLoc(node) - this.buttonSize / 2;
        if (x >= x1 && x - x1 < this.buttonSize && y >= y1 && y - y1 < this.buttonSize) {
            this._nodeHitLocation = !node.isLeafNode() ? 0 : 3;
        } else if (x < x1) {
            this._nodeHitLocation = 3;
        }
        if (this._nodeHitLocation != -1) {
            return node;
        }
        if (x >= node.getX() && x - node.getX() < node.getWidth() && y >= node.getY() && y - node.getY() < node.getHeight()) {
            this._nodeHitLocation = 1;
            this.locationOnNode = y - node.getY() <= node.getHeight() / 5 ? 0 : (node.getY() + node.getHeight() - 1 - y <= node.getHeight() / 5 ? 2 : 1);
            return node;
        }
        node = null;
        if (node != null && x > node.getX() + node.getHeight()) {
            this._nodeHitLocation = 2;
        }
        return node;
    }

    private void internalSetIndentSize(int newValue) {
        if (newValue % 2 != 0) {
            newValue = newValue > 1 ? --newValue : ++newValue;
        }
        this.setIndentSize(newValue);
    }

    private boolean isFlagSet(int flag) {
        return (this.m_flags & flag) != 0;
    }

    private boolean isLinesAtRoot() {
        return this.getLineVisibility() == 0;
    }

    private boolean isLinesDrawn() {
        return this.getLineVisibility() != 1;
    }

    private int isNodeInView(int index) {
        if (index < this.m_verticalOffset) {
            return 0;
        }
        if (index >= this.m_verticalOffset + this.getFullyVisibleRowCount(false)) {
            return 2;
        }
        return -1;
    }

    private boolean isPreviousSibling(NodeView dragNode, NodeView dropNode) {
        NodeView dragParent = dragNode.getParent();
        if (dragParent != dropNode.getParent() || dragParent == null) {
            return false;
        }
        return dragParent.getIndex(dragNode, 0) < dragParent.getIndex(dropNode, 0);
    }

    private boolean isVisitable(NodeView node) {
        return node != null && (this.isRootNodeVisible() || node.getDepth() != 0);
    }

    private void keyTyped(KeyEvent event) {
        if (event.isControlDown()) {
            return;
        }
        char ch = event.getKeyChar();
        if (Character.getType(ch) == 15) {
            return;
        }
        if (ch == '*') {
            return;
        }
        this._searchChar = ch;
        this.selectSearchString(event.isShiftDown());
    }

    private void mouseDown(MouseEvent event) {
        NodeView node = this.internalNodeHitTest(event.getPoint());
        if (node == null) {
            return;
        }
        if (this._nodeHitLocation == 0) {
            if (!node.isLeafNode()) {
                this.setNodeExpanded(node, !node.isExpanded(), false);
            }
        } else if (this._nodeHitLocation == 1) {
            boolean consumed;
            this.setCurrentNode(node);
            this.updateGUISelection(node, event.getModifiers());
            if (event.getClickCount() == 2 && !(consumed = this.fireNodeActionEvent("defaultAction", node))) {
                node.onAction();
            }
        }
    }

    private void leftKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (this.isExtendedSelectionAllowed()) {
            NodeView curNode = this.getCurrentNode();
            NodeView prevNode = curNode.getParent();
            if (!this.isVisitable(prevNode)) {
                prevNode = curNode;
            }
            if (controlDown && shiftDown) {
                if (!curNode.isLeafNode() && curNode.isExpanded()) {
                    this.setNodeExpanded(curNode, false, false);
                    this.setNodeInView(curNode);
                } else {
                    this.setNodeInView(prevNode);
                    this.setCurrentNode(prevNode);
                }
            } else if (controlDown) {
                this.scrollNodeHorizontally(-5);
            } else if (!shiftDown) {
                if (!curNode.isLeafNode() && curNode.isExpanded()) {
                    this.setNodeExpanded(curNode, false, false);
                    this.setNodeInView(curNode);
                    this.updateGUISelection(curNode, 0);
                } else {
                    this.setNodeInView(prevNode);
                    this.setCurrentNode(prevNode);
                    this.updateGUISelection(prevNode, 0);
                }
            }
        } else if (controlDown) {
            this.scrollNodeHorizontally(-5);
        } else {
            NodeView curNode = this.getCurrentNode();
            if (!curNode.isLeafNode() && curNode.isExpanded()) {
                this.setNodeExpanded(curNode, false, false);
                this.setNodeInView(curNode);
            } else {
                this.selectParentItem();
            }
        }
    }

    private void multiplyKeyPressed(KeyEvent event) {
        NodeView node = this.getCurrentNode();
        if (node != null && !node.isLeafNode()) {
            this.setNodeExpanded(node, true, true);
        }
    }

    private void onHScroll(AdjustmentEvent event) {
        switch (event.getAdjustmentType()) {
            case 1: {
                this.scrollHorizontally(1, 4);
                break;
            }
            case 2: {
                this.scrollHorizontally(-1, 4);
                break;
            }
            case 4: {
                this.scrollHorizontally(1, 1);
                break;
            }
            case 3: {
                this.scrollHorizontally(-1, 1);
                break;
            }
            case 5: {
                this.scrollHorizontally(this.horizontalScroll.getValue() - this.m_horizontalOffset, 5);
            }
        }
    }

    private void onVScroll(AdjustmentEvent event) {
        switch (event.getAdjustmentType()) {
            case 1: {
                this.scrollVertically(1, 4);
                break;
            }
            case 2: {
                this.scrollVertically(-1, 4);
                break;
            }
            case 4: {
                this.scrollVertically(1, 1);
                break;
            }
            case 3: {
                this.scrollVertically(-1, 1);
                break;
            }
            case 5: {
                this.scrollVertically(this.verticalScroll.getValue() - this.m_verticalOffset, 4);
            }
        }
    }

    private void pageDownKeyPressed(KeyEvent event) {
        this.scrollPageVertically(1);
        if (!event.isControlDown()) {
            NodeView node = this._topNode;
            this.setCurrentNode(node);
            this.updateGUISelection(node, 0);
        }
    }

    private void pageUpKeyPressed(KeyEvent event) {
        this.scrollPageVertically(-1);
        if (!event.isControlDown()) {
            NodeView node = this._topNode;
            this.setCurrentNode(node);
            this.updateGUISelection(node, 0);
        }
    }

    private void paintDrag(Graphics g) {
        if (this.dragNode == this.overNode || !this.dropSiteValid) {
            return;
        }
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        if (!this.inBetween) {
            g.fillRect(this.m_insets.left, this.overNode.getY(), this.m_drawableWidth, this.overNode.getHeight());
        } else {
            int yPre = this.overNode.getY();
            int height = this.overNode.getHeight();
            if (this.locationOnNode == 0) {
                this.paintLineInBetweenNodes(this.m_insets.left, yPre, this.m_insets.left + this.m_drawableWidth - 1, yPre, g, 0);
            } else if (this.locationOnNode == 2) {
                this.paintLineInBetweenNodes(this.m_insets.left, yPre + height, this.m_insets.left + this.m_drawableWidth - 1, yPre + height, g, 2);
            } else if (this.locationOnNode == 3) {
                this.paintLineInBetweenNodes(this.m_insets.left, yPre, this.m_insets.left + this.m_drawableWidth - 1, yPre, g, 3);
            } else if (this.locationOnNode == 4) {
                this.paintLineInBetweenNodes(this.m_insets.left, yPre + height, this.m_insets.left + this.m_drawableWidth - 1, yPre + height, g, 4);
            } else {
                System.out.println("invalid state ------------------------>");
            }
        }
        g.setPaintMode();
    }

    private void paintExpandable(Graphics g, NodeView node) {
        int indent = 0;
        int btnVis = 0;
        btnVis = this.getButtonVisibility();
        if (btnVis != 1 && ((indent = this.getDepth(node)) != 0 || btnVis != 2)) {
            int x = this.getNodeXLoc(node, indent, true);
            int y = this.getNodeYLoc(node);
            int drawX = x - this.buttonSize / 2;
            int drawY = y - this.buttonSize / 2;
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(drawX, drawY, this.buttonSize, this.buttonSize);
            }
            g.setColor(this._buttonColor);
            g.drawRect(drawX, drawY, this.buttonSize, this.buttonSize);
            g.setColor(this._plusMinusColor);
            g.drawLine(drawX + 2, y, drawX + (this.buttonSize - 2), y);
            if (!node.isExpanded()) {
                g.drawLine(x, drawY + 2, x, drawY + (this.buttonSize - 2));
            }
        }
    }

    private void paintLines(Graphics g) {
        if (this._lines.count() == 0) {
            return;
        }
        g.setColor(this._lineColor);
        int lStyle = this.getLineStyle();
        int cnt = this._lines.count();
        for (int j = 0; j < cnt; ++j) {
            TreeLine line = this._lines.getLine(j);
            if (lStyle == 1) {
                this.drawDottedLine(g, line);
                continue;
            }
            g.drawLine(line.x1, line.y1, line.x2, line.y2);
        }
    }

    private void paintLineInBetweenNodes(int x1, int y1, int x2, int y2, Graphics g, int location) {
        int factor = 3;
        x1 += factor;
        x2 -= factor;
        if (location == 3 || location == 4) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            g.drawLine(x1 + 2, y1, x2 - 2, y2);
        }
        if (location == 0) {
            g.drawLine(x2, y2, x2 + factor, y2 + factor);
            g.drawLine(x1 - factor, y1 + factor, x1, y1);
            g.drawLine(x2 - 1, y2, x2 + factor - 1, y2 + factor);
            g.drawLine(x1 - factor + 1, y1 + factor, x1 + 1, y1);
        } else if (location == 2) {
            g.drawLine(x1 - factor, y1 - factor, x1, y1);
            g.drawLine(x2, y2, x2 + factor, y2 - factor);
            g.drawLine(x1 - factor + 1, y1 - factor, x1 + 1, y1);
            g.drawLine(x2 - 1, y2, x2 + factor - 1, y2 - factor);
        }
    }

    private void positionNode(NodeView node, int index, int position) {
        block8: {
            block7: {
                if (this.m_visibleRowCount == 0) {
                    return;
                }
                if (index == -1 && node != null) {
                    index = this._iterator.getIndexOfNode(node);
                }
                if (index == -1) {
                    return;
                }
                if (position == -1) {
                    position = this.isNodeInView(index);
                }
                if (position == -1) {
                    return;
                }
                if (position != 0) break block7;
                while (this.isNodeInView(index) != -1) {
                    this.scrollNodeVertically(-1);
                }
                break block8;
            }
            if (position != 2) break block8;
            while (this.isNodeInView(index) != -1) {
                this.scrollNodeVertically(1);
            }
        }
    }

    private boolean processDrop() {
        boolean retVal = false;
        if (this.dragNode != null && this.dropNode != null && !this.mouseExited) {
            boolean prevSibling;
            NodeState state = this.dragNode.getState();
            boolean bl = prevSibling = this.dropIndex == -1 ? false : this.isPreviousSibling(this.dragNode, this.overNode);
            if (this.dndDelegate.performDrop(this.dragNodePath, this.dropNodePath, this.dropIndex)) {
                NodeView nv;
                this.setNodeExpanded(this.dropNode, true, false);
                if (prevSibling) {
                    --this.dropIndex;
                }
                NodeView nodeView = nv = this.dropIndex != -1 ? this._iterator.getVisibleNodeChild(this.dropNode, this.dropIndex) : this._iterator.getVisibleNodeChild(this.dropNode, this._iterator.getVisibleNodeChildCount(this.dropNode) - 1);
                if (nv == null) {
                    try {
                        if (this.dragNodePath != null && this.dragNodePath.length > 0) {
                            nv = this.getNodeView((NodeInterface)this.dragNodePath[this.dragNodePath.length - 1], 1);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        nv = null;
                    }
                }
                if (nv != null) {
                    nv.setState(state);
                }
                retVal = true;
            }
            Object var2_2 = null;
        }
        this.dragInProgress = false;
        this.dragNode = null;
        this.dropNode = null;
        this.overNode = null;
        this.inBetween = false;
        this.dragNodePath = null;
        this.dropNodePath = null;
        this.iconView.setVisible(false);
        this.repaint();
        return retVal;
    }

    private void refreshNodeTypeStyles() {
        NodeStyle ns;
        String key;
        StaticTreeNodeStyleInterface staticTreeNodeStyleModel;
        Object[] types = null;
        StaticPropertyBagInterface[] styles = null;
        StaticTreeNodeStyleInterface staticTreeNodeStyleInterface = staticTreeNodeStyleModel = this.getModel() instanceof StaticTreeNodeStyleInterface ? (StaticTreeNodeStyleInterface)this.getModel() : null;
        if (staticTreeNodeStyleModel != null) {
            types = staticTreeNodeStyleModel.getNodeTypes();
            styles = staticTreeNodeStyleModel.getNodeTypeStyles();
        }
        if (this._nodeTypeStyles == null) {
            this._nodeTypeStyles = new Dictionary(types != null && types.length != 0 ? types.length : 1);
        }
        int len = types == null ? 0 : types.length;
        for (int i = 0; i < len; ++i) {
            key = types[i];
            if (this._nodeTypeStyles.containsKey((Object)key)) continue;
            ns = new NodeStyle();
            if (this._nodeStyleListener == null) {
                this._nodeStyleListener = new NodeStyleListener();
            }
            ns.addPropertyBagChangedListener(this._nodeStyleListener);
            if (styles != null && styles[i] != null) {
                ns.set(styles[i]);
            }
            this._nodeTypeStyles.set((Object)key, (Object)ns);
        }
        if (this._nodeTypeStyles.count() > len) {
            Enumeration keys = this._nodeTypeStyles.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                if (types != null && Util.arrayContains((Object[])types, (Object)key)) continue;
                ns = (NodeStyle)((Object)this._nodeTypeStyles.get((Object)key));
                ns.removePropertyBagChangedListener(this._nodeStyleListener);
                this._nodeTypeStyles.removeAt((Object)key);
            }
        }
    }

    private void remeasureAllNodes(Graphics g, NodeView node) {
        OrderedCollection oc;
        int height;
        if (node == null) {
            return;
        }
        node.remeasure(g, true);
        if (node.getHeight() < this.getButtonSize()) {
            node.setHeight(this.getButtonSize());
        }
        if ((height = node.getHeight()) % 2 == 1) {
            node.setHeight(height + 1);
        }
        if ((oc = node.getInMemoryChildren()) == null) {
            return;
        }
        int cnt = oc.count();
        for (int i = 0; i < cnt; ++i) {
            this.remeasureAllNodes(g, (NodeView)oc.get(i));
        }
    }

    private void remeasureNodes(Graphics g) {
        NodeView node = this._iterator.getNodeAtIndex(0);
        int buttonHeight = this.getButtonSize();
        while (node != null) {
            node.remeasure(g, false);
            if (node.getHeight() < buttonHeight) {
                node.setHeight(buttonHeight % 2 == 1 ? buttonHeight + 1 : buttonHeight);
            } else if (node.getHeight() % 2 == 1) {
                node.setHeight(node.getHeight() + 1);
            }
            node = this._iterator.getNextNode(node, true);
        }
    }

    private synchronized void restoreCursor() {
        if (!this.isFlagSet(16384)) {
            return;
        }
        Cursor cursor = this.prevCursor;
        this.prevCursor = null;
        this.unsetFlag(16384);
        super.setCursor(cursor);
    }

    private void rightKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (this.isExtendedSelectionAllowed()) {
            NodeView curNode = this.getCurrentNode();
            if (controlDown && shiftDown) {
                if (!curNode.isLeafNode()) {
                    if (!curNode.isExpanded()) {
                        this.setNodeExpanded(curNode, true, false);
                        this.setNodeInView(curNode);
                    } else {
                        NodeView nextNode = this._iterator.getChildNode(curNode, true);
                        if (nextNode == null) {
                            nextNode = curNode;
                        }
                        this.setNodeInView(nextNode);
                        this.setCurrentNode(nextNode);
                    }
                }
            } else if (controlDown) {
                this.scrollNodeHorizontally(5);
            } else if (!shiftDown && !curNode.isLeafNode()) {
                if (!curNode.isExpanded()) {
                    this.setNodeExpanded(curNode, true, false);
                    this.setNodeInView(curNode);
                    this.updateGUISelection(curNode, 0);
                } else {
                    NodeView nextNode = this._iterator.getNextNode(curNode, true);
                    if (nextNode == null) {
                        nextNode = curNode;
                    }
                    this.setNodeInView(nextNode);
                    this.setCurrentNode(nextNode);
                    this.updateGUISelection(nextNode, 0);
                }
            }
        } else if (controlDown) {
            this.scrollNodeHorizontally(5);
        } else {
            NodeView curNode = this.getCurrentNode();
            if (!curNode.isLeafNode() && !curNode.isExpanded()) {
                this.setNodeExpanded(curNode, true, false);
                this.setNodeInView(curNode);
            } else if (!curNode.isLeafNode()) {
                this.selectNextItem();
            }
        }
    }

    private void scrollHalfPageHorizontally(int amount) {
        int oldOff = this.m_horizontalOffset;
        this.setFlag(256);
        this.setHorizontalOffset(amount * (this.m_drawableWidth / 2));
        this.unsetFlag(256);
        if (oldOff != this.m_horizontalOffset) {
            this.updateAll(null);
            this.repaint();
        }
    }

    private void scrollHalfPageVertically(int amount) {
        int oldOff = this.m_verticalOffset;
        this.setFlag(256);
        if (amount > 0) {
            for (int i = 0; i < amount; ++i) {
                this.scrollNodeVertically(this.getFullyVisibleRowCount(false) / 2);
            }
        } else if (amount < 0) {
            for (int i = 0; i > amount; --i) {
                this.scrollNodeVertically(-(this.getFullyVisibleRowCount(false) / 2));
            }
        }
        this.unsetFlag(256);
        if (oldOff != this.m_verticalOffset) {
            this.updateAll(null);
            this.repaint();
        }
    }

    private void scrollHorizontalExtent(boolean left) {
        int oldOff = this.m_horizontalOffset;
        if (left) {
            this.setHorizontalOffset(0);
        } else {
            this.setHorizontalOffset(this._lineLength);
        }
        if (oldOff != this.m_horizontalOffset) {
            this.updateAll(null);
            this.repaint();
        }
    }

    private void scrollNodeHorizontally(int amount) {
        this.setHorizontalOffset(this.m_horizontalOffset + amount);
        if (!this.isFlagSet(256)) {
            this.updateAll(null);
            this.repaint();
        }
    }

    private void scrollNodeVertically(int amount) {
        int newOff = this.m_verticalOffset + amount;
        if (newOff < 0) {
            newOff = 0;
        } else if (newOff >= this.m_visibleNodeCount) {
            newOff = this.m_visibleNodeCount - 1;
        }
        if (newOff != this.m_verticalOffset && (newOff = this.validateVerticalOffset(newOff)) != this.m_verticalOffset) {
            this.setVerticalOffset(newOff);
            if (!this.isFlagSet(256)) {
                this.updateAll(null);
                this.repaint();
            }
        }
    }

    private void scrollPageHorizontally(int amount) {
        int oldOff = this.m_horizontalOffset;
        this.setFlag(256);
        this.scrollNodeHorizontally(amount * this.m_drawableWidth);
        this.unsetFlag(256);
        if (oldOff != this.m_horizontalOffset) {
            this.updateAll(null);
            this.repaint();
        }
    }

    private void scrollPageVertically(int amount) {
        int oldOff = this.m_verticalOffset;
        this.setFlag(256);
        if (amount > 0) {
            for (int i = 0; i < amount; ++i) {
                this.scrollNodeVertically(this.getFullyVisibleRowCount(false));
            }
        } else if (amount < 0) {
            for (int i = 0; i > amount; --i) {
                this.scrollNodeVertically(-this.getFullyVisibleRowCount(false));
            }
        }
        this.unsetFlag(256);
        if (oldOff != this.m_verticalOffset) {
            this.updateAll(null);
            this.repaint();
        }
    }

    private void scrollVerticalExtent(boolean top) {
        if (top) {
            this.setVerticalOffset(0);
        } else {
            this.setBottomNode(null, this.m_visibleNodeCount - 1);
        }
    }

    private void selectNextItem() {
        NodeView node = this.getCurrentNode();
        if (node == null) {
            return;
        }
        NodeView nextNode = this._iterator.getNextNode(node, true);
        if (!this.isVisitable(nextNode)) {
            nextNode = node;
        }
        this.setNodeInView(nextNode);
        this.setCurrentNode(nextNode);
        this.updateGUISelection(nextNode, 0);
    }

    private void selectParentItem() {
        NodeView node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        NodeView parentNode = node.getParent();
        if (parentNode == null || this.getDepth(parentNode) < 0) {
            return;
        }
        int index = this._iterator.getIndexOfNode(parentNode);
        if (index < this.m_verticalOffset) {
            this.positionNode(null, index, 0);
        }
        this.setCurrentNode(parentNode);
        this.updateGUISelection(parentNode, 0);
    }

    private void selectPreviousItem() {
        NodeView node = this.getCurrentNode();
        if (node == null) {
            return;
        }
        NodeView prevNode = this._iterator.getPrevNode(node, true);
        if (!this.isVisitable(prevNode)) {
            prevNode = node;
        }
        this.setNodeInView(prevNode);
        this.setCurrentNode(prevNode);
        this.updateGUISelection(prevNode, 0);
    }

    private void selectSearchString(boolean backwards) {
        NodeView nv;
        if (this._searchChar == '\u0000') {
            return;
        }
        NodeView curNode = this.getCurrentNode();
        String curTxt = curNode.getNodeText();
        if (curTxt != null) {
            curTxt = curTxt.toUpperCase();
        }
        if (curTxt != null && curTxt.startsWith(String.valueOf(Character.toUpperCase(this._searchChar)))) {
            this._searchCnt = backwards ? --this._searchCnt : ++this._searchCnt;
            if (this._searchCnt < 1) {
                this._searchCnt = 1;
            }
        } else {
            this._searchCnt = 1;
        }
        if ((nv = this.getNodeView(String.valueOf(this._searchChar) + '*', this._searchCnt)) == null && this._searchCnt != 1) {
            this._searchCnt = 1;
            nv = this.getNodeView(String.valueOf(this._searchChar) + '*', this._searchCnt);
        }
        if (nv != null) {
            this.setCurrentNode(nv);
            this.updateGUISelection(nv, 0);
            this.scrollToNode(nv, false);
        }
    }

    private void setBottomNode(NodeView node, int index) {
        Graphics g;
        if (index == -1 && node != null) {
            index = this._iterator.getIndexOfNode(node);
        }
        if (node == null) {
            node = this._iterator.getNodeAtIndex(index);
        }
        if ((g = this.getGraphics()) == null) {
            return;
        }
        int dispHeight = this.m_drawableHeight;
        while (dispHeight > 0 && node != null) {
            node.remeasure(g, false);
            if (node.getHeight() < this.getButtonSize()) {
                node.setHeight(this.getButtonSize());
            }
            if (node.getHeight() % 2 == 1) {
                node.setHeight(node.getHeight() + 1);
            }
            if ((dispHeight -= node.getHeight()) <= 0) continue;
            node = this._iterator.getPrevNode(node, true);
        }
        if (dispHeight < 0) {
            node = this._iterator.getNextNode(node, true);
        }
        if ((index = this._iterator.getIndexOfNode(node)) != this.m_verticalOffset) {
            this.setVerticalOffset(index);
            this.repaint();
        }
    }

    private void setFlag(int flag) {
        this.m_flags |= flag;
    }

    private void setHorizontalOffset(int newOffset) {
        if (newOffset < 0 || this._lineLength < this.m_drawableWidth) {
            newOffset = 0;
        } else if (newOffset + this.m_drawableWidth > this._lineLength) {
            newOffset = this._lineLength - this.m_drawableWidth;
        }
        if (this.m_horizontalOffset != newOffset) {
            this.m_horizontalOffset = newOffset;
            this.setFlag(131073);
        }
    }

    private void setNodeExpanded(NodeView node, boolean expand, boolean recursive) {
        this.setWaitCursor();
        if (recursive) {
            this.setFlag(256);
        }
        if (recursive) {
            boolean consumed = expand ? this.fireNodeActionEvent("expandAllStarting", node) : this.fireNodeActionEvent("collapseAllStarting", node);
            if (!consumed) {
                node.setFullyExpanded(expand);
            }
            if (expand) {
                this.fireNodeActionEvent("expandAllEnding", node);
            } else {
                this.fireNodeActionEvent("collapseAllEnding", node);
            }
        } else {
            node.setExpanded(expand);
        }
        if (recursive) {
            this.unsetFlag(256);
        }
        this.updateAll(null);
        this.repaint();
        this.restoreCursor();
    }

    private void setNodeInView(NodeView node) {
        this.positionNode(node, -1, -1);
    }

    private void setVerticalOffset(int newOff) {
        if (newOff < 0) {
            newOff = 0;
        }
        int oldOff = this.m_verticalOffset;
        NodeView oldTop = this._topNode;
        this.m_verticalOffset = newOff;
        this._topNode = this._iterator.getNodeAtIndex(this.m_verticalOffset);
        if (this._topNode == null) {
            this._topNode = this.getTopNode();
        }
        if (oldTop != this._topNode) {
            this.setFlag(196610);
        }
    }

    private synchronized void setWaitCursor() {
        Cursor currentCursor = this.getCursor();
        if (this.isFlagSet(16384)) {
            return;
        }
        if (currentCursor != null && currentCursor.getType() == 3) {
            this.setFlag(16384);
            return;
        }
        this.prevCursor = this.getCursor();
        this.setFlag(16384);
        super.setCursor(this.waitCursor);
    }

    private void spaceKeyPressed(KeyEvent event) {
        if (this.isExtendedSelectionAllowed()) {
            boolean controlDown = event.isControlDown();
            boolean shiftDown = event.isShiftDown();
            if (!controlDown || !shiftDown) {
                NodeView curNode;
                if (controlDown) {
                    NodeView curNode2;
                    this.guiSelectNode = curNode2 = this.getCurrentNode();
                    curNode2.setSelected(!curNode2.isSelected());
                } else if (!shiftDown && !(curNode = this.getCurrentNode()).isSelected()) {
                    this.guiSelectNode = curNode;
                    curNode.onSelect();
                }
            }
        }
    }

    private void startAlarm(Alarm alarm, ScrollListener listener, long interval, Point point, boolean scrollForward) {
        alarm.setInterval(interval);
        listener.scrollForward = scrollForward;
        alarm.start();
    }

    private void subtractKeyPressed(KeyEvent event) {
        NodeView node = this.getCurrentNode();
        if (node.isExpanded() && !node.isLeafNode()) {
            this.setNodeExpanded(node, false, false);
        }
    }

    private int validateVerticalOffset(int newOff) {
        return this.validateVerticalOffset(newOff, true);
    }

    private int validateVerticalOffset(int newOff, boolean useTopNode) {
        NodeView node = null;
        node = useTopNode && newOff > this.m_verticalOffset ? this._iterator.getNodeAtIndexFrom2(this._topNode, newOff - this.m_verticalOffset) : this._iterator.getNodeAtIndex(newOff);
        NodeView initNode = node;
        if (node != null) {
            int dispHeight;
            for (dispHeight = this.m_drawableHeight; dispHeight > 0 && node != null; dispHeight -= node.getHeight()) {
                node = this._iterator.getNextNode(node, true);
            }
            if (node == null && dispHeight > 0) {
                node = this._iterator.getPrevNode(initNode, true);
                if (node == null) {
                    return newOff;
                }
                dispHeight -= node.getHeight();
                while (node != null && dispHeight > 0) {
                    --newOff;
                    if ((node = this._iterator.getPrevNode(node, true)) == null) continue;
                    dispHeight -= node.getHeight();
                }
            }
        }
        if (newOff < 0) {
            newOff = 0;
        }
        return newOff;
    }

    private void unsetFlag(int flag) {
        this.m_flags &= ~flag;
    }

    private void updateAll(Graphics g) {
        if (this.isFlagSet(256)) {
            return;
        }
        while (this.isFlagSet(241395)) {
            if (g == null && this.isFlagSet(164864) && (g = this.getGraphics()) == null) {
                return;
            }
            if (this.isFlagSet(512)) {
                this.updateVisibleNodeCount();
            }
            if (this.isFlagSet(2048)) {
                this.updateInsets();
            }
            if (this.isFlagSet(16)) {
                this.updateResized();
            }
            if (this.isFlagSet(128)) {
                this.updateVerticalOffset();
                this.setFlag(131072);
            }
            if (this.isFlagSet(32768)) {
                if (g == null) continue;
                this.updateDisplayedNodes(g);
            }
            if (this.isFlagSet(32)) {
                this.updateLineLength();
            }
            if (this.isFlagSet(65536)) {
                this.updateVisibleRowCount();
            }
            if (this.isFlagSet(131072)) {
                if (g == null) continue;
                this.updateDisplayedNodesLocations(g);
            }
            if (this.isFlagSet(262144)) {
                this.updateNodeLines();
            }
            if (this.isFlagSet(1024)) {
                this.unsetFlag(1024);
                if (g == null) continue;
                this.updateAllNodes(g);
                continue;
            }
            if (this.isFlagSet(64)) {
                this.updateHorizontalOffset();
            }
            if (this.isFlagSet(8192)) {
                this.updatePaintShift();
                if (this.horizontalScroll.isVisible()) {
                    this.m_horizontalOffset = 0;
                    this.horizontalScroll.setValue(0);
                }
                if (g == null) {
                    this.setFlag(131072);
                } else {
                    this.updateDisplayedNodesLocations(g);
                }
            }
            if (this.isFlagSet(1)) {
                this.updateHorizontalScrollbar();
            }
            if (!this.isFlagSet(2)) continue;
            this.updateVerticalScrollbar();
        }
    }

    private void updateAllNodes(Graphics g) {
        this.updateVisibleNodeCount();
        this.remeasureAllNodes(g, this.getRoot());
        this.setVerticalOffset(this.validateVerticalOffset(this.m_verticalOffset));
        this.updateVisibleRowCount();
        this.updateLineLength();
        this.updateDisplayedNodesLocations(g);
        this.updateVerticalScrollbar();
    }

    private void updateDisplayedNodes(Graphics g) {
        this.unsetFlag(32768);
        if (this._topNode == null) {
            this._topNode = this.getTopNode();
        }
        this.remeasureNodes(g);
        this.setVerticalOffset(this.validateVerticalOffset(this.m_verticalOffset));
        this.updateVisibleRowCount();
        this.updateDisplayedNodesLocations(g);
        this.updateVerticalScrollbar();
        this.updateLineLength();
    }

    private void updateDisplayedNodesLocations(Graphics g) {
        this.unsetFlag(131072);
        NodeView node = this._topNode;
        if (node == null) {
            node = this.getTopNode();
        }
        int height = this.m_drawableHeight;
        int buttonSize = this.getButtonSize();
        int i = this._iterator.getIndexOfNode(node);
        while (node != null && height > 0) {
            int x = this.getNodeXLoc(this.getDepth(node), false);
            int y = this.getNewYLoc(i - this.m_verticalOffset);
            if (!this._shiftedOver || this.getDepth(node) > 0) {
                x += this.imageGap + buttonSize / 2;
            }
            node.setX(x);
            node.setY(y);
            height -= node.getHeight();
            node = this._iterator.getNextNode(node, true);
            ++i;
        }
        this.updateNodeLines();
    }

    private void updateGUISelection(NodeView node, int mouseModifiers) {
        this.guiSelectNode = node;
        if (this.isExtendedSelectionAllowed()) {
            if ((mouseModifiers & 2) != 0) {
                node.setSelected(!node.isSelected());
            } else {
                this.guiDeselectAll(node);
                if (this.selectedNodes.count() > 0) {
                    OrderedCollection oc = new OrderedCollection(this.selectedNodes.toArray());
                    int cnt = oc.count();
                    for (int i = 0; i < cnt; ++i) {
                        NodeView nv = (NodeView)oc.get(i);
                        if (nv == node) continue;
                        nv.setSelected(false);
                    }
                }
                this.guiSelectNode = node;
                node.onSelect();
            }
        } else if (this.getSelectedNode() != node) {
            node.onSelect();
        } else if (!node.isSelected()) {
            node.onSelect();
        }
    }

    private void updateHorizontalOffset() {
        this.unsetFlag(64);
        int oldHOff = this.m_horizontalOffset;
        if (!this.horizontalScroll.isVisible()) {
            this.m_horizontalOffset = 0;
        } else {
            this.m_horizontalOffset = this.horizontalScroll.getValue();
            int hVal = this._lineLength - this.m_drawableWidth;
            if (hVal > 0 && this.m_horizontalOffset > hVal) {
                this.m_horizontalOffset = hVal;
            }
        }
        if (oldHOff != this.m_horizontalOffset) {
            this.setFlag(131072);
        }
    }

    private void updateHorizontalScrollbar() {
        boolean visible;
        this.unsetFlag(1);
        int max = this._lineLength > this.m_drawableWidth ? this._lineLength : this.m_drawableWidth;
        switch (this.getHorizontalScrollbarVisibility()) {
            case 2: {
                visible = false;
                break;
            }
            case 1: {
                visible = true;
                break;
            }
            default: {
                boolean bl = visible = this.m_drawableWidth < max && this.m_drawableWidth > 0;
            }
        }
        if (visible) {
            this.horizontalScroll.setValues(this.m_horizontalOffset, this.m_drawableWidth, 0, max);
        }
        if (visible != this.horizontalScroll.isVisible()) {
            this.horizontalScroll.setVisible(visible);
            this.panel.setVisible(visible);
            this.setFlag(16);
        }
        if (this.isFlagSet(16)) {
            this.validate();
            this.updateAll(null);
        }
    }

    private void updateHPowerScroll(Point point) {
        if (this.m_hbarAlarm == null) {
            this.m_hbarAlarm = new Alarm();
            this.m_hbarAlarm.setCount(0);
            this.m_hbarAlarmListener = new HScrollListener();
            this.m_hbarAlarm.addAlarmListener((AlarmListener)this.m_hbarAlarmListener);
        } else if (this.m_hbarAlarm.isRunning()) {
            this.m_hbarAlarm.stop();
        }
        if (point.x < this.bounds.x) {
            this.startAlarm(this.m_hbarAlarm, this.m_hbarAlarmListener, this.getTimeOutInterval(this.bounds.x - point.x), point, false);
        } else if (point.x > Rectangles.getRight((Rectangle)this.bounds) - this.m_vbarWidth) {
            this.startAlarm(this.m_hbarAlarm, this.m_hbarAlarmListener, this.getTimeOutInterval(point.x - (Rectangles.getRight((Rectangle)this.bounds) - this.m_vbarWidth) + 1), point, true);
        }
    }

    private void updateInsets() {
        this.unsetFlag(2048);
        Insets insets = this.getInsets();
        if (Util.unequal((Object)this.m_insets, (Object)insets)) {
            this.m_insets.top = insets.top;
            this.m_insets.bottom = insets.bottom;
            this.m_insets.left = insets.left;
            this.m_insets.right = insets.right;
            this.updateResized();
        }
    }

    private void updateLineLength() {
        this.unsetFlag(32);
        int hOff = this.m_horizontalOffset;
        this.m_horizontalOffset = 0;
        this._lineLength = 0;
        NodeView node = this._iterator.getNodeAtIndex(0);
        while (node != null) {
            int length;
            int x = this.getNodeXLoc(this.getDepth(node));
            if (!this._shiftedOver || this.getDepth(node) > 0) {
                x += this.imageGap + this.buttonSize / 2;
            }
            if ((length = x + node.getWidth()) > this._lineLength) {
                this._lineLength = length;
            }
            node = this._iterator.getNextNode(node, true);
        }
        ++this._lineLength;
        this.m_horizontalOffset = hOff;
        this.updateHorizontalOffset();
        this.updateHorizontalScrollbar();
    }

    private void updateNodeLines() {
        NodeView node = null;
        NodeView nextNode = null;
        NodeView prevNode = null;
        NodeView curNode = this.getCurrentNode();
        int start = this.m_verticalOffset;
        int end = start + this.m_visibleRowCount;
        this._lines.removeAll();
        if (this._lines.count() == 0 && this.isLinesDrawn()) {
            for (int i = start; i < end; ++i) {
                prevNode = i != start ? node : (i == 0 ? null : this._iterator.getNodeAtIndex(i - 1));
                node = i == start ? this._topNode : nextNode;
                nextNode = this._iterator.getNextNode(node, true);
                if (node == null) break;
                if (i == start && this.getDepth(node) != 0 && i > 0) {
                    prevNode = this._iterator.getPrevNode(node, true);
                }
                this.getLines(null, node, i, prevNode, nextNode);
            }
        }
    }

    private void updatePaintShift() {
        boolean buttonsVisible;
        this.unsetFlag(8192);
        this._shiftedOver = false;
        NodeView effectiveRoot = this.root;
        if (!this.isRootNodeVisible() && this.root != null) {
            effectiveRoot = this._iterator.getChildNode(this.root, false);
        }
        if (effectiveRoot == null) {
            return;
        }
        boolean linesAtRoot = this.isLinesAtRoot();
        boolean bl = buttonsVisible = this.getButtonVisibility() == 0;
        if (linesAtRoot && buttonsVisible) {
            if (effectiveRoot.isLeafNode() && this._iterator.getNextVisibleSibling(effectiveRoot) == null) {
                this._shiftedOver = true;
            }
        } else if (linesAtRoot && !buttonsVisible) {
            if (this._iterator.getNextVisibleSibling(effectiveRoot) == null) {
                this._shiftedOver = true;
            }
        } else if (!linesAtRoot && buttonsVisible) {
            buttonsVisible = false;
            while (effectiveRoot != null && !(buttonsVisible = !effectiveRoot.isLeafNode())) {
                effectiveRoot = this._iterator.getNextVisibleSibling(effectiveRoot);
            }
            if (!buttonsVisible) {
                this._shiftedOver = true;
            }
        } else {
            this._shiftedOver = true;
        }
    }

    private void updatePopup(Command[] commands, Component comp, int x, int y) {
        this.popup = new JPopupMenu();
        this.popup.setLightWeightPopupEnabled(this.isLightWeightPopupEnabled());
        CommandManager.addCommands((JPopupMenu)this.popup, (Command[])commands, (Object)this);
        this.popup.show(comp, x, y);
    }

    public void setLightWeightPopupEnabled(boolean newValue) {
        if (this._lightWeightPopupEnabled != newValue) {
            this._lightWeightPopupEnabled = newValue;
            this.popup.setLightWeightPopupEnabled(newValue);
            this.firePropertyChange("lightWeightPopupEnabled", new Boolean(!newValue), new Boolean(newValue));
        }
    }

    public boolean isLightWeightPopupEnabled() {
        return this._lightWeightPopupEnabled;
    }

    private void updateResized() {
        this.unsetFlag(16);
        this.m_hbarHeight = this.horizontalScroll.isVisible() ? this.horizontalScroll.getSize().height : 0;
        this.m_vbarWidth = this.verticalScroll.isVisible() ? this.verticalScroll.getSize().width : 0;
        this.spacer.setHeight(this.m_hbarHeight);
        this.spacer.setWidth(this.m_vbarWidth);
        this.spacer.setVisible(this.horizontalScroll.isVisible() && this.verticalScroll.isVisible());
        this.m_drawableHeight = this.getDrawableHeight();
        this.m_drawableWidth = this.getDrawableWidth();
        this.validate();
        this.updateVerticalScrollbar();
        this.updateVerticalOffset();
        this.setFlag(32768);
    }

    private void updateVerticalOffset() {
        this.unsetFlag(128);
        int vOff = 0;
        if (this.verticalScroll.isVisible()) {
            int hVal;
            vOff = this.verticalScroll.getValue();
            if (this.m_visibleNodeCount != -1 && vOff > (hVal = this.m_visibleNodeCount - this.getFullyVisibleRowCount(false)) && hVal > 0) {
                vOff = hVal;
            }
        }
        if (vOff != this.m_verticalOffset) {
            this.setVerticalOffset(vOff);
        }
    }

    private void updateVerticalScrollbar() {
        boolean visible;
        this.unsetFlag(2);
        int max = this.m_visibleNodeCount == -1 ? this.m_visibleRowCount * 10 : this.m_visibleNodeCount;
        int vRC = this.getFullyVisibleRowCount(false);
        switch (this.getVerticalScrollbarVisibility()) {
            case 2: {
                visible = false;
                break;
            }
            case 1: {
                visible = true;
                break;
            }
            default: {
                boolean bl = visible = vRC < max && vRC > 0;
            }
        }
        if (visible) {
            this.verticalScroll.setValues(this.m_verticalOffset, vRC, 0, max);
            this.verticalScroll.setBlockIncrement(vRC);
        }
        if (visible != this.verticalScroll.isVisible()) {
            this.verticalScroll.setVisible(visible);
            this.setFlag(16);
        }
        if (this.isFlagSet(16)) {
            this.validate();
            this.updateAll(null);
        }
    }

    private void updateVisibleNodeCount() {
        this.unsetFlag(512);
        int n = this.m_visibleNodeCount = this.root != null ? this.root.getVisibleNodeCount() : 0;
        if (!this.isRootNodeVisible() && this.m_visibleNodeCount > 0) {
            --this.m_visibleNodeCount;
        }
    }

    private void updateVisibleRowCount() {
        this.unsetFlag(65536);
        NodeView node = this._topNode;
        int dispHeight = this.m_drawableHeight;
        this.m_visibleRowCount = 0;
        NodeView last = null;
        while (dispHeight > 0 && node != null) {
            dispHeight -= node.getHeight();
            last = node;
            node = this._iterator.getNextNode(last, true);
            ++this.m_visibleRowCount;
        }
    }

    private void updateVPowerScroll(Point point) {
        if (this.m_vbarAlarm == null) {
            this.m_vbarAlarm = new Alarm();
            this.m_vbarAlarm.setCount(0);
            this.m_vbarAlarmListener = new VScrollListener();
            this.m_vbarAlarm.addAlarmListener((AlarmListener)this.m_vbarAlarmListener);
        } else if (this.m_vbarAlarm.isRunning()) {
            this.m_vbarAlarm.stop();
        }
        if (point.y < this.bounds.y) {
            this.startAlarm(this.m_vbarAlarm, this.m_vbarAlarmListener, this.getTimeOutInterval(this.bounds.y - point.y), point, false);
        } else if (point.y > Rectangles.getBottom((Rectangle)this.bounds) - this.m_hbarHeight) {
            this.startAlarm(this.m_vbarAlarm, this.m_vbarAlarmListener, this.getTimeOutInterval(point.y - (Rectangles.getBottom((Rectangle)this.bounds) - this.m_hbarHeight) + 1), point, true);
        }
    }

    private void upKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (this.isExtendedSelectionAllowed()) {
            NodeView curNode = this.getCurrentNode();
            NodeView prevNode = this._iterator.getPrevNode(curNode, true);
            if (!this.isVisitable(prevNode)) {
                prevNode = curNode;
            }
            if (controlDown && shiftDown) {
                this.setNodeInView(prevNode);
                this.setCurrentNode(prevNode);
            } else if (controlDown) {
                this.scrollNodeVertically(-1);
            } else {
                this.setNodeInView(prevNode);
                this.setCurrentNode(prevNode);
                this.updateGUISelection(prevNode, 0);
            }
        } else if (controlDown) {
            this.scrollNodeVertically(-1);
        } else {
            this.selectPreviousItem();
        }
    }

    final FontStyle getDefaultFontStyle() {
        if (this._defaultFontStyle == null) {
            this._defaultFontStyle = new FontStyle();
            this._defaultFontStyle.setFont(this.getFont());
        }
        return this._defaultFontStyle;
    }

    boolean isNodeTypeStylesSaved() {
        return this._nodeTypeStylesSaved;
    }

    void noteNodeChildrenChanged(NodeView node) {
        this.setFlag(41472);
        if (!this.isRootNodeVisible() && node == this.getRoot() && !node.isExpanded()) {
            this.setNodeExpanded(node, true, false);
        }
        this.repaint();
    }

    void noteNodeExpandedChanged(NodeView node) {
        if (!this.isRootNodeVisible() && node == this.getRoot() && !node.isExpanded()) {
            this.setNodeExpanded(node, true, false);
            return;
        }
        if (!this.isExtendedSelectionAllowed()) {
            this.deselectAll(this.getSelectedNode());
        }
        if (node.isExpanded()) {
            this.fireNodeActionEvent("expanded", node);
        } else {
            this.fireNodeActionEvent("collapsed", node);
        }
        if (this.getImageSize().width == -1 || this.getImageSize().height == -1) {
            this.setFlag(1024);
        } else if (node.isSelected()) {
            if (node.getSelectedIcon() == null ^ node.getExpandedSelectedIcon() == null) {
                this.setFlag(1024);
            } else {
                this.setFlag(33280);
            }
        } else if (node.getDefaultIcon() == null && node.getExpandedIcon() != null) {
            this.setFlag(1024);
        } else {
            this.setFlag(33280);
        }
        this.repaint();
    }

    void noteNodeExpandedTextChanged(NodeView node) {
        if (node.isExpandedTextDisplayed()) {
            this.setFlag(32768);
            this.repaint();
        }
    }

    boolean noteNodeExpanding(NodeView node, boolean expanding) {
        if (expanding) {
            return this.fireNodeActionEvent("expanding", node);
        }
        return this.fireNodeActionEvent("collapsing", node);
    }

    void noteNodeIconChanged(NodeView node) {
        this.repaint();
    }

    void noteNodeRenameStarting(NodeView node) {
        this.setFlag(4);
    }

    void noteNodeRenameEnding(NodeView node) {
        this.unsetFlag(4);
    }

    void noteNodeResized(NodeView node) {
        this.setFlag(1024);
        this.repaint();
    }

    void noteNodeSelectedChanged(NodeView node) {
        boolean newValue = node.isSelected();
        ItemEvent ievent = null;
        if (this.guiSelectNode == node && this.itemListener != null) {
            ievent = newValue ? new ItemEvent(this, 701, node, 1) : new ItemEvent(this, 701, node, 2);
        }
        if (!this.isExtendedSelectionAllowed()) {
            if (Util.unequal((Object)node, (Object)this.selectedNode)) {
                if (newValue) {
                    NodeView oldSelected = this.selectedNode;
                    String oldSelectedItem = this.getSelectedItem();
                    if (this.guiSelectNode == node) {
                        NodeView tempGuiSelectNode = this.guiSelectNode;
                        this.guiDeselectAll(node);
                        this.guiSelectNode = tempGuiSelectNode;
                    } else {
                        this.deselectAll(node);
                    }
                    this.firePropertyChange("selectedItem", oldSelectedItem, this.getSelectedItem());
                    this.firePropertyChange("selectedNode", oldSelected, this.selectedNode);
                } else {
                    this.selectedNode = null;
                }
            } else if (!newValue) {
                this.selectedNode = null;
            }
        } else {
            this.selectedNode = null;
            if (!newValue) {
                if (this.selectedNodes.contains((Object)node)) {
                    this.selectedNodes.remove((Object)node);
                }
            } else {
                this.selectedNodes.add((Object)node);
            }
            this.firePropertyChange("selectedNodes", null, null);
        }
        if (this.guiSelectNode == node) {
            this.guiSelectNode = null;
            this.processEvent(ievent);
        }
        if (newValue && !this.isExtendedSelectionAllowed() && node != this.getCurrentNode()) {
            this.setCurrentNode(node);
        }
        if (this.getImageSize().width == -1 || this.getImageSize().height == -1) {
            this.setFlag(1024);
        } else if (node.isExpanded()) {
            if (node.getExpandedIcon() == null && node.getExpandedSelectedIcon() != null) {
                this.setFlag(1024);
            }
        } else if (node.getDefaultIcon() == null && node.getSelectedIcon() != null) {
            this.setFlag(1024);
        }
        this.repaint();
    }

    void noteNodeTextChanged(NodeView node) {
        if (!node.isExpandedTextDisplayed()) {
            this.setFlag(32768);
            this.repaint();
        }
    }

    void noteNodeTypeChanged(NodeView node) {
        this.setFlag(1024);
        this.repaint();
    }

    void setNodeTypeStylesSaved(boolean newValue) {
        this._nodeTypeStylesSaved = newValue;
    }

    class VisibleNodeTreeViewIterator
    extends TreeViewIterator {
        public VisibleNodeTreeViewIterator(TreeView treeView) {
            super(treeView);
        }

        @Override
        public NodeView getPrevNode(NodeView node, boolean checkExpanded) {
            if (node == null) {
                return this._treeView.getRoot();
            }
            NodeView prev = this.getPreviousVisibleSibling(node);
            if (prev == null) {
                return node.getParent();
            }
            return this.getLastNode(prev);
        }

        @Override
        public NodeView getChildNode(NodeView parent, boolean checkExpanded) {
            if (parent == null) {
                return null;
            }
            boolean bl = checkExpanded = checkExpanded ? parent.isExpanded() : true;
            if (!parent.isLeafNode() && checkExpanded && (this.getVisibleNodeChildCount(parent) > 0 || this.getVisibleNodeChildCount(parent) == -1)) {
                return this.getVisibleNodeChild(parent, 0);
            }
            return null;
        }

        @Override
        public NodeView getLastNode(NodeView parent) {
            if (!parent.isLeafNode() && parent.isExpanded()) {
                int cnt = this.getVisibleNodeChildCount(parent);
                if (cnt == -1) {
                    NodeView node;
                    if ((node = this.getVisibleNodeChild(parent, ++cnt)) == null) {
                        return null;
                    }
                    while (node != null) {
                        node = this.getVisibleNodeChild(parent, ++cnt);
                    }
                }
                if (cnt <= 0) {
                    return parent;
                }
                return this.getLastNode(this.getVisibleNodeChild(parent, cnt - 1));
            }
            return parent;
        }

        @Override
        public NodeView getNextSiblingNode(NodeView node) {
            NodeView sibling = this.getNextVisibleSibling(node);
            if (sibling != null) {
                return sibling;
            }
            if (node.getParent() != null) {
                return this.getNextSiblingNode(node.getParent());
            }
            return null;
        }

        public NodeView getNextVisibleSibling(NodeView node) {
            NodeView next = node;
            while ((next = next.getNextSibling()) != null && !next.isVisible()) {
            }
            return next;
        }

        public NodeView getPreviousVisibleSibling(NodeView node) {
            NodeView prev = node;
            while ((prev = prev.getPreviousSibling()) != null && !prev.isVisible()) {
            }
            return prev;
        }

        public NodeView getVisibleNodeChild(NodeView parent, int index) {
            return parent.getVisibleNodeChild(index);
        }

        public int getVisibleNodeChildCount(NodeView parent) {
            return parent.getVisibleNodeChildCount();
        }
    }

    class TreeViewIterator {
        TreeView _treeView;

        public TreeViewIterator(TreeView treeView) {
            this._treeView = treeView;
        }

        public int getNodeIndex(int yPosition, NodeView topNode, int verticalOffset) {
            NodeView node = topNode;
            if (node == null) {
                return -1;
            }
            int highestPixel = node.getY();
            if (highestPixel > yPosition) {
                return -1;
            }
            int nodeIndex = -1;
            int effY = yPosition - highestPixel;
            while (node != null) {
                ++nodeIndex;
                int height = node.getHeight();
                if ((effY -= height) <= 0) break;
                node = this.getNextNode(node, true);
            }
            return nodeIndex += verticalOffset;
        }

        public int getIndexOfNode(NodeView node) {
            int index = -1;
            NodeView n = this.getNodeAtIndex(0);
            while (n != null) {
                ++index;
                if (Util.equal((Object)node, (Object)n)) {
                    return index;
                }
                n = this.getNextNode(n, true);
            }
            return -1;
        }

        public NodeView getNodeAtIndexFrom(NodeView node, int index) {
            while (index-- > 0) {
                node = this.getNextNode(node, true);
            }
            return node;
        }

        public NodeView getNodeAtIndexFrom2(NodeView node, int index) {
            NodeView temp = node;
            while (index-- >= 0 && temp != null) {
                node = temp;
                temp = this.getNextNode(temp, true);
            }
            return node;
        }

        public NodeView getNodeAtIndex(int index) {
            if (!this._treeView.isRootNodeVisible()) {
                ++index;
            }
            NodeView node = null;
            for (int i = 0; i < index + 1; ++i) {
                if ((node = this.getNextNode(node, true)) != null) continue;
                return null;
            }
            return node;
        }

        public NodeView getNextNode(NodeView node, boolean checkExpanded) {
            if (node == null) {
                return this._treeView.getRoot();
            }
            NodeView next = this.getChildNode(node, checkExpanded);
            if (next != null) {
                return next;
            }
            next = this.getNextSiblingNode(node);
            return next;
        }

        public NodeView getPrevNode(NodeView node, boolean checkExpanded) {
            if (node == null) {
                return this._treeView.getRoot();
            }
            NodeView prev = node.getPreviousSibling();
            if (prev == null) {
                return node.getParent();
            }
            return this.getLastNode(prev);
        }

        public NodeView getChildNode(NodeView parent, boolean checkExpanded) {
            if (parent == null) {
                return null;
            }
            boolean bl = checkExpanded = checkExpanded ? parent.isExpanded() : true;
            if (!parent.isLeafNode() && checkExpanded && (parent.getNodeChildCount() > 0 || parent.getNodeChildCount() == -1)) {
                return (NodeView)parent.getNodeChild(0);
            }
            return null;
        }

        public NodeView getLastNode(NodeView parent) {
            if (!parent.isLeafNode() && parent.isExpanded()) {
                int cnt = parent.getNodeChildCount();
                if (cnt == -1) {
                    NodeView node;
                    if ((node = (NodeView)parent.getNodeChild(++cnt)) == null) {
                        return null;
                    }
                    while (node != null) {
                        node = (NodeView)parent.getNodeChild(++cnt);
                    }
                }
                if (cnt <= 0) {
                    return parent;
                }
                return this.getLastNode((NodeView)parent.getNodeChild(cnt - 1));
            }
            return parent;
        }

        public NodeView getNextSiblingNode(NodeView node) {
            NodeView sibling = node.getNextSibling();
            if (sibling != null) {
                return sibling;
            }
            if (node.getParent() != null) {
                return this.getNextSiblingNode(node.getParent());
            }
            return null;
        }
    }

    class DnDMouseListener
    implements MouseMotionListener {
        DnDMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            TreeView.this.handleDrag(event);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }
    }

    class SelectedStringPredicate
    implements PredicateInterface {
        String selectedString;

        SelectedStringPredicate(String selectedString) {
            this.selectedString = selectedString;
        }

        public boolean predicate(Object object) {
            NodeView node = (NodeView)object;
            String text = TreeView.this.isNodeExpandedTextDisplayed() ? node.getNodeExpandedText() : node.getNodeText();
            return Strings.match((String)text, (String)this.selectedString, (boolean)true);
        }
    }

    class NodeInterfacePredicate
    implements PredicateInterface {
        NodeInterface nodeI;

        NodeInterfacePredicate(NodeInterface nodeI) {
            if (nodeI == null) {
                throw new IllegalArgumentException(RB.getStringResource((String)TreeView.RB_KEY, (String)"nullNodeInterface.ex.txt"));
            }
            this.nodeI = nodeI;
        }

        public boolean predicate(Object object) {
            NodeView node = (NodeView)object;
            return Util.equal((Object)node.getNode(), (Object)this.nodeI);
        }
    }

    class NodeStyleListener
    implements PropertyBagChangedListener {
        NodeStyleListener() {
        }

        public void propertyBagChanged(PropertyBagChangedEvent event) {
            String propertyName = event.getPropertyName();
            if (propertyName == "fontStyle" || propertyName == "textGap" || propertyName == "textPad" || propertyName == "imageVisible" || propertyName == "imageSize") {
                TreeView.this.setFlag(1024);
            }
            TreeView.this.repaint();
        }
    }

    private final class DragListener
    extends ScrollListener {
        private DragListener() {
        }

        public void fireAlarm(AlarmEvent event) {
            if (TreeView.this.overNode != null && !TreeView.this.overNode.isLeafNode() && !TreeView.this.overNode.isExpanded()) {
                TreeView.this.setNodeExpanded(TreeView.this.overNode, true, false);
            }
        }
    }

    private final class VScrollListener
    extends ScrollListener {
        private VScrollListener() {
        }

        public void fireAlarm(AlarmEvent event) {
            TreeView.this.scrollVertically(this.scrollForward ? 1 : -1, 4);
        }
    }

    private final class HScrollListener
    extends ScrollListener {
        private HScrollListener() {
        }

        public void fireAlarm(AlarmEvent event) {
            TreeView.this.scrollHorizontally(this.scrollForward ? 1 : -1, 4);
        }
    }

    private abstract class ScrollListener
    implements AlarmListener {
        public boolean scrollForward;

        private ScrollListener() {
        }
    }
}

