/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.collection.OrderedCollection;
import com.sas.swing.visuals.TreeLine;

class TreeLines {
    OrderedCollection _lines;

    TreeLines() {
    }

    public void add(TreeLine line) {
        TreeLine mergedLine;
        if (line == null) {
            throw new IllegalArgumentException("can't add null line");
        }
        if (this._lines == null) {
            this._lines = new OrderedCollection();
        }
        if ((mergedLine = this.merge(line)) != null) {
            line = this.merge(mergedLine);
            if (line != null) {
                this._lines.remove((Object)mergedLine);
            }
        } else {
            this._lines.add((Object)line);
        }
    }

    private TreeLine merge(TreeLine line) {
        int cnt = this._lines.count();
        for (int i = 0; i < cnt; ++i) {
            TreeLine l = this.getLine(i);
            if (l == line || !l.doesLineConnect(line)) continue;
            l.merge(line);
            return l;
        }
        return null;
    }

    public TreeLine getLine(int index) {
        return (TreeLine)this._lines.get(index);
    }

    public void remove(TreeLine line) {
        if (line == null || this._lines == null || this._lines.count() == 0) {
            return;
        }
        int cnt = this._lines.count();
        for (int i = 0; i < cnt; ++i) {
            TreeLine l = this.getLine(i);
            if (!l.contains(line)) continue;
            this._lines.remove((Object)l);
            TreeLine[] lines = l.split(line);
            if (lines[0] != null) {
                this._lines.add((Object)lines[0]);
            }
            if (lines[1] != null) {
                this._lines.add((Object)lines[1]);
            }
            return;
        }
    }

    public void removeAll() {
        if (this._lines != null) {
            this._lines.removeAll();
        }
    }

    public int count() {
        if (this._lines != null) {
            return this._lines.count();
        }
        return 0;
    }

    public String toString() {
        String ret = "";
        if (this._lines == null || this._lines.count() == 0) {
            ret = "empty";
        } else {
            int cnt = this._lines.count();
            for (int i = 0; i < cnt; ++i) {
                ret = ret + this.getLine(i) + "\n";
            }
        }
        return ret;
    }
}

