/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.beans.CustomizerClosingInterface;
import com.sas.swing.visuals.wizard.ButtonLayout;
import com.sas.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class SwingCustomizerDialog
extends JDialog
implements ActionListener,
WindowListener {
    protected JButton closeButton;
    protected Component customizer;
    protected JPanel mainPanel = new JPanel();
    protected JScrollPane swingScrollPane;
    protected ScrollPane awtScrollPane;
    private static String[][] labels = new String[1][1];

    public SwingCustomizerDialog(Component customizer, Object object, String title, Frame frame) {
        super(frame == null ? new JFrame() : frame, title);
        this.mainPanel.setLayout(new BorderLayout());
        this.customizer = customizer;
        this.swingScrollPane = new JScrollPane();
        this.awtScrollPane = new ScrollPane();
        if (customizer instanceof JComponent) {
            this.mainPanel.add((Component)this.swingScrollPane, "Center");
            this.swingScrollPane.setViewportView(customizer);
            this.pack();
        } else if (customizer instanceof Component) {
            this.awtScrollPane.add(customizer, "Center");
            this.mainPanel.add((Component)this.awtScrollPane, "Center");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingCustomizerDialog.this.setWindowSizeForCustomizer();
                }
            });
        }
        this.closeButton = new JButton(labels[0][0]);
        this.closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        ButtonLayout layout = new ButtonLayout();
        buttonPanel.setLayout((LayoutManager)layout);
        buttonPanel.add(this.closeButton);
        this.mainPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    private void setWindowSizeForCustomizer() {
        if (this.customizer != null && this.customizer instanceof Component) {
            Dimension customSize = this.customizer.getPreferredSize();
            Dimension titleSize = this.mainPanel.getPreferredSize();
            this.setSize(Math.max(customSize.width + 40, titleSize.width), customSize.height + 75);
            this.awtScrollPane.invalidate();
            this.mainPanel.invalidate();
            this.getContentPane().validate();
        }
    }

    public SwingCustomizerDialog(Component customizer, Object object, String title) {
        this(customizer, object, title, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.callCustomizerClosing();
            this.dispose();
        }
    }

    protected void callCustomizerClosing() {
        Component customizer = this.getCustomizer();
        if (customizer instanceof CustomizerClosingInterface) {
            ((CustomizerClosingInterface)customizer).customizerClosing();
            customizer = null;
        }
    }

    public Component getCustomizer() {
        return this.customizer;
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.callCustomizerClosing();
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    static {
        try {
            SwingCustomizerDialog.labels[0][0] = Util.getCommonStringResource((String)"Close.txt");
        }
        catch (Exception e) {
            SwingCustomizerDialog.labels[0][0] = "Close";
        }
    }
}

