/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.ModelInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.lang.DoubleData;
import com.sas.lang.DoubleDataInterface;
import com.sas.lang.FloatData;
import com.sas.lang.StringDataInterface;
import com.sas.models.BoundedDouble;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.SpinButton;
import com.sas.util.Alarm;
import com.sas.util.Countable;
import com.sas.util.IndexedGetInterface;
import com.sas.util.PrefixPredicate;
import com.sas.util.Util;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.transforms.EnumerationTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.validators.ValidationInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SpinBox
extends JComponent
implements Adjustable,
ItemSelectable,
AdjustmentListener,
StringDataInterface,
DoubleDataInterface,
ContentsChangedListener,
PropertyChangeListener,
FocusListener,
ActionListener {
    public static final String RB_KEY = "SpinBox.";
    static final long serialVersionUID = 8622081177453794884L;
    protected SpinButton spinBtn;
    protected JTextField text;
    protected double precision;
    protected NumberFormat numberFormat;
    protected boolean numberFormatSet;
    protected BoundedNumberInterface defaultRangeModel;
    protected BoundedNumberInterface boundedNumberModel;
    protected StaticOrderedCollectionInterface staticOrderedCollectionModel;
    protected boolean precisionDisplayed;
    protected transient boolean textInvoked;
    protected transient boolean valueInvoked;
    protected transient PrefixPredicate prefixPredicate;
    protected transient ArrowKeyAdapter arrowKeyAdapter;
    protected transient AdjustmentListener adjustmentListener;
    protected transient ItemListener itemListener;
    protected ValidationInterface validator;
    protected GenericErrorHandlerInterface errorHandler;
    protected TransformInterface displayTransform;
    private String spinBoxText;
    private boolean validating;
    private static int defaultWidth = 124;
    private static int defaultHeight = 23;
    private static String[] requiredInterface1String = new String[]{"com.sas.models.BoundedNumberInterface"};
    private static String[] requiredInterface2String = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    public static final int UP_DOWN = 2;
    public static final int LEFT_RIGHT = 3;

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        String[][][] propertyMetadata = new String[][][]{{{"Name", "alarm"}, {"Hidden", "true"}}, {{"Name", "columns"}, {"Expert", "true"}}, {{"Name", "blockIncrement"}, {"Hidden", "true"}}, {{"Name", "blockIncrementNumber"}, {"Hidden", "true"}}, {{"Name", "maximum"}, {"Expert", "true"}}, {{"Name", "minimum"}, {"Expert", "true"}}, {{"Name", "precisionDisplayed"}, {"Hidden", "true"}}, {{"Name", "precision"}, {"Hidden", "true"}}, {{"Name", "unitIncrement"}, {"Expert", "true"}}, {{"Name", "value"}, {"Expert", "true"}}, {{"Name", "visibleAmount"}, {"Hidden", "true"}}, {{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}}};
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        return ebi;
    }

    public SpinBox() {
        this.setDefaultValues();
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Object eSource = e.getSource();
        if (this.adjustmentListener != null && (eSource == this || eSource == this.spinBtn)) {
            this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, e.getID(), e.getAdjustmentType(), e.getValue()));
        }
    }

    public synchronized void contentsChanged(ContentsChangedEvent e) {
        StaticOrderedCollectionInterface model = this.getStaticOrderedCollectionModel();
        if (e.getSource() == model && model instanceof IndexedGetInterface) {
            int curIndex;
            StaticOrderedCollectionInterface collection = model;
            int count = collection.count() - 1;
            if (count < 0) {
                count = 1;
            }
            if ((curIndex = this.spinBtn.getValue()) <= count && collection.count() != 0) {
                Object item = collection.get(curIndex);
                try {
                    if (this.displayTransform != null) {
                        item = this.displayTransform.transform(item);
                    }
                }
                catch (TransformException exc) {
                    System.out.println("TransformException in contentsChanged " + (Object)((Object)exc));
                }
                if (item != null && Util.unequal((Object)this.getText(), (Object)item.toString())) {
                    this.setText(item.toString());
                }
            } else if (collection.count() == 0) {
                this.setText("");
            }
            this.setMaximum(count);
        }
    }

    @Override
    public void setToolTipText(String txt) {
        super.setToolTipText(txt);
        if (this.text != null) {
            this.text.setToolTipText(txt);
        }
        if (this.spinBtn != null) {
            this.spinBtn.setToolTipText(txt);
        }
    }

    public boolean isDefaultModelAttached() {
        if (this.getStaticOrderedCollectionModel() != null) {
            return false;
        }
        return this.getModel().equals(this.defaultRangeModel);
    }

    public BoundedNumberInterface getModel() {
        return this.boundedNumberModel;
    }

    public void setModel(BoundedNumberInterface model) {
        BoundedNumberInterface oldModel = this.boundedNumberModel;
        if (model != null && this.staticOrderedCollectionModel != null) {
            if (this.staticOrderedCollectionModel != null && this.staticOrderedCollectionModel instanceof ContentsChangedSource) {
                this.staticOrderedCollectionModel.removeContentsChangedListener((ContentsChangedListener)this);
            }
            StaticOrderedCollectionInterface oldSOCModel = this.staticOrderedCollectionModel;
            this.staticOrderedCollectionModel = null;
            this.firePropertyChange("staticOrderedCollectionModel", oldSOCModel, null);
        }
        this.boundedNumberModel = model;
        if (this.boundedNumberModel == null && this.staticOrderedCollectionModel == null) {
            try {
                this.setModel((BoundedNumberInterface)((BoundedDouble)this.defaultRangeModel).clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else {
            this.refresh((ModelInterface)this.boundedNumberModel);
        }
        this.firePropertyChange("model", oldModel, this.boundedNumberModel);
    }

    public StaticOrderedCollectionInterface getStaticOrderedCollectionModel() {
        return this.staticOrderedCollectionModel;
    }

    public void setStaticOrderedCollectionModel(StaticOrderedCollectionInterface model) {
        StaticOrderedCollectionInterface oldModel = this.staticOrderedCollectionModel;
        if (model == null) {
            if (this.staticOrderedCollectionModel != null && this.staticOrderedCollectionModel instanceof ContentsChangedSource) {
                this.staticOrderedCollectionModel.removeContentsChangedListener((ContentsChangedListener)this);
            }
            this.staticOrderedCollectionModel = null;
            try {
                this.setModel((BoundedNumberInterface)((BoundedDouble)this.defaultRangeModel).clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else {
            this.staticOrderedCollectionModel = model;
            BoundedNumberInterface oldBNIModel = this.boundedNumberModel;
            this.boundedNumberModel = null;
            this.firePropertyChange("model", oldBNIModel, null);
        }
        this.refresh((ModelInterface)this.staticOrderedCollectionModel);
        this.firePropertyChange("staticOrderedCollectionModel", oldModel, this.staticOrderedCollectionModel);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.text != null) {
            this.text.setForeground(color);
        }
        super.setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        if (this.text != null) {
            this.text.setBackground(color);
        }
        super.setBackground(color);
    }

    public Alarm getAlarm() {
        return this.spinBtn.getAlarm();
    }

    public int getArrowDirection() {
        return this.spinBtn.getArrowDirection();
    }

    public long getDelay() {
        return this.spinBtn.getDelay();
    }

    public long getStartInterval() {
        return this.spinBtn.getStartInterval();
    }

    @Override
    public int getBlockIncrement() {
        return this.spinBtn.getBlockIncrement();
    }

    public int getColumns() {
        return this.text.getColumns();
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public final double getDoubleData() {
        return this.getNumberValue().doubleValue();
    }

    @Override
    public int getMaximum() {
        return this.spinBtn.getMaximum();
    }

    @Override
    public int getMinimum() {
        return this.spinBtn.getMinimum();
    }

    public Number getBlockIncrementNumber() {
        return this.spinBtn.getBlockIncrementNumber();
    }

    public Number getMaximumNumber() {
        return this.spinBtn.getMaximumNumber();
    }

    public Number getMinimumNumber() {
        return this.spinBtn.getMinimumNumber();
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(2);
        requiredInterfaces.addElement(requiredInterface1String);
        requiredInterfaces.addElement(requiredInterface2String);
        return requiredInterfaces;
    }

    public Number getUnitIncrementNumber() {
        return this.spinBtn.getUnitIncrementNumber();
    }

    public Number getNumberValue() {
        return this.spinBtn.getNumberValue();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public int getOrientation() {
        return this.spinBtn.getOrientation();
    }

    public double getPrecision() {
        return this.precision;
    }

    @Override
    public Object[] getSelectedObjects() {
        StaticOrderedCollectionInterface model = this.getStaticOrderedCollectionModel();
        if (model != null) {
            Object[] selectedItem = new Object[]{model.get(this.getValue())};
            return selectedItem;
        }
        return null;
    }

    public String getText() {
        return this.text.getText();
    }

    public JTextField getTextField() {
        return this.text;
    }

    public JButton getIncrementButton() {
        return this.spinBtn.incrementButton;
    }

    public JButton getDecrementButton() {
        return this.spinBtn.decrementButton;
    }

    @Override
    public int getUnitIncrement() {
        return this.spinBtn.getUnitIncrement();
    }

    @Override
    public int getValue() {
        return this.spinBtn.getValue();
    }

    @Override
    public int getVisibleAmount() {
        return this.spinBtn.getVisibleAmount();
    }

    public boolean isCycleOn() {
        return this.spinBtn.isCycleOn();
    }

    public boolean isPrecisionDisplayed() {
        return this.precisionDisplayed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setText(this.text.getText());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!this.validating) {
            this.setText(this.text.getText());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object eSource = event.getSource();
        String name = event.getPropertyName();
        if (eSource == this.spinBtn && name != null) {
            Object newValue = event.getNewValue();
            if (Util.equal((Object)name, (Object)"numberValue")) {
                if (!this.textInvoked && newValue != null && newValue instanceof Number) {
                    this.updateText((Number)newValue);
                }
                this.firePropertyChange("doubleData", event.getOldValue(), newValue);
                this.firePropertyChange(name, event.getOldValue(), newValue);
            } else if (Util.equal((Object)name, (Object)"value") || Util.equal((Object)name, (Object)"maximumNumber") || Util.equal((Object)name, (Object)"minimumNumber") || Util.equal((Object)name, (Object)"unitIncrementNumber") || Util.equal((Object)name, (Object)"blockIncrementNumber") || Util.equal((Object)name, (Object)"maximum") || Util.equal((Object)name, (Object)"minimum") || Util.equal((Object)name, (Object)"unitIncrement") || Util.equal((Object)name, (Object)"blockIncrement") || Util.equal((Object)name, (Object)"alarm") || Util.equal((Object)name, (Object)"cycleOn") || Util.equal((Object)name, (Object)"arrowDirection") || Util.equal((Object)name, (Object)"orientation")) {
                this.firePropertyChange(name, event.getOldValue(), newValue);
            }
        } else if (eSource == this.text && name != null) {
            if (Util.equal((Object)name, (Object)"text") && !this.valueInvoked) {
                this.updateValue(this.text.getText());
            }
            if (Util.equal((Object)name, (Object)"text") || Util.equal((Object)name, (Object)"columns")) {
                this.firePropertyChange(name, event.getOldValue(), event.getNewValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(ModelInterface model) {
        if (model instanceof ValidationInterface) {
            this.setValidator((ValidationInterface)model);
        } else {
            this.setValidator(null);
        }
        if (model instanceof BoundedNumberInterface && model != null) {
            this.spinBtn.setModel((BoundedNumberInterface)model);
            try {
                this.valueInvoked = true;
                Number newNumberValue = this.spinBtn.getNumberValue();
                String newText = null;
                newText = this.numberFormat != null && this.numberFormat instanceof DecimalFormat ? this.numberFormat.format(newNumberValue) : (newNumberValue instanceof Double ? DoubleData.toString((Double)((Double)newNumberValue)) : (newNumberValue instanceof Float ? FloatData.toString((Float)((Float)newNumberValue)) : newNumberValue.toString()));
                this.setText(newText);
            }
            finally {
                this.valueInvoked = false;
            }
        }
        if (model instanceof StaticOrderedCollectionInterface && model != null) {
            int value;
            Object item = null;
            int count = ((Countable)model).count();
            if (count > (value = this.spinBtn.getValue())) {
                item = ((StaticOrderedCollectionInterface)model).get(value);
            } else if (count < 0) {
                item = ((StaticOrderedCollectionInterface)model).get(0);
            }
            if (--count < 0) {
                count = 1;
            }
            int itemIndex = 0;
            if (item != null) {
                itemIndex = ((StaticOrderedCollectionInterface)model).getIndex(item, 0);
            }
            BoundedLong boundedLong = new BoundedLong(0L, 0L, (long)count, 1L, 1L);
            this.spinBtn.setModel((BoundedNumberInterface)boundedLong);
            try {
                if (this.displayTransform != null) {
                    item = this.displayTransform.transform(item);
                }
            }
            catch (TransformException e) {
                System.out.println("TransformException in refresh " + (Object)((Object)e));
            }
            try {
                this.valueInvoked = true;
                if (item != null) {
                    this.setText(item.toString());
                } else {
                    this.setText("");
                }
            }
            finally {
                this.valueInvoked = false;
            }
            this.spinBtn.setCycleOn(true);
            if (model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
            }
        } else {
            try {
                this.valueInvoked = true;
                this.setText("");
            }
            finally {
                this.valueInvoked = false;
            }
        }
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener l) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public void setAlarm(Alarm alarm) {
        this.spinBtn.setAlarm(alarm);
    }

    public void setArrowDirection(int d) {
        this.spinBtn.setArrowDirection(d);
        this.invalidate();
        this.validate();
    }

    @Override
    public void setBlockIncrement(int block) {
        this.spinBtn.setBlockIncrement(block);
    }

    public void setColumns(int cols) {
        this.text.setColumns(cols);
    }

    public void setCycleOn(boolean cycle) {
        this.spinBtn.setCycleOn(cycle);
    }

    public void setDefaultValues() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 0, 0);
        this.spinBtn = new SpinButton();
        this.text = new JTextField();
        this.defaultRangeModel = new BoundedDouble();
        this.arrowKeyAdapter = new ArrowKeyAdapter();
        this.arrowKeyAdapter.setSpinButton(this.spinBtn);
        this.prefixPredicate = new PrefixPredicate(" ");
        ((BoundedDouble)this.defaultRangeModel).initialize();
        this.setOpaque(false);
        this.validating = false;
        this.precision = 1.0;
        this.precisionDisplayed = false;
        layout.setRemainderColumn(1);
        layout.setUseColumnRemainder(true);
        layout.setFillCell(true);
        this.numberFormatSet = true;
        ((BoundedDouble)this.defaultRangeModel).setUnitIncrement(1.0);
        ((BoundedDouble)this.defaultRangeModel).setValue(0.0);
        ((BoundedDouble)this.defaultRangeModel).setMaximum(Double.MAX_VALUE);
        ((BoundedDouble)this.defaultRangeModel).setMinimum(-1.7976931348623157E308);
        this.text.setColumns(5);
        this.text.addKeyListener(this.arrowKeyAdapter);
        this.setText("0");
        this.spinBtn.setOrientation(1);
        Dimension spinSize = this.spinBtn.getPreferredSize();
        this.spinBtn.setSize(spinSize.width, 0);
        this.spinBtn.addAdjustmentListener(this);
        this.text.addPropertyChangeListener(this);
        this.spinBtn.addPropertyChangeListener(this);
        this.text.addFocusListener(this);
        this.text.addActionListener(this);
        this.setLayout((LayoutManager)layout);
        try {
            this.boundedNumberModel = (BoundedNumberInterface)((BoundedDouble)this.defaultRangeModel).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.staticOrderedCollectionModel = null;
        this.setModel(this.boundedNumberModel);
        this.add(this.text);
        this.add(this.spinBtn);
    }

    public void setDelay(long delay) {
        this.spinBtn.setDelay(delay);
    }

    public void setStartInterval(long startInterval) {
        this.spinBtn.setStartInterval(startInterval);
    }

    public void setDisplayTransform(TransformInterface transform) {
        if (Util.unequal((Object)transform, (Object)this.displayTransform)) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = transform;
            StaticOrderedCollectionInterface model = this.getStaticOrderedCollectionModel();
            if (model != null) {
                int value = this.spinBtn.getValue();
                Object item = model.get(value);
                try {
                    if (this.displayTransform != null) {
                        item = this.displayTransform.transform(item);
                    }
                }
                catch (TransformException e) {
                    System.out.println("TransformException in refresh " + (Object)((Object)e));
                }
                if (item != null) {
                    this.setText(item.toString());
                } else {
                    this.setText("");
                }
            }
            this.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
        }
    }

    public final void setDoubleData(double d) {
        this.setNumberValue(new Double(d));
    }

    @Override
    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            super.setEnabled(e);
            this.spinBtn.setEnabled(e);
            this.text.setEnabled(e);
        }
    }

    @Override
    public void setMaximum(int max) {
        this.spinBtn.setMaximum(max);
    }

    @Override
    public void setMinimum(int min) {
        this.spinBtn.setMinimum(min);
    }

    public void setBlockIncrementNumber(Number block) {
        this.spinBtn.setBlockIncrementNumber(block);
    }

    public void setMaximumNumber(Number max) {
        this.spinBtn.setMaximumNumber(max);
    }

    public void setMinimumNumber(Number min) {
        this.spinBtn.setMinimumNumber(min);
    }

    public void setUnitIncrementNumber(Number unit) {
        this.spinBtn.setUnitIncrementNumber(unit);
    }

    public void setNumberValue(Number value) {
        this.spinBtn.setNumberValue(value);
    }

    public void setNumberFormat(NumberFormat nf) {
        if (nf != this.numberFormat) {
            NumberFormat oldFormat = this.numberFormat;
            this.numberFormat = nf;
            this.numberFormatSet = true;
            this.updateText(this.getNumberValue());
            this.firePropertyChange("numberFormat", oldFormat, this.numberFormat);
        }
    }

    public void setOrientation(int orient) {
        this.spinBtn.setOrientation(orient);
        this.invalidate();
        this.validate();
    }

    public void setText(String txt) {
        if (!txt.equals(this.spinBoxText)) {
            if (this.getValidator() == null) {
                String oldText = this.spinBoxText;
                this.text.setText(txt);
                this.spinBoxText = txt;
                this.firePropertyChange("text", oldText, txt);
                if (!this.valueInvoked) {
                    this.updateValue(txt);
                }
            } else if (!this.validating && !this.spinBoxText.equals(txt)) {
                try {
                    this.validating = true;
                    if (this.getValidator().validateValue((Object)this, (Object)txt)) {
                        txt = (String)this.getValidator().normalizeValue((Object)this, (Object)txt);
                        String oldText = this.spinBoxText;
                        this.text.setText(txt);
                        this.spinBoxText = txt;
                        this.firePropertyChange("text", oldText, txt);
                        if (!this.valueInvoked) {
                            this.updateValue(txt);
                        }
                    } else {
                        this.spinBtn.stopAdjusting();
                        this.handleError();
                        this.text.setText(this.spinBoxText);
                        if (!this.valueInvoked) {
                            this.updateValue(this.spinBoxText);
                        }
                    }
                }
                finally {
                    this.validating = false;
                }
            }
        }
    }

    protected void handleError() {
        GenericErrorHandlerInterface handler = this.getErrorHandler();
        if (handler != null && this.validator != null) {
            handler.handleError((Object)this, this.validator.getValidationMessage(), this.validator.getValidationMessageCode());
        }
    }

    @Override
    public void setUnitIncrement(int unit) {
        this.spinBtn.setUnitIncrement(unit);
    }

    @Override
    public void setValue(int val) {
        this.spinBtn.setValue(val);
    }

    public void setValidator(ValidationInterface newValidator) {
        if (this.validator != newValidator) {
            ValidationInterface oldValidator = this.validator;
            this.validator = newValidator;
            this.firePropertyChange("validator", oldValidator, this.validator);
        }
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    public void setErrorHandler(GenericErrorHandlerInterface newErrorHandler) {
        if (this.errorHandler != newErrorHandler) {
            GenericErrorHandlerInterface oldErrorHandler = this.errorHandler;
            this.errorHandler = newErrorHandler;
            this.firePropertyChange("errorhandler", oldErrorHandler, this.errorHandler);
        }
    }

    public GenericErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setVisibleAmount(int amt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateText(Number newValue) {
        StaticOrderedCollectionInterface socModel = this.getStaticOrderedCollectionModel();
        if (socModel != null) {
            Object item = null;
            int index = newValue.intValue();
            if (index < socModel.count()) {
                item = socModel.get(index);
            }
            if (item != null) {
                try {
                    try {
                        if (this.displayTransform != null) {
                            item = this.displayTransform.transform(item);
                        }
                    }
                    catch (TransformException e) {
                        System.out.println("TransformException in updateText " + (Object)((Object)e));
                    }
                    if (item != null) {
                        this.valueInvoked = true;
                        this.setText(item.toString());
                    }
                }
                finally {
                    this.valueInvoked = false;
                }
                if (this.itemListener != null) {
                    ItemEvent evt = new ItemEvent(this, 701, item, 1);
                    this.itemListener.itemStateChanged(evt);
                }
            }
        } else {
            BoundedNumberInterface bniModel = this.getModel();
            if (bniModel != null) {
                String valueText = null;
                valueText = this.numberFormat != null ? this.numberFormat.format(newValue) : (newValue instanceof Double ? DoubleData.toString((Double)((Double)newValue)) : (newValue instanceof Float ? FloatData.toString((Float)((Float)newValue)) : newValue.toString()));
                if (valueText != null) {
                    try {
                        this.valueInvoked = true;
                        this.setText(valueText);
                    }
                    finally {
                        this.valueInvoked = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateValue(String txt) {
        StaticOrderedCollectionInterface socModel = this.getStaticOrderedCollectionModel();
        if (socModel != null) {
            int index;
            this.prefixPredicate.setPrefix(txt);
            Enumeration e = socModel.getItems();
            if (this.displayTransform != null) {
                e = new EnumerationTransform(e, this.displayTransform);
            }
            if ((index = this.prefixPredicate.findItemByPrefix(e, 0)) >= 0) {
                try {
                    this.textInvoked = true;
                    this.spinBtn.setValue(index);
                    if (this.adjustmentListener != null) {
                        this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 5, index));
                    }
                }
                finally {
                    this.textInvoked = false;
                }
                if (this.itemListener != null) {
                    ItemEvent evt = new ItemEvent(this, 701, socModel.get(index), 1);
                    this.itemListener.itemStateChanged(evt);
                }
            }
        } else {
            BoundedNumberInterface bniModel = this.getModel();
            if (bniModel != null) {
                Number value = bniModel.getNumberValue();
                Number txtValue = null;
                try {
                    txtValue = this.numberFormat != null ? (Number)this.numberFormat.parse(txt) : (Number)(value instanceof Long ? (Number)new Long(txt) : (Number)new Double(DoubleData.valueOf((String)txt)));
                }
                catch (ParseException e) {
                    System.out.println("ParseException for " + txt);
                    try {
                        this.valueInvoked = true;
                        DecimalFormat formatter = new DecimalFormat();
                        this.setText(formatter.format(value));
                    }
                    finally {
                        this.valueInvoked = false;
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("NumberFormatException for " + txt);
                    try {
                        this.valueInvoked = true;
                        DecimalFormat formatter = new DecimalFormat();
                        this.setText(formatter.format(value));
                    }
                    finally {
                        this.valueInvoked = false;
                    }
                }
                if (txtValue != null) {
                    try {
                        this.textInvoked = true;
                        this.spinBtn.setNumberValue(txtValue);
                        if (this.adjustmentListener != null) {
                            this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 5, txtValue.intValue()));
                        }
                    }
                    finally {
                        this.textInvoked = false;
                    }
                }
            }
        }
    }

    class ArrowKeyAdapter
    implements KeyListener {
        SpinButton spinBtn;

        public void setSpinButton(SpinButton sBtn) {
            this.spinBtn = sBtn;
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 40 && this.spinBtn.isDecrementEnabled()) {
                this.spinBtn.incrementBy(-1, 0);
                SpinBox.this.adjustmentValueChanged(new AdjustmentEvent(this.spinBtn, 601, 2, this.spinBtn.getValue()));
            } else if (keyCode == 38 && this.spinBtn.isIncrementEnabled()) {
                this.spinBtn.incrementBy(1, 0);
                SpinBox.this.adjustmentValueChanged(new AdjustmentEvent(this.spinBtn, 601, 1, this.spinBtn.getValue()));
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

