/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.lang.StringDataInterface;
import com.sas.swing.visuals.NodeView;
import com.sas.util.CharBuffer;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class NodeViewTextEditor
implements StringDataInterface {
    private static final String DOTS = "...";
    private static final Cursor TEXT_CURSOR = Cursor.getPredefinedCursor(2);
    private static final int NOT_SET = -999;
    private static final int TC_LINES_DIRTY = 2;
    private static final int TC_TEXT_SELECTED = 16;
    private static final int TC_HOLD_PAINT = 128;
    private transient int m_flags = 0;
    private transient int _selectionEnd = 0;
    private transient int _selectionStart = 0;
    private transient int _pixelLength;
    private transient String _text;
    private transient CharBuffer _buffer;
    private transient NodeView _node;
    private transient int _caretPosition;
    private transient boolean _caretVisible;
    private transient Point _caretLocation;
    private transient int _xRenderOffset;
    private transient int _prefWidth;

    public NodeView getNodeView() {
        return this._node;
    }

    public void setNodeView(NodeView node) {
        this._node = node;
        this._xRenderOffset = 0;
        if (this._node != null) {
            this.setText(this._node.getDisplayedText());
            this.selectAll();
        }
    }

    public void applyText() {
        if (this.hasChanged()) {
            this._node.setDisplayedText(this.getText());
        }
    }

    public boolean hasChanged() {
        if (this._node == null) {
            return false;
        }
        return Util.unequal((Object)this.getText(), (Object)this._node.getDisplayedText());
    }

    private boolean backspaceKeyPressed(KeyEvent event) {
        if (this.isFlagSet(16)) {
            this.removeSelection();
        } else if (this.getCaretPosition() > 0) {
            this._buffer.removeAt(this.getCaretPosition() - 1);
            this.moveCaret(-1, true);
        }
        return true;
    }

    private boolean deleteKeyPressed(KeyEvent event) {
        if (this.isFlagSet(16)) {
            this.removeSelection();
        } else if (this.getCaretPosition() != this._buffer.length()) {
            this._buffer.removeAt(this.getCaretPosition());
            this.moveCaret(0, true);
        }
        return true;
    }

    private boolean endKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (controlDown && shiftDown) {
            this.setSelected(this._buffer.length());
        } else if (controlDown) {
            this.unsetFlag(16);
            this.moveCaret(this._buffer.length() - this.getCaretPosition(), false);
        } else if (shiftDown) {
            this.setSelected(this._buffer.length());
        } else {
            this.unsetFlag(16);
            this.moveCaret(this._buffer.length() - this._caretPosition, false);
        }
        return true;
    }

    private boolean enterKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (!(controlDown && shiftDown || controlDown || shiftDown)) {
            NodeView node = this._node;
            node.setEditable(false);
            node.treeView.repaint();
        }
        return true;
    }

    private void formatText(Graphics g, FontMetrics fm) {
        int fontHeight = fm.getHeight();
        this._text = this._buffer.toString();
        this._pixelLength = fm.stringWidth(this._text);
        this.setCaretPosition(this.getCaretPosition());
        this.unsetFlag(2);
    }

    private int getBottomEdge() {
        return this._node.getHeight();
    }

    private int getDisplayedBottomEdge() {
        return this._node.getHeight();
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public int getCaretPosition(int xPos) {
        Graphics g = this._node.treeView.getGraphics();
        return this.getCaretPosition(xPos, g.getFontMetrics(this._node.getEffectiveFont()));
    }

    private int getCaretPosition(int xPos, FontMetrics fm) {
        int distance = xPos - this.getLeftMargin();
        if (distance <= 0) {
            return 0;
        }
        if (distance > this._pixelLength) {
            return this._buffer.length();
        }
        int pos = 0;
        int cnt = this._buffer.length();
        for (int i = 1; i <= cnt; ++i) {
            pos = i;
            int strWidth = fm.stringWidth(this._buffer.substring(0, i));
            if (strWidth <= distance - 3) continue;
            return pos;
        }
        return pos;
    }

    private int getDrawableHeight() {
        return this._node.getHeight();
    }

    private int getDrawableWidth() {
        return this._node.getWidth() - this.getLeftMargin() * 2;
    }

    private int getLeftMargin() {
        Integer tp = (Integer)this._node.getEffectiveStylePropertyValue("textPad", null);
        if (tp != null && tp != 0) {
            return tp / 2;
        }
        return 0;
    }

    private int getRightMargin() {
        return this.getLeftMargin();
    }

    public int getPreferredWidth(Graphics g) {
        this.setFlag(128);
        this.formatText(g, g.getFontMetrics(this._node.getEffectiveFont()));
        this.setFlag(2);
        this.unsetFlag(128);
        this._prefWidth = this._pixelLength + this.getLeftMargin() * 2 + 10;
        return this._prefWidth;
    }

    private int getRightEdge() {
        return this._node.getWidth() - this.getRightMargin();
    }

    public String getText() {
        return this._buffer.toString();
    }

    private boolean homeKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (controlDown && shiftDown) {
            this.setSelected(0);
        } else if (controlDown) {
            this.unsetFlag(16);
            this.moveCaret(-this.getCaretPosition(), false);
        } else if (shiftDown) {
            this.setSelected(0);
        } else {
            this.unsetFlag(16);
            this.moveCaret(-this.getCaretPosition(), false);
        }
        return true;
    }

    private void invertRectangle(Graphics g, int x, int y, int width, int height) {
        Color c = g.getColor();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        g.fillRect(x, y, width, height);
        g.setPaintMode();
        g.setColor(c);
    }

    private boolean isFlagSet(int flag) {
        return (this.m_flags & flag) != 0;
    }

    private void keyPressed(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 65: {
                this.letterAKeyPressed(event);
                break;
            }
            case 37: 
            case 38: {
                this.leftKeyPressed(event);
                break;
            }
            case 39: 
            case 40: {
                this.rightKeyPressed(event);
                break;
            }
            case 36: {
                this.homeKeyPressed(event);
                break;
            }
            case 35: {
                this.endKeyPressed(event);
                break;
            }
            case 8: {
                this.backspaceKeyPressed(event);
                break;
            }
            case 127: {
                this.deleteKeyPressed(event);
                break;
            }
            case 10: {
                this.enterKeyPressed(event);
                break;
            }
            case 27: {
                this.escapeKeyPressed(event);
            }
        }
        if (this._node != null) {
            this._node.treeView.repaint();
        }
    }

    protected boolean isCharacterValid(char ch) {
        return Character.getType(ch) != 15;
    }

    private void keyTyped(KeyEvent event) {
        int pos;
        char ch = event.getKeyChar();
        if (!this.isCharacterValid(ch)) {
            return;
        }
        int newLen = this._buffer.length() + 1;
        if (this.isFlagSet(16)) {
            this.removeSelection();
        }
        if ((pos = this.getCaretPosition()) == this._buffer.length()) {
            this._buffer.append(ch);
        } else {
            this._buffer.insert(pos, ch);
        }
        this._text = this._buffer.toString();
        this.moveCaret(1, true);
    }

    private boolean leftKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (!controlDown || !shiftDown) {
            if (controlDown) {
                this.unsetFlag(16);
            } else if (shiftDown) {
                this.setSelected(this.getCaretPosition() - 1);
            } else {
                if (this.isFlagSet(16)) {
                    this.setCaretPosition(this._selectionStart < this._selectionEnd ? this._selectionStart : this._selectionEnd);
                } else {
                    this.moveCaret(-1, false);
                }
                this.unsetFlag(16);
            }
        }
        return true;
    }

    public void selectAll() {
        this.setSelected(0, this._buffer.length());
        this.setCaretPosition(this._buffer.length());
    }

    private boolean letterAKeyPressed(KeyEvent event) {
        if (event.isControlDown() && !event.isShiftDown()) {
            this.selectAll();
        }
        return true;
    }

    private void measureCaretPosition(FontMetrics fm, int leftEdge) {
        this.updateCaretLocation(fm, leftEdge, 0);
    }

    private void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.setSelected(0, this._buffer.length());
        }
    }

    private void mouseDown(MouseEvent event) {
        Point mousePoint = event.getPoint();
        if (event.isShiftDown()) {
            if (!this.isFlagSet(16)) {
                this.setFlag(16);
                this._selectionStart = this.getCaretPosition();
            }
            this.setCaretPosition(this.getCaretPosition(mousePoint.x));
            this._selectionEnd = this.getCaretPosition();
        } else {
            this.unsetFlag(16);
            this.setCaretPosition(this.getCaretPosition(mousePoint.x));
        }
    }

    private void mouseDragged(MouseEvent event) {
        Point mousePoint = event.getPoint();
        if (this.isFlagSet(16)) {
            this.setSelected(this.getCaretPosition(mousePoint.x));
        } else {
            this.setSelected(this.getCaretPosition(), this.getCaretPosition(mousePoint.x));
        }
    }

    private void moveCaret(int amount, boolean format) {
        Graphics g = this._node.treeView.getGraphics();
        FontMetrics fm = g.getFontMetrics(this._node.getEffectiveFont());
        int dst = this.getCaretPosition() + amount;
        if (format) {
            this.formatText(g, fm);
        }
        this.setFlag(128);
        this.setCaretPosition(dst);
        this.unsetFlag(128);
        this.measureCaretPosition(fm, this.getLeftMargin());
        this._node.treeView.repaint();
    }

    public void paint(Graphics g) {
        this.setFlag(128);
        Color color = (Color)this._node.getEffectiveStylePropertyValue("foregroundColor", null);
        if (color == null) {
            color = this._node.treeView.getForeground();
        }
        g.setColor(color);
        Font font = this._node.getEffectiveFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        int lineHeight = fm.getHeight();
        if (this.isFlagSet(2)) {
            this.formatText(g, fm);
        }
        this.unsetFlag(128);
        this.renderText(g, fm, this._node.getWidth());
    }

    private void paintSelection(Graphics g, FontMetrics fm, int x, int y) {
        int endOfLine = this._buffer.length();
        int width = 0;
        if (this._selectionStart >= 0 && this._selectionStart <= endOfLine) {
            if (this._selectionEnd >= 0 && this._selectionEnd <= endOfLine) {
                if (this._selectionStart != 0) {
                    x += fm.stringWidth(this._buffer.substring(0, this._selectionStart));
                }
                width = fm.stringWidth(this._buffer.substring(this._selectionStart, this._selectionEnd));
            }
        } else if (this._selectionEnd >= 0 && this._selectionEnd <= endOfLine) {
            if (this._selectionEnd == 0) {
                return;
            }
            width = fm.stringWidth(this._buffer.substring(0, this._selectionEnd));
        }
        this.invertRectangle(g, x, y, width, fm.getHeight() - 1);
    }

    public void processFocusEvent(FocusEvent event) {
    }

    public void processKeyEvent(KeyEvent event) {
        switch (event.getID()) {
            case 401: {
                this.keyPressed(event);
                break;
            }
            case 400: {
                this.keyTyped(event);
            }
        }
    }

    public void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                this.mouseDown(event);
                break;
            }
            case 500: {
                this.mouseClicked(event);
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                this.mouseDragged(event);
            }
        }
    }

    private void removeSelection() {
        if (this.isFlagSet(16)) {
            this.unsetFlag(16);
            int tempStart = this._selectionStart;
            int tempEnd = this._selectionEnd;
            if (this._selectionStart > this._selectionEnd) {
                tempStart = this._selectionEnd;
                tempEnd = this._selectionStart;
            }
            this._buffer.remove(tempStart, tempEnd);
            this.setFlag(2);
            this.setCaretPosition(tempStart);
        }
    }

    private void ensureCaretIsVisible(int caretHeight) {
        int leftEdge = this.getX() + this.getLeftMargin();
        int rightEdge = this.getX() + this.getWidth() - leftEdge * 2;
        int effLocX = this._caretLocation.x + this._xRenderOffset;
        if (effLocX < leftEdge || effLocX >= rightEdge) {
            this._xRenderOffset = this._caretLocation.x < leftEdge ? leftEdge - this._caretLocation.x : (this._caretLocation.x >= rightEdge ? rightEdge - this._caretLocation.x : 0);
        }
    }

    private void renderText(Graphics g, FontMetrics fm, int drawableWidth) {
        int leftEdge = this.getLeftMargin();
        int lineHeight = fm.getHeight();
        this.measureCaretPosition(fm, leftEdge);
        this.ensureCaretIsVisible(lineHeight);
        int selStart = this._selectionStart;
        int selEnd = this._selectionEnd;
        if (this._selectionStart > this._selectionEnd) {
            this._selectionStart = this._selectionEnd;
            this._selectionEnd = selStart;
        }
        int x = this.getX() + this.getLeftMargin() + this._xRenderOffset;
        int y = this.getY() + this._node.getTextY(fm);
        g.drawString(this._text.toString(), x, y);
        g.setColor(Color.black);
        g.drawLine(this._caretLocation.x + this._xRenderOffset, this._caretLocation.y, this._caretLocation.x + this._xRenderOffset, this._caretLocation.y + lineHeight - 2);
        if (this.isFlagSet(16)) {
            this.paintSelection(g, fm, x, y - fm.getMaxAscent() + 1);
        }
        if (this._selectionStart != selStart) {
            this._selectionStart = selStart;
            this._selectionEnd = selEnd;
        }
    }

    private boolean rightKeyPressed(KeyEvent event) {
        boolean controlDown = event.isControlDown();
        boolean shiftDown = event.isShiftDown();
        if (!controlDown || !shiftDown) {
            if (controlDown) {
                this.unsetFlag(16);
            } else if (shiftDown) {
                this.setSelected(this.getCaretPosition() + 1);
            } else {
                if (this.isFlagSet(16)) {
                    this.setCaretPosition(this._selectionStart < this._selectionEnd ? this._selectionEnd : this._selectionStart);
                } else {
                    this.moveCaret(1, false);
                }
                this.unsetFlag(16);
            }
        }
        return true;
    }

    private boolean escapeKeyPressed(KeyEvent event) {
        this.cancel();
        return true;
    }

    public void cancel() {
        this.setText(this._node.getDisplayedText());
        this._node.setEditable(false);
    }

    private void setCaretPosition(int position) {
        this._caretPosition = position > this._buffer.length() ? this._buffer.length() : (position < 0 ? 0 : position);
        if (!this.isFlagSet(128)) {
            this._node.treeView.repaint();
        }
    }

    private void setFlag(int flag) {
        this.m_flags |= flag;
    }

    private void setSelected(int newCaretPos) {
        int start = this.isFlagSet(16) ? this._selectionStart : this.getCaretPosition();
        this.setSelected(start, newCaretPos);
    }

    private void setSelected(int start, int end) {
        this.setFlag(16);
        int max = this._buffer.length();
        if (start < end) {
            if (start < 0) {
                start = 0;
            } else if (start > max) {
                this.unsetFlag(16);
            }
            if (end > max) {
                end = max;
            } else if (end < 0) {
                this.unsetFlag(16);
            }
        } else if (start > end) {
            if (end < 0) {
                end = 0;
            } else if (end > max) {
                this.unsetFlag(16);
            }
            if (start > max) {
                start = max;
            } else if (start < 0) {
                this.unsetFlag(16);
            }
        }
        if (start == end) {
            this.unsetFlag(16);
            this.setCaretPosition(end);
        }
        if (this.isFlagSet(16)) {
            this._selectionStart = start;
            this.setCaretPosition(end);
            this._selectionEnd = this.getCaretPosition();
        }
        if (!this.isFlagSet(128)) {
            this._node.treeView.repaint();
        }
    }

    public void setText(String newValue) {
        this._buffer = new CharBuffer(newValue == null ? "" : newValue);
        this.setFlag(2);
        this._caretPosition = this._buffer.length();
    }

    private void unsetFlag(int flag) {
        this.m_flags &= ~flag;
    }

    private void updateCaretLocation(FontMetrics fm, int x, int y) {
        if (this._caretLocation == null) {
            this._caretLocation = new Point();
        }
        if (this._caretPosition <= 0) {
            this._caretLocation.x = x;
        } else if (this._caretPosition >= this._buffer.length()) {
            this._caretLocation.x = x + this._pixelLength;
        } else {
            String subStr = this._buffer.substring(0, this._caretPosition);
            this._caretLocation.x = x + fm.stringWidth(subStr);
        }
        this._caretLocation.y = y + 2;
    }

    int getX() {
        return 0;
    }

    int getY() {
        return 0;
    }

    int getWidth() {
        int width = this._node.treeView.m_drawableWidth - (this._node.getX() + this._node.getTextX());
        if (width < this._prefWidth) {
            return width;
        }
        return this._prefWidth;
    }

    int getHeight() {
        return this._node.getHeight();
    }
}

