/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.GlobalInfoTable;
import com.sas.RunningObjectTable;
import com.sas.beans.PropertyEditorBeanRequestor;
import com.sas.beans.PropertyEditorDescriptorRequestor;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;

public class JComponentModelCustomizerPanel
extends SwingCustomizerPanel
implements ListSelectionListener,
PropertyChangeListener {
    protected static final String RB_KEY = "JComponentModelCustomizerPanel.";
    protected JLabel selectModel;
    protected JRadioButton detachModel;
    protected JList modelList;
    protected PropertyEditor propertyEditor;
    protected ListSelectionModel listSelectionModel;
    protected Object propValue;
    protected boolean settingModel;
    protected Object swingBean;

    public JComponentModelCustomizerPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(1, 1);
        outerLayout.setVgap(5);
        outerLayout.setHgap(5);
        outerLayout.setFillCell(true);
        this.setLayout((LayoutManager)outerLayout);
        JPanel modelContainer = new JPanel();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder());
        Util.configureGroupBoxBorder((Border)titledBorder, (String)RB.getStringResource((String)RB_KEY, (String)"modelSelection.txt"));
        modelContainer.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(3, 1);
        layout.setVgap(5);
        layout.setHgap(5);
        layout.setFillCell(true);
        layout.setUseColumnRemainder(true);
        modelContainer.setLayout((LayoutManager)layout);
        this.selectModel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"selectModel.txt"));
        modelContainer.add(this.selectModel);
        JScrollPane jListPane = new JScrollPane();
        this.modelList = new JList();
        this.modelList.setSelectionMode(0);
        jListPane.getViewport().add(this.modelList);
        modelContainer.add(jListPane);
        this.add(modelContainer);
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        this.propValue = null;
        if (bean instanceof Object) {
            this.swingBean = bean;
            try {
                Class propertyEditorClass = null;
                PropertyDescriptor propertyDescriptor = com.sas.beans.Util.getPropertyDescriptor((Object)this.swingBean, (String)"model");
                if (propertyDescriptor != null) {
                    propertyEditorClass = propertyDescriptor.getPropertyEditorClass();
                    if (propertyEditorClass == null) {
                        propertyEditorClass = GlobalInfoTable.loadClass((String)"com.sas.beans.editors._javaxSwingModelEditor");
                        this.propertyEditor = (PropertyEditor)propertyEditorClass.newInstance();
                    } else {
                        this.propertyEditor = (PropertyEditor)propertyEditorClass.newInstance();
                    }
                    if (propertyDescriptor != null && this.propertyEditor instanceof PropertyEditorDescriptorRequestor) {
                        ((PropertyEditorDescriptorRequestor)this.propertyEditor).setPropertyDescriptor(propertyDescriptor);
                    }
                    this.propValue = com.sas.beans.Util.getPropertyValue((Object)this.swingBean, (String)"model");
                    this.propertyEditor.setValue(this.propValue);
                    ((PropertyEditorBeanRequestor)this.propertyEditor).setBeanContainingProperty(this.swingBean);
                    String[] tags = this.propertyEditor.getTags();
                    this.modelList.setListData(tags);
                    this.setModelSelected();
                    this.listSelectionModel = this.modelList.getSelectionModel();
                    this.listSelectionModel.addListSelectionListener(this);
                    com.sas.beans.Util.addPropertyChangeListener((Object)this.swingBean, (PropertyChangeListener)this);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!this.settingModel) {
            int index = this.modelList.getSelectedIndex();
            ListModel lm = this.modelList.getModel();
            if (index != -1) {
                Object selectedItem = lm.getElementAt(index);
                if (com.sas.util.Util.equal((Object)selectedItem.toString(), (Object)"null") || com.sas.util.Util.equal((Object)selectedItem.toString(), (Object)RB.getStringResource((String)RB_KEY, (String)"setDefaultModel.txt"))) {
                    com.sas.beans.Util.setPropertyValue((Object)this.bean, (String)"model", (Object)Util.getDefaultModel((Object)this.bean));
                } else {
                    Object component = RunningObjectTable.lookupComponent((String)selectedItem.toString());
                    if (component != null) {
                        com.sas.beans.Util.setPropertyValue((Object)this.bean, (String)"model", (Object)component);
                    }
                }
            }
        }
    }

    protected void setModelSelected() {
        block2: {
            ListModel lm;
            int itemCount;
            String componentName;
            block3: {
                componentName = RunningObjectTable.lookupComponentName((Object)this.propValue);
                if (componentName == null && this.propValue != null) {
                    String message = com.sas.util.Util.getCommonStringResource((String)"InstanceOfClass.txt");
                    componentName = Message.format((String)message, (Object)this.propValue.getClass().getName());
                }
                if ((itemCount = (lm = this.modelList.getModel()).getSize()) <= 0) break block2;
                if (!this.hasDefaultModelAttached()) break block3;
                Object item = lm.getElementAt(0);
                if (item == null || !com.sas.util.Util.unequal((Object)item.toString(), (Object)RB.getStringResource((String)RB_KEY, (String)"setDefaultModel.txt"))) break block2;
                this.modelList.setSelectedIndex(0);
                break block2;
            }
            for (int i = 0; i < itemCount; ++i) {
                Object modelItem = lm.getElementAt(i);
                if (!com.sas.util.Util.equal(modelItem, (Object)componentName)) continue;
                this.modelList.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("model")) {
            try {
                this.settingModel = true;
                this.propValue = com.sas.beans.Util.getPropertyValue((Object)this.swingBean, (String)"model");
                this.propertyEditor.setValue(this.propValue);
                ((PropertyEditorBeanRequestor)this.propertyEditor).setBeanContainingProperty(this.swingBean);
                String[] tags = this.propertyEditor.getTags();
                this.modelList.setListData(tags);
                this.setModelSelected();
            }
            catch (Exception exception) {
            }
            finally {
                this.settingModel = false;
            }
        }
    }

    protected boolean hasDefaultModelAttached() {
        if (this.bean instanceof JComboBox && ((JComboBox)this.bean).getModel() instanceof DefaultComboBoxModel || this.bean instanceof JList && ((JList)this.bean).getModel() instanceof DefaultListModel || this.bean instanceof JTree && ((JTree)this.bean).getModel() instanceof DefaultTreeModel || this.bean instanceof JTable && ((JTable)this.bean).getModel() instanceof DefaultTableModel || this.bean instanceof JButton && ((JButton)this.bean).getModel() instanceof DefaultButtonModel || this.bean instanceof JCheckBox && ((JCheckBox)this.bean).getModel() instanceof JToggleButton.ToggleButtonModel || this.bean instanceof JToggleButton && ((JToggleButton)this.bean).getModel() instanceof JToggleButton.ToggleButtonModel || this.bean instanceof JRadioButton && ((JRadioButton)this.bean).getModel() instanceof JToggleButton.ToggleButtonModel || this.bean instanceof JSlider && ((JSlider)this.bean).getModel() instanceof DefaultBoundedRangeModel || this.bean instanceof JTabbedPane && ((JTabbedPane)this.bean).getModel() instanceof DefaultSingleSelectionModel) {
            return true;
        }
        return this.bean instanceof ViewDefaultModel && ((ViewDefaultModel)this.bean).isDefaultModelAttached();
    }

    @Override
    public void customizerClosing() {
        if (this.bean instanceof Component) {
            ((Component)this.bean).removePropertyChangeListener("model", this);
        }
        if (this.listSelectionModel != null) {
            this.listSelectionModel.removeListSelectionListener(this);
        }
    }
}

