/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.PropertyLinkAdaptor;
import com.sas.lang.StringDataInterface;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.swing.property.PropertyEditorHost;
import com.sas.swing.visuals.BaseBorder;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.SpinBox;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.util.JTextFieldValidator;
import com.sas.swing.visuals.util.Util;
import com.sas.swing.visuals.util.ValidationUtil;
import com.sas.util.transforms.StringToIntegerTransform;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class JComponentCustomizerPanel
extends SwingCustomizerPanel
implements PropertyChangeListener,
ActionListener,
ItemListener,
ComponentListener,
FocusListener {
    protected static final String RB_KEY = "JComponentCustomizerPanel.";
    protected PropertyEditorHost fgColorHost;
    protected PropertyEditorHost bgColorHost;
    protected PropertyEditorHost fontHost;
    protected PropertyEditorHost borderHost;
    protected JCheckBox visible;
    protected JCheckBox enabled;
    protected JCheckBox transparent;
    protected JTextField xField;
    protected JTextField yField;
    protected JTextField widthField;
    protected JTextField heightField;
    protected JTextField sampleText;
    protected JTextField borderText;
    protected JTextField toolTip;
    protected SpinBox borderMargin;
    protected JLabel labelBorderMargin;
    protected JPanel fontContainer;
    protected JPanel borderContainer;
    protected JPanel borderTextContainer;
    protected JPanel borderMarginContainer;
    protected JPanel spacer;
    protected PropertyLinkAdaptor propertyLinkAdaptor0in;
    protected PropertyLinkAdaptor propertyLinkAdaptor0out;
    protected JTextFieldValidator xValidator;
    protected JTextFieldValidator yValidator;
    protected JTextFieldValidator widthValidator;
    protected JTextFieldValidator heightValidator;
    protected boolean colorContainerCreated;
    protected boolean fontContainerCreated;
    protected boolean boundsContainerCreated;
    protected boolean borderContainerCreated;
    protected boolean visibleEnabledContainerCreated;
    protected boolean tooltipContainerCreated;

    public JComponentCustomizerPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    protected JTextField addLabelAndField(Container container, String label) {
        JLabel labelView = new JLabel(label);
        container.add(labelView);
        JTextField field = new JTextField();
        field.setColumns(5);
        container.add(field);
        return field;
    }

    public void setDefaultValues() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(4, 2, 5, 5, true, false, false);
        this.setLayout((LayoutManager)outerLayout);
        this.add(this.createColorContainer());
        this.add(this.createFontContainer());
        this.add(this.createBoundsContainer());
        this.add(this.createBorderContainer());
        this.add(this.createVisibleEnabledContainer());
        this.add(this.createToolTipContainer());
    }

    protected Container createColorContainer() {
        this.colorContainerCreated = true;
        JPanel colorContainer = new JPanel();
        colorContainer.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource((String)RB_KEY, (String)"Color.txt"), (int)5, (int)5, (int)5, (int)5));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 5, true, false, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        colorContainer.setLayout((LayoutManager)layout);
        this.transparent = new JCheckBox(RB.getStringResource((String)RB_KEY, (String)"Transparent.txt"));
        colorContainer.add(this.transparent);
        JPanel bgColorContainer = new JPanel();
        AutoSizingGridLayout bgLayout = new AutoSizingGridLayout(1, -1, 5, 0, true, false, true);
        bgColorContainer.setLayout((LayoutManager)bgLayout);
        JLabel bgLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"Background.txt"));
        bgColorContainer.add(bgLabel);
        this.bgColorHost = new PropertyEditorHost();
        bgColorContainer.add(this.bgColorHost);
        colorContainer.add(bgColorContainer);
        JPanel fgColorContainer = new JPanel();
        AutoSizingGridLayout fgLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, true);
        fgColorContainer.setLayout((LayoutManager)fgLayout);
        JLabel fgLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"Foreground.txt"));
        fgColorContainer.add(fgLabel);
        this.fgColorHost = new PropertyEditorHost();
        fgColorContainer.add(this.fgColorHost);
        colorContainer.add(fgColorContainer);
        fgLayout.setInterlockedColumnContainers(new Container[]{bgColorContainer});
        bgLayout.setInterlockedColumnContainers(new Container[]{fgColorContainer});
        return colorContainer;
    }

    protected Container createFontContainer() {
        this.fontContainerCreated = true;
        this.fontContainer = new JPanel();
        this.fontContainer.setPreferredSize(new Dimension(250, 100));
        this.fontContainer.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource((String)RB_KEY, (String)"Font.txt"), (int)5, (int)5, (int)5, (int)5));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        layout.paintLines(this.fontContainer.getGraphics(), (Container)this.fontContainer);
        this.fontContainer.setLayout((LayoutManager)layout);
        this.fontHost = new PropertyEditorHost();
        this.fontContainer.add(this.fontHost);
        this.sampleText = new JTextField(RB.getStringResource((String)RB_KEY, (String)"FontSample.txt"));
        this.sampleText.setCaretPosition(0);
        this.fontContainer.add(this.sampleText);
        return this.fontContainer;
    }

    protected Container createBoundsContainer() {
        this.boundsContainerCreated = true;
        JPanel boundsContainer = new JPanel();
        boundsContainer.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource((String)RB_KEY, (String)"Bounds.txt"), (int)5, (int)5, (int)5, (int)5));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 5, 5, 5, true, false, false);
        boundsContainer.setLayout((LayoutManager)layout);
        this.xField = this.addLabelAndField(boundsContainer, RB.getStringResource((String)RB_KEY, (String)"X.txt"));
        boundsContainer.add(new JLabel("  "));
        this.widthField = this.addLabelAndField(boundsContainer, RB.getStringResource((String)RB_KEY, (String)"Width.txt"));
        this.yField = this.addLabelAndField(boundsContainer, RB.getStringResource((String)RB_KEY, (String)"Y.txt"));
        boundsContainer.add(new JLabel("  "));
        this.heightField = this.addLabelAndField(boundsContainer, RB.getStringResource((String)RB_KEY, (String)"Height.txt"));
        return boundsContainer;
    }

    protected Container createBorderContainer() {
        this.borderContainerCreated = true;
        this.borderContainer = new JPanel();
        this.borderContainer.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource((String)RB_KEY, (String)"Border.txt"), (int)5, (int)5, (int)5, (int)5));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        layout.setVgap(5);
        layout.setFillCell(true);
        layout.setUseColumnRemainder(true);
        this.borderContainer.setLayout((LayoutManager)layout);
        this.borderHost = new PropertyEditorHost();
        this.borderContainer.add(this.borderHost);
        this.borderTextContainer = new JPanel();
        AutoSizingGridLayout borderTextLayout = new AutoSizingGridLayout(1, 0, 5, 5, true, true, true);
        borderTextLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.borderTextContainer.setLayout((LayoutManager)borderTextLayout);
        ((AutoSizingGridLayout)this.borderTextContainer.getLayout()).setRemainderColumn(2);
        this.borderMarginContainer = new JPanel();
        this.borderMarginContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 0, 5, 5, true, true, true));
        ((AutoSizingGridLayout)this.borderMarginContainer.getLayout()).setRemainderColumn(0);
        JLabel labelBorderText = new JLabel();
        labelBorderText.setText(RB.getStringResource((String)RB_KEY, (String)"BorderText.txt"));
        this.borderTextContainer.add(labelBorderText);
        this.borderText = new JTextField();
        this.borderTextContainer.add(this.borderText);
        this.spacer = new JPanel();
        this.spacer.setPreferredSize(new Dimension(15, 0));
        this.spacer.setVisible(false);
        this.borderTextContainer.add(this.spacer);
        this.labelBorderMargin = new JLabel();
        this.labelBorderMargin.setText(RB.getStringResource((String)RB_KEY, (String)"BorderMargin.txt"));
        this.labelBorderMargin.setVisible(false);
        this.borderMarginContainer.add(this.labelBorderMargin);
        this.borderMargin = new SpinBox();
        this.borderMargin.setModel((BoundedNumberInterface)new BoundedLong(0L, 0L, Long.MAX_VALUE));
        this.borderMargin.setVisible(false);
        this.borderMargin.setColumns(4);
        this.borderMarginContainer.add(this.borderMargin);
        this.borderMarginContainer.setVisible(false);
        this.borderTextContainer.add(this.borderMarginContainer);
        this.borderContainer.add(this.borderTextContainer);
        return this.borderContainer;
    }

    protected Container createVisibleEnabledContainer() {
        this.visibleEnabledContainerCreated = true;
        JPanel miscPanel = new JPanel();
        miscPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 0);
        layout.setHgap(15);
        miscPanel.setLayout((LayoutManager)layout);
        this.visible = new JCheckBox(RB.getStringResource((String)RB_KEY, (String)"Visible.txt"));
        miscPanel.add(this.visible);
        this.enabled = new JCheckBox(RB.getStringResource((String)RB_KEY, (String)"Enabled.txt"));
        miscPanel.add(this.enabled);
        return miscPanel;
    }

    protected Container createToolTipContainer() {
        this.tooltipContainerCreated = true;
        JPanel toolTipTextContainer = new JPanel();
        toolTipTextContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 0, 5, 5, true, false, true));
        ((AutoSizingGridLayout)toolTipTextContainer.getLayout()).setRemainderColumn(2);
        this.toolTip = this.addLabelAndField(toolTipTextContainer, RB.getStringResource((String)RB_KEY, (String)"tooltipText.txt"));
        return toolTipTextContainer;
    }

    public PropertyEditorHost getFontHost() {
        return this.fontHost;
    }

    public PropertyEditorHost getForegroundHost() {
        return this.fgColorHost;
    }

    public PropertyEditorHost getBackgroundHost() {
        return this.bgColorHost;
    }

    public PropertyEditorHost getBorderHost() {
        return this.borderHost;
    }

    @Override
    public void setObject(Object bean) {
        int fontContainerHeight;
        PropertyDescriptor transparentDesc;
        PropertyDescriptor borderDesc;
        super.setObject(bean);
        if (bean instanceof JComponent) {
            JComponent swingBean = (JComponent)bean;
            if (this.boundsContainerCreated) {
                swingBean.addComponentListener(this);
            }
            try {
                if (this.colorContainerCreated) {
                    this.fgColorHost.setProperty(bean, "foreground");
                    this.bgColorHost.setProperty(bean, "background");
                    if (this.fgColorHost.getPropertyEditor() != null) {
                        this.fgColorHost.getPropertyEditor().addPropertyChangeListener(this);
                    }
                    if (this.bgColorHost.getPropertyEditor() != null) {
                        this.bgColorHost.getPropertyEditor().addPropertyChangeListener(this);
                    }
                }
                if (this.fontContainerCreated) {
                    this.fontHost.setProperty(bean, "font");
                    if (this.fontHost.getPropertyEditor() != null) {
                        this.fontHost.getPropertyEditor().addPropertyChangeListener(this);
                    }
                }
                if (this.borderContainerCreated) {
                    this.borderHost.setProperty(bean, "border");
                    if (this.borderHost.getPropertyEditor() != null) {
                        this.borderHost.getPropertyEditor().addPropertyChangeListener(this);
                    }
                }
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            if (this.fontContainerCreated) {
                this.propertyLinkAdaptor0in = PropertyLinkAdaptor.addLink((Object)swingBean, (String)"font", (Object)this.sampleText, (String)"font");
            }
            if (this.boundsContainerCreated) {
                this.xField.setText(new Integer(swingBean.getX()).toString());
                this.yField.setText(new Integer(swingBean.getY()).toString());
                this.widthField.setText(new Integer(swingBean.getWidth()).toString());
                this.heightField.setText(new Integer(swingBean.getHeight()).toString());
            }
            if (this.tooltipContainerCreated) {
                this.toolTip.setText(swingBean.getToolTipText());
            }
            if (this.visibleEnabledContainerCreated) {
                this.visible.setSelected(swingBean.isVisible());
                this.enabled.setSelected(swingBean.isEnabled());
            }
            if (this.colorContainerCreated) {
                this.transparent.setSelected(!swingBean.isOpaque());
            }
            if (this.fontContainerCreated) {
                this.propertyLinkAdaptor0out = PropertyLinkAdaptor.addLink((Object)this.sampleText, (String)"font", (Object)swingBean, (String)"font");
            }
            if (this.borderContainerCreated) {
                Border border = swingBean.getBorder();
                if (border instanceof StringDataInterface) {
                    String text = ((StringDataInterface)border).getText();
                    if (text == null) {
                        text = "";
                    }
                    this.borderText.setText(text);
                    if (border instanceof BaseBorder) {
                        int margin = ((BaseBorder)border).getTextMargin();
                        this.borderMargin.setValue(margin);
                        this.borderMargin.setVisible(true);
                        this.borderMarginContainer.setVisible(true);
                        this.spacer.setVisible(true);
                        this.labelBorderMargin.setVisible(true);
                    } else {
                        this.borderMarginContainer.setVisible(false);
                        this.borderMargin.setVisible(false);
                        this.labelBorderMargin.setVisible(false);
                        this.spacer.setVisible(false);
                    }
                    this.borderTextContainer.setVisible(true);
                } else if (border instanceof TitledBorder) {
                    String text = ((TitledBorder)border).getTitle();
                    if (text == null) {
                        text = "";
                    }
                    this.borderText.setText(text);
                    this.borderTextContainer.setVisible(true);
                    this.borderMarginContainer.setVisible(false);
                    this.borderMargin.setVisible(false);
                    this.labelBorderMargin.setVisible(false);
                    this.spacer.setVisible(false);
                } else {
                    this.borderTextContainer.setVisible(false);
                }
            }
            if (this.colorContainerCreated) {
                this.bgColorHost.setEnabled(!this.transparent.isSelected());
            }
        }
        if (this.borderContainerCreated && ((borderDesc = com.sas.beans.Util.getPropertyDescriptor((Object)bean, (String)"border")) == null || borderDesc.isHidden())) {
            this.borderContainer.setVisible(false);
        }
        if (this.colorContainerCreated && ((transparentDesc = com.sas.beans.Util.getPropertyDescriptor((Object)bean, (String)"opaque")) == null || transparentDesc.isHidden())) {
            this.transparent.setVisible(false);
        }
        if (this.colorContainerCreated) {
            this.transparent.addActionListener(this);
        }
        if (this.borderContainerCreated) {
            this.borderText.addPropertyChangeListener(this);
            this.borderMargin.addPropertyChangeListener(this);
            this.borderText.addActionListener(this);
            this.borderText.addFocusListener(this);
        }
        if (this.visibleEnabledContainerCreated) {
            this.visible.addItemListener(this);
            this.enabled.addItemListener(this);
        }
        if (this.tooltipContainerCreated) {
            this.toolTip.addActionListener(this);
            this.toolTip.addFocusListener(this);
        }
        if (this.boundsContainerCreated) {
            this.xValidator = ValidationUtil.addJTextFieldValidator(this.xField);
            this.yValidator = ValidationUtil.addJTextFieldValidator(this.yField);
            this.widthValidator = ValidationUtil.addJTextFieldValidator(this.widthField, 0, Integer.MAX_VALUE);
            this.heightValidator = ValidationUtil.addJTextFieldValidator(this.heightField, 0, Integer.MAX_VALUE);
            this.xValidator.addPropertyChangeListener(this);
            this.yValidator.addPropertyChangeListener(this);
            this.widthValidator.addPropertyChangeListener(this);
            this.heightValidator.addPropertyChangeListener(this);
        }
        if (this.fontContainerCreated && this.fontContainer.getPreferredSize().height < (fontContainerHeight = this.sampleText.getPreferredSize().height + 5 + this.fontHost.getPreferredSize().height + this.fontContainer.getInsets().top + this.fontContainer.getInsets().bottom)) {
            this.fontContainer.setPreferredSize(new Dimension(250, fontContainerHeight));
            this.fontContainer.getLayout().layoutContainer(this.fontContainer);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        JComponent swingBean = (JComponent)this.bean;
        if (e.getComponent() == swingBean) {
            Rectangle rect = swingBean.getBounds();
            this.xField.setText(new Integer(rect.x).toString());
            this.yField.setText(new Integer(rect.y).toString());
            this.widthField.setText(new Integer(rect.width).toString());
            this.heightField.setText(new Integer(rect.height).toString());
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        JComponent swingBean = (JComponent)this.bean;
        if (e.getComponent() == swingBean) {
            Rectangle rect = swingBean.getBounds();
            this.xField.setText(new Integer(rect.x).toString());
            this.yField.setText(new Integer(rect.y).toString());
        }
    }

    @Override
    public void focusGained(FocusEvent ev) {
        if (ev.getSource() instanceof JTextField) {
            ((JTextField)ev.getSource()).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent ev) {
        if (ev.getSource() == this.toolTip) {
            this.updateToolTipText();
        } else if (ev.getSource() == this.borderText) {
            this.updateBorderText();
        }
    }

    public void updateBorderText() {
        JComponent swingBean = (JComponent)this.bean;
        if (swingBean.getBorder() instanceof StringDataInterface) {
            ((StringDataInterface)swingBean.getBorder()).setText(this.borderText.getText());
        } else if (swingBean.getBorder() instanceof TitledBorder) {
            ((TitledBorder)swingBean.getBorder()).setTitle(this.borderText.getText());
        }
        swingBean.revalidate();
        swingBean.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor fgColorEditor = null;
        PropertyEditor bgColorEditor = null;
        PropertyEditor fontEditor = null;
        PropertyEditor borderEditor = null;
        if (this.colorContainerCreated) {
            fgColorEditor = this.fgColorHost.getPropertyEditor();
            bgColorEditor = this.bgColorHost.getPropertyEditor();
        }
        if (this.fontContainerCreated) {
            fontEditor = this.fontHost.getPropertyEditor();
        }
        if (this.borderContainerCreated) {
            borderEditor = this.borderHost.getPropertyEditor();
        }
        JComponent swingBean = (JComponent)this.bean;
        String propName = evt.getPropertyName();
        Object source = evt.getSource();
        if (source == fgColorEditor) {
            swingBean.setForeground((Color)fgColorEditor.getValue());
        } else if (source == bgColorEditor) {
            swingBean.setBackground((Color)bgColorEditor.getValue());
        } else if (source == fontEditor) {
            swingBean.setFont((Font)fontEditor.getValue());
            this.sampleText.setFont((Font)fontEditor.getValue());
            this.fontContainer.setPreferredSize(new Dimension(250, this.sampleText.getPreferredSize().height + 5 + this.fontHost.getPreferredSize().height + this.fontContainer.getInsets().top + this.fontContainer.getInsets().bottom));
            this.fontContainer.getLayout().layoutContainer(this.fontContainer);
            this.revalidate();
            this.repaint();
        } else if (source == borderEditor) {
            swingBean.setBorder((Border)borderEditor.getValue());
            if (swingBean.getBorder() instanceof StringDataInterface) {
                String text = ((StringDataInterface)swingBean.getBorder()).getText();
                this.borderText.setText(text);
                if (swingBean.getBorder() instanceof BaseBorder) {
                    int margin = ((BaseBorder)swingBean.getBorder()).getTextMargin();
                    this.borderMargin.setValue(margin);
                    this.borderMargin.setVisible(true);
                    this.labelBorderMargin.setVisible(true);
                    this.borderMarginContainer.setVisible(true);
                    this.spacer.setVisible(true);
                } else {
                    this.borderMargin.setVisible(false);
                    this.labelBorderMargin.setVisible(false);
                    this.borderMarginContainer.setVisible(false);
                    this.spacer.setVisible(false);
                }
                this.borderTextContainer.setVisible(true);
            } else if (swingBean.getBorder() instanceof TitledBorder) {
                String text = ((TitledBorder)swingBean.getBorder()).getTitle();
                this.borderText.setText(text);
                this.borderTextContainer.setVisible(true);
                this.borderMarginContainer.setVisible(false);
                this.borderMargin.setVisible(false);
                this.labelBorderMargin.setVisible(false);
                this.spacer.setVisible(false);
            } else {
                this.borderTextContainer.setVisible(false);
            }
            swingBean.revalidate();
            swingBean.repaint();
        } else if (source == this.borderText && propName != null && propName.equals("text")) {
            this.updateBorderText();
        } else if (source == this.borderMargin && propName != null && propName.equals("value")) {
            if (swingBean.getBorder() instanceof BaseBorder) {
                ((BaseBorder)swingBean.getBorder()).setTextMargin(this.borderMargin.getValue());
                swingBean.repaint();
            }
        } else if ((source == this.xValidator || source == this.yValidator || source == this.widthValidator || source == this.heightValidator) && propName.equals("valid") && evt.getNewValue() instanceof Boolean && ((Boolean)evt.getNewValue()).booleanValue()) {
            Integer x = (Integer)StringToIntegerTransform.defaultInstance.transform((Object)this.xField.getText());
            Integer y = (Integer)StringToIntegerTransform.defaultInstance.transform((Object)this.yField.getText());
            Integer width = (Integer)StringToIntegerTransform.defaultInstance.transform((Object)this.widthField.getText());
            Integer height = (Integer)StringToIntegerTransform.defaultInstance.transform((Object)this.heightField.getText());
            swingBean.setBounds(x, y, width, height);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        JComponent swingBean = (JComponent)this.bean;
        if (source == this.borderText) {
            if (swingBean.getBorder() instanceof StringDataInterface) {
                ((StringDataInterface)swingBean.getBorder()).setText(this.borderText.getText());
            } else if (swingBean.getBorder() instanceof TitledBorder) {
                ((TitledBorder)swingBean.getBorder()).setTitle(this.borderText.getText());
            }
            swingBean.revalidate();
            swingBean.repaint();
        } else if (source == this.toolTip) {
            this.updateToolTipText();
        } else if (source == this.transparent) {
            swingBean.setOpaque(!this.transparent.isSelected());
            this.bgColorHost.setEnabled(!this.transparent.isSelected());
            swingBean.repaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        JComponent swingBean = (JComponent)this.bean;
        if (source == this.visible) {
            swingBean.setVisible(this.visible.isSelected());
        } else if (source == this.enabled) {
            swingBean.setEnabled(this.enabled.isSelected());
        }
    }

    public void updateToolTipText() {
        JComponent swingBean = (JComponent)this.bean;
        if (this.toolTip.getText().equals("")) {
            swingBean.setToolTipText(null);
        } else {
            swingBean.setToolTipText(this.toolTip.getText());
        }
    }

    @Override
    public void customizerClosing() {
        if (this.bean instanceof JComponent) {
            if (this.colorContainerCreated) {
                this.fgColorHost.updateTextValue();
                this.bgColorHost.updateTextValue();
                if (this.fgColorHost.getPropertyEditor() != null) {
                    this.fgColorHost.getPropertyEditor().removePropertyChangeListener(this);
                    this.fgColorHost.getPropertyEditor().setValue(null);
                }
                if (this.bgColorHost.getPropertyEditor() != null) {
                    this.bgColorHost.getPropertyEditor().removePropertyChangeListener(this);
                    this.bgColorHost.getPropertyEditor().setValue(null);
                }
                this.transparent.removeActionListener(this);
            }
            if (this.fontContainerCreated) {
                this.fontHost.updateTextValue();
                if (this.fontHost.getPropertyEditor() != null) {
                    this.fontHost.getPropertyEditor().removePropertyChangeListener(this);
                    this.fontHost.getPropertyEditor().setValue(null);
                }
                PropertyLinkAdaptor.removeLink((PropertyLinkAdaptor)this.propertyLinkAdaptor0in);
                PropertyLinkAdaptor.removeLink((PropertyLinkAdaptor)this.propertyLinkAdaptor0out);
            }
            if (this.borderContainerCreated) {
                this.borderHost.updateTextValue();
                if (this.borderHost.getPropertyEditor() != null) {
                    this.borderHost.getPropertyEditor().removePropertyChangeListener(this);
                    this.borderHost.getPropertyEditor().setValue(null);
                }
                this.borderText.removePropertyChangeListener(this);
                this.borderMargin.removePropertyChangeListener(this);
                this.borderText.removeActionListener(this);
                this.borderText.removeFocusListener(this);
            }
            if (this.tooltipContainerCreated) {
                this.updateToolTipText();
                this.toolTip.removeActionListener(this);
            }
            if (this.boundsContainerCreated) {
                ((JComponent)this.bean).removeComponentListener(this);
                this.xField.removeActionListener(this);
                this.yField.removeActionListener(this);
                this.widthField.removeActionListener(this);
                this.heightField.removeActionListener(this);
                this.xValidator.removeListenersOnTextField();
                this.yValidator.removeListenersOnTextField();
                this.widthValidator.removeListenersOnTextField();
                this.heightValidator.removeListenersOnTextField();
            }
            if (this.visibleEnabledContainerCreated) {
                this.visible.removeItemListener(this);
                this.enabled.removeItemListener(this);
            }
        }
    }
}

