/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.TreeInterface;
import com.sas.visuals.IconInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class HierarchyListCellRenderer
extends DefaultListCellRenderer {
    transient HierarchyIcon _hierarchyIcon = new HierarchyIcon();
    protected TreeInterface _treeHierarchy;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value == null) {
            this.setText("");
            return this;
        }
        if (value instanceof NodeIconInterface) {
            NodeIconInterface nodeIcon = (NodeIconInterface)value;
            this.setText(nodeIcon.getNodeText());
            this._hierarchyIcon.setIcon(this._getIcon(nodeIcon, isSelected));
            this._hierarchyIcon.setDepth(index == -1 ? 0 : this.getDepth((NodeInterface)nodeIcon));
            this.setIcon(this._hierarchyIcon);
        } else if (value instanceof NodeInterface) {
            NodeInterface node = (NodeInterface)value;
            this.setText(node.getNodeText());
            this.setIcon(null);
        } else {
            if (value == null) {
                this.setText("null");
            } else {
                this.setText(value.toString());
            }
            this.setIcon(null);
        }
        return this;
    }

    private IconInterface _getIcon(NodeIconInterface nodeIcon, boolean isSelected) {
        IconInterface iconInterface = null;
        iconInterface = nodeIcon.isLeafNode() ? (isSelected ? nodeIcon.getSelectedIcon() : nodeIcon.getDefaultIcon()) : (isSelected ? nodeIcon.getExpandedSelectedIcon() : nodeIcon.getExpandedIcon());
        if (iconInterface == null) {
            return nodeIcon.getDefaultIcon();
        }
        return iconInterface;
    }

    public void setHierarchy(TreeInterface hierarchy) {
        this._treeHierarchy = hierarchy;
    }

    public void setIndent(int indent) {
        if (indent <= 0) {
            throw new IllegalArgumentException("Indent value must be greater than 0. (new value = " + indent + ")");
        }
        this._hierarchyIcon.setIndent(indent);
    }

    private int getDepth(NodeInterface node) {
        if (this._treeHierarchy != null && this._treeHierarchy.getRoot() != null) {
            return HierarchyListCellRenderer.getDepth(this._treeHierarchy.getRoot(), node) - 1;
        }
        return 0;
    }

    private static final int getDepth(NodeInterface parent, NodeInterface node) {
        if (parent == null || node == null) {
            return -1;
        }
        if (node == parent) {
            return 0;
        }
        return HierarchyListCellRenderer.getDepth(parent, node, 0);
    }

    private static final int getDepth(NodeInterface parent, NodeInterface node, int curDepth) {
        ++curDepth;
        int cnt = parent.getNodeChildCount();
        for (int i = 0; i < cnt; ++i) {
            int depth;
            NodeInterface tempNode = (NodeInterface)parent.getNodeChild(i);
            if (tempNode == node) {
                return curDepth;
            }
            if (tempNode.getNodeChildCount() <= 0 || (depth = HierarchyListCellRenderer.getDepth(tempNode, node, curDepth)) == -1) continue;
            return depth;
        }
        return -1;
    }

    class HierarchyIcon
    implements Icon {
        Icon _icon = null;
        IconInterface _iconInterface = null;
        int _depth;
        int _indent;

        public HierarchyIcon() {
            this.setDepth(0);
            this.setIndent(15);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            x += this._depth * this._indent;
            if (this._icon != null) {
                this._icon.paintIcon(c, g, x, y);
            } else {
                Dimension prefSize = this._iconInterface.getPreferredSize();
                this._iconInterface.paint(c, g, x, y, prefSize.width, prefSize.height);
            }
        }

        @Override
        public int getIconWidth() {
            int width = this._icon != null ? this._icon.getIconWidth() : this._iconInterface.getPreferredSize().width;
            return width + this._depth * this._indent;
        }

        @Override
        public int getIconHeight() {
            if (this._icon != null) {
                return this._icon.getIconHeight();
            }
            return this._iconInterface.getPreferredSize().height;
        }

        public void setDepth(int depth) {
            this._depth = depth;
        }

        public void setIcon(IconInterface iconInterface) {
            if (iconInterface == null) {
                throw new IllegalArgumentException("IconInterface must be non-null.");
            }
            this._icon = null;
            this._iconInterface = iconInterface;
        }

        public void setIndent(int indent) {
            this._indent = indent;
        }
    }
}

