/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.RunningObjectTable;
import com.sas.collection.SortedCollection;
import com.sas.swing.models.ListModelAdapter;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.util.Comparator;
import com.sas.util.IndexedGetInterface;
import com.sas.util.transforms.DisplayTransformInterface;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.transforms.TransformInterfaceEditor;
import com.sas.util.transforms.Transforms;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DisplayTransformCustomizerPanel
extends SwingCustomizerPanel
implements ListSelectionListener,
PropertyChangeListener,
ActionListener {
    protected static final String RB_KEY = "DisplayTransformCustomizerPanel.";
    protected DisplayTransformInterface displayTransform;
    protected JList inputList;
    protected JList outputList;
    protected JComboBox transformBox;
    protected ListModelAdapter inputModel;
    protected SortedCollection sortedSources;
    protected ListModelAdapter outputModel;
    protected DefaultComboBoxModel transformModel;
    protected SortedCollection sortedTargets;
    protected TransformInterfaceEditor editor;
    protected JPanel transformContainer;
    protected boolean settingClasses;
    protected boolean settingTransform;
    protected boolean madeVisible;
    protected boolean settingInputList;
    protected boolean settingOutputList;
    private int numberOfRegisteredTransforms;

    public DisplayTransformCustomizerPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public DisplayTransformCustomizerPanel() {
        this(RB.getStringResource((String)RB_KEY, (String)"displayTransformTabTitle.txt"));
    }

    public void setDefaultValues() {
        this.settingClasses = false;
        this.settingTransform = false;
        this.settingInputList = false;
        this.settingOutputList = false;
        this.numberOfRegisteredTransforms = Transforms.getRegisteredTransforms().length;
        this.madeVisible = false;
        this.createComponents();
    }

    protected void createComponents() {
        this.createMainPanel();
        this.createTransformContainer();
        this.add(this.transformContainer);
    }

    protected void createMainPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        this.setLayout((LayoutManager)outerLayout);
    }

    protected void createTransformContainer() {
        this.transformContainer = new JPanel();
        this.transformContainer.setBorder(Util.getGroupBoxBorder((String)RB.getStringResource((String)RB_KEY, (String)"displayTransformSelection.txt"), (int)5, (int)5, (int)5, (int)5));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 2, 5, 5, true, true, true);
        layout.setColumnSpacePartitioner((SpacePartitionerInterface)new EqualSpacePartitioner(false));
        layout.setRemainderRow(2);
        this.transformContainer.setLayout((LayoutManager)layout);
        this.createTransformContainerComponents();
    }

    protected void createTransformContainerComponents() {
        JLabel sourceLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"sourceClass.txt"));
        this.transformContainer.add(sourceLabel);
        JLabel targetLabel = new JLabel(RB.getStringResource((String)RB_KEY, (String)"targetClass.txt"));
        this.transformContainer.add(targetLabel);
        this.inputList = new JList();
        this.inputList.setSelectionMode(0);
        JScrollPane inputPane = new JScrollPane(this.inputList);
        this.transformContainer.add(inputPane);
        this.outputList = new JList();
        this.outputList.setSelectionMode(0);
        JScrollPane outputPane = new JScrollPane(this.outputList);
        this.transformContainer.add(outputPane);
        Container cont1 = new Container();
        cont1.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, true, true));
        JLabel selectTransform = new JLabel(RB.getStringResource((String)RB_KEY, (String)"selectDisplayTransform.txt"));
        cont1.add(selectTransform);
        this.transformBox = new JComboBox();
        cont1.add(this.transformBox);
        this.transformContainer.add(cont1);
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof DisplayTransformInterface) {
            this.displayTransform = (DisplayTransformInterface)bean;
            this.editor = new TransformInterfaceEditor();
            this.editor.setValue((Object)this.displayTransform);
            this.editor.setBeanContainingProperty(bean);
            this.sortedSources = new SortedCollection(Transforms.getRegisteredSourceClasses(), (Comparator)new ClassComparator(), false);
            this.inputModel = new ListModelAdapter((IndexedGetInterface)this.sortedSources);
            this.inputList.setModel(this.inputModel);
            this.inputList.setCellRenderer(new ClassRenderer());
            this.sortedTargets = new SortedCollection((Comparator)new ClassComparator(), false);
            this.outputModel = new ListModelAdapter((IndexedGetInterface)this.sortedTargets);
            this.outputList.setModel(this.outputModel);
            this.outputList.setCellRenderer(new ClassRenderer());
            this.transformModel = new DefaultComboBoxModel();
            this.transformBox.setModel(this.transformModel);
            this.synchronizeLists();
            this.addLinks();
        }
    }

    public void addLinks() {
        this.inputList.getSelectionModel().addListSelectionListener(this);
        this.outputList.getSelectionModel().addListSelectionListener(this);
        this.transformBox.addActionListener(this);
        com.sas.beans.Util.addPropertyChangeListener((Object)this.bean, (PropertyChangeListener)this);
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.madeVisible && !this.isVisible()) {
            this.madeVisible = true;
            this.inputList.ensureIndexIsVisible(this.inputList.getSelectedIndex());
            this.outputList.ensureIndexIsVisible(this.outputList.getSelectedIndex());
            Rectangle rect = this.outputList.getCellBounds(this.outputList.getSelectedIndex(), this.outputList.getSelectedIndex());
            if (rect != null && rect.getWidth() == 0.0) {
                this.madeVisible = false;
            }
        }
        super.setVisible(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.settingClasses) return;
        if (!this.inputList.getValueIsAdjusting() && event.getSource() == this.inputList.getSelectionModel()) {
            try {
                this.settingInputList = true;
                Object obj = this.inputList.getSelectedValue();
                this.outputList.clearSelection();
                this.transformBox.setSelectedIndex(-1);
                this.sortedTargets.removeAll();
                this.setTransformList();
                this.setTransformOnBean(null);
                if (obj == null || !(obj instanceof Class)) return;
                Class cls = (Class)obj;
                this.sortedTargets.addItems(Transforms.getRegisteredSourceTransforms((Class)cls).keys());
                return;
            }
            finally {
                this.settingInputList = false;
            }
        }
        if (this.outputList.getValueIsAdjusting() || event.getSource() != this.outputList.getSelectionModel()) return;
        try {
            Class cls2;
            Class cls1;
            TransformInterface transform;
            this.settingOutputList = true;
            Object obj1 = this.inputList.getSelectedValue();
            Object obj2 = this.outputList.getSelectedValue();
            this.transformBox.setSelectedIndex(-1);
            this.setTransformList();
            if (obj1 == null || !(obj1 instanceof Class) || obj2 == null || !(obj2 instanceof Class) || (transform = Transforms.lookupTransform((Class)(cls1 = (Class)obj1), (Class)(cls2 = (Class)obj2))) == null) return;
            this.transformModel.addElement(transform.getClass().getName());
            this.transformBox.setSelectedItem(transform.getClass().getName());
            this.setTransformOnBean(transform);
            return;
        }
        finally {
            this.settingOutputList = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        block7: {
            Object selectedItem;
            if (!(this.settingTransform || this.settingInputList || this.settingOutputList || evt.getSource() != this.transformBox || (selectedItem = this.transformBox.getSelectedItem()) == null)) {
                this.editor.setAsText(selectedItem.toString());
                try {
                    this.settingTransform = true;
                    this.setTransformOnBean((TransformInterface)this.editor.getValue());
                    String name = RunningObjectTable.lookupComponentName((Object)this.getCurrentTransform());
                    if (name == null && this.getCurrentTransform() != null) break block7;
                    this.setTransformList();
                    this.setTransformSelected();
                    try {
                        this.settingClasses = true;
                        this.inputList.clearSelection();
                        this.sortedTargets.removeAll();
                    }
                    finally {
                        this.settingClasses = false;
                    }
                }
                finally {
                    this.settingTransform = false;
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.settingTransform && !this.settingInputList && !this.settingOutputList && e.getSource() == this.bean && e.getPropertyName().equals("displayTransform")) {
            this.synchronizeLists();
        }
    }

    protected void synchronizeLists() {
        try {
            this.settingTransform = true;
            this.setTransformList();
            this.setTransformSelected();
            if (this.getCurrentTransform() != null && this.transformBox.getSelectedIndex() == 0) {
                this.transformModel.addElement(this.getCurrentTransform().getClass().getName());
                this.transformBox.setSelectedItem(this.editor.getAsText());
            }
            this.setSourceAndTargetClasses(this.getCurrentTransform());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.settingTransform = false;
        }
    }

    protected TransformInterface getCurrentTransform() {
        return this.displayTransform.getDisplayTransform();
    }

    protected void setTransformList() {
        this.transformModel.removeAllElements();
        String[] transforms = this.editor.getTags();
        int size = transforms.length - this.numberOfRegisteredTransforms;
        for (int i = 0; i < size; ++i) {
            this.transformModel.addElement(transforms[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSourceAndTargetClasses(TransformInterface transform) {
        block6: {
            try {
                this.settingClasses = true;
                if (transform != null) {
                    Enumeration classes = Transforms.getRegisteredSourceClassesForTransform((TransformInterface)transform);
                    if (classes.hasMoreElements()) {
                        String className = transform.getClass().getName();
                        Class cls = (Class)classes.nextElement();
                        this.inputList.setSelectedValue(cls, true);
                        this.sortedTargets.removeAll();
                        this.sortedTargets.addItems(Transforms.getRegisteredSourceTransforms((Class)cls).keys());
                        Hashtable table = Transforms.getRegisteredSourceTransforms((Class)cls);
                        Enumeration outputClassesEnum = table.keys();
                        while (outputClassesEnum.hasMoreElements()) {
                            Object outClass = outputClassesEnum.nextElement();
                            Object obj = table.get(outClass);
                            if (obj == null || !obj.getClass().getName().equals(className)) continue;
                            this.outputList.setSelectedValue(outClass, true);
                            break block6;
                        }
                        break block6;
                    }
                    this.inputList.clearSelection();
                    this.sortedTargets.removeAll();
                    break block6;
                }
                this.inputList.clearSelection();
                this.sortedTargets.removeAll();
            }
            finally {
                this.settingClasses = false;
            }
        }
    }

    protected void setTransformOnBean(TransformInterface transform) {
        this.displayTransform.setDisplayTransform(transform);
        this.editor.setValue((Object)transform);
    }

    protected void setTransformSelected() {
        this.editor.setValue((Object)this.getCurrentTransform());
        this.transformBox.setSelectedItem(this.editor.getAsText());
    }

    @Override
    public void customizerClosing() {
        this.inputList.getSelectionModel().removeListSelectionListener(this);
        this.outputList.getSelectionModel().removeListSelectionListener(this);
        this.transformBox.removeActionListener(this);
        com.sas.beans.Util.removePropertyChangeListener((Object)this.bean, (PropertyChangeListener)this);
    }

    public static String getClassDeclaration(Class classObj) {
        String name = com.sas.util.Util.getClassDeclaration((Class)classObj);
        if (classObj.isInterface()) {
            name = "interface " + name;
        } else if (!classObj.isPrimitive()) {
            name = "class " + name;
        }
        return name;
    }

    class ClassRenderer
    extends DefaultListCellRenderer {
        ClassRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean isInterface = false;
            if (value instanceof Class) {
                if (((Class)value).isInterface()) {
                    isInterface = true;
                }
                value = DisplayTransformCustomizerPanel.getClassDeclaration((Class)value);
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isInterface) {
                this.setFont(new Font(this.getFont().getFontName(), 2, this.getFont().getSize()));
            }
            return this;
        }
    }

    class ClassComparator
    implements Comparator {
        ClassComparator() {
        }

        public int compare(Object a, Object b) {
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a == b) {
                return 0;
            }
            if (a instanceof Class) {
                if (b instanceof Class) {
                    Class aa = (Class)a;
                    Class bb = (Class)b;
                    String aName = DisplayTransformCustomizerPanel.getClassDeclaration(aa);
                    String bName = DisplayTransformCustomizerPanel.getClassDeclaration(bb);
                    if (aa.isPrimitive()) {
                        if (bb.isPrimitive()) {
                            if (aName.equals(bName)) {
                                return 0;
                            }
                            if (aName.compareTo(bName) < 0) {
                                return -1;
                            }
                            return 1;
                        }
                        return 1;
                    }
                    if (bb.isPrimitive()) {
                        return -1;
                    }
                    if (aName.equals(bName)) {
                        return 0;
                    }
                    if (aName.compareTo(bName) < 0) {
                        return -1;
                    }
                    return 1;
                }
                return 1;
            }
            return -1;
        }
    }
}

