/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.awt.util.Util;
import com.sas.models.NodeInterface;
import com.sas.swing.visuals.DirectoryList;
import com.sas.swing.visuals.NodeActionEvent;
import com.sas.swing.visuals.NodeView;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.TreeView;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class DirectoryDialog
extends JDialog
implements WindowListener,
KeyListener {
    public static String separator = System.getProperty("file.separator");
    protected static final String RB_KEY = "DirectoryDialog.";
    protected String NAME;
    protected DirectoryList _dirList;
    protected TreeView _tree;
    protected JTextField _name;
    protected String _currentDirectory = "";
    protected Frame _parent;
    protected boolean _wasCancelled;
    protected boolean _allowNewDirectories;
    protected boolean _prompt;
    protected JButton okButton;
    protected JButton cancelButton;

    public DirectoryDialog(Frame frame, String title, String startingDirectory, boolean allowNew, boolean prompt) {
        super(frame, title, true);
        this._parent = frame;
        this._prompt = prompt;
        this._allowNewDirectories = allowNew;
        this.createDialog(startingDirectory);
    }

    public DirectoryDialog(Frame frame, String title, String startingDirectory, boolean allowNew) {
        this(frame, title, startingDirectory, allowNew, false);
    }

    public DirectoryDialog(Frame frame, String title, String startingDirectory) {
        this(frame, title, startingDirectory, true, false);
    }

    private void createDialog(String startingDirectory) {
        this.getContentPane().setLayout(new BorderLayout(8, 0));
        this.NAME = RB.getStringResource((String)RB_KEY, (String)"Name.txt");
        this._dirList = new DirectoryList();
        this._tree = new TreeView();
        this._tree.initialize();
        this._tree.setLineVisibility(1);
        this._tree.setButtonVisibility(1);
        this._tree.setIndentSize(6);
        this._tree.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String directory = ((TreeView)e.getSource()).getSelectedItem();
                    if (directory.indexOf(":") == 1 && directory.length() == 2) {
                        directory = directory + File.separator;
                    }
                    if (directory.equals(DirectoryDialog.this._currentDirectory)) {
                        return;
                    }
                    DirectoryDialog.this.setDirectoryName(directory);
                }
            }
        });
        this._tree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeActionEvent naEvent = (NodeActionEvent)event;
                if (naEvent.getActionCommand() == "defaultAction") {
                    NodeView nodeView = naEvent.getNode();
                    if (nodeView.getDepth() == 0 || nodeView.getDepth() == 1) {
                        DirectoryDialog.this.setDrive(nodeView.getNodeText());
                    } else {
                        DirectoryDialog.this.setDirectory(nodeView.getNodeExpandedText(), true);
                    }
                }
            }
        });
        Container mainPanel = new Container();
        mainPanel.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 5, 8, true, true, true));
        Container subPanel = new Container();
        AutoSizingGridLayout asgl1 = new AutoSizingGridLayout(0, 2, 5, 5, true, true, true);
        subPanel.setLayout((LayoutManager)asgl1);
        subPanel.add(new JLabel(this.NAME));
        this._name = new JTextField(35);
        subPanel.add(this._name);
        mainPanel.add(subPanel);
        this._name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String directory = ((JTextField)e.getSource()).getText();
                if (directory.indexOf(":") == 1 && directory.length() == 2) {
                    directory = directory + separator;
                }
                if (directory.indexOf("My Computer") != -1) {
                    return;
                }
                if (DirectoryDialog.this.verifyDirectory(DirectoryDialog.this._parent, directory)) {
                    if (directory.equals(DirectoryDialog.this._currentDirectory)) {
                        return;
                    }
                    DirectoryDialog.this.setDirectory(directory, true);
                }
            }
        });
        subPanel = new Container();
        subPanel.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 5, 5, true, true, true));
        subPanel.add(this._tree);
        mainPanel.add(subPanel);
        this.getContentPane().add("Center", mainPanel);
        Container btnPanel = new Container();
        btnPanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 0, 6, true, false, true));
        this.okButton = new JButton(Message.format((String)RB.getStringResource((String)"okButton.txt"), (Object)"  ", (Object)"  "));
        btnPanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryDialog.this.onOK();
            }
        });
        this.cancelButton = new JButton(Message.format((String)RB.getStringResource((String)"cancelButton.txt"), (Object)"  ", (Object)"  "));
        btnPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryDialog.this.onCancel();
            }
        });
        this.getContentPane().add("East", btnPanel);
        if (startingDirectory == null || startingDirectory.equals("")) {
            startingDirectory = System.getProperty("user.dir");
        }
        this.setDirectory(startingDirectory);
        this.addWindowListener(this);
        this._tree.addKeyListener(this);
        this._name.addKeyListener(this);
        this._parent.addKeyListener(this);
        this.okButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.addKeyListener(this);
    }

    public void setDirectory(String directory) {
        this.setDirectory(directory, false);
    }

    private void setDrive(String drive) {
        this._tree.setModel(null);
        this._dirList.setStartingDirectory(drive, true, true);
        this._tree.setModel(this._dirList);
        if (drive.equals("My Computer")) {
            this.setDirectoryName(drive);
        } else {
            this.setDirectoryName(drive + File.separator);
        }
    }

    private void setDirectory(String directory, boolean includeChildren) {
        this._tree.setModel(null);
        this._dirList.setStartingDirectory(directory, includeChildren, false);
        this._tree.setModel(this._dirList);
        this.setDirectoryName(directory);
    }

    private void setDirectoryName(String directory) {
        this._currentDirectory = directory;
        if (this._dirList.getRoot() == null) {
            directory = "";
        } else if (!directory.equals("My Computer")) {
            NodeView node = this.searchTree(this._tree.getRoot(), this._dirList.getLastDirectoryName());
            if (node != null) {
                node.setVisible();
            }
            if ((node = this.searchTree(this._tree.getRoot(), directory)) != null) {
                this._tree.scrollToNode(node, true);
            }
        } else {
            NodeView nodeView = this._tree.getNodeView(this._dirList.getRoot(), 1);
            nodeView.setExpanded(true);
            nodeView.setSelected(true);
        }
        this._name.setText(directory);
    }

    public String getDirectory() {
        return this._name.getText();
    }

    protected NodeView searchTree(NodeView node, String val) {
        if (node == null) {
            return node;
        }
        NodeView retNode = null;
        NodeInterface ni = node.getNode();
        if (ni.getNodeExpandedText().toUpperCase().equals(val.toUpperCase())) {
            node.setSelected(true);
            return node;
        }
        for (int i = 0; i < node.getNodeChildCount() && (retNode = this.searchTree((NodeView)node.getNodeChild(i), val)) == null; ++i) {
        }
        return retNode;
    }

    protected void onOK() {
        String directory = this.getDirectory();
        this._name.setText(directory);
        this.setVisible(false);
    }

    protected void onCancel() {
        this._wasCancelled = true;
        this.setVisible(false);
    }

    public boolean wasCancelled() {
        return this._wasCancelled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this._wasCancelled = false;
        }
        super.setVisible(visible);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.top += 8;
        insets.bottom += 8;
        insets.left += 8;
        insets.right += 8;
        return insets;
    }

    public boolean verifyDirectory(Frame parent, String directory) {
        File file = new File(directory);
        directory = file.getAbsolutePath();
        file = new File(directory);
        boolean rc = true;
        if (!directory.trim().equals("") && !file.exists()) {
            String TITLE = RB.getStringResource((String)RB_KEY, (String)"CreateDirectory.txt");
            if (this._allowNewDirectories) {
                JDialog dialog;
                JOptionPane pane;
                boolean buttonYes = false;
                if (this._prompt) {
                    String PROMPT = RB.getStringResource((String)RB_KEY, (String)"CreateDirectoryPrompt.txt");
                    pane = new JOptionPane(PROMPT + " \"" + directory + "\"?", 3, 0, null, null, null);
                    dialog = pane.createDialog(parent, TITLE);
                    Util.centerOver(dialog, this);
                    dialog.setVisible(true);
                    Object selectedValue = pane.getValue();
                    buttonYes = selectedValue instanceof Integer && (Integer)selectedValue == 0;
                }
                if (buttonYes || !this._prompt) {
                    if (!file.mkdirs()) {
                        String errorMsg = RB.getStringResource((String)RB_KEY, (String)"CreateError.txt");
                        pane = new JOptionPane(errorMsg + " \"" + directory + "\".", 0, 0, null, null, null);
                        dialog = pane.createDialog(parent, TITLE);
                        Util.centerOver(dialog, this);
                        dialog.setVisible(true);
                        rc = false;
                    }
                } else {
                    rc = false;
                }
            } else {
                String errorMsg = RB.getStringResource((String)RB_KEY, (String)"DirectoryCreationNotAllowed.txt");
                JOptionPane pane = new JOptionPane(errorMsg + " \"" + directory + "\".", 0, 0, null, null, null);
                JDialog dialog = pane.createDialog(parent, TITLE);
                Util.centerOver(dialog, this);
                dialog.setVisible(true);
                rc = false;
            }
        }
        return rc;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 27: {
                this.onCancel();
                break;
            }
            case 3: {
                this.onCancel();
                break;
            }
            case 10: {
                if (evt.getSource() != this._tree && evt.getSource() != this._name && evt.getSource() != this.cancelButton) {
                    this.onOK();
                    break;
                }
                if (evt.getSource() != this.cancelButton) break;
                this.onCancel();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this._tree.removeKeyListener(this);
        this._name.removeKeyListener(this);
        this._parent.removeKeyListener(this);
        this.okButton.removeKeyListener(this);
        this.cancelButton.removeKeyListener(this);
        this.removeKeyListener(this);
        this._wasCancelled = true;
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }
}

