/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.beans.Introspector;
import com.sas.beans.Util;
import com.sas.security.SecuritySupport;
import com.sas.swing.property.AbstractPropertyDescriptorAttribute;
import com.sas.swing.property.PropertyDescriptorAttributeModifier;
import com.sas.swing.property.RB;
import com.sas.text.Message;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ValueAttribute
extends AbstractPropertyDescriptorAttribute
implements PropertyDescriptorAttributeModifier {
    public static final String RB_KEY = "ValueAttribute.";
    protected Set exceptionDescSet = new HashSet();
    public static final ValueAttribute defaultInstance = new ValueAttribute();
    protected static Set modifiedPropertySet = new HashSet();

    @Override
    public boolean isEditable(Object[] bean, PropertyDescriptor propDesc) {
        try {
            if (propDesc.getWriteMethod() != null || propDesc instanceof IndexedPropertyDescriptor && ((IndexedPropertyDescriptor)propDesc).getIndexedWriteMethod() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Class getAttributeClass() {
        return PropertyDescriptor.class;
    }

    @Override
    public Object getAttribute(Object[] bean, PropertyDescriptor propDesc) {
        if (bean != null && bean.length > 0) {
            return this.getAttribute(bean[0], propDesc);
        }
        return null;
    }

    public void resetExceptions() {
        this.exceptionDescSet.clear();
    }

    public void handleException(Exception e, String message) {
        System.out.println(message);
        e.printStackTrace();
    }

    public Object getAttribute(Object bean, PropertyDescriptor propDesc) {
        Method readMethod = propDesc.getReadMethod();
        if (readMethod == null) {
            return null;
        }
        Object value = null;
        if (!this.exceptionDescSet.contains(propDesc)) {
            try {
                Class<?> beanClass = bean.getClass();
                Class<?> declaringClass = readMethod.getDeclaringClass();
                if (!declaringClass.isAssignableFrom(beanClass)) {
                    BeanInfo sourceBeanInfo = Introspector.getBeanInfo(beanClass);
                    PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor((String)propDesc.getName(), (BeanInfo)sourceBeanInfo);
                    readMethod = propertyDescriptor.getReadMethod();
                }
                value = SecuritySupport.securitySupport.invokeMethod(readMethod, bean, null);
            }
            catch (Exception e) {
                Throwable exception = e;
                if (e instanceof InvocationTargetException) {
                    exception = ((InvocationTargetException)e).getTargetException();
                }
                String msgText = Message.format((String)RB.getStringResource(RB_KEY, "errorGettingProperty.txt"), (Object)exception, (Object)propDesc.getName(), (Object)bean);
                this.handleException(e, msgText);
                this.exceptionDescSet.add(propDesc);
            }
        }
        return value;
    }

    @Override
    public boolean setAttribute(Object[] beans, PropertyDescriptor propDesc, Object value) {
        if (propDesc instanceof IndexedPropertyDescriptor) {
            return false;
        }
        try {
            boolean primitiveType = false;
            Class<?> propertyType = propDesc.getPropertyType();
            if (propertyType != null) {
                primitiveType = propertyType.isPrimitive();
            }
            boolean modified = false;
            String propName = propDesc.getName();
            for (int i = 0; i < beans.length; ++i) {
                Object originalValue = this.getAttribute(beans[i], propDesc);
                if (primitiveType) {
                    if (!com.sas.util.Util.unequal((Object)originalValue, (Object)value)) continue;
                    modified = true;
                    Util.setPropertyValue((Object)beans[i], (String)propName, (Object)value);
                    continue;
                }
                if (originalValue == value && !ValueAttribute.isModifiedProperty(propName)) continue;
                modified = true;
                ValueAttribute.removeModifiedProperty(propName);
                Util.setPropertyValue((Object)beans[i], (String)propName, (Object)value);
            }
            return modified;
        }
        catch (Exception e) {
            System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "errorSettingAttribute.txt"), (Object)propDesc.getName(), (Object)value));
            System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "exceptionThrown.txt"), (Object)e));
            return false;
        }
    }

    public static boolean isModifiedProperty(String propName) {
        return modifiedPropertySet.contains(propName);
    }

    public static void addModifiedProperty(String propName) {
        modifiedPropertySet.add(propName);
    }

    public static void removeModifiedProperty(String propName) {
        modifiedPropertySet.remove(propName);
    }

    public static void resetModifiedPropertySet() {
        modifiedPropertySet.clear();
    }
}

