/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.swing.property.PropertyDescriptorAttribute;
import com.sas.swing.property.PropertySheetTable;
import com.sas.swing.property.PropertyTableModel;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FilterAction
extends AbstractAction
implements TableModelListener {
    public static final String EXPERT = "expert";
    public static final String READONLY = "readOnly";
    public static final String PREFERRED = "preferred";
    public static final String HIDDEN = "hidden";
    public static final String BOUND = "bound";
    public static final String CONSTRAINED = "constrained";
    public static final String NORMAL = "normal";
    protected boolean updateEnabled;
    protected PropertySheetTable propertyTable;
    protected PropertyTableModel propertyModel;

    public FilterAction(PropertySheetTable table, String actionCommand, String name) {
        super(name);
        this.putValue("ActionCommandKey", actionCommand);
        this.propertyTable = table;
        this.propertyModel = (PropertyTableModel)table.getModel();
        this.propertyModel.addTableModelListener(this);
        this.updateEnabled = true;
        this.updateEnabled();
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        this.updateEnabled();
    }

    protected void updateEnabled() {
        String actionCmd = (String)this.getValue("ActionCommandKey");
        if (!this.updateEnabled || actionCmd == null || actionCmd.equals(NORMAL)) {
            return;
        }
        PropertyDescriptorAttribute propDescAttribute = this.propertyModel.getPropertyDescriptorAttribute(actionCmd);
        if (propDescAttribute == null) {
            return;
        }
        Object[] objs = this.propertyModel.getObjects();
        List allPropList = this.propertyModel.getAllPropertyDescriptors();
        for (int i = 0; i < allPropList.size(); ++i) {
            PropertyDescriptor propDesc = (PropertyDescriptor)allPropList.get(i);
            Object attrValue = propDescAttribute.getAttribute(objs, propDesc);
            if (!(attrValue instanceof Boolean) || !attrValue.equals(Boolean.TRUE)) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void filterTable(String filterID, boolean filterON) {
        if (filterID == null) {
            return;
        }
        int filterMod = 0;
        int filter = this.propertyModel.getPropertyDescriptorFilter();
        filterMod = filterID.equals(EXPERT) ? 1 : (filterID.equals(READONLY) ? 2 : (filterID.equals(PREFERRED) ? 32 : (filterID.equals(HIDDEN) ? 16 : (filterID.equals(BOUND) ? 4 : (filterID.equals(CONSTRAINED) ? 8 : 64)))));
        filter = filterON ? (filter |= filterMod) : (filter &= ~filterMod);
        try {
            this.updateEnabled = false;
            int row = this.propertyTable.getSelectedRow();
            int col = this.propertyTable.getSelectedColumn();
            if (this.propertyTable.isEditing() && !this.propertyTable.getCellEditor().stopCellEditing()) {
                return;
            }
            PropertyDescriptor selectPropDesc = null;
            if (row != -1) {
                selectPropDesc = this.propertyModel.getPropertyDescriptor(row);
            }
            this.propertyModel.filterTable(filter);
            List propDescList = this.propertyModel.getCurrentPropertyDescriptors();
            if (selectPropDesc != null && propDescList.contains(selectPropDesc) && (row = propDescList.indexOf(selectPropDesc)) != -1 && col != -1) {
                this.propertyTable.changeSelection(row, col, false, false);
            }
        }
        finally {
            this.updateEnabled = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        if (eSource instanceof AbstractButton) {
            String actionCmd = (String)this.getValue("ActionCommandKey");
            this.filterTable(actionCmd, ((AbstractButton)eSource).isSelected());
        }
    }
}

