/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.property;

import com.sas.swing.property.DrillAction;
import com.sas.swing.property.DrillInfo;
import com.sas.swing.property.PropertySheetTable;
import com.sas.swing.property.PropertyTableModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DrillDownAction
extends DrillAction
implements ListSelectionListener {
    protected static Set excludedClassSet;

    public DrillDownAction(String name, Stack compStack, PropertySheetTable table) {
        super(name, compStack, table);
        DrillDownAction.populateExcludedClassSet();
        this.propTable.getSelectionModel().addListSelectionListener(this);
        this.updateEnabled();
    }

    public Set getExcludedClassSet() {
        return excludedClassSet;
    }

    protected static void populateExcludedClassSet() {
        if (excludedClassSet == null) {
            excludedClassSet = new HashSet();
            excludedClassSet.add(Boolean.class);
            excludedClassSet.add(Character.class);
            excludedClassSet.add(Integer.class);
            excludedClassSet.add(Short.class);
            excludedClassSet.add(Double.class);
            excludedClassSet.add(String.class);
            excludedClassSet.add(Class.class);
            excludedClassSet.add(Long.class);
            excludedClassSet.add(Byte.class);
            excludedClassSet.add(Float.class);
            excludedClassSet.add(Dimension.class);
            excludedClassSet.add(Point.class);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.drillDown();
    }

    public static boolean canDrillDown(JTable table, int row, int column) {
        DrillDownAction.populateExcludedClassSet();
        Object value = table.getValueAt(row, column);
        return value != null && (value == null || !excludedClassSet.contains(value.getClass())) && table.isCellEditable(row, column);
    }

    protected void updateEnabled() {
        int selectedRow = this.propTable.getSelectedRow();
        if (selectedRow == -1) {
            this.setEnabled(false);
            return;
        }
        int valueCol = this.propTable.getColumnIndex("value");
        if (valueCol == -1) {
            this.setEnabled(false);
            return;
        }
        valueCol = this.propTable.convertColumnIndexToView(valueCol);
        this.setEnabled(DrillDownAction.canDrillDown(this.propTable, selectedRow, valueCol));
    }

    public Object getFirstComponent() {
        if (this.objStack == null) {
            return null;
        }
        if (this.objStack.size() == 0) {
            return null;
        }
        Object x = this.objStack.get(0);
        if (x instanceof DrillInfo) {
            x = ((DrillInfo)x).objects[0];
        }
        return x;
    }

    protected void drillDown() {
        int index = this.propTable.getSelectedRow();
        if (index != -1) {
            int valueCol = this.propTable.getColumnIndex("value");
            if (valueCol == -1) {
                return;
            }
            Object obj = this.propTable.getValueAt(index, valueCol = this.propTable.convertColumnIndexToView(valueCol));
            if (obj == null) {
                return;
            }
            DrillInfo info = new DrillInfo();
            info.objects = this.propTable.getObjects();
            info.rowIndex = index;
            PropertyDescriptor propDesc = ((PropertyTableModel)this.propTable.getModel()).getPropertyDescriptor(info.rowIndex);
            info.name = propDesc.getName();
            this.objStack.push(info);
            this.propTable.clearSelection();
            if (this.propTable.isEditing() && !this.propTable.getCellEditor().stopCellEditing()) {
                return;
            }
            Object[] objects = new Object[]{obj};
            this.propTable.setObjects(objects);
            this.fireStateChanged();
        }
    }
}

