/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.PropertyChangeSource;
import com.sas.models.Node;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.swing.models.IconAdapter;
import com.sas.swing.models.NodeIconsInterface;
import com.sas.util.transforms.DisplayTransformInterface;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.IconInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class TreeNodeAdapter
implements TreeNode,
NodeIconsInterface,
PropertyChangeListener,
PropertyChangeSource,
DisplayTransformInterface {
    protected static final String DEFAULT = "DEFAULT";
    protected static final String EXPANDED = "EXPANDED";
    protected static final String EXPANDED_SELECTED = "EXPANDED_SELECTED";
    protected static final String SELECTED = "SELECTED";
    protected boolean textExpanded;
    protected boolean refreshChildNodes;
    protected TreeNode parent;
    protected SimpleNodeInterface node;
    protected List childNodeList = new ArrayList();
    protected Map iconMap = new HashMap();
    protected PropertyChangeSupport propertyChangeSupport;
    protected TransformInterface displayTransform;

    public TreeNodeAdapter(SimpleNodeInterface node) {
        this(node, false);
    }

    public TreeNodeAdapter(SimpleNodeInterface node, boolean expandText) {
        this(node, expandText, null);
    }

    public TreeNodeAdapter(SimpleNodeInterface node, TransformInterface transform) {
        this(node, false, transform);
    }

    public TreeNodeAdapter(SimpleNodeInterface node, boolean expandText, TransformInterface transform) {
        this.displayTransform = transform;
        this.setModel(node);
        this.setExpandedTextUsed(expandText);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    public SimpleNodeInterface getModel() {
        return this.node;
    }

    public void setModel(SimpleNodeInterface nodeInterface) {
        if (this.node instanceof PropertyChangeSource) {
            ((PropertyChangeSource)nodeInterface).removePropertyChangeListener((PropertyChangeListener)this);
        }
        SimpleNodeInterface oldNode = this.node;
        this.node = nodeInterface == null ? this.newDefaultModel() : nodeInterface;
        if (this.node != oldNode) {
            this.firePropertyChange("model", oldNode, this.node);
        }
        if (this.node instanceof PropertyChangeSource) {
            ((PropertyChangeSource)this.node).addPropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.node instanceof NodeIconInterface) {
            NodeIconInterface iconNode = (NodeIconInterface)this.node;
            this.iconMap.put(DEFAULT, this.newIcon(iconNode.getDefaultIcon()));
            this.iconMap.put(EXPANDED_SELECTED, this.newIcon(iconNode.getExpandedSelectedIcon()));
            this.iconMap.put(EXPANDED, this.newIcon(iconNode.getExpandedIcon()));
            this.iconMap.put(SELECTED, this.newIcon(iconNode.getSelectedIcon()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(TransformInterface newTransform) {
        if (this.displayTransform != newTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = newTransform;
            this.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
        }
    }

    protected Icon newIcon(IconInterface icon) {
        if (icon != null) {
            return new IconAdapter(icon);
        }
        return null;
    }

    protected SimpleNodeInterface newDefaultModel() {
        return new Node();
    }

    protected TreeNode newTreeNode(SimpleNodeInterface node) {
        TreeNodeAdapter treeNode = new TreeNodeAdapter(node, this.getDisplayTransform());
        treeNode.setParent(this);
        return treeNode;
    }

    public void setParent(TreeNode parent) {
        TreeNode oldParent = this.parent;
        if (parent != oldParent) {
            this.parent = parent;
            this.firePropertyChange("parent", oldParent, this.parent);
        }
    }

    protected void createChildNodes() {
        int count = this.getChildCount();
        if (count != this.childNodeList.size() || this.refreshChildNodes) {
            this.childNodeList.clear();
            SimpleNodeInterface[] nodeChildren = this.getModel().getNodeChildren(0, count);
            for (int i = 0; i < nodeChildren.length; ++i) {
                TreeNode childTreeNode = this.newTreeNode(nodeChildren[i]);
                this.childNodeList.add(childTreeNode);
            }
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.createChildNodes();
        return (TreeNode)this.childNodeList.get(childIndex);
    }

    @Override
    public int getChildCount() {
        SimpleNodeInterface nodeInterface = this.getModel();
        int childCount = nodeInterface.getNodeChildCount();
        if (childCount == -1) {
            childCount = nodeInterface.countNodeChildren(0);
        }
        return childCount;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        this.createChildNodes();
        return this.childNodeList.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isLeaf();
    }

    @Override
    public boolean isLeaf() {
        return this.getModel().isLeafNode();
    }

    public Enumeration children() {
        this.createChildNodes();
        return Collections.enumeration(this.childNodeList);
    }

    public boolean isExpandedTextUsed() {
        return this.textExpanded;
    }

    public void setExpandedTextUsed(boolean expanded) {
        this.textExpanded = expanded;
    }

    public Icon getIcon() {
        return (Icon)this.iconMap.get(DEFAULT);
    }

    public Icon getExpandedIcon() {
        return (Icon)this.iconMap.get(EXPANDED);
    }

    public Icon getExpandedSelectedIcon() {
        return (Icon)this.iconMap.get(EXPANDED_SELECTED);
    }

    public Icon getSelectedIcon() {
        return (Icon)this.iconMap.get(SELECTED);
    }

    public String toString() {
        SimpleNodeInterface thisNode = this.getModel();
        String text = thisNode.toString();
        if (thisNode instanceof NodeInterface) {
            text = this.isExpandedTextUsed() ? ((NodeInterface)thisNode).getNodeExpandedText() : ((NodeInterface)thisNode).getNodeText();
        }
        if (this.getDisplayTransform() != null) {
            try {
                Object obj = this.getDisplayTransform().transform((Object)text);
                text = obj != null ? obj.toString() : null;
            }
            catch (TransformException e) {
                e.printStackTrace();
            }
        }
        return text;
    }
}

