/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.ComponentException;
import com.sas.MissingValues;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.beans.PropertyChangeSupport;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.models.SimpleTable;
import com.sas.swing.models.TableModelInsertRowSupport;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.table.AccurateRowCountInterface;
import com.sas.table.ColumnTemplateTableInterface;
import com.sas.table.DataCellChangedEvent;
import com.sas.table.DataTableInterface;
import com.sas.table.DeleteRowInterface;
import com.sas.table.FormattedDataInterface;
import com.sas.table.FormattedInterface;
import com.sas.table.FreeformTableInterface;
import com.sas.table.InsertRowInterface;
import com.sas.table.RowChangedEvent;
import com.sas.table.RowLabelChangedEvent;
import com.sas.table.RowTemplateTableInterface;
import com.sas.table.SortDistinctValuesInterface;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.table.TableInterface;
import com.sas.table.UpdateRowInterface;
import com.sas.util.UncheckedException;
import com.sas.util.transforms.DisplayTransformInterface;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableModelAdapter
extends AbstractTableModel
implements ContentsChangedListener,
PropertyChangeSource,
ViewDefaultModel,
DisplayTransformInterface,
StaticRowLabelInterface,
DeleteRowInterface,
InsertRowInterface,
UpdateRowInterface,
AccurateRowCountInterface,
SortDistinctValuesInterface,
FormattedInterface,
StaticColumnInfoInterface {
    protected boolean defaultModelAttached;
    protected PropertyChangeSupport propertyChangeSupport;
    protected StaticTableInterface model;
    protected int maxRowCount;
    protected int currentMaxCount;
    protected int lastRowIndex;
    protected boolean tableEditable;
    protected TransformInterface displayTransform;
    protected Hashtable columnDisplayTransforms;
    protected int currentRowCount;
    private TableModelInsertRowSupport helper;
    protected boolean formattedDataUsed;
    protected boolean sortAllowed;
    protected boolean distinctValues;
    private int oldRowCount;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "model";
        ebi.defaultOutputPropertyName = "model";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public TableModelAdapter() {
        this.initTable();
        this.setModel(null);
    }

    public TableModelAdapter(StaticTableInterface table) {
        this.initTable();
        this.setModel(table);
    }

    protected void initTable() {
        this.columnDisplayTransforms = new Hashtable();
        this.helper = new TableModelInsertRowSupport();
        this.maxRowCount = 100;
        this.resetRowCount();
        this.tableEditable = false;
        this.currentRowCount = 0;
        this.formattedDataUsed = true;
        this.sortAllowed = true;
        this.distinctValues = false;
        this.oldRowCount = -1;
    }

    protected StaticTableInterface newDefaultModel() {
        this.setDefaultModelAttached(true);
        return new SimpleTable();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.processPropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    public StaticTableInterface getModel() {
        return this.model;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModelAttached;
    }

    protected void setDefaultModelAttached(boolean defaultModelUsed) {
        if (defaultModelUsed != this.defaultModelAttached) {
            this.defaultModelAttached = defaultModelUsed;
            this.firePropertyChange("defaultModelAttached", new Boolean(!this.defaultModelAttached), new Boolean(this.defaultModelAttached));
        }
    }

    public void setModel(StaticTableInterface table) {
        boolean defaultModelUsed = false;
        if (table == null) {
            defaultModelUsed = true;
            table = this.newDefaultModel();
        }
        if (this.model != table) {
            if (this.model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.model).removeContentsChangedListener((ContentsChangedListener)this);
            }
            StaticTableInterface oldModel = this.model;
            this.model = table;
            this.columnDisplayTransforms = new Hashtable();
            if (table instanceof ContentsChangedSource) {
                ((ContentsChangedSource)table).addContentsChangedListener((ContentsChangedListener)this);
            }
            if (!defaultModelUsed) {
                this.setDefaultModelAttached(false);
            }
            this.fireTableStructureChanged();
            this.firePropertyChange(new PropertyChangeEvent(this, "model", oldModel, this.model));
        }
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(TransformInterface newTransform) {
        if (this.displayTransform != newTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = newTransform;
            this.fireTableStructureChanged();
            this.firePropertyChange("displayTransform", oldTransform, this.displayTransform);
        }
    }

    public TransformInterface getColumnDisplayTransform(String columnName) {
        return (TransformInterface)this.columnDisplayTransforms.get(columnName);
    }

    public void setColumnDisplayTransform(String columnName, TransformInterface newTransform) {
        if (this.getColumnDisplayTransform(columnName) != newTransform) {
            TransformInterface oldTransform = this.getColumnDisplayTransform(columnName);
            if (newTransform != null) {
                this.columnDisplayTransforms.put(columnName, newTransform);
            } else {
                this.columnDisplayTransforms.remove(columnName);
            }
            this.fireTableStructureChanged();
            this.firePropertyChange("columnDisplayTransform", oldTransform, newTransform);
        }
    }

    public Enumeration getColumnNamesWithDisplayTransform() {
        return this.columnDisplayTransforms.keys();
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event instanceof RowChangedEvent) {
            RowChangedEvent evt = (RowChangedEvent)event;
            if (evt.howChanged == 3) {
                int oldCount = this.getRowCount();
                if (this.oldRowCount != -1) {
                    oldCount = this.oldRowCount;
                }
                this.recalculateRowCount();
                int newCount = this.getRowCount();
                if (oldCount == newCount) {
                    this.fireTableRowsUpdated(0, newCount - 1);
                } else if (newCount > oldCount) {
                    if (evt.index == -1) {
                        this.fireTableRowsInserted(oldCount, newCount - 1);
                    } else {
                        this.fireTableRowsInserted(evt.index - 1, evt.index - 1 + (newCount - oldCount) - 1);
                    }
                } else if (evt.index == -1) {
                    this.fireTableRowsDeleted(newCount, oldCount - 1);
                } else {
                    this.fireTableRowsDeleted(evt.index - 1, evt.index - 1 + (oldCount - newCount) - 1);
                }
            } else if (evt.count > 0) {
                if (evt.howChanged == 1) {
                    this.recalculateRowCount();
                    this.fireTableRowsInserted(evt.index - 1, evt.index + evt.count - 2);
                } else if (evt.howChanged == 2) {
                    this.recalculateRowCount();
                    this.fireTableRowsDeleted(evt.index - 1, evt.index + evt.count - 2);
                } else {
                    this.fireTableDataChanged();
                }
            }
        } else if (event instanceof DataCellChangedEvent) {
            DataCellChangedEvent evt = (DataCellChangedEvent)event;
            if (evt.colCount == 1 && evt.rowCount == 1) {
                this.fireTableCellUpdated(evt.rowIndex - 1, evt.colIndex - 1);
            } else {
                this.fireTableRowsUpdated(evt.rowIndex - 1, evt.rowIndex + evt.rowCount - 2);
            }
        } else if (event instanceof RowLabelChangedEvent) {
            RowLabelChangedEvent evt = (RowLabelChangedEvent)event;
            if (evt.count > 0) {
                this.fireTableRowsUpdated(evt.index - 1, evt.index + evt.count - 2);
            }
        } else {
            this.fireTableStructureChanged();
        }
    }

    public Class getColumnClass(int columnIndex) {
        StaticTableInterface table = this.getModel();
        try {
            if (this.isFormattedDataUsed()) {
                return String.class;
            }
            if (table instanceof StaticRowTemplateTableInterface) {
                return ((StaticRowTemplateTableInterface)table).getColumnClass(columnIndex + 1);
            }
            return super.getColumnClass(columnIndex);
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getColumnName(" + columnIndex + ")";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
    }

    public Class getUnformattedColumnClass(int columnIndex) {
        StaticTableInterface table = this.getModel();
        try {
            if (table instanceof StaticRowTemplateTableInterface) {
                return ((StaticRowTemplateTableInterface)table).getColumnClass(columnIndex + 1);
            }
            return super.getColumnClass(columnIndex);
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getColumnName(" + columnIndex + ")";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public int getColumnCount() {
        try {
            return this.getModel().getColumnCount();
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getRowCount()";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        StaticTableInterface table = this.getModel();
        try {
            String columnLabel = null;
            columnLabel = table instanceof StaticColumnLabelInterface ? ((StaticColumnLabelInterface)table).getColumnLabel(columnIndex + 1).toString() : super.getColumnName(columnIndex);
            return columnLabel;
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getColumnName(" + columnIndex + ")";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
    }

    public void setMaxRowCount(int rc) {
        this.maxRowCount = rc;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @Override
    public void fireTableChanged(TableModelEvent evt) {
        if (evt.getType() == 1 || evt.getType() == -1) {
            this.resetRowCount();
            this.recalculateRowCount();
        }
        super.fireTableChanged(evt);
    }

    @Override
    public void fireTableStructureChanged() {
        this.recalculateRowCount();
        super.fireTableStructureChanged();
    }

    protected void updateRowCount(int firstRow, int lastRow) {
        super.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    protected void resetRowCount() {
        this.currentMaxCount = -1;
        this.lastRowIndex = -1;
    }

    protected void expandRowCount() {
        int prevRowCount = this.lastRowIndex + 1;
        int newMaxCount = this.getMaxRowCount();
        if (newMaxCount != 0) {
            newMaxCount += prevRowCount;
        }
        int rowCount = prevRowCount;
        try {
            rowCount = this.getModel().countRows(newMaxCount);
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:expandRowCount()";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        this.lastRowIndex = rowCount != newMaxCount ? -1 : rowCount - 1;
        this.currentRowCount = rowCount;
        this.currentMaxCount = newMaxCount;
        SwingUtilities.invokeLater(new TableRowsInserted(prevRowCount, rowCount, this));
    }

    @Override
    public int getRowCount() {
        int rowCount = this.currentRowCount;
        if (this.helper.isUncommittedRowPresent()) {
            ++rowCount;
        }
        return rowCount;
    }

    protected void recalculateRowCount() {
        try {
            int rowCount = this.getModel().getRowCount();
            if (rowCount >= 0) {
                this.currentRowCount = rowCount;
                this.lastRowIndex = -1;
            } else {
                int newMaxCount = this.getMaxRowCount();
                if (newMaxCount != 0 && this.currentMaxCount != -1) {
                    newMaxCount = this.currentMaxCount;
                }
                this.lastRowIndex = (rowCount = this.getModel().countRows(newMaxCount)) != newMaxCount ? -1 : rowCount - 1;
                this.currentRowCount = rowCount;
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:recalculateRowCount()";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.isFormattedDataUsed()) {
            return this.getFormattedValueAt(rowIndex, columnIndex);
        }
        return this.getUnformattedValueAt(rowIndex, columnIndex);
    }

    public Object getUnformattedValueAt(int rowIndex, int columnIndex) {
        try {
            StaticTableInterface table;
            Object value = null;
            if (this.helper.isUncommittedRowPresent()) {
                if (rowIndex == this.helper.getUncommittedRowNumber()) {
                    value = this.helper.getValueAt(columnIndex);
                    return value;
                }
                rowIndex = this.helper.getAdjustedRowNumber(rowIndex);
            }
            if ((value = (table = this.getModel()).getCell(rowIndex + 1, columnIndex + 1)) == null) {
                value = MissingValues.Dot;
            }
            try {
                if (this.getColumnDisplayTransform(this.getColumnName(columnIndex)) == null) {
                    if (this.getDisplayTransform() != null) {
                        value = this.getDisplayTransform().transform(value);
                    }
                } else {
                    value = this.getColumnDisplayTransform(this.getColumnName(columnIndex)).transform(value);
                }
            }
            catch (TransformException e) {
                e.printStackTrace();
            }
            if (rowIndex == this.lastRowIndex) {
                this.expandRowCount();
            }
            return value;
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getValueAt(" + rowIndex + ", " + columnIndex + ") ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.isTableEditable()) {
            StaticTableInterface table = this.getModel();
            if (table instanceof TableInterface) {
                return ((TableInterface)table).isCellsModifiable();
            }
            return false;
        }
        return false;
    }

    public boolean isTableEditable() {
        return this.tableEditable;
    }

    public void setTableEditable(boolean editable) {
        this.tableEditable = editable;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.isTableEditable()) {
            try {
                StaticTableInterface table;
                if (aValue instanceof MissingValues) {
                    aValue = null;
                }
                if (this.helper.isUncommittedRowPresent()) {
                    if (rowIndex == this.helper.getUncommittedRowNumber()) {
                        this.helper.setValueAt(aValue, columnIndex);
                        return;
                    }
                    rowIndex = this.helper.getAdjustedRowNumber(rowIndex);
                }
                if ((table = this.getModel()) instanceof FormattedDataInterface) {
                    if (aValue == null) {
                        ((FormattedDataInterface)table).setFormattedCell(rowIndex + 1, columnIndex + 1, "");
                    } else {
                        ((FormattedDataInterface)table).setFormattedCell(rowIndex + 1, columnIndex + 1, aValue.toString());
                    }
                } else if (table instanceof TableInterface) {
                    ((TableInterface)table).setCell(rowIndex + 1, columnIndex + 1, aValue);
                }
            }
            catch (TableException e) {
                String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:setValueAt(" + rowIndex + ", " + columnIndex + ") ";
                throw new ComponentException(errorMsg, (Throwable)e);
            }
        }
    }

    public Object getRowLabel(int row) {
        try {
            if (this.model instanceof StaticRowLabelInterface) {
                if (this.helper.isUncommittedRowPresent()) {
                    if (row == this.helper.getUncommittedRowNumber()) {
                        return null;
                    }
                    row = this.helper.getAdjustedRowNumber(row);
                }
                Object obj = ((StaticRowLabelInterface)this.model).getRowLabel(row + 1);
                return obj;
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getRowLabel(" + row + ") ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        return new Integer(row + 1);
    }

    public Object[] getRowLabels(int startIndex, int count) {
        try {
            if (this.model instanceof StaticRowLabelInterface) {
                return ((StaticRowLabelInterface)this.model).getRowLabels(startIndex, count);
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getRowLabels(" + startIndex + ", " + count + ") ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        Object[] labels = new Object[count];
        for (int i = 0; i < count; ++i) {
            labels[i] = new Integer(i + startIndex);
        }
        return labels;
    }

    public boolean isRowLabelsSupported() {
        try {
            if (this.model instanceof StaticRowLabelInterface) {
                return ((StaticRowLabelInterface)this.model).isRowLabelsSupported();
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:isRowLabelsSupported( ) ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        return false;
    }

    public boolean isRowsLabelSupported() {
        try {
            if (this.model instanceof StaticRowLabelInterface) {
                return ((StaticRowLabelInterface)this.model).isRowsLabelSupported();
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:isRowsLabelSupported( ) ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        return false;
    }

    public void insertUncommittedRow(int rowIndex) throws UncheckedException {
        if (this.isRowInsertionAllowed() || this.isTableExtendOnly()) {
            this.helper.insertUncommittedRow((TableModel)this, rowIndex);
            rowIndex = this.getUncommittedRowNumber();
            this.fireTableRowsInserted(rowIndex, rowIndex);
        }
    }

    public void commitUncommittedRow() throws UncheckedException {
        if (this.isRowInsertionAllowed() || this.isTableExtendOnly()) {
            this.oldRowCount = this.getRowCount();
            int row = this.getUncommittedRowNumber();
            Object[] temp = this.helper.commitUncommittedRow((TableModel)this);
            if (temp == null) {
                return;
            }
            StaticTableInterface sti = this.getModel();
            try {
                Object[] data;
                if (sti instanceof FormattedDataInterface) {
                    data = new Object[temp.length + 1];
                    for (Object data[i] : temp) {
                    }
                    data[i] = "__FORMATTED__";
                } else {
                    data = temp;
                }
                if (sti instanceof RowTemplateTableInterface) {
                    if (this.isTableExtendOnly()) {
                        row = -1;
                        ((RowTemplateTableInterface)sti).addRow(row, data);
                    } else {
                        ((RowTemplateTableInterface)sti).addRow(row + 1, data);
                    }
                } else if (sti instanceof ColumnTemplateTableInterface) {
                    int i;
                    int n;
                    if (this.isTableExtendOnly()) {
                        row = -1;
                        n = data.length;
                        for (i = 0; i < n; ++i) {
                            ((ColumnTemplateTableInterface)sti).addRow(row, data[i].getClass(), data[i]);
                        }
                    } else {
                        n = data.length;
                        for (i = 0; i < n; ++i) {
                            ((ColumnTemplateTableInterface)sti).addRow(row + 1, data[i].getClass(), data[i]);
                        }
                    }
                } else if (sti instanceof FreeformTableInterface) {
                    ((FreeformTableInterface)sti).addRow(row + 1, data);
                }
                if (row != -1) {
                    this.fireTableRowsUpdated(row, row);
                } else {
                    this.fireTableRowsUpdated(0, this.getRowCount() - 1);
                }
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
        this.oldRowCount = -1;
    }

    public void cancelUncommittedRow() throws UncheckedException {
        if (this.isRowInsertionAllowed() || this.isTableExtendOnly()) {
            int row = this.getUncommittedRowNumber();
            this.helper.cancelUncommittedRow((TableModel)this);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public boolean isUncommittedRowPresent() {
        return this.helper.isUncommittedRowPresent();
    }

    public int getUncommittedRowNumber() {
        return this.helper.getUncommittedRowNumber();
    }

    public boolean isRowInsertionAllowed() {
        if (this.isTableEditable()) {
            try {
                StaticTableInterface sti = this.getModel();
                if (sti instanceof RowTemplateTableInterface) {
                    return ((RowTemplateTableInterface)sti).isRowsInsertable() || ((RowTemplateTableInterface)sti).isRowsExtendable();
                }
                if (sti instanceof ColumnTemplateTableInterface) {
                    return ((ColumnTemplateTableInterface)sti).isRowsInsertable() || ((ColumnTemplateTableInterface)sti).isRowsExtendable();
                }
                if (sti instanceof FreeformTableInterface) {
                    return ((FreeformTableInterface)sti).isRowsInsertable() || ((FreeformTableInterface)sti).isRowsExtendable();
                }
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
        return false;
    }

    public boolean isTableExtendOnly() {
        if (this.isTableEditable()) {
            try {
                StaticTableInterface sti = this.getModel();
                if (sti instanceof RowTemplateTableInterface) {
                    return !((RowTemplateTableInterface)sti).isRowsInsertable() && ((RowTemplateTableInterface)sti).isRowsExtendable();
                }
                if (sti instanceof ColumnTemplateTableInterface) {
                    return !((ColumnTemplateTableInterface)sti).isRowsInsertable() && ((ColumnTemplateTableInterface)sti).isRowsExtendable();
                }
                if (sti instanceof FreeformTableInterface) {
                    return !((FreeformTableInterface)sti).isRowsInsertable() && ((FreeformTableInterface)sti).isRowsExtendable();
                }
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
        return false;
    }

    public boolean isRowUpdateAllowed() {
        StaticTableInterface sti;
        if (this.isTableEditable() && (sti = this.getModel()) instanceof TableInterface) {
            return ((TableInterface)sti).isCellsModifiable();
        }
        return false;
    }

    public void deleteRow(int rowIndex) {
        if (this.isRowDeletionAllowed()) {
            try {
                StaticTableInterface sti = this.getModel();
                if (sti instanceof RowTemplateTableInterface) {
                    ((RowTemplateTableInterface)sti).deleteRow(rowIndex + 1);
                } else if (sti instanceof ColumnTemplateTableInterface) {
                    ((ColumnTemplateTableInterface)sti).deleteRow(rowIndex + 1);
                } else if (sti instanceof FreeformTableInterface) {
                    ((FreeformTableInterface)sti).deleteRow(rowIndex + 1);
                }
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
    }

    public boolean isRowDeletionAllowed() {
        if (this.isTableEditable()) {
            try {
                StaticTableInterface sti = this.getModel();
                if (sti instanceof RowTemplateTableInterface) {
                    return ((RowTemplateTableInterface)sti).isRowsDeletable();
                }
                if (sti instanceof ColumnTemplateTableInterface) {
                    return ((ColumnTemplateTableInterface)sti).isRowsDeletable();
                }
                if (sti instanceof FreeformTableInterface) {
                    return ((FreeformTableInterface)sti).isRowsDeletable();
                }
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
        return false;
    }

    public boolean isAccurateRowCountAvailable() {
        return this.lastRowIndex == -1;
    }

    public void sort(String[] columnNames, int[] direction) {
        if (this.getModel() instanceof SortableInterface) {
            try {
                ((SortableInterface)this.getModel()).sort(columnNames, direction);
            }
            catch (SortException se) {
                se.printStackTrace();
            }
        }
    }

    public boolean isColumnSortable(String columnName) {
        if (this.getModel() instanceof SortableInterface) {
            return ((SortableInterface)this.getModel()).isColumnSortable(columnName);
        }
        return false;
    }

    public boolean isSortAllowed() {
        if (this.getModel() instanceof SortableInterface && this.sortAllowed) {
            return ((SortableInterface)this.getModel()).isSortAllowed();
        }
        return false;
    }

    public void setSortAllowed(boolean allowSorting) {
        if (allowSorting != this.sortAllowed) {
            this.sortAllowed = allowSorting;
            this.firePropertyChange("sortAllowed", this.sortAllowed ? Boolean.FALSE : Boolean.TRUE, this.sortAllowed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public String[] getSortedColumns() {
        if (this.getModel() instanceof SortableInterface) {
            return ((SortableInterface)this.getModel()).getSortedColumns();
        }
        return new String[0];
    }

    public int[] getSortedDirections() {
        if (this.getModel() instanceof SortableInterface) {
            return ((SortableInterface)this.getModel()).getSortedDirections();
        }
        return new int[0];
    }

    public boolean isDistinctValues() {
        return this.distinctValues;
    }

    public void setDistinctValues(boolean distinct) {
        if (distinct != this.distinctValues) {
            this.distinctValues = distinct;
            this.firePropertyChange("distinctValues", this.distinctValues ? Boolean.FALSE : Boolean.TRUE, this.distinctValues ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public String getColumnInfoUsed() {
        if (this.model instanceof DataTableInterface) {
            return ((DataTableInterface)this.model).getColumnInfoUsed();
        }
        return null;
    }

    public void setColumnInfoUsed(String columnInfoUsed) throws UncheckedException {
        if (this.model instanceof DataTableInterface) {
            try {
                ((DataTableInterface)this.model).setColumnInfoUsed(columnInfoUsed);
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
    }

    public String getFormat(int columnIndex) throws UncheckedException {
        StaticTableInterface table = this.getModel();
        if (table instanceof StaticColumnInfoInterface) {
            return (String)this.getColumnInfo(columnIndex + 1, "FORMAT");
        }
        return "";
    }

    public String getFormattedValueAt(int rowIndex, int columnIndex) {
        try {
            StaticTableInterface table;
            Object value = null;
            if (this.helper.isUncommittedRowPresent()) {
                if (rowIndex == this.helper.getUncommittedRowNumber()) {
                    value = this.helper.getValueAt(columnIndex);
                    if (value == null) {
                        return "";
                    }
                    return value.toString();
                }
                rowIndex = this.helper.getAdjustedRowNumber(rowIndex);
            }
            if ((value = (table = this.getModel()) instanceof FormattedDataInterface ? ((FormattedDataInterface)table).getFormattedCell(rowIndex + 1, columnIndex + 1) : table.getCell(rowIndex + 1, columnIndex + 1)) == null) {
                value = MissingValues.Dot;
            }
            try {
                if (this.getColumnDisplayTransform(this.getColumnName(columnIndex)) == null) {
                    if (this.getDisplayTransform() != null) {
                        value = this.getDisplayTransform().transform(value);
                    }
                } else {
                    value = this.getColumnDisplayTransform(this.getColumnName(columnIndex)).transform(value);
                }
            }
            catch (TransformException e) {
                e.printStackTrace();
            }
            if (rowIndex == this.lastRowIndex) {
                this.expandRowCount();
            }
            if (value == null) {
                return "";
            }
            return value.toString();
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getValueAt(" + rowIndex + ", " + columnIndex + ") ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
    }

    public void setFormattedDataUsed(boolean useFormattedData) {
        if (useFormattedData != this.formattedDataUsed) {
            boolean old = this.formattedDataUsed;
            this.formattedDataUsed = useFormattedData;
            this.firePropertyChange("formattedDataUsed", old ? Boolean.TRUE : Boolean.FALSE, old ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    public boolean isFormattedDataUsed() {
        return this.formattedDataUsed;
    }

    public Object getColumnInfo(int index, String columnInfoName) throws UncheckedException {
        if (this.model instanceof StaticColumnInfoInterface) {
            try {
                return ((StaticColumnInfoInterface)this.model).getColumnInfo(index, columnInfoName);
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
        return null;
    }

    public String[] getColumnInfoNames() throws UncheckedException {
        if (this.model instanceof StaticColumnInfoInterface) {
            try {
                return ((StaticColumnInfoInterface)this.model).getColumnInfoNames();
            }
            catch (TableException e) {
                throw new UncheckedException(e.getMessage());
            }
        }
        return new String[0];
    }

    class TableRowsInserted
    implements Runnable {
        protected int firstRow;
        protected int lastRow;
        protected TableModelAdapter tableModel;

        public TableRowsInserted(int firstRow, int lastRow, TableModelAdapter tableModel) {
            this.firstRow = firstRow;
            this.lastRow = lastRow;
            this.tableModel = tableModel;
        }

        @Override
        public void run() {
            this.tableModel.updateRowCount(this.firstRow, this.lastRow);
        }
    }
}

