/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.beans.PropertyChangeSupport;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.util.IndexedGetInterface;
import com.sas.util.transforms.DisplayTransformInterface;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;

public class ListModelAdapter
extends AbstractListModel
implements ContentsChangedListener,
PropertyChangeSource,
ViewDefaultModel,
DisplayTransformInterface {
    protected boolean defaultModelAttached;
    protected IndexedGetInterface model;
    protected PropertyChangeSupport propertyChangeSupport;
    protected TransformInterface displayTransform;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "model";
        ebi.defaultOutputPropertyName = "model";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ListModelAdapter() {
        this.setModel(null);
    }

    public ListModelAdapter(IndexedGetInterface collection) {
        this.setModel(collection);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.processPropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    protected IndexedGetInterface newDefaultModel() {
        this.setDefaultModelAttached(true);
        return new OrderedCollection();
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModelAttached;
    }

    protected void setDefaultModelAttached(boolean defaultModelUsed) {
        if (defaultModelUsed != this.defaultModelAttached) {
            this.defaultModelAttached = defaultModelUsed;
            this.firePropertyChange("defaultModelAttached", new Boolean(!this.defaultModelAttached), new Boolean(this.defaultModelAttached));
        }
    }

    public IndexedGetInterface getModel() {
        return this.model;
    }

    public void setModel(IndexedGetInterface collection) {
        boolean defaultModelUsed = false;
        if (collection == null) {
            defaultModelUsed = true;
            collection = this.newDefaultModel();
        }
        if (this.model != collection) {
            IndexedGetInterface oldModel = this.model;
            if (this.model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.model).removeContentsChangedListener((ContentsChangedListener)this);
            }
            this.model = collection;
            if (collection instanceof ContentsChangedSource) {
                ((ContentsChangedSource)collection).addContentsChangedListener((ContentsChangedListener)this);
            }
            if (!defaultModelUsed) {
                this.setDefaultModelAttached(false);
            }
            this.fireContentsChanged(this, -1, -1);
            this.firePropertyChange(new PropertyChangeEvent(this, "model", oldModel, this.model));
        }
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(TransformInterface newDisplayTransform) {
        if (this.displayTransform != newDisplayTransform) {
            TransformInterface oldDisplayTransform = this.displayTransform;
            this.displayTransform = newDisplayTransform;
            this.fireContentsChanged(this, -1, -1);
            this.firePropertyChange("displayTransform", oldDisplayTransform, this.displayTransform);
        }
    }

    @Override
    public Object getElementAt(int index) {
        Object element = this.getModel().get(index);
        try {
            if (this.getDisplayTransform() != null) {
                element = this.getDisplayTransform().transform(element);
            }
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return element;
    }

    @Override
    public int getSize() {
        return this.getModel().count();
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event instanceof CollectionChangedInfo) {
            CollectionChangedInfo changeInfo = (CollectionChangedInfo)event;
            int end = changeInfo.end - 1;
            if (changeInfo.howChanged == HowChanged.ADDED && end >= 0) {
                this.fireIntervalAdded(this, changeInfo.start, end);
            } else if (changeInfo.howChanged == HowChanged.REMOVED && end >= 0) {
                this.fireIntervalRemoved(this, changeInfo.start, end);
            } else {
                this.fireContentsChanged(this, changeInfo.start, end);
            }
        } else {
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

