/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.IconInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class IconAdapter
implements TransformInterface,
Icon {
    public static final IconAdapter defaultInstance = new IconAdapter();
    protected IconInterface iconValue;

    public IconAdapter() {
    }

    public IconAdapter(IconInterface icon) {
        this.iconValue = icon;
    }

    public IconInterface getIcon() {
        return this.iconValue;
    }

    protected Icon newIcon(IconInterface i) {
        return new IconAdapter(i);
    }

    public Object transform(Object o) throws TransformException {
        if (o != null && o instanceof IconInterface) {
            return this.newIcon((IconInterface)o);
        }
        return null;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        IconInterface icon = this.getIcon();
        if (icon == null) {
            return;
        }
        Dimension preferredSize = icon.getPreferredSize();
        icon.paint(c, g, x, y, preferredSize.width, preferredSize.height);
    }

    @Override
    public int getIconWidth() {
        IconInterface icon = this.getIcon();
        if (icon == null) {
            return -1;
        }
        return icon.getPreferredSize().width;
    }

    @Override
    public int getIconHeight() {
        IconInterface icon = this.getIcon();
        if (icon == null) {
            return -1;
        }
        return icon.getPreferredSize().height;
    }
}

