/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.charts;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.models.RangeCollectionInterface;
import com.sas.models.RangeSegmentInterface;
import com.sas.swing.charts.DefaultRangeViewData;
import com.sas.swing.charts.RangeView;
import com.sas.swing.charts.RangeViewDataInterface;
import com.sas.swing.charts.RangeViewRendererInterface;
import com.sas.swing.charts.RangeViewStyle;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.text.Format;

public class TrafficLightRangeViewRenderer
implements RangeViewRendererInterface {
    RangeViewDataInterface rangeViewData;
    RangeViewStyle rangeViewStyle;
    RangeCollectionInterface rangeCollection;
    int orientation = 1;
    private Color foreground = Color.black;
    protected boolean rangeReversed = false;

    public TrafficLightRangeViewRenderer() {
        this.rangeViewData = new DefaultRangeViewData();
    }

    public TrafficLightRangeViewRenderer(RangeViewDataInterface newData) {
        this.rangeViewData = newData;
    }

    @Override
    public void paint(RangeView rangeView, Graphics2D g) {
        this.foreground = rangeView.getForeground();
        this.buildWidget(rangeView, g);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    @Override
    public RangeViewDataInterface getData() {
        return this.rangeViewData;
    }

    @Override
    public void setData(RangeViewDataInterface rvd) {
        this.rangeViewData = rvd;
    }

    @Override
    public RangeViewStyle getStyle() {
        return this.rangeViewStyle;
    }

    @Override
    public void setStyle(RangeViewStyle rvs) {
        this.rangeViewStyle = rvs;
    }

    @Override
    public RangeCollectionInterface getRange() {
        return this.rangeCollection;
    }

    @Override
    public void setRange(RangeCollectionInterface newRangeCollection) {
        this.rangeCollection = newRangeCollection;
    }

    protected boolean isRangeReversed() {
        double minRange0;
        double minRangeN = this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMinimumNumber().doubleValue();
        return minRangeN < (minRange0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue());
    }

    private void buildWidget(RangeView jComponent, Graphics2D gc) {
        Rectangle bounds = jComponent.getBounds();
        Rectangle rect = new Rectangle(jComponent.getBounds());
        Insets insets = jComponent.getInsets();
        rect.x = 0;
        rect.y = 0;
        if ((int)rect.getWidth() == 0) {
            rect.setRect(rect.getX(), rect.getY(), RangeView.getDefaultWidth(), rect.getHeight());
        }
        if ((int)rect.getHeight() == 0) {
            rect.setRect(rect.getX(), rect.getY(), rect.getHeight(), RangeView.getDefaultHeight());
        }
        this.rangeReversed = this.isRangeReversed();
        if (jComponent.isOpaque()) {
            gc.setColor(jComponent.getBackground());
            gc.fillRect(0, 0, (int)rect.getWidth(), (int)rect.getHeight());
        }
        rect.setRect(rect.getX() + (double)insets.left + 2.0, rect.getY() + (double)insets.top + 2.0, rect.getWidth() - (double)insets.left - (double)insets.right - 4.0, rect.getHeight() - (double)insets.top - (double)insets.bottom - 4.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHints(hints);
        double spacingFactor = 0.2;
        double radius = this.calculateRadius(gc, rect, spacingFactor);
        double spacing = spacingFactor * radius;
        Area backdropArea = this.buildBackdrop(gc, rect, spacing, radius);
        this.buildLights(gc, backdropArea, spacing, radius);
        if (this.rangeViewStyle.isValueVisible()) {
            this.buildValueLabel(gc, backdropArea);
        }
    }

    private void buildValueLabel(Graphics2D gc, Area backdropArea) {
        Rectangle2D bounds = backdropArea.getBounds2D();
        gc.setFont(this.rangeViewStyle.getValueFont());
        FontMetrics fm = gc.getFontMetrics();
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        rvValue = (Double)pb.get("value");
        Format formatter = this.rangeViewData.getDisplayValueFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        String rangeLabel = formatter.format(new Double(rvValue)).trim();
        int stringWidth = fm.stringWidth(rangeLabel);
        double xValue = bounds.getCenterX() - (double)stringWidth / 2.0;
        double yValue = bounds.getMaxY() + (double)fm.getHeight();
        gc.setColor(this.rangeViewStyle.getValueColor());
        gc.drawString(rangeLabel, (float)xValue, (float)yValue);
    }

    private Ellipse2D buildLights(Graphics2D gc, Area backdropArea, double spacing, double radius) {
        int numRanges = this.rangeCollection.getSegmentCount();
        Ellipse2D.Double ellipse2D = null;
        Rectangle2D bounds = backdropArea.getBounds2D();
        double startX = bounds.getX() + spacing;
        double startY = bounds.getY() + spacing;
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        rvValue = (Double)pb.get("value");
        RangeSegmentInterface rsi = this.rangeCollection.getSegment(rvValue);
        for (int i = numRanges - 1; i >= 0; --i) {
            boolean lightOn;
            RangeSegmentInterface thisRSI = this.rangeCollection.getSegment(i);
            gc.setColor((Color)thisRSI.get("COLOR"));
            Ellipse2D.Double ellipse = new Ellipse2D.Double(startX, startY, radius * 2.0, radius * 2.0);
            gc.fill(ellipse);
            gc.setColor(this.foreground);
            gc.draw(ellipse);
            boolean bl = lightOn = rvValue < thisRSI.getMaximumNumber().doubleValue() && rvValue >= thisRSI.getMinimumNumber().doubleValue();
            if (!lightOn) {
                if (i == numRanges - 1) {
                    boolean bl2 = this.rangeReversed ? rvValue < thisRSI.getMinimumNumber().doubleValue() : (lightOn = rvValue >= thisRSI.getMaximumNumber().doubleValue());
                }
                if (i == 0) {
                    boolean bl3 = this.rangeReversed ? rvValue >= thisRSI.getMaximumNumber().doubleValue() : (lightOn = rvValue < thisRSI.getMinimumNumber().doubleValue());
                }
            }
            if (!lightOn) {
                Ellipse2D.Double inner = new Ellipse2D.Double(startX + spacing, startY + spacing, (radius - spacing) * 2.0, (radius - spacing) * 2.0);
                gc.fill(inner);
            } else {
                ellipse2D = ellipse;
            }
            startY = startY + radius * 2.0 + spacing;
        }
        return ellipse2D;
    }

    private double calculateRadius(Graphics2D gc, Rectangle2D rect, double spacingFactor) {
        int fontHeight = 0;
        if (this.rangeViewStyle.isValueVisible()) {
            gc.setFont(this.rangeViewStyle.getValueFont());
            FontMetrics fm = gc.getFontMetrics();
            fontHeight = fm.getHeight();
        }
        double wRadius = rect.getWidth() / (2.0 * spacingFactor + 2.0);
        int numRanges = this.rangeCollection.getSegmentCount();
        double hRadius = (rect.getHeight() - (double)fontHeight) / ((double)(numRanges * 2) + 2.0 * spacingFactor * (double)numRanges);
        return Math.min(wRadius, hRadius);
    }

    private Area buildBackdrop(Graphics2D gc, Rectangle2D rect, double spacing, double radius) {
        gc.setColor(this.foreground);
        int fontHeight = 0;
        if (this.rangeViewStyle.isValueVisible()) {
            gc.setFont(this.rangeViewStyle.getValueFont());
            FontMetrics fm = gc.getFontMetrics();
            fontHeight = fm.getHeight();
        }
        Rectangle2D.Double backdropRect = new Rectangle2D.Double();
        int numRanges = this.rangeCollection.getSegmentCount();
        ((Rectangle2D)backdropRect).setRect(rect.getX(), rect.getY() + spacing, radius * 2.0 + spacing * 2.0, radius * (double)numRanges * 2.0 + spacing * (double)numRanges);
        ((Rectangle2D)backdropRect).setRect(((RectangularShape)backdropRect).getX() + (rect.getWidth() - ((RectangularShape)backdropRect).getWidth() - spacing * 2.0) / 2.0, ((RectangularShape)backdropRect).getY() + (rect.getHeight() - ((RectangularShape)backdropRect).getHeight() - spacing * 2.0 - (double)fontHeight) / 2.0, ((RectangularShape)backdropRect).getWidth(), ((RectangularShape)backdropRect).getHeight());
        Area backdropArea = new Area(backdropRect);
        GeneralPath path = new GeneralPath();
        path.moveTo((float)((RectangularShape)backdropRect).getX(), (float)((RectangularShape)backdropRect).getY());
        path.quadTo((float)(((RectangularShape)backdropRect).getX() + ((RectangularShape)backdropRect).getWidth() / 2.0), (float)(((RectangularShape)backdropRect).getY() - spacing), (float)(((RectangularShape)backdropRect).getX() + ((RectangularShape)backdropRect).getWidth()), (float)((RectangularShape)backdropRect).getY());
        path.closePath();
        backdropArea.add(new Area(path));
        path = new GeneralPath();
        path.moveTo((float)((RectangularShape)backdropRect).getX(), (float)((RectangularShape)backdropRect).getY() + (float)((RectangularShape)backdropRect).getHeight());
        path.quadTo((float)(((RectangularShape)backdropRect).getX() + ((RectangularShape)backdropRect).getWidth() / 2.0), (float)(((RectangularShape)backdropRect).getY() + spacing + ((RectangularShape)backdropRect).getHeight()), (float)(((RectangularShape)backdropRect).getX() + ((RectangularShape)backdropRect).getWidth()), (float)(((RectangularShape)backdropRect).getY() + ((RectangularShape)backdropRect).getHeight()));
        path.closePath();
        backdropArea.add(new Area(path));
        backdropArea.transform(AffineTransform.getTranslateInstance(1.0, 2.0));
        gc.draw(backdropArea);
        gc.fill(backdropArea);
        Color backArcColor = new Color(230, 230, 230);
        gc.setColor(backArcColor);
        backdropArea.transform(AffineTransform.getTranslateInstance(-1.0, -2.0));
        gc.draw(backdropArea);
        gc.fill(backdropArea);
        return backdropArea;
    }
}

