/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.charts;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.models.RangeCollectionInterface;
import com.sas.swing.charts.DefaultRangeViewData;
import com.sas.swing.charts.RangeView;
import com.sas.swing.charts.RangeViewDataInterface;
import com.sas.swing.charts.RangeViewRendererInterface;
import com.sas.swing.charts.RangeViewStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Vector;
import javax.swing.Timer;

public class StandardRangeViewRenderer
implements RangeViewRendererInterface {
    RangeViewDataInterface rangeViewData;
    RangeViewStyle rangeViewStyle;
    RangeCollectionInterface rangeCollection;
    protected Color foreground = Color.black;
    protected boolean animationEnabled = false;
    protected double paintValue = 0.0;
    protected double oldValue = 0.0;
    protected double increment = 0.0;
    protected Timer animationTimer = null;
    protected boolean rangeReversed = false;

    public StandardRangeViewRenderer() {
        this(new DefaultRangeViewData());
    }

    public StandardRangeViewRenderer(RangeViewDataInterface newData) {
        this.rangeViewData = newData;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        this.oldValue = (Double)pb.get("value");
    }

    @Override
    public void paint(RangeView rangeView, Graphics2D g) {
        if (this.paintValue != this.oldValue) {
            this.buildWidget(rangeView, g);
            return;
        }
        this.foreground = rangeView.getForeground();
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        double val = (Double)pb.get("value");
        if (this.animationEnabled && val != this.oldValue) {
            ActionListener[] listeners;
            if (this.animationTimer == null) {
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                    }
                };
                this.animationTimer = new Timer(1, listener);
                this.animationTimer.removeActionListener(listener);
                listener = new TimerListener(rangeView, g, val, this.animationTimer);
                this.animationTimer.addActionListener(listener);
            }
            if ((listeners = this.animationTimer.getActionListeners()) != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof TimerListener)) continue;
                    ((TimerListener)listeners[i]).setValue(val);
                }
            }
            this.animationTimer.start();
            this.buildWidget(rangeView, g);
        } else {
            this.paintValue = val;
            this.oldValue = val;
            this.buildWidget(rangeView, g);
        }
    }

    @Override
    public RangeViewDataInterface getData() {
        return this.rangeViewData;
    }

    @Override
    public void setData(RangeViewDataInterface rvd) {
        this.rangeViewData = rvd;
    }

    @Override
    public RangeViewStyle getStyle() {
        return this.rangeViewStyle;
    }

    @Override
    public void setStyle(RangeViewStyle rvs) {
        this.rangeViewStyle = rvs;
    }

    @Override
    public RangeCollectionInterface getRange() {
        return this.rangeCollection;
    }

    @Override
    public void setRange(RangeCollectionInterface newRangeCollection) {
        this.rangeCollection = newRangeCollection;
    }

    protected int getNumberSecondaryValues() {
        int temp = Math.max(0, this.rangeViewData.getDataCount() - 1);
        return Math.min(temp, 4);
    }

    protected boolean isRangeReversed() {
        double minRange0;
        double minRangeN = this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMinimumNumber().doubleValue();
        return minRangeN < (minRange0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue());
    }

    protected void buildWidget(RangeView jComponent, Graphics2D gc) {
        double tempWidth;
        double tempHeight;
        Rectangle rect = new Rectangle(jComponent.getBounds());
        Insets insets = jComponent.getInsets();
        this.rangeReversed = this.isRangeReversed();
        if (rect.width == 0) {
            rect.width = RangeView.getDefaultWidth();
        }
        if (rect.height == 0) {
            rect.height = RangeView.getDefaultHeight();
        }
        if (jComponent.isOpaque()) {
            gc.setColor(jComponent.getBackground());
            gc.fillRect(0, 0, rect.width, rect.height);
        }
        rect.width = rect.width - insets.left - insets.right;
        rect.height = rect.height - insets.top - insets.bottom;
        double strokeWidth = 15.0;
        double targetHeight = 190.0 - strokeWidth;
        double targetWidth = 320.0 - strokeWidth;
        if (targetHeight / targetWidth * (double)rect.width > (double)rect.height) {
            tempHeight = rect.height;
            tempWidth = (double)rect.height * (targetWidth / targetHeight);
        } else {
            tempHeight = (double)rect.width * (targetHeight / targetWidth);
            tempWidth = rect.width;
        }
        double ratio = tempHeight / targetHeight;
        double radius = Math.sqrt(Math.pow(0.5 * tempHeight, 2.0) + Math.pow(tempHeight, 2.0)) - (strokeWidth *= ratio);
        double standardXOffset = 0.5 * tempWidth - strokeWidth / 2.0 - (double)rect.width / 2.0 + ((double)rect.width - tempWidth);
        standardXOffset += (double)insets.left;
        double standardYOffset = tempHeight - (radius * 0.86 + strokeWidth / 2.0 - (strokeWidth - 6.0) / 2.0 + 4.0) + ((double)rect.height - tempHeight);
        standardYOffset = standardYOffset / 2.0 + (double)insets.top;
        double bandWidth = 0.145;
        double bandSpace = 0.0575;
        double bandOffset = 0.02;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHints(hints);
        Area backdropArea = this.buildBackdrop(gc, radius, strokeWidth, tempWidth, standardXOffset, standardYOffset);
        Area colorSegmentsArea = this.buildSegmentArea(backdropArea, radius, strokeWidth, tempWidth, bandWidth, bandSpace, bandOffset, standardXOffset, standardYOffset);
        Vector colorBands = new Vector();
        int numberBands = this.getNumberSecondaryValues();
        if (numberBands != 0) {
            colorBands = this.buildBandAreas(backdropArea, radius, strokeWidth, tempWidth, bandWidth, bandSpace, bandOffset, standardXOffset, standardYOffset);
        }
        int numRange = this.rangeCollection.getSegmentCount();
        double[] seg = new double[numRange + 1];
        double[] labelValue = new double[numRange + 1];
        this.getSegmentValues(numRange, seg, labelValue);
        gc.setColor(this.foreground);
        gc.draw(colorSegmentsArea);
        for (int i = 0; i < colorBands.size(); ++i) {
            gc.draw((Area)colorBands.elementAt(i));
        }
        Vector bandSegments = new Vector();
        Vector colorSegments = this.buildColorSegments(gc, bandSegments, colorSegmentsArea, colorBands, seg, radius, tempWidth, strokeWidth, standardXOffset, standardYOffset);
        Vector bandMarkers = new Vector();
        if (numberBands != 0) {
            bandMarkers = this.buildBandMarkers(gc, bandSegments, radius, strokeWidth, tempWidth, standardXOffset, standardYOffset, ratio);
        }
        Area arrowArea = this.buildArrow(gc, radius, strokeWidth, tempWidth, standardXOffset, standardYOffset, ratio);
        Area valueBaseArea = this.buildHub(gc, radius, strokeWidth, tempWidth, standardXOffset, standardYOffset, ratio);
        if (this.rangeViewStyle.isLabelsVisible()) {
            this.buildRangeLabels(gc, colorSegments, labelValue, radius);
        }
        if (this.rangeViewStyle.isValueVisible()) {
            this.buildValueLabel(gc, valueBaseArea, radius);
        }
    }

    protected Vector getBandColorList(int numBands) {
        Vector<Color> colorList = new Vector<Color>();
        colorList.addElement(new Color(143, 143, 143));
        colorList.addElement(new Color(163, 163, 163));
        colorList.addElement(new Color(184, 184, 184));
        colorList.addElement(new Color(204, 204, 204));
        return colorList;
    }

    protected void getSegmentValues(int numRange, double[] seg, double[] labelValue) {
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
        }
        double delta = valueN - value0;
        seg[0] = 90.0;
        labelValue[0] = this.rangeReversed ? valueN : value0;
        for (int i = 1; i < numRange; ++i) {
            double tempMin = this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue();
            if (this.rangeReversed) {
                tempMin = this.rangeCollection.getSegment(i).getMaximumNumber().doubleValue();
            }
            labelValue[i] = tempMin;
            seg[i] = (1.0 - (tempMin - value0) / delta) * 90.0;
            if (!this.rangeReversed) continue;
            seg[i] = (1.0 - (valueN - tempMin) / delta) * 90.0;
        }
        seg[numRange] = 0.0;
        labelValue[numRange] = this.rangeReversed ? value0 : valueN;
    }

    protected Area buildBackdrop(Graphics2D gc, double radius, double strokeWidth, double tempWidth, double standardXOffset, double standardYOffset) {
        double strokeOffset = strokeWidth / 2.0;
        Arc2D.Double topArc = new Arc2D.Double();
        ((Arc2D)topArc).setArc(0.5 * tempWidth - radius + strokeOffset, strokeOffset, radius * 2.0, radius * 2.0, 45.0, 90.0, 2);
        Arc2D.Double lowerArc = new Arc2D.Double();
        double newRadius = radius * 0.4;
        ((Arc2D)lowerArc).setArc(0.5 * tempWidth - newRadius + strokeOffset, radius - newRadius + strokeOffset, newRadius * 2.0, newRadius * 2.0, 0.0, 360.0, 2);
        Area backdropArc = new Area(topArc);
        backdropArc.subtract(new Area(lowerArc));
        BasicStroke backArcStroke = new BasicStroke((float)strokeWidth, 1, 1);
        gc.setStroke(backArcStroke);
        backdropArc.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        gc.setColor(this.foreground);
        backdropArc.transform(AffineTransform.getTranslateInstance(1.0, 2.0));
        gc.draw(backdropArc);
        gc.fill(backdropArc);
        Color backArcColor = new Color(230, 230, 230);
        gc.setColor(backArcColor);
        backdropArc.transform(AffineTransform.getTranslateInstance(-1.0, -2.0));
        gc.draw(backdropArc);
        gc.fill(backdropArc);
        gc.setStroke(new BasicStroke());
        return backdropArc;
    }

    protected Area buildSegmentArea(Area backdropArea, double radius, double strokeWidth, double tempWidth, double bandWidth, double bandSpace, double bandOffset, double standardXOffset, double standardYOffset) {
        double strokeOffset = strokeWidth / 2.0;
        Arc2D.Double colorArc = new Arc2D.Double();
        double newRadius = radius * 0.9;
        ((Arc2D)colorArc).setArc(0.5 * tempWidth - newRadius + strokeOffset, radius - newRadius + strokeOffset, newRadius * 2.0, newRadius * 2.0, 45.0, 90.0, 2);
        double lowerArcOffset = 0.4;
        int numberBands = this.getNumberSecondaryValues();
        lowerArcOffset = (bandWidth * (double)numberBands + bandSpace * (double)numberBands + bandOffset) * 0.5 + 0.4;
        Arc2D.Double lowerArc = new Arc2D.Double();
        newRadius = radius * lowerArcOffset;
        ((Arc2D)lowerArc).setArc(0.5 * tempWidth - newRadius + strokeOffset, radius - newRadius + strokeOffset, newRadius * 2.0, newRadius * 2.0, 45.0, 90.0, 2);
        Area colorArea = new Area(colorArc);
        colorArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        backdropArea.transform(AffineTransform.getTranslateInstance(0.0, -(radius * 0.02)));
        colorArea.intersect(backdropArea);
        Area newLowerArea = new Area(lowerArc);
        newLowerArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        colorArea.subtract(newLowerArea);
        backdropArea.transform(AffineTransform.getTranslateInstance(0.0, radius * 0.02));
        return colorArea;
    }

    protected Vector buildBandAreas(Area backdropArea, double radius, double strokeWidth, double tempWidth, double bandWidth, double bandSpace, double bandOffset, double standardXOffset, double standardYOffset) {
        Vector<Area> bandArcs = new Vector<Area>();
        double strokeOffset = strokeWidth / 2.0;
        for (int i = 1; i <= this.getNumberSecondaryValues(); ++i) {
            double topArcRadius = ((bandWidth * (double)i + bandSpace * (double)(i - 1) + bandOffset) * 0.5 + 0.4) * radius;
            double botArcRadius = ((bandWidth * (double)(i - 1) + bandSpace * (double)(i - 1) + bandOffset) * 0.5 + 0.4) * radius;
            Arc2D.Double bandArcTop = new Arc2D.Double();
            ((Arc2D)bandArcTop).setArc(0.5 * tempWidth - topArcRadius + strokeOffset, radius - topArcRadius + strokeOffset, topArcRadius * 2.0, topArcRadius * 2.0, 45.0, 90.0, 2);
            Arc2D.Double bandArcBot = new Arc2D.Double();
            ((Arc2D)bandArcBot).setArc(0.5 * tempWidth - botArcRadius + strokeOffset, radius - botArcRadius + strokeOffset, botArcRadius * 2.0, botArcRadius * 2.0, 45.0, 90.0, 2);
            backdropArea.transform(AffineTransform.getTranslateInstance(0.0, -(radius * 0.02)));
            Area bandArea = new Area(bandArcTop);
            bandArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            bandArea.intersect(backdropArea);
            Area newBandArcBot = new Area(bandArcBot);
            newBandArcBot.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            bandArea.subtract(newBandArcBot);
            backdropArea.transform(AffineTransform.getTranslateInstance(0.0, radius * 0.02));
            bandArcs.addElement(bandArea);
        }
        return bandArcs;
    }

    protected Vector buildColorSegments(Graphics2D gc, Vector bandSegments, Area colorArea, Vector bandArcs, double[] seg, double radius, double tempWidth, double strokeWidth, double standardXOffset, double standardYOffset) {
        double strokeOffset = strokeWidth / 2.0;
        Vector<Area> colorSegments = new Vector<Area>();
        gc.setStroke(new BasicStroke(0.5f));
        int numRange = this.rangeCollection.getSegmentCount();
        Vector colorList = this.getBandColorList(numRange);
        for (int i = 0; i < numRange; ++i) {
            Area segmentArea = new Area();
            segmentArea.add(colorArea);
            segmentArea.transform(AffineTransform.getTranslateInstance(0.0, radius * 0.02));
            Arc2D.Double leftArc = new Arc2D.Double();
            ((Arc2D)leftArc).setArc(0.5 * tempWidth - radius + strokeOffset, strokeOffset, radius * 2.0, radius * 2.0, seg[i] + 45.0, 90.0, 2);
            Area newLeftArea = new Area(leftArc);
            newLeftArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            segmentArea.subtract(newLeftArea);
            Arc2D.Double rightArc = new Arc2D.Double();
            ((Arc2D)rightArc).setArc(0.5 * tempWidth - radius + strokeOffset, strokeOffset, radius * 2.0, radius * 2.0, 0.0, seg[i + 1] + 45.0, 2);
            Area newRightArea = new Area(rightArc);
            newRightArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            segmentArea.subtract(newRightArea);
            segmentArea.transform(AffineTransform.getTranslateInstance(0.0, -(radius * 0.02)));
            gc.setColor((Color)this.rangeCollection.getSegment(i).get("COLOR"));
            gc.fill(segmentArea);
            gc.setColor(this.foreground);
            gc.draw(segmentArea);
            colorSegments.add(new Area(segmentArea));
            for (int j = 0; j < bandArcs.size(); ++j) {
                segmentArea = new Area();
                segmentArea.add((Area)bandArcs.elementAt(j));
                segmentArea.transform(AffineTransform.getTranslateInstance(0.0, radius * 0.02));
                Area newLeftArea2 = new Area(leftArc);
                newLeftArea2.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
                Area newRightArea2 = new Area(rightArc);
                newRightArea2.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
                segmentArea.subtract(newLeftArea2);
                segmentArea.subtract(newRightArea2);
                segmentArea.transform(AffineTransform.getTranslateInstance(0.0, -(radius * 0.02)));
                gc.setColor((Color)colorList.elementAt(j));
                gc.fill(segmentArea);
                gc.setColor(this.foreground);
                gc.draw(segmentArea);
                bandSegments.add(segmentArea);
            }
        }
        return colorSegments;
    }

    protected Area buildArrow(Graphics2D gc, double radius, double strokeWidth, double tempWidth, double standardXOffset, double standardYOffset, double ratio) {
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        double strokeOffset = strokeWidth / 2.0;
        Rectangle2D.Double pointer = new Rectangle2D.Double(0.0, 0.0, radius * 0.75, 4.0 * ratio);
        GeneralPath pointerTip = new GeneralPath();
        pointerTip.moveTo((float)(radius * 0.745), 0.0f);
        pointerTip.lineTo((float)(radius * 0.84), (float)(2.5 * ratio));
        pointerTip.lineTo((float)(radius * 0.745), (float)(4.0 * ratio));
        pointerTip.lineTo((float)(radius * 0.745), 0.0f);
        Rectangle2D.Double removeThis = new Rectangle2D.Double(0.0, 0.0, radius * 0.2, 4.0 * ratio);
        Area arrowArea = new Area(pointer);
        arrowArea.add(new Area(pointerTip));
        arrowArea.subtract(new Area(removeThis));
        double rvValue = 0.0;
        rvValue = this.paintValue;
        double arrowAngle = 46.0;
        if (delta != 0.0) {
            arrowAngle = (1.0 - (rvValue - value0) / delta) * 90.0 + 45.0 + 1.0;
            if (this.rangeReversed) {
                arrowAngle = (1.0 - (valueN - rvValue) / delta) * 90.0 + 45.0 + 1.0;
            }
        } else {
            arrowAngle = rvValue > value0 ? 46.0 : (rvValue < value0 ? 136.0 : 91.0);
        }
        arrowAngle = Math.max(46.0, arrowAngle);
        arrowAngle = Math.min(136.0, arrowAngle);
        double angleRadians = -(arrowAngle / 360.0) * 2.0 * Math.PI;
        double tempValue = Math.max(value0, Math.min(rvValue, valueN));
        Color arrowHubColor = (Color)this.rangeCollection.getSegment(tempValue).get("COLOR");
        Area highlightArea = new Area();
        highlightArea.add(arrowArea);
        highlightArea.transform(AffineTransform.getTranslateInstance(0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset - 1.0));
        highlightArea.transform(AffineTransform.getRotateInstance(angleRadians, 0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset));
        highlightArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        gc.setColor(Color.white);
        gc.draw(highlightArea);
        gc.setStroke(new BasicStroke(1.5f));
        arrowArea.transform(AffineTransform.getTranslateInstance(0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset));
        arrowArea.transform(AffineTransform.getRotateInstance(angleRadians, 0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset));
        arrowArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        gc.setColor(arrowHubColor);
        gc.fill(arrowArea);
        gc.setColor(this.foreground);
        gc.draw(arrowArea);
        return arrowArea;
    }

    protected Vector buildBandMarkers(Graphics2D gc, Vector bandArcs, double radius, double strokeWidth, double tempWidth, double standardXOffset, double standardYOffset, double ratio) {
        int i;
        gc.setStroke(new BasicStroke(2.0f));
        int numBands = this.getNumberSecondaryValues();
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
        }
        double delta = valueN - value0;
        double strokeOffset = strokeWidth / 2.0;
        Vector<Area> bandMarkers = new Vector<Area>();
        double[] secondaryValues = new double[this.rangeViewData.getDataCount() - 1];
        int dataCount = this.rangeViewData.getDataCount();
        for (i = 1; i < dataCount; ++i) {
            StaticPropertyBagInterface pbi = this.rangeViewData.getDataAt(i);
            secondaryValues[dataCount - 1 - i] = (Double)pbi.get("value");
        }
        for (i = 0; i < numBands; ++i) {
            Rectangle2D.Double bandPointer = new Rectangle2D.Double(0.0, 0.0, radius * 0.9, 4.0 * ratio);
            Area bandValueArea = new Area(bandPointer);
            double bandValue = secondaryValues[i];
            double minValue = this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMinimumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
            double maxValue = !this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMaximumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            double tempValue = Math.max(minValue, Math.min(maxValue, bandValue));
            Color bandColor = (Color)this.rangeCollection.getSegment(tempValue).get("COLOR");
            double arrowAngle = (1.0 - (bandValue - value0) / delta) * 90.0 + 45.0 + 1.0;
            if (this.rangeReversed) {
                arrowAngle = (1.0 - (valueN - bandValue) / delta) * 90.0 + 45.0 + 1.0;
            }
            arrowAngle = Math.max(45.0, arrowAngle);
            arrowAngle = Math.min(135.0, arrowAngle);
            double angleRadians = -(arrowAngle / 360.0) * 2.0 * Math.PI;
            Area entireBand = new Area((Area)bandArcs.elementAt(i));
            for (int j = 1; j < numRange; ++j) {
                entireBand.add((Area)bandArcs.elementAt(i + j * numBands));
            }
            Area highlightArea = new Area();
            highlightArea.add(bandValueArea);
            highlightArea.transform(AffineTransform.getTranslateInstance(0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset - 1.0));
            highlightArea.transform(AffineTransform.getRotateInstance(angleRadians, 0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset));
            highlightArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            highlightArea.intersect(entireBand);
            gc.setColor(Color.white);
            gc.draw(highlightArea);
            bandValueArea.transform(AffineTransform.getTranslateInstance(0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset));
            bandValueArea.transform(AffineTransform.getRotateInstance(angleRadians, 0.5 * tempWidth + strokeOffset, radius * 0.98 + strokeOffset));
            bandValueArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            bandValueArea.intersect(entireBand);
            gc.setColor(bandColor);
            gc.fill(bandValueArea);
            gc.setColor(this.foreground);
            gc.draw(bandValueArea);
            bandMarkers.addElement(bandValueArea);
        }
        return bandMarkers;
    }

    protected Area buildHub(Graphics2D gc, double radius, double strokeWidth, double tempWidth, double standardXOffset, double standardYOffset, double ratio) {
        double strokeOffset = strokeWidth / 2.0;
        Arc2D.Double valueBaseArc = new Arc2D.Double();
        double newRadius = 0.3 * radius;
        ((Arc2D)valueBaseArc).setArc(0.5 * tempWidth - newRadius + strokeOffset, radius - newRadius + strokeOffset, newRadius * 2.0, newRadius * 2.0, 45.0, 90.0, 2);
        Area valueBaseArea = new Area(valueBaseArc);
        newRadius = 0.14 * radius;
        Rectangle2D.Double valueBaseRect = new Rectangle2D.Double(0.0, radius - newRadius, tempWidth, radius);
        valueBaseArea.subtract(new Area(valueBaseRect));
        strokeWidth -= 6.0 * ratio;
        strokeWidth = Math.max(1.0, strokeWidth);
        valueBaseArea.transform(AffineTransform.getTranslateInstance(0.0, 3.0));
        valueBaseArea.transform(AffineTransform.getTranslateInstance(1.0, 1.0));
        gc.setColor(this.foreground);
        gc.setStroke(new BasicStroke((float)strokeWidth));
        valueBaseArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        gc.draw(valueBaseArea);
        valueBaseArea.transform(AffineTransform.getTranslateInstance(-1.0, -1.0));
        Color backArcColor = new Color(230, 230, 230);
        gc.setColor(backArcColor);
        gc.draw(valueBaseArea);
        double rvValue = this.oldValue;
        double minValue = this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMinimumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double maxValue = !this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMaximumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
        double tempValue = Math.max(minValue, Math.min(maxValue, rvValue));
        Color arrowHubColor = (Color)this.rangeCollection.getSegment(tempValue).get("COLOR");
        gc.setColor(arrowHubColor);
        gc.fill(valueBaseArea);
        gc.setColor(this.foreground);
        gc.setStroke(new BasicStroke(0.85f));
        gc.draw(valueBaseArea);
        return valueBaseArea;
    }

    protected void buildRangeLabels(Graphics2D gc, Vector colorSegments, double[] labelValue, double radius) {
        int firstSeg;
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        gc.setColor(this.rangeViewStyle.getLabelColor());
        gc.setFont(this.rangeViewStyle.getLabelFont());
        double halfRange = delta / 2.0 + value0;
        Format formatter = this.rangeViewData.getDisplayValueFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        FontRenderContext frc = gc.getFontRenderContext();
        Area rangeArea = new Area();
        for (firstSeg = 0; rangeArea.isEmpty() && firstSeg < numRange; ++firstSeg) {
            rangeArea = (Area)colorSegments.elementAt(firstSeg);
        }
        double[] coordinates = new double[6];
        PathIterator path = rangeArea.getPathIterator(null, 1.0);
        coordinates = new double[6];
        path.currentSegment(coordinates);
        Rectangle2D rangeRect = rangeArea.getBounds2D();
        float xInt = (float)rangeRect.getX();
        while (!path.isDone() && Math.abs((double)xInt - coordinates[0]) > 0.001) {
            path.currentSegment(coordinates);
            path.next();
        }
        String rangeLabel = formatter.format(new Double(labelValue[firstSeg - 1])).trim();
        Rectangle2D stringBounds = gc.getFont().getStringBounds(rangeLabel, frc);
        float stringWidth = (float)stringBounds.getWidth();
        float yInt = (float)(coordinates[1] - radius * 0.025);
        xInt = (float)((double)(xInt - stringWidth) + radius * 0.015);
        gc.drawString(rangeLabel, xInt, yInt);
        int lastSeg = numRange;
        rangeArea = new Area();
        while (rangeArea.isEmpty() && lastSeg > 0) {
            rangeArea = (Area)colorSegments.elementAt(--lastSeg);
        }
        path = rangeArea.getPathIterator(null, 1.0);
        path.currentSegment(coordinates);
        rangeRect = rangeArea.getBounds2D();
        xInt = (float)rangeRect.getMaxX();
        while (!path.isDone() && Math.abs((double)xInt - coordinates[0]) > 0.001) {
            path.currentSegment(coordinates);
            path.next();
        }
        rangeLabel = formatter.format(new Double(labelValue[lastSeg + 1])).trim();
        yInt = (float)(coordinates[1] - radius * 0.025);
        xInt = (float)((double)xInt - radius * 0.015);
        gc.drawString(rangeLabel, xInt, yInt);
        for (int i = firstSeg; i < lastSeg + 1; ++i) {
            int nextSeg;
            int prevSeg = i;
            Area prevArea = new Area();
            Area nextArea = new Area();
            while (prevArea.isEmpty() && prevSeg > 0) {
                prevArea = (Area)colorSegments.elementAt(--prevSeg);
            }
            for (nextSeg = i; nextArea.isEmpty() && nextSeg < numRange; ++nextSeg) {
                nextArea = (Area)colorSegments.elementAt(nextSeg);
            }
            i = nextSeg - 1;
            rangeLabel = formatter.format(new Double(labelValue[i])).trim();
            if (prevArea.isEmpty() || nextArea.isEmpty()) continue;
            Rectangle prevRange = prevArea.getBounds();
            Rectangle nextRange = nextArea.getBounds();
            stringBounds = gc.getFont().getStringBounds(rangeLabel, frc);
            stringWidth = (float)stringBounds.getWidth();
            if (labelValue[i] < halfRange && !this.rangeReversed || labelValue[i] > halfRange && this.rangeReversed) {
                xInt = (float)((RectangularShape)nextRange).getX();
                yInt = (float)((RectangularShape)prevRange).getY();
                xInt -= stringWidth;
            } else if (labelValue[i] > halfRange && !this.rangeReversed || labelValue[i] < halfRange && this.rangeReversed) {
                xInt = (float)prevRange.getMaxX();
                yInt = (float)((RectangularShape)nextRange).getY();
            } else {
                xInt = (float)((RectangularShape)nextRange).getX();
                yInt = (float)((RectangularShape)prevRange).getY();
                xInt -= stringWidth / 2.0f;
            }
            gc.drawString(rangeLabel, xInt, yInt -= (float)(radius * 0.015));
        }
    }

    protected void buildValueLabel(Graphics2D gc, Area valueBaseArea, double radius) {
        Format formatter = this.rangeViewData.getDisplayValueFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D valueBaseBounds = valueBaseArea.getBounds2D();
        float xInt = (float)valueBaseBounds.getCenterX();
        float yInt = (float)(valueBaseBounds.getMaxY() - 0.01 * radius);
        gc.setFont(this.rangeViewStyle.getValueFont());
        frc = gc.getFontRenderContext();
        double rvValue = this.oldValue;
        String valueLabel = formatter.format(new Double(rvValue)).trim();
        Rectangle2D stringBounds = gc.getFont().getStringBounds(valueLabel, frc);
        float stringWidth = (float)stringBounds.getWidth();
        xInt = (float)((double)xInt - (double)stringWidth / 2.0);
        if (this.rangeViewStyle.getValueTextHighlight()) {
            gc.setColor(Color.white);
            gc.drawString(valueLabel, xInt - 1.0f, yInt - 1.0f);
        }
        gc.setColor(this.rangeViewStyle.getValueColor());
        gc.drawString(valueLabel, xInt, yInt);
    }

    class TimerListener
    implements ActionListener {
        RangeView rangeView;
        Graphics2D g;
        double val;
        Timer timer;

        public TimerListener(RangeView rv, Graphics2D gc, double value, Timer time) {
            this.rangeView = rv;
            this.g = gc;
            this.val = value;
            this.timer = time;
        }

        public void setValue(double value) {
            this.val = value;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (StandardRangeViewRenderer.this.paintValue != this.val) {
                StandardRangeViewRenderer.this.increment = (this.val - StandardRangeViewRenderer.this.oldValue) / 50.0;
            }
            if (StandardRangeViewRenderer.this.increment == 0.0) {
                StandardRangeViewRenderer.this.increment = 1.0;
            }
            StandardRangeViewRenderer.this.paintValue += StandardRangeViewRenderer.this.increment;
            if (StandardRangeViewRenderer.this.increment > 0.0) {
                if (StandardRangeViewRenderer.this.paintValue >= this.val) {
                    StandardRangeViewRenderer.this.paintValue = this.val;
                    StandardRangeViewRenderer.this.oldValue = this.val;
                    StandardRangeViewRenderer.this.increment = 0.0;
                    this.timer.stop();
                }
            } else if (StandardRangeViewRenderer.this.paintValue <= this.val) {
                StandardRangeViewRenderer.this.paintValue = this.val;
                StandardRangeViewRenderer.this.oldValue = this.val;
                StandardRangeViewRenderer.this.increment = 0.0;
                this.timer.stop();
            }
            this.rangeView.repaint();
        }
    }
}

