/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.charts;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.models.RangeCollectionInterface;
import com.sas.swing.charts.DefaultRangeViewData;
import com.sas.swing.charts.RangeView;
import com.sas.swing.charts.RangeViewDataInterface;
import com.sas.swing.charts.RangeViewRendererInterface;
import com.sas.swing.charts.RangeViewStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.Timer;

public class SliderRangeViewRenderer
implements RangeViewRendererInterface {
    RangeViewDataInterface rangeViewData;
    RangeViewStyle rangeViewStyle;
    RangeCollectionInterface rangeCollection;
    int orientation = 0;
    int maxBandSize = 10;
    private Color foreground = Color.black;
    private Font adjustedLabelsFont;
    private boolean adjustedLabelsVisible;
    private Font adjustedValueFont;
    private boolean adjustedValueVisible;
    private int adjustedMaxBandSize;
    private Area[] colorSegments;
    private Area colorSegmentsArea;
    private Rectangle2D[] labelPositions;
    private Area backdropArea;
    private Area indicatorArea;
    private Rectangle2D valuePosition;
    private Area secondaryIndicatorArea;
    private int maxLabelWidth;
    protected boolean animationEnabled = false;
    protected Timer animationTimer = null;
    protected double paintValue = 0.0;
    protected double oldValue = 0.0;
    protected double increment = 0.0;
    private boolean rangeReversed = false;
    Rectangle drawSpace = new Rectangle();
    double strokeWidth = 15.0;
    double[] segmentValues;
    Format formatter;

    public SliderRangeViewRenderer() {
        this.rangeViewData = new DefaultRangeViewData();
    }

    public SliderRangeViewRenderer(RangeViewDataInterface newData) {
        this.rangeViewData = newData;
    }

    @Override
    public void paint(RangeView rangeView, Graphics2D g) {
        if (this.paintValue != this.oldValue) {
            this.buildWidget(rangeView, g);
            return;
        }
        this.foreground = rangeView.getForeground();
        g.setFont(this.rangeViewStyle.getLabelFont());
        this.adjustedLabelsFont = g.getFont();
        this.adjustedLabelsVisible = this.rangeViewStyle.isLabelsVisible();
        g.setFont(this.rangeViewStyle.getValueFont());
        this.adjustedValueFont = g.getFont();
        this.adjustedValueVisible = this.rangeViewStyle.isValueVisible();
        this.adjustedMaxBandSize = this.maxBandSize;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        double val = (Double)pb.get("value");
        if (this.animationEnabled && val != this.oldValue) {
            ActionListener[] listeners;
            if (this.animationTimer == null) {
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                    }
                };
                this.animationTimer = new Timer(1, listener);
                this.animationTimer.removeActionListener(listener);
                listener = new TimerListener(rangeView, g, val, this.animationTimer);
                this.animationTimer.addActionListener(listener);
            }
            if ((listeners = this.animationTimer.getActionListeners()) != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof TimerListener)) continue;
                    ((TimerListener)listeners[i]).setValue(val);
                }
            }
            this.animationTimer.start();
            this.buildWidget(rangeView, g);
        } else {
            this.paintValue = val;
            this.oldValue = val;
            this.buildWidget(rangeView, g);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    public int getMaxBandSize() {
        return this.maxBandSize;
    }

    public void setMaxBandSize(int band) {
        this.maxBandSize = band;
    }

    @Override
    public RangeViewDataInterface getData() {
        return this.rangeViewData;
    }

    @Override
    public void setData(RangeViewDataInterface rvd) {
        this.rangeViewData = rvd;
    }

    @Override
    public RangeViewStyle getStyle() {
        return this.rangeViewStyle;
    }

    @Override
    public void setStyle(RangeViewStyle rvs) {
        this.rangeViewStyle = rvs;
    }

    @Override
    public RangeCollectionInterface getRange() {
        return this.rangeCollection;
    }

    @Override
    public void setRange(RangeCollectionInterface newRangeCollection) {
        this.rangeCollection = newRangeCollection;
    }

    private boolean isRangeReversed() {
        double minRange0;
        double minRangeN = this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMinimumNumber().doubleValue();
        return minRangeN < (minRange0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue());
    }

    private void buildWidget(RangeView jComponent, Graphics2D gc) {
        if (jComponent.isOpaque()) {
            gc.setColor(jComponent.getBackground());
            gc.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.rangeReversed = this.isRangeReversed();
        this.formatter = this.rangeViewData.getDisplayValueFormat();
        if (this.formatter == null) {
            this.formatter = new DecimalFormat(new String("#0.##"));
        }
        this.drawSpace = new Rectangle(jComponent.getBounds());
        Insets insets = jComponent.getInsets();
        this.drawSpace.width = this.drawSpace.width - insets.left - insets.right;
        this.drawSpace.height = this.drawSpace.height - insets.top - insets.bottom;
        this.drawSpace.x = insets.left;
        this.drawSpace.y = insets.right;
        this.segmentValues = this.getSegmentValues();
        if ((this.adjustedValueVisible || this.adjustedLabelsVisible) && !this.reduceFontSizes(gc)) {
            return;
        }
        this.calculateColorBandArea(gc);
        this.calculateSegments();
        if (this.adjustedLabelsVisible) {
            this.calculateRangeLabelSize(gc);
        }
        this.calculateBackdrop(gc);
        this.calculateIndicator();
        if (this.adjustedValueVisible) {
            this.calculateValueLabel(gc);
        }
        if (this.rangeViewData.getDataCount() > 1) {
            this.calculateSecondaryIndicator();
        }
        this.repositionAreas();
        this.drawSlider(gc);
    }

    private void drawSlider(Graphics2D gc) {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHints(hints);
        this.renderBackdrop(gc);
        this.renderColorSegments(gc);
        if (this.adjustedLabelsVisible) {
            this.renderRangeLabels(gc);
        }
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        rvValue = this.paintValue;
        this.renderIndicator(gc, rvValue);
        if (this.adjustedValueVisible) {
            this.renderValueLabel(gc, this.oldValue);
        }
        if (this.rangeViewData.getDataCount() > 1) {
            this.renderSecondaryIndicator(gc);
        }
    }

    private void renderSecondaryIndicator(Graphics2D gc) {
        gc.setColor(Color.white);
        gc.fill(this.secondaryIndicatorArea);
        gc.setColor(this.foreground);
        gc.draw(this.secondaryIndicatorArea);
    }

    private void renderValueLabel(Graphics2D gc, double rvValue) {
        gc.setFont(this.adjustedValueFont);
        gc.setColor(this.rangeViewStyle.getValueColor());
        gc.drawString(this.formatter.format(new Double(rvValue)).trim(), (int)this.valuePosition.getX(), (int)this.valuePosition.getY());
    }

    private void renderIndicator(Graphics2D gc, double rvValue) {
        double minValue = this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMinimumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double maxValue = !this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMaximumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
        double tempValue = Math.max(minValue, Math.min(maxValue, rvValue));
        Color arrowHubColor = (Color)this.rangeCollection.getSegment(tempValue).get("COLOR");
        gc.setColor(arrowHubColor);
        gc.fill(this.indicatorArea);
        gc.setColor(this.foreground);
        gc.draw(this.indicatorArea);
    }

    private void renderRangeLabels(Graphics2D gc) {
        gc.setFont(this.adjustedLabelsFont);
        gc.setColor(this.rangeViewStyle.getLabelColor());
        for (int i = 0; i < this.labelPositions.length; ++i) {
            gc.drawString(this.formatter.format(new Double(this.segmentValues[i])).trim(), (int)this.labelPositions[i].getX(), (int)this.labelPositions[i].getY());
        }
    }

    private void renderColorSegments(Graphics2D gc) {
        for (int i = 0; i < this.colorSegments.length; ++i) {
            gc.setColor((Color)this.rangeCollection.getSegment(i).get("COLOR"));
            gc.fill(this.colorSegments[i]);
        }
        gc.setColor(this.foreground);
        gc.draw(this.colorSegmentsArea);
    }

    private void renderBackdrop(Graphics2D gc) {
        BasicStroke backArcStroke = new BasicStroke((float)this.strokeWidth, 1, 1);
        gc.setStroke(backArcStroke);
        gc.setColor(this.foreground);
        this.backdropArea.transform(AffineTransform.getTranslateInstance(1.0, 2.0));
        gc.draw(this.backdropArea);
        Color backArcColor = new Color(230, 230, 230);
        gc.setColor(backArcColor);
        this.backdropArea.transform(AffineTransform.getTranslateInstance(-1.0, -2.0));
        gc.draw(this.backdropArea);
        gc.fill(this.backdropArea);
        gc.setStroke(new BasicStroke());
    }

    private boolean reduceFontSizes(Graphics2D gc) {
        Rectangle2D bounds;
        FontRenderContext frc;
        String rangeLabel;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        Double rvValue = (Double)pb.get("value");
        rvValue = new Double(this.paintValue);
        if (this.adjustedValueVisible && this.rangeViewStyle.getValuePlacement() == 1) {
            rangeLabel = this.formatter.format(rvValue).trim();
            gc.setFont(this.adjustedValueFont);
            frc = gc.getFontRenderContext();
            bounds = this.adjustedValueFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
            while (bounds.getWidth() > this.drawSpace.getWidth()) {
                this.adjustedValueFont = new Font(this.adjustedValueFont.getName(), this.adjustedValueFont.getStyle(), this.adjustedValueFont.getSize() - 1);
                bounds = this.adjustedValueFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
            }
        }
        if (this.orientation == 0) {
            rangeLabel = this.formatter.format(rvValue).trim();
            gc.setFont(this.adjustedValueFont);
            frc = gc.getFontRenderContext();
            bounds = this.adjustedValueFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
            double valueHeight = this.rangeViewStyle.isValueVisible() ? bounds.getHeight() : 0.0;
            bounds = this.adjustedLabelsFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
            double labelHeight = this.rangeViewStyle.isLabelsVisible() ? bounds.getHeight() : 0.0;
            double swValue = this.strokeWidth * 3.0;
            while (labelHeight + swValue + valueHeight + (double)this.adjustedMaxBandSize > this.drawSpace.getHeight()) {
                if (this.adjustedLabelsVisible && this.adjustedLabelsFont.getSize() > 6) {
                    this.decrementFontSize();
                    bounds = this.adjustedValueFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
                    valueHeight = bounds.getHeight();
                    bounds = this.adjustedLabelsFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
                    labelHeight = bounds.getHeight();
                    continue;
                }
                if (this.adjustedLabelsVisible) {
                    this.adjustedLabelsVisible = false;
                    labelHeight = 0.0;
                    continue;
                }
                if (this.adjustedValueVisible) {
                    this.adjustedValueVisible = false;
                    valueHeight = 0.0;
                    swValue = this.strokeWidth * 2.0;
                    continue;
                }
                if (this.adjustedMaxBandSize > 1) {
                    --this.adjustedMaxBandSize;
                    swValue = this.strokeWidth * 2.0;
                    continue;
                }
                return false;
            }
        } else {
            double maxLabelSize = 0.0;
            if (this.adjustedLabelsVisible) {
                maxLabelSize = this.getMaxLabelSize(gc);
            }
            double valueLength = 0.0;
            if (this.adjustedValueVisible && this.rangeViewStyle.getValuePlacement() == 0) {
                valueLength = this.getValueLength(gc, rvValue);
            }
            while (maxLabelSize + valueLength + (double)this.adjustedMaxBandSize + this.strokeWidth * 2.0 > this.drawSpace.getWidth()) {
                if (this.adjustedLabelsVisible && this.adjustedLabelsFont.getSize() > 6) {
                    this.decrementFontSize();
                    maxLabelSize = this.getMaxLabelSize(gc);
                    valueLength = this.getValueLength(gc, rvValue);
                    continue;
                }
                if (this.adjustedLabelsVisible) {
                    this.adjustedLabelsVisible = false;
                    maxLabelSize = 0.0;
                    continue;
                }
                if (this.adjustedValueVisible) {
                    this.adjustedValueVisible = false;
                    valueLength = 0.0;
                    continue;
                }
                if (this.adjustedMaxBandSize > 1) {
                    --this.adjustedMaxBandSize;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private double getValueLength(Graphics2D gc, Double rvValue) {
        double valueLength = 0.0;
        gc.setFont(this.adjustedValueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        String valueLabel = this.formatter.format(rvValue).trim();
        Rectangle2D bounds = this.adjustedValueFont.createGlyphVector(frc, valueLabel).getVisualBounds();
        valueLength = bounds.getWidth();
        return valueLength;
    }

    private double getMaxLabelSize(Graphics2D gc) {
        double maxLabelSize = 0.0;
        gc.setFont(this.adjustedLabelsFont);
        FontRenderContext frc = gc.getFontRenderContext();
        FontMetrics fm = gc.getFontMetrics();
        for (int i = 0; i < this.segmentValues.length; ++i) {
            String rangeLabel = this.formatter.format(new Double(this.segmentValues[i])).trim();
            Rectangle2D bounds = this.adjustedLabelsFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
            maxLabelSize = Math.max(maxLabelSize, 4.0 + (double)fm.stringWidth(rangeLabel) + (double)fm.charWidth('a') / 2.0);
        }
        return maxLabelSize;
    }

    private void decrementFontSize() {
        int decrement = (int)((double)this.adjustedValueFont.getSize() * (1.0 / (double)this.adjustedLabelsFont.getSize()));
        int adjustedFontSize = Math.max(6, this.adjustedValueFont.getSize() - decrement);
        this.adjustedValueFont = new Font(this.adjustedValueFont.getName(), this.adjustedValueFont.getStyle(), adjustedFontSize);
        this.adjustedLabelsFont = new Font(this.adjustedLabelsFont.getName(), this.adjustedLabelsFont.getStyle(), this.adjustedLabelsFont.getSize() - 1);
    }

    private void repositionAreas() {
        if (this.orientation == 0) {
            int i;
            int componentHeight = (int)this.drawSpace.getHeight();
            int sliderHeight = 0;
            if (this.adjustedValueVisible) {
                sliderHeight = (int)((double)sliderHeight + (this.valuePosition.getHeight() + this.strokeWidth * 1.5));
            }
            sliderHeight = (int)((double)sliderHeight + this.backdropArea.getBounds().getHeight());
            double minY = this.backdropArea.getBounds().getY();
            if (this.adjustedValueVisible && this.rangeViewStyle.getValuePlacement() == 1) {
                minY = Math.min(this.valuePosition.getY(), minY);
            } else if (this.adjustedValueVisible) {
                minY = Math.min(this.valuePosition.getY() - this.valuePosition.getHeight(), minY);
            }
            double delta = Math.max(0.0, Math.max((double)(componentHeight - sliderHeight) / 2.0, 0.0) + (this.drawSpace.getBounds().getY() - minY));
            if (this.adjustedValueVisible) {
                this.valuePosition.setRect(this.valuePosition.getX(), this.valuePosition.getY() + delta, this.valuePosition.getWidth(), this.valuePosition.getHeight());
            }
            AffineTransform transform = AffineTransform.getTranslateInstance(0.0, delta);
            this.backdropArea.transform(transform);
            for (i = 0; i < this.colorSegments.length; ++i) {
                this.colorSegments[i].transform(transform);
            }
            this.colorSegmentsArea.transform(transform);
            if (this.adjustedLabelsVisible) {
                for (i = 0; i < this.labelPositions.length; ++i) {
                    this.labelPositions[i].setRect(this.labelPositions[i].getX(), this.labelPositions[i].getY() + delta, this.labelPositions[i].getWidth(), this.labelPositions[i].getHeight());
                }
            }
            this.indicatorArea.transform(transform);
            if (this.rangeViewData.getDataCount() > 1) {
                this.secondaryIndicatorArea.transform(transform);
            }
        } else {
            int componentWidth = (int)this.drawSpace.getWidth();
            int sliderWidth = 0;
            if (this.adjustedValueVisible && this.rangeViewStyle.getValuePlacement() == 0) {
                sliderWidth = (int)((double)sliderWidth + this.valuePosition.getWidth());
            }
            sliderWidth = (int)((double)sliderWidth + this.backdropArea.getBounds().getWidth());
            double minX = this.backdropArea.getBounds().getX();
            if (this.adjustedValueVisible) {
                Math.min(this.valuePosition.getX(), minX);
            }
            double delta = (this.drawSpace.getBounds().getX() - minX) * 2.0 + (double)componentWidth - (double)sliderWidth;
            if (sliderWidth - componentWidth <= 0) {
                int i;
                if (this.adjustedValueVisible) {
                    this.valuePosition.setRect(this.valuePosition.getX() + delta / 2.0, this.valuePosition.getY(), this.valuePosition.getWidth(), this.valuePosition.getHeight());
                }
                AffineTransform transform = AffineTransform.getTranslateInstance(delta / 2.0, 0.0);
                this.backdropArea.transform(transform);
                for (i = 0; i < this.colorSegments.length; ++i) {
                    this.colorSegments[i].transform(transform);
                }
                this.colorSegmentsArea.transform(transform);
                if (this.adjustedLabelsVisible) {
                    for (i = 0; i < this.labelPositions.length; ++i) {
                        this.labelPositions[i].setRect(this.labelPositions[i].getX() + delta / 2.0, this.labelPositions[i].getY(), this.labelPositions[i].getWidth(), this.labelPositions[i].getHeight());
                    }
                }
                this.indicatorArea.transform(transform);
                if (this.rangeViewData.getDataCount() > 1) {
                    this.secondaryIndicatorArea.transform(transform);
                }
            }
        }
    }

    private void calculateValueLabel(Graphics2D gc) {
        double valueY;
        double valueX;
        Rectangle2D indicatorRect = this.indicatorArea.getBounds2D();
        double indWidth = indicatorRect.getWidth();
        double indHeight = indicatorRect.getHeight();
        double indX = indicatorRect.getX();
        double indY = indicatorRect.getY();
        gc.setFont(this.adjustedValueFont);
        FontMetrics fm = gc.getFontMetrics();
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        rvValue = (Double)pb.get("value");
        rvValue = this.oldValue;
        String rangeLabel = this.formatter.format(new Double(rvValue)).trim();
        double stringWidth = fm.stringWidth(rangeLabel);
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D bounds = this.adjustedValueFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
        double stringHeight = bounds.getHeight();
        if (this.rangeViewStyle.getValuePlacement() == 1) {
            Rectangle2D backdropRect = this.backdropArea.getBounds2D();
            valueX = backdropRect.getMinX() + backdropRect.getWidth() / 2.0 - stringWidth / 2.0;
            valueY = backdropRect.getMinY() + backdropRect.getHeight() + stringHeight + this.strokeWidth;
        } else if (this.orientation == 0) {
            valueX = indX + indWidth / 2.0 - stringWidth / 2.0;
            valueY = indY - 3.0;
        } else {
            valueX = indX + indWidth + 4.0;
            valueY = indY + indHeight / 2.0 + stringHeight / 2.0;
        }
        bounds.setRect(valueX, valueY, bounds.getWidth(), bounds.getHeight());
        this.valuePosition = bounds;
    }

    private void calculateSecondaryIndicator() {
        double rightY;
        double leftY;
        double rightX;
        double leftX;
        double pointerY;
        double pointerX;
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(1);
        rvValue = (Double)pb.get("value");
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        if (this.rangeReversed) {
            relativePosition = Math.min(Math.max((valueN - rvValue) / delta, 0.0), 1.0);
        }
        Rectangle2D colorSegmentsBounds = this.colorSegmentsArea.getBounds2D();
        double yValue = colorSegmentsBounds.getY();
        double rectWidth = colorSegmentsBounds.getWidth();
        double rectHeight = colorSegmentsBounds.getHeight();
        double xValue = colorSegmentsBounds.getX();
        if (this.orientation == 0) {
            pointerX = xValue + rectWidth * relativePosition;
            pointerY = yValue + 2.0;
            leftX = pointerX - this.strokeWidth * 0.4;
            rightX = pointerX + this.strokeWidth * 0.4;
            rightY = leftY = pointerY - this.strokeWidth * 0.4;
        } else {
            pointerX = xValue + rectWidth - 2.0;
            pointerY = yValue + rectHeight * relativePosition;
            rightX = leftX = pointerX + this.strokeWidth * 0.4;
            leftY = pointerY - this.strokeWidth * 0.4;
            rightY = pointerY + this.strokeWidth * 0.4;
        }
        Polygon triangle = new Polygon();
        triangle.addPoint((int)leftX, (int)leftY);
        triangle.addPoint((int)rightX, (int)rightY);
        triangle.addPoint((int)pointerX, (int)pointerY);
        this.secondaryIndicatorArea = new Area(triangle);
    }

    private void calculateIndicator() {
        double rightY;
        double leftY;
        double rightX;
        double leftX;
        double pointerY;
        double pointerX;
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        rvValue = this.paintValue;
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        if (this.rangeReversed) {
            relativePosition = Math.min(Math.max((valueN - rvValue) / delta, 0.0), 1.0);
        }
        Rectangle2D colorSegmentsBounds = this.colorSegmentsArea.getBounds2D();
        double yValue = colorSegmentsBounds.getY();
        double rectWidth = colorSegmentsBounds.getWidth();
        double rectHeight = colorSegmentsBounds.getHeight();
        double xValue = colorSegmentsBounds.getX();
        if (this.orientation == 0) {
            pointerX = xValue + rectWidth * relativePosition;
            pointerY = yValue + 2.0;
            leftX = pointerX - this.strokeWidth * 0.8;
            rightX = pointerX + this.strokeWidth * 0.8;
            rightY = leftY = pointerY - this.strokeWidth * 0.8;
        } else {
            pointerX = xValue + rectWidth - 2.0;
            pointerY = yValue + rectHeight * relativePosition;
            rightX = leftX = pointerX + this.strokeWidth * 0.8;
            leftY = pointerY - this.strokeWidth * 0.8;
            rightY = pointerY + this.strokeWidth * 0.8;
        }
        Polygon triangle = new Polygon();
        triangle.addPoint((int)leftX, (int)leftY);
        triangle.addPoint((int)rightX, (int)rightY);
        triangle.addPoint((int)pointerX, (int)pointerY);
        this.indicatorArea = new Area(triangle);
    }

    private void calculateBackdrop(Graphics gc) {
        Rectangle2D segmentBounds = this.colorSegmentsArea.getBounds2D();
        Rectangle2D.Double backdropRect = new Rectangle2D.Double();
        ((Rectangle2D)backdropRect).setRect(segmentBounds.getX(), segmentBounds.getY(), segmentBounds.getWidth(), segmentBounds.getHeight());
        if (this.adjustedLabelsVisible) {
            if (this.orientation == 0) {
                ((Rectangle2D)backdropRect).setRect(((RectangularShape)backdropRect).getX(), ((RectangularShape)backdropRect).getY(), ((RectangularShape)backdropRect).getWidth(), ((RectangularShape)backdropRect).getHeight() + this.labelPositions[0].getHeight());
            } else {
                this.maxLabelWidth = this.getMaxLabelWidth();
                ((Rectangle2D)backdropRect).setRect(((RectangularShape)backdropRect).getX() - (double)this.maxLabelWidth, ((RectangularShape)backdropRect).getY(), (double)this.maxLabelWidth + ((RectangularShape)backdropRect).getWidth(), ((RectangularShape)backdropRect).getHeight());
            }
        }
        this.backdropArea = new Area(backdropRect);
    }

    private int getMaxLabelWidth() {
        int width = 0;
        for (int i = 0; i < this.labelPositions.length; ++i) {
            width = (int)Math.max(this.labelPositions[i].getWidth(), (double)width);
        }
        return width;
    }

    private boolean calculateRangeLabelSize(Graphics2D gc) {
        int i;
        double yValue;
        double xValue;
        gc.setFont(this.adjustedLabelsFont);
        Rectangle2D segmentRect = this.colorSegments[0].getBounds();
        FontMetrics fm = gc.getFontMetrics();
        this.labelPositions = new Rectangle2D[this.colorSegments.length + 1];
        String rangeLabel = this.formatter.format(new Double(this.segmentValues[0])).trim();
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D bounds = this.adjustedLabelsFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
        if (this.orientation == 0) {
            bounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() + this.strokeWidth / 2.0);
            xValue = segmentRect.getX();
            yValue = segmentRect.getY() + segmentRect.getHeight() + bounds.getHeight();
        } else {
            bounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth() + (double)fm.charWidth('a') / 2.0, bounds.getHeight());
            xValue = segmentRect.getX() - (double)fm.stringWidth(rangeLabel) - (double)fm.charWidth('a') / 2.0;
            yValue = segmentRect.getY() + bounds.getHeight();
        }
        bounds.setRect(xValue, yValue, bounds.getWidth(), bounds.getHeight());
        this.labelPositions[0] = bounds;
        Area boundsOne = new Area(bounds);
        Rectangle2D boundsTwo = new Rectangle2D.Double();
        if (this.orientation == 0) {
            for (i = 1; i < this.segmentValues.length - 1; ++i) {
                segmentRect = this.colorSegments[i].getBounds2D();
                rangeLabel = this.formatter.format(new Double(this.segmentValues[i])).trim();
                bounds = this.adjustedLabelsFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
                bounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth() + (double)fm.charWidth('a') / 2.0, bounds.getHeight());
                xValue = segmentRect.getX() - (double)fm.stringWidth(rangeLabel) / 2.0;
                bounds.setRect(xValue, yValue, bounds.getWidth(), bounds.getHeight() + this.strokeWidth / 2.0);
                this.labelPositions[i] = bounds;
                ((Rectangle2D)boundsTwo).setRect(bounds);
                if (boundsOne.intersects(boundsTwo)) {
                    Font newFont;
                    Font labelFont = this.adjustedLabelsFont;
                    if (labelFont.getSize() <= 6) {
                        this.adjustedLabelsVisible = false;
                        return false;
                    }
                    this.adjustedLabelsFont = newFont = new Font(labelFont.getFamily(), labelFont.getStyle(), labelFont.getSize() - 1);
                    return this.calculateRangeLabelSize(gc);
                }
                boundsOne.add(new Area(boundsTwo));
            }
        } else {
            for (i = 1; i < this.segmentValues.length - 1; ++i) {
                segmentRect = this.colorSegments[i].getBounds2D();
                rangeLabel = this.formatter.format(new Double(this.segmentValues[i])).trim();
                bounds = this.adjustedLabelsFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
                xValue = segmentRect.getX() - (double)fm.stringWidth(rangeLabel) - (double)fm.charWidth('a') / 2.0;
                yValue = segmentRect.getY() + bounds.getHeight() / 2.0;
                bounds.setRect(xValue, yValue, bounds.getWidth(), bounds.getHeight());
                this.labelPositions[i] = bounds;
                ((Rectangle2D)boundsTwo).setRect(bounds);
                if (boundsOne.intersects(boundsTwo)) {
                    Font newFont;
                    Font labelFont = this.adjustedLabelsFont;
                    if (labelFont.getSize() <= 6) {
                        this.adjustedLabelsVisible = false;
                        return false;
                    }
                    this.adjustedLabelsFont = newFont = new Font(labelFont.getFamily(), labelFont.getStyle(), labelFont.getSize() - 1);
                    return this.calculateRangeLabelSize(gc);
                }
                boundsOne.add(new Area(boundsTwo));
            }
        }
        rangeLabel = this.formatter.format(new Double(this.segmentValues[this.segmentValues.length - 1])).trim();
        bounds = this.adjustedLabelsFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
        if (this.orientation == 0) {
            bounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() + this.strokeWidth / 2.0);
            xValue = segmentRect.getX() + segmentRect.getWidth() - (double)fm.stringWidth(rangeLabel);
        } else {
            bounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth() + (double)fm.charWidth('a') / 2.0, bounds.getHeight());
            yValue = segmentRect.getY() + segmentRect.getHeight();
            xValue = segmentRect.getX() - (double)fm.stringWidth(rangeLabel) - (double)fm.charWidth('a') / 2.0;
        }
        bounds.setRect(xValue, yValue, bounds.getWidth(), bounds.getHeight());
        this.labelPositions[this.labelPositions.length - 1] = bounds;
        boundsTwo = bounds;
        if (boundsOne.intersects(boundsTwo)) {
            Font newFont;
            Font labelFont = this.adjustedLabelsFont;
            if (labelFont.getSize() <= 6) {
                this.adjustedLabelsVisible = false;
                return false;
            }
            this.adjustedLabelsFont = newFont = new Font(labelFont.getFamily(), labelFont.getStyle(), labelFont.getSize() - 1);
            return this.calculateRangeLabelSize(gc);
        }
        return true;
    }

    private double[] getSegmentValues() {
        int numRange = this.rangeCollection.getSegmentCount();
        double[] labelValue = new double[numRange + 1];
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        labelValue[0] = value0;
        if (this.rangeReversed) {
            labelValue[0] = valueN;
        }
        for (int i = 1; i < numRange; ++i) {
            double tempMax;
            double tempMin;
            labelValue[i] = tempMin = this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue();
            if (!this.rangeReversed) continue;
            labelValue[i] = tempMax = this.rangeCollection.getSegment(i).getMaximumNumber().doubleValue();
        }
        labelValue[numRange] = valueN;
        if (this.rangeReversed) {
            labelValue[numRange] = value0;
        }
        return labelValue;
    }

    private void calculateSegments() {
        Rectangle colorRect = this.colorSegmentsArea.getBounds();
        int numRange = this.rangeCollection.getSegmentCount();
        this.colorSegments = new Area[numRange];
        double colorBandWidth = colorRect.getWidth();
        double xValue = colorRect.getX();
        double yValue = colorRect.getY();
        double colorBandHeight = colorRect.getHeight();
        double xStart = xValue;
        double xEnd = xValue + colorBandWidth;
        double yStart = yValue;
        double yEnd = yValue + colorBandHeight;
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        for (int i = 0; i < numRange; ++i) {
            value0 = this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue();
            valueN = this.rangeCollection.getSegment(i).getMaximumNumber().doubleValue();
            double relativeWidth = (valueN - value0) / delta;
            double increment = relativeWidth * colorBandWidth;
            Rectangle2D.Double leftRect = new Rectangle2D.Double();
            Rectangle2D.Double rightRect = new Rectangle2D.Double();
            if (this.orientation == 0) {
                increment = relativeWidth * colorBandWidth;
                ((Rectangle2D)leftRect).setRect(xStart, yValue - 2.0, xValue - xStart, colorBandHeight + 4.0);
                ((Rectangle2D)rightRect).setRect(xValue + increment, yValue - 2.0, xEnd + 4.0, colorBandHeight + 4.0);
            } else {
                increment = relativeWidth * colorBandHeight;
                ((Rectangle2D)leftRect).setRect(xStart - 2.0, yStart, colorBandWidth + 4.0, yValue - yStart);
                ((Rectangle2D)rightRect).setRect(xStart - 2.0, yValue + increment, colorBandWidth + 4.0, yEnd + 4.0);
            }
            Area segmentArea = new Area(this.colorSegmentsArea);
            segmentArea.subtract(new Area(leftRect));
            segmentArea.subtract(new Area(rightRect));
            this.colorSegments[i] = segmentArea;
            if (this.orientation == 0) {
                xValue += increment;
                continue;
            }
            yValue += increment;
        }
    }

    private void calculateColorBandArea(Graphics2D gc) {
        Rectangle2D.Double colorRect = new Rectangle2D.Double();
        if (this.orientation == 0) {
            colorRect.setRect(this.strokeWidth + this.drawSpace.getX(), this.strokeWidth + this.drawSpace.getY(), (double)this.drawSpace.width - this.strokeWidth * 2.0, this.adjustedMaxBandSize);
        } else {
            colorRect.setRect(this.strokeWidth + this.drawSpace.getX(), this.strokeWidth + this.drawSpace.getY(), this.adjustedMaxBandSize, (double)this.drawSpace.height - this.strokeWidth * 2.0);
            if (this.adjustedValueVisible && this.rangeViewStyle.getValuePlacement() == 1) {
                StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
                Double rvValue = (Double)pb.get("value");
                rvValue = new Double(this.paintValue);
                String rangeLabel = this.formatter.format(rvValue).trim();
                gc.setFont(this.adjustedValueFont);
                FontRenderContext frc = gc.getFontRenderContext();
                Rectangle2D bounds = this.adjustedValueFont.createGlyphVector(frc, rangeLabel).getVisualBounds();
                colorRect.setRect(colorRect.getX(), colorRect.getY(), colorRect.getWidth(), colorRect.getHeight() - bounds.getHeight() - this.strokeWidth / 2.0);
            }
        }
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double();
        ((RoundRectangle2D)roundRect).setRoundRect(colorRect.getX(), colorRect.getY(), colorRect.getWidth(), colorRect.getHeight(), this.strokeWidth / 2.0, this.strokeWidth / 2.0);
        this.colorSegmentsArea = new Area(roundRect);
    }

    class TimerListener
    implements ActionListener {
        RangeView rangeView;
        Graphics2D g;
        double val;
        Timer timer;

        public TimerListener(RangeView rv, Graphics2D gc, double value, Timer time) {
            this.rangeView = rv;
            this.g = gc;
            this.val = value;
            this.timer = time;
        }

        public void setValue(double value) {
            this.val = value;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SliderRangeViewRenderer.this.paintValue != this.val) {
                SliderRangeViewRenderer.this.increment = (this.val - SliderRangeViewRenderer.this.oldValue) / 50.0;
            }
            if (SliderRangeViewRenderer.this.increment == 0.0) {
                SliderRangeViewRenderer.this.increment = 1.0;
            }
            SliderRangeViewRenderer.this.paintValue += SliderRangeViewRenderer.this.increment;
            if (SliderRangeViewRenderer.this.increment > 0.0) {
                if (SliderRangeViewRenderer.this.paintValue >= this.val) {
                    SliderRangeViewRenderer.this.paintValue = this.val;
                    SliderRangeViewRenderer.this.oldValue = this.val;
                    SliderRangeViewRenderer.this.increment = 0.0;
                    this.timer.stop();
                }
            } else if (SliderRangeViewRenderer.this.paintValue <= this.val) {
                SliderRangeViewRenderer.this.paintValue = this.val;
                SliderRangeViewRenderer.this.oldValue = this.val;
                SliderRangeViewRenderer.this.increment = 0.0;
                this.timer.stop();
            }
            this.rangeView.repaint();
        }
    }
}

