/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.charts;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.swing.charts.RangeView;
import com.sas.swing.charts.StandardRangeViewRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Vector;

public class SimpleDialRangeViewRenderer
extends StandardRangeViewRenderer {
    @Override
    protected void buildWidget(RangeView jComponent, Graphics2D gc) {
        double tempWidth;
        double tempHeight;
        double targetWidth;
        double targetHeight;
        Rectangle rect = new Rectangle(jComponent.getBounds());
        Insets insets = jComponent.getInsets();
        this.rangeReversed = this.isRangeReversed();
        if (rect.width == 0) {
            rect.width = 120;
        }
        if (rect.height == 0) {
            rect.height = 80;
        }
        if (jComponent.isOpaque()) {
            gc.setColor(jComponent.getBackground());
            gc.fillRect(0, 0, rect.width, rect.height);
        }
        rect.width = rect.width - insets.left - insets.right - 4;
        rect.height = rect.height - insets.top - insets.bottom - 4;
        gc.setFont(this.rangeViewStyle.getLabelFont());
        FontMetrics fm = gc.getFontMetrics();
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            value0 = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            valueN = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        int value0Width = 0;
        int valueNWidth = 0;
        int labelHeight = 0;
        int valueHeight = 0;
        Format formatter = this.rangeViewData.getDisplayValueFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        if (this.rangeViewStyle.isLabelsVisible()) {
            value0Width = fm.stringWidth(formatter.format(new Double(value0)).trim());
            valueNWidth = fm.stringWidth(formatter.format(new Double(valueN)).trim());
            labelHeight = fm.getHeight();
        }
        if (this.rangeViewStyle.isValueVisible()) {
            gc.setFont(this.rangeViewStyle.getValueFont());
            fm = gc.getFontMetrics();
            valueHeight = fm.getHeight();
        }
        rect.width = rect.width - value0Width - valueNWidth;
        rect.height = rect.height - valueHeight - labelHeight;
        if (rect.height <= 0) {
            rect.height = 80;
        }
        if (rect.width <= 0) {
            rect.width = 120;
        }
        if ((targetHeight = 80.0) / (targetWidth = 120.0) * (double)rect.width > (double)rect.height) {
            tempHeight = rect.height;
            tempWidth = (double)rect.height * (targetWidth / targetHeight);
        } else {
            tempHeight = (double)rect.width * (targetHeight / targetWidth);
            tempWidth = rect.width;
        }
        double ratio = tempHeight / targetHeight;
        double radius = Math.sqrt(Math.pow(0.5 * tempHeight, 2.0) + Math.pow(tempHeight, 2.0));
        double standardXOffset = 0.5 * tempWidth - (double)rect.width / 2.0 + ((double)rect.width - tempWidth);
        standardXOffset = standardXOffset + (double)insets.left + (double)value0Width + 2.0;
        double standardYOffset = tempHeight - radius * 0.86 + ((double)rect.height - tempHeight) + (double)labelHeight;
        standardYOffset = standardYOffset / 2.0 + (double)insets.top + 2.0;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHints(hints);
        Area colorSegmentsArea = this.buildSegmentArea(radius, tempWidth, standardXOffset, standardYOffset);
        double[] seg = new double[numRange + 1];
        double[] labelValue = new double[numRange + 1];
        this.getSegmentValues(numRange, seg, labelValue);
        gc.setColor(this.foreground);
        Vector colorSegments = this.buildColorSegments(gc, colorSegmentsArea, seg, radius, tempWidth, 1.0, standardXOffset, standardYOffset);
        Area arrowArea = this.buildArrow(gc, radius, 1.0, tempWidth, standardXOffset, standardYOffset, ratio);
        Area valueBaseArea = this.buildHub(gc, radius, 1.0, tempWidth, standardXOffset, standardYOffset, ratio);
        if (this.rangeViewStyle.isLabelsVisible()) {
            this.buildRangeLabels(gc, colorSegments, labelValue, radius);
        }
        if (this.rangeViewStyle.isValueVisible()) {
            this.buildValueLabel(gc, valueBaseArea, radius);
        }
        if (this.rangeViewData.getDataCount() > 1) {
            this.buildSecondaryValue(gc, radius, 1.0, tempWidth, standardXOffset, standardYOffset, ratio);
        }
    }

    @Override
    protected void buildValueLabel(Graphics2D gc, Area valueBaseArea, double radius) {
        Rectangle2D rect = valueBaseArea.getBounds2D();
        Format formatter = this.rangeViewData.getDisplayValueFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D valueBaseBounds = valueBaseArea.getBounds2D();
        float xInt = (float)(rect.getX() + rect.getWidth() / 2.0);
        float yInt = (float)(rect.getY() + rect.getHeight());
        gc.setFont(this.rangeViewStyle.getValueFont());
        frc = gc.getFontRenderContext();
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        double rvValue = this.oldValue;
        String valueLabel = formatter.format(new Double(rvValue)).trim();
        Rectangle2D stringBounds = gc.getFont().getStringBounds(valueLabel, frc);
        float stringWidth = (float)stringBounds.getWidth();
        xInt = (float)((double)xInt - (double)stringWidth / 2.0);
        yInt = (float)((double)yInt + stringBounds.getHeight());
        gc.setColor(this.rangeViewStyle.getValueColor());
        gc.drawString(valueLabel, xInt, yInt);
    }

    protected Area buildSecondaryValue(Graphics2D gc, double radius, double strokeWidth, double tempWidth, double standardXOffset, double standardYOffset, double ratio) {
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        GeneralPath pointer = new GeneralPath();
        pointer.moveTo((float)(radius * 0.95 - ratio * 6.0), (float)(-ratio * 6.0));
        pointer.lineTo((float)(radius * 0.95), 0.0f);
        pointer.lineTo((float)(radius * 0.95 - ratio * 6.0), (float)(ratio * 6.0));
        Rectangle2D.Double removeThis = new Rectangle2D.Double(0.0, -(ratio * 8.0), radius * 0.2, 16.0 * ratio);
        Area arrowArea = new Area(pointer);
        arrowArea.subtract(new Area(removeThis));
        Arc2D.Double valueBaseArc = new Arc2D.Double();
        double newRadius = radius;
        ((Arc2D)valueBaseArc).setArc(0.5 * tempWidth - newRadius, radius - newRadius, newRadius * 2.0, newRadius * 2.0, 45.0, 90.0, 2);
        Area valueBaseArea = new Area(valueBaseArc);
        valueBaseArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(1);
        rvValue = (Double)pb.get("value");
        double arrowAngle = 45.0;
        if (delta != 0.0) {
            arrowAngle = (1.0 - (rvValue - value0) / delta) * 90.0 + 45.0;
            if (this.rangeReversed) {
                arrowAngle = (1.0 - (valueN - rvValue) / delta) * 90.0 + 45.0;
            }
        } else {
            arrowAngle = rvValue > value0 ? 45.0 : (rvValue < value0 ? 135.0 : 90.0);
        }
        arrowAngle = Math.max(45.0, arrowAngle);
        arrowAngle = Math.min(135.0, arrowAngle);
        double angleRadians = -(arrowAngle / 360.0) * 2.0 * Math.PI;
        gc.setStroke(new BasicStroke(1.0f));
        arrowArea.transform(AffineTransform.getTranslateInstance(0.5 * tempWidth, radius));
        arrowArea.transform(AffineTransform.getRotateInstance(angleRadians, 0.5 * tempWidth, radius));
        arrowArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        gc.setColor(Color.white);
        gc.fill(arrowArea);
        gc.setColor(this.foreground);
        gc.draw(arrowArea);
        return arrowArea;
    }

    @Override
    protected Area buildArrow(Graphics2D gc, double radius, double strokeWidth, double tempWidth, double standardXOffset, double standardYOffset, double ratio) {
        int numRange = this.rangeCollection.getSegmentCount();
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        if (this.rangeReversed) {
            valueN = this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
            value0 = this.rangeCollection.getSegment(numRange - 1).getMinimumNumber().doubleValue();
        }
        double delta = valueN - value0;
        GeneralPath pointer = new GeneralPath();
        pointer.moveTo(0.0f, (float)(-(ratio * 6.0)));
        pointer.lineTo((float)(radius * 0.85), 0.0f);
        pointer.lineTo(0.0f, (float)(6.0 * ratio));
        Rectangle2D.Double removeThis = new Rectangle2D.Double(0.0, -(ratio * 8.0), radius * 0.2, 16.0 * ratio);
        Area arrowArea = new Area(pointer);
        arrowArea.subtract(new Area(removeThis));
        Arc2D.Double valueBaseArc = new Arc2D.Double();
        double newRadius = radius;
        ((Arc2D)valueBaseArc).setArc(0.5 * tempWidth - newRadius, radius - newRadius, newRadius * 2.0, newRadius * 2.0, 45.0, 90.0, 2);
        Area valueBaseArea = new Area(valueBaseArc);
        valueBaseArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        double rvValue = 0.0;
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        rvValue = this.paintValue;
        double arrowAngle = 45.0;
        if (delta != 0.0) {
            arrowAngle = (1.0 - (rvValue - value0) / delta) * 90.0 + 45.0;
            if (this.rangeReversed) {
                arrowAngle = (1.0 - (valueN - rvValue) / delta) * 90.0 + 45.0;
            }
        } else {
            arrowAngle = rvValue > value0 ? 45.0 : (rvValue < value0 ? 135.0 : 90.0);
        }
        arrowAngle = Math.max(45.0, arrowAngle);
        arrowAngle = Math.min(135.0, arrowAngle);
        double angleRadians = -(arrowAngle / 360.0) * 2.0 * Math.PI;
        gc.setStroke(new BasicStroke(1.0f));
        arrowArea.transform(AffineTransform.getTranslateInstance(0.5 * tempWidth, radius));
        arrowArea.transform(AffineTransform.getRotateInstance(angleRadians, 0.5 * tempWidth, radius));
        arrowArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        arrowArea.intersect(valueBaseArea);
        gc.setColor(Color.white);
        gc.fill(arrowArea);
        gc.setColor(this.foreground);
        gc.draw(arrowArea);
        return arrowArea;
    }

    @Override
    protected Area buildHub(Graphics2D gc, double radius, double strokeWidth, double tempWidth, double standardXOffset, double standardYOffset, double ratio) {
        Arc2D.Double valueBaseArc = new Arc2D.Double();
        double newRadius = 0.45 * radius;
        ((Arc2D)valueBaseArc).setArc(0.5 * tempWidth - newRadius, radius - newRadius, newRadius * 2.0, newRadius * 2.0, 45.0, 90.0, 2);
        Area valueBaseArea = new Area(valueBaseArc);
        newRadius = 0.14 * radius;
        Rectangle2D.Double valueBaseRect = new Rectangle2D.Double(0.0, radius - newRadius, tempWidth, radius);
        valueBaseArea.subtract(new Area(valueBaseRect));
        gc.setColor(this.foreground);
        gc.setStroke(new BasicStroke((float)strokeWidth));
        valueBaseArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        gc.draw(valueBaseArea);
        StaticPropertyBagInterface pb = this.rangeViewData.getDataAt(0);
        double rvValue = (Double)pb.get("value");
        double minValue = this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMinimumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double maxValue = !this.rangeReversed ? this.rangeCollection.getSegment(this.rangeCollection.getSegmentCount() - 1).getMaximumNumber().doubleValue() : this.rangeCollection.getSegment(0).getMaximumNumber().doubleValue();
        double tempValue = Math.max(minValue, Math.min(maxValue, rvValue));
        Color arrowHubColor = (Color)this.rangeCollection.getSegment(tempValue).get("COLOR");
        gc.setColor(arrowHubColor);
        gc.fill(valueBaseArea);
        gc.setColor(this.foreground);
        gc.draw(valueBaseArea);
        return valueBaseArea;
    }

    protected Vector buildColorSegments(Graphics2D gc, Area colorArea, double[] seg, double radius, double tempWidth, double strokeWidth, double standardXOffset, double standardYOffset) {
        Vector<Area> colorSegments = new Vector<Area>();
        gc.setStroke(new BasicStroke(1.0f));
        int numRange = this.rangeCollection.getSegmentCount();
        Vector colorList = this.getBandColorList(numRange);
        for (int i = 0; i < numRange; ++i) {
            Area segmentArea = new Area();
            segmentArea.add(colorArea);
            Arc2D.Double leftArc = new Arc2D.Double();
            leftArc.setArc(0.5 * tempWidth - radius, 0.0, radius * 2.0, radius * 2.0, seg[i] + 45.0, 90.0, 2);
            Area newLeftArea = new Area(leftArc);
            newLeftArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            segmentArea.subtract(newLeftArea);
            Arc2D.Double rightArc = new Arc2D.Double();
            rightArc.setArc(0.5 * tempWidth - radius, 0.0, radius * 2.0, radius * 2.0, 0.0, seg[i + 1] + 45.0, 2);
            Area newRightArea = new Area(rightArc);
            newRightArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
            segmentArea.subtract(newRightArea);
            gc.setColor((Color)this.rangeCollection.getSegment(i).get("COLOR"));
            gc.fill(segmentArea);
            gc.setColor(this.foreground);
            gc.draw(segmentArea);
            colorSegments.add(new Area(segmentArea));
        }
        return colorSegments;
    }

    protected Area buildSegmentArea(double radius, double tempWidth, double standardXOffset, double standardYOffset) {
        Arc2D.Double colorArc = new Arc2D.Double();
        double newRadius = radius * 0.95;
        ((Arc2D)colorArc).setArc(0.5 * tempWidth - newRadius, radius - newRadius, newRadius * 2.0, newRadius * 2.0, 45.0, 90.0, 2);
        double lowerArcOffset = 0.55;
        int numberBands = this.getNumberSecondaryValues();
        Arc2D.Double lowerArc = new Arc2D.Double();
        newRadius = radius * lowerArcOffset;
        ((Arc2D)lowerArc).setArc(0.5 * tempWidth - newRadius, radius - newRadius, newRadius * 2.0, newRadius * 2.0, 0.0, 180.0, 2);
        Area colorArea = new Area(colorArc);
        colorArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        Area newLowerArea = new Area(lowerArc);
        newLowerArea.transform(AffineTransform.getTranslateInstance(standardXOffset, standardYOffset));
        colorArea.subtract(newLowerArea);
        return colorArea;
    }
}

