/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.ModelInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;
import com.sas.models.BufferHints;
import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import com.sas.storage.jdbc.RB;
import com.sas.table.ColumnChangedEvent;
import com.sas.table.DataCellChangedEvent;
import com.sas.table.DataTableInterface;
import com.sas.table.RowChangedEvent;
import com.sas.table.TableException;
import com.sas.util.transforms.ObjectToStringTransform;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.Hashtable;

public class JDBCToDataTableAdapter
extends JDBCAdapter
implements DataTableInterface,
ModelInterface,
ContentsChangedSource {
    public static final int ERROR_CODE_END_OF_FILE = 1;
    protected Hashtable defaultValues;
    protected transient ContentsChangedListenerList allContentsChangedListeners;

    public JDBCToDataTableAdapter() {
        this(null, null);
    }

    public JDBCToDataTableAdapter(ResultSet result) {
        super(result);
    }

    public JDBCToDataTableAdapter(Connection conn, String queryStatement) {
        super(conn, queryStatement);
    }

    public boolean attachView() {
        return true;
    }

    public void detachView() {
    }

    protected boolean absolute(int index) throws TableException {
        boolean retVal;
        try {
            retVal = this.doAbsolute(index);
        }
        catch (Exception se) {
            TableException te = new TableException(se.getMessage());
            if (se.getMessage() != null && se.getMessage().equals(RB.getStringResource((String)"JDBCAdapter.", (String)"endOfResultSet.ex.txt"))) {
                te.setErrorCode(1);
            }
            throw te;
        }
        return retVal;
    }

    protected void initDefaultValues() {
        if (this.defaultValues != null) {
            return;
        }
        this.defaultValues = new Hashtable(1);
    }

    public void refresh() {
        this.initialized = false;
        this.init();
    }

    public int getColumnIndex(String name) throws IllegalArgumentException, TableException {
        try {
            return this.retrieveColumnIndex(name);
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public String getColumnInfoUsed() {
        return this.retrieveColumnInfoUsed();
    }

    public void setColumnInfoUsed(String info) throws TableException {
        try {
            this.putColumnInfoUsed(info);
        }
        catch (Exception e) {
            throw new TableException(e.getMessage());
        }
    }

    public void setWhere(String whereString) {
        this.setQueryStatement(whereString);
    }

    public String getWhere() {
        return this.getQueryStatement();
    }

    public String[] getDisplayedColumns() {
        return null;
    }

    public void setDisplayedColumns(String[] p0) {
        throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"notSupported.ex.txt"));
    }

    public void setBufferSize(int rows) {
        this.init();
        try {
            this.result.setFetchSize(rows);
        }
        catch (SQLException se) {
            se.getMessage();
        }
    }

    public int getBufferSize() {
        this.init();
        try {
            return this.result.getFetchSize();
        }
        catch (SQLException se) {
            se.getMessage();
            return 0;
        }
    }

    public void setBufferBlocks(int p0) {
        throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"notSupported.ex.txt"));
    }

    public int getBufferBlocks() {
        return 1;
    }

    public void commitRow() {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"readOnly.ex.txt"));
        }
        if (!this.autoCommit) {
            try {
                this.result.updateRow();
                this.fireContentsChanged(new RowChangedEvent((Object)this, this.result.getRow(), 1, 4));
            }
            catch (SQLException se) {
                se.getMessage();
            }
        }
    }

    public void useBufferHints(BufferHints p0) {
    }

    public void addColumn(int p0, Class p1, Object p2) throws TableException {
        throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"notSupported.ex.txt"));
    }

    public void addRow(int index) throws TableException {
        if (this.isReadOnly()) {
            throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"readOnly.ex.txt"));
        }
        if (index != -1) {
            throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"notThisIndex.ex.txt"));
        }
        try {
            int columnCount = this.getColumnCount();
            Object[] values = new Object[columnCount];
            for (int col = 1; col <= columnCount; ++col) {
                values[col - 1] = this.getColumnDefaultValue(col);
            }
            this.addRow(index, values);
        }
        catch (Exception e) {
            throw new TableException(e.getMessage());
        }
    }

    public void addRow(int index, Object[] values) throws TableException {
        if (this.isReadOnly()) {
            throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"readOnly.ex.txt"));
        }
        if (index != -1) {
            throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"notThisIndex.ex.txt"));
        }
        int n = this.getColumnCount();
        if (n != values.length) {
            throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"unequalLengths.ex.txt"));
        }
        try {
            this.result.moveToInsertRow();
            for (int col = 1; col <= n; ++col) {
                this.updateCell(col, values[col - 1]);
            }
            this.result.insertRow();
            this.result.moveToCurrentRow();
            this.rowNumber = this.result.getRow();
            if (this.resultSetRequeryUsed && !this.resultSetUsed && this.conn != null) {
                DatabaseMetaData metadata = this.conn.getMetaData();
                if (!metadata.ownInsertsAreVisible(this.result.getType())) {
                    this.initialized = false;
                    this.init();
                } else {
                    ++this.rowCount;
                }
            } else {
                this.rowCount = -1;
                this.isRowCountKnown = false;
            }
            this.fireContentsChanged(new RowChangedEvent((Object)this, index, 1, 3));
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public void deleteColumn(int p0) throws TableException {
        throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"notSupported.ex.txt"));
    }

    public void deleteRow(int row) throws TableException {
        if (this.isReadOnly()) {
            throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"readOnly.ex.txt"));
        }
        this.init();
        try {
            this.absolute(row);
            this.result.deleteRow();
            this.rowNumber = this.result.getRow();
            if (this.resultSetRequeryUsed && !this.resultSetUsed && this.conn != null) {
                DatabaseMetaData metadata = this.conn.getMetaData();
                if (!metadata.ownDeletesAreVisible(this.result.getType())) {
                    this.initialized = false;
                    this.init();
                } else {
                    --this.rowCount;
                }
            } else {
                this.rowCount = -1;
                this.isRowCountKnown = false;
            }
            this.fireContentsChanged(new RowChangedEvent((Object)this, row, 1, 2));
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public Object getColumnDefaultValue(int index) throws TableException {
        this.init();
        try {
            this.initDefaultValues();
            if (this.defaultValues.containsKey(new Integer(index))) {
                Object value = this.defaultValues.get(new Integer(index));
                return value;
            }
            int type = this.meta.getColumnType(index);
            return JDBCDataTypeInfo.getDefaultValue((int)type);
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public Object[] getColumnDefaultValues(int index, int count) throws TableException {
        Object[] values = new Object[count];
        for (int col = 1; col <= count; ++col) {
            values[col - 1] = this.getColumnDefaultValue(index + col - 1);
        }
        return values;
    }

    public boolean isColumnsDeletable() throws TableException {
        return false;
    }

    public boolean isColumnsExtendable() throws TableException {
        return false;
    }

    public boolean isColumnsInsertable() throws TableException {
        return false;
    }

    public boolean isColumnsRedefinable() throws TableException {
        return false;
    }

    public boolean isRowsDeletable() throws TableException {
        return this.isReadOnly();
    }

    public boolean isRowsExtendable() throws TableException {
        return this.isReadOnly();
    }

    public boolean isRowsInsertable() throws TableException {
        return false;
    }

    public void setColumnDefaultValue(int index, Object newValue) throws TableException {
        this.initDefaultValues();
        Integer indexInt = new Integer(index);
        if (newValue != null) {
            this.defaultValues.put(indexInt, newValue);
        } else if (this.defaultValues.containsKey(indexInt)) {
            this.defaultValues.remove(indexInt);
        }
    }

    public void setColumnClass(int p0, Class p1) throws TableException {
        throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"notSupported.ex.txt"));
    }

    public Object getRowLabel(int row) throws TableException {
        String label = Integer.toString(row);
        return label;
    }

    public Object[] getRowLabels(int startIndex, int count) throws TableException {
        Object[] labels = new Object[count];
        for (int index = 1; index <= count; ++index) {
            labels[index - 1] = Integer.toString(startIndex);
            ++startIndex;
        }
        return labels;
    }

    public boolean isRowLabelsSupported() throws TableException {
        return true;
    }

    public boolean isRowsLabelSupported() throws TableException {
        return false;
    }

    public Object getColumnLabel(int index) throws TableException {
        try {
            return this.retrieveColumnLabel(index);
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public Object[] getColumnLabels(int index, int count) throws TableException {
        Object[] labels = new Object[count];
        for (int col = 1; col <= count; ++col) {
            labels[col - 1] = this.getColumnLabel(index + col - 1);
        }
        return labels;
    }

    public boolean isColumnLabelsSupported() throws TableException {
        return true;
    }

    public boolean isColumnsLabelSupported() throws TableException {
        return false;
    }

    public void setFormattedCell(int rowIndex, int columnIndex, String value) throws TableException {
        this.setCell(rowIndex, columnIndex, value);
    }

    public void setFormattedCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, String[][] values) throws TableException {
        this.setCells(startRowIndex, startColumnIndex, rowCount, columnCount, values);
    }

    public void setFormattedColumn(int index, String[] values) throws TableException {
        this.setColumn(index, values);
    }

    public void setFormattedRow(int index, String[] values) throws TableException {
        this.setRow(index, values);
    }

    public String[] getColumnInfoNames() throws TableException {
        return new String[]{"NAME", "LABEL"};
    }

    public Object getColumnInfo(int index, String columnInfoName) throws TableException {
        this.init();
        if (columnInfoName.equalsIgnoreCase("NAME")) {
            try {
                return this.meta.getColumnName(index);
            }
            catch (SQLException se) {
                throw new TableException(se.getMessage());
            }
        }
        if (columnInfoName.equalsIgnoreCase("LABEL")) {
            try {
                return this.meta.getColumnLabel(index);
            }
            catch (SQLException se) {
                throw new TableException(se.getMessage());
            }
        }
        throw new IllegalStateException(RB.getStringResource((String)"JDBCAdapter.", (String)"invalidInfo.ex.txt"));
    }

    public Class getColumnClass(int index) throws TableException {
        try {
            return this.retrieveColumnClass(index);
        }
        catch (Exception e) {
            throw new TableException(e.getMessage());
        }
    }

    public Class[] getColumnClasses(int col, int columnCount) throws TableException {
        Class[] names = new Class[columnCount];
        for (int i = col; i < col + columnCount; ++i) {
            names[i - col] = this.getColumnClass(i);
        }
        return names;
    }

    public boolean isCellsModifiable() {
        return !this.isReadOnly();
    }

    public boolean isMultipleRowUpdateSupported() {
        return true;
    }

    public boolean isMultipleColumnUpdateSupported() {
        return true;
    }

    public void setCell(int rowIndex, int columnIndex, Object value) throws TableException {
        this.init();
        try {
            this.absolute(rowIndex);
            this.putValueAt(value, rowIndex, columnIndex);
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public void setCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, Object[][] values) throws TableException {
        if (this.isReadOnly()) {
            throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"readOnly.ex.txt"));
        }
        this.init();
        try {
            int startRow = startRowIndex;
            for (int row = 0; row < rowCount; ++row) {
                this.absolute(startRow);
                for (int col = 0; col < columnCount; ++col) {
                    this.updateCell(startColumnIndex + col, values[row][col]);
                }
                this.result.updateRow();
                ++startRow;
            }
            this.fireContentsChanged(new DataCellChangedEvent((Object)this, startRowIndex, startColumnIndex, rowCount, columnCount));
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public void setColumn(int columnIndex, Object[] values) throws TableException {
        if (this.isReadOnly()) {
            throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"readOnly.ex.txt"));
        }
        this.init();
        for (int row = 1; row <= values.length; ++row) {
            try {
                this.absolute(row);
                this.updateCell(columnIndex, values[row - 1]);
                this.result.updateRow();
                continue;
            }
            catch (SQLException se) {
                throw new TableException(se.getMessage());
            }
        }
        this.fireContentsChanged(new ColumnChangedEvent((Object)this, columnIndex, 1, 4));
    }

    public void setRow(int rowIndex, Object[] values) throws TableException {
        if (this.isReadOnly()) {
            throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"readOnly.ex.txt"));
        }
        try {
            int columnCount = this.getColumnCount();
            if (columnCount != values.length) {
                throw new TableException(RB.getStringResource((String)"JDBCAdapter.", (String)"unequalLengths.ex.txt"));
            }
            this.absolute(rowIndex);
            for (int col = 1; col <= columnCount; ++col) {
                this.updateCell(col, values[col - 1]);
            }
            if (this.autoCommit) {
                this.result.updateRow();
                this.fireContentsChanged(new RowChangedEvent((Object)this, rowIndex, 1, 4));
            }
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public int countColumns(int maxCount) throws TableException {
        try {
            return this.doCountColumns(maxCount);
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public int countRows(int maxCount) throws TableException {
        try {
            return this.calculateRowCount();
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
    }

    public Object getCell(int row, int col) throws TableException {
        this.init();
        try {
            this.absolute(row);
            return this.retrieveValueAt(row, col);
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
        catch (TableException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TableException(e.getMessage());
        }
    }

    public Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Object[][] cells = new Object[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                cells[row][col] = this.getCell(startRowIndex + row, startColumnIndex + col);
            }
        }
        return cells;
    }

    public Class getCellClass(int row, int col) throws TableException {
        return this.getColumnClass(col);
    }

    public Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        Class[][] cells = new Class[rowCount][columnCount];
        for (int col = 1; col <= columnCount; ++col) {
            Class name = this.getColumnClass(startColumnIndex + col - 1);
            for (int row = 1; row <= rowCount; ++row) {
                cells[row - 1][col - 1] = name;
            }
        }
        return cells;
    }

    public Object[] getColumn(int index) throws TableException {
        int rowCount = this.getRowCount();
        Object[] cells = new Object[rowCount];
        for (int row = 1; row <= rowCount; ++row) {
            cells[row - 1] = this.getCell(row, index);
        }
        return cells;
    }

    public int getColumnCount() throws TableException {
        try {
            return this.retrieveColumnCount();
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
        catch (Exception e) {
            throw new TableException(e.getMessage());
        }
    }

    public Object[] getRow(int row) throws TableException {
        int columnCount = this.getColumnCount();
        Object[] cells = new Object[columnCount];
        for (int col = 1; col <= columnCount; ++col) {
            cells[col - 1] = this.getCell(row, col);
        }
        return cells;
    }

    public int getRowCount() throws TableException {
        try {
            return this.calculateRowCount();
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
        catch (Exception e) {
            throw new TableException(e.getMessage());
        }
    }

    public String getFormattedCell(int rowIndex, int colIndex) throws TableException {
        Object value = this.getCell(rowIndex, colIndex);
        if (value == null) {
            return "";
        }
        return (String)ObjectToStringTransform.defaultInstance.transform(value);
    }

    public String[][] getFormattedCells(int startRow, int startColumn, int rowCount, int columnCount) throws TableException {
        String[][] cells = new String[rowCount][columnCount];
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= columnCount; ++col) {
                cells[row - 1][col - 1] = this.getFormattedCell(startRow + row - 1, startColumn + col - 1);
            }
        }
        return cells;
    }

    public String[] getFormattedColumn(int col) throws TableException {
        int count = this.getRowCount();
        String[] columnData = new String[count];
        for (int row = 1; row <= count; ++row) {
            columnData[row - 1] = this.getFormattedCell(row, col);
        }
        return columnData;
    }

    public String[] getFormattedRow(int row) throws TableException {
        int count = this.getColumnCount();
        String[] rowData = new String[count];
        for (int col = 1; col <= count; ++col) {
            rowData[col - 1] = this.getFormattedCell(row, col);
        }
        return rowData;
    }

    protected void updateCell(int col, Object value) throws TableException {
        try {
            this.doUpdateCell(col, value);
        }
        catch (SQLException se) {
            throw new TableException(se.getMessage());
        }
        catch (NumberFormatException ne) {
            throw new TableException(ne.getMessage());
        }
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "JDBCToDataTableInfo"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "connection"}, {"Hidden", "true"}}, {{"Name", "where"}, {"Hidden", "true"}}, {{"Name", "bufferBlocks"}, {"Hidden", "true"}}, {{"Name", "bufferSize"}, {"Hidden", "true"}}, {{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "cellsModifiable"}, {"Hidden", "true"}}, {{"Name", "columnCount"}, {"Expert", "true"}}, {{"Name", "column"}, {"Hidden", "true"}}, {{"Name", "columnClass"}, {"Hidden", "true"}}, {{"Name", "columnDefaultValue"}, {"Hidden", "true"}}, {{"Name", "columnInfoNames"}, {"Expert", "true"}}, {{"Name", "columnLabelsSupported"}, {"Expert", "true"}}, {{"Name", "columnLabel"}, {"Hidden", "true"}}, {{"Name", "columnsDeletable"}, {"Expert", "true"}}, {{"Name", "columnsExtendable"}, {"Expert", "true"}}, {{"Name", "columnsInsertable"}, {"Expert", "true"}}, {{"Name", "columnsLabelSupported"}, {"Expert", "true"}}, {{"Name", "columnsRedefinable"}, {"Expert", "true"}}, {{"Name", "displayedColumns"}, {"Hidden", "true"}}, {{"Name", "formattedColumn"}, {"Hidden", "true"}}, {{"Name", "formattedRow"}, {"Hidden", "true"}}, {{"Name", "multipleColumnUpdateSupported"}, {"Expert", "true"}}, {{"Name", "multipleRowUpdateSupported"}, {"Expert", "true"}}, {{"Name", "row"}, {"Hidden", "true"}}, {{"Name", "rowCount"}, {"Expert", "true"}}, {{"Name", "rowLabel"}, {"Hidden", "true"}}, {{"Name", "rowLabelsSupported"}, {"Expert", "true"}}, {{"Name", "rowsDeletable"}, {"Expert", "true"}}, {{"Name", "rowsExtendable"}, {"Expert", "true"}}, {{"Name", "rowsInsertable"}, {"Expert", "true"}}, {{"Name", "rowsLabelSupported"}, {"Expert", "true"}}, {{"Name", "resultSetRequeryUsed"}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public synchronized void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public synchronized void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    public void fireModelEvent(EventObject event) {
        if (event instanceof ContentsChangedEvent) {
            this.fireContentsChanged((ContentsChangedEvent)event);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.allContentsChangedListeners != null && this.allContentsChangedListeners.count() > 0) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
    }

    public void fireCellEvent(int row, int column) {
        this.fireContentsChanged(new DataCellChangedEvent((Object)this, row, column, 1, 1));
    }

    public void fireModelEvent() {
        this.fireContentsChanged();
    }

    protected void fireContentsChanged() {
        this.fireContentsChanged(new ContentsChangedEvent((Object)this));
    }
}

