/*
 * Decompiled with CFR 0.152.
 */
package com.sas.spedo.wq;

import com.sas.net.sharenet.ShareNetConnection;
import com.sas.spedo.ISpedoDSO;
import com.sas.spedo.SpedoException;
import com.sas.spedo.SpedoManagerInterface;
import com.sas.spedo.jdbc.JDBCDSO;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class WQSpedoManager
implements SpedoManagerInterface {
    protected ShareNetConnection dataConnection;

    public WQSpedoManager(ShareNetConnection connection) throws SpedoException {
        this.dataConnection = connection;
    }

    @Override
    public Vector getSpedoDSOVector() throws SpedoException {
        Vector<JDBCDSO> dsoVector = new Vector<JDBCDSO>();
        if (this.dataConnection != null) {
            try {
                DatabaseMetaData dbMetaData = this.dataConnection.getMetaData();
                ResultSet schemas = dbMetaData.getSchemas();
                while (schemas.next()) {
                    String dsoName = schemas.getString(1).trim();
                    JDBCDSO dso = new JDBCDSO();
                    dso.setOptionString("alreadyExists");
                    dso.setSpedoDSO(dsoName);
                    dso.connect(this.dataConnection);
                    dsoVector.addElement(dso);
                }
                schemas.close();
            }
            catch (SQLException e) {
                throw new SpedoException("SpedoException: WQSpedoManager.getSpedoDSOVector() : " + e.getMessage());
            }
        }
        return dsoVector;
    }

    @Override
    public ISpedoDSO getSpedoDSO(String dsoName) throws SpedoException {
        try {
            JDBCDSO dso = new JDBCDSO();
            dso.setOptionString("alreadyExists");
            dso.setSpedoDSO(dsoName.trim().toUpperCase());
            dso.connect(this.dataConnection);
            return dso;
        }
        catch (SpedoException e) {
            throw new SpedoException("SpedoException: WQSpedoManager.getSpedoDSO() : " + e.getMessage());
        }
    }
}

