/*
 * Decompiled with CFR 0.152.
 */
package com.sas.spedo.jdbc;

import com.sas.spedo.IBookmark;
import com.sas.spedo.ISpedoRowset;
import com.sas.spedo.ISpedoSchemaRowset;
import com.sas.spedo.ITableInfo;
import com.sas.spedo.SpedoException;
import com.sas.spedo.jdbc.JDBCDSO;
import com.sas.spedo.jdbc.JDBCSchemaRowset;
import com.sas.spedo.jdbc.SasTableInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCRowset
extends JDBCSchemaRowset
implements ISpedoRowset {
    private boolean tableCreated = false;
    private boolean start = false;
    private boolean end = false;
    String columnNames = null;

    public JDBCRowset() throws SpedoException {
    }

    public JDBCRowset(ResultSet results, String tableName, JDBCDSO dso) throws SpedoException {
        super(results, tableName, dso);
    }

    public JDBCRowset(String tableName, JDBCDSO dso) throws SpedoException {
        super(tableName, dso);
    }

    public JDBCRowset(String tableName, String password, JDBCDSO dso) throws SpedoException {
        super(tableName, password, dso);
    }

    public JDBCRowset(Statement statement, ResultSet results, int specHandling) throws SpedoException {
        super(statement, results, specHandling);
    }

    @Override
    public ITableInfo getSASTableInfo() throws SpedoException {
        SasTableInfo tableInfo = new SasTableInfo();
        return tableInfo;
    }

    @Override
    public ISpedoSchemaRowset getColumnRowset() throws SpedoException {
        if (!this.isOpen) {
            throw new SpedoException("SpedoException: JDBCRowset.getColumnRowset: Rowset not open.");
        }
        try {
            JDBCSchemaRowset mdrs = new JDBCSchemaRowset(this.statement, this.rs, 1);
            return mdrs;
        }
        catch (SpedoException se) {
            throw new SpedoException("SpedoException: JDBCRowset.getColumnRowset() : " + se.getMessage());
        }
    }

    @Override
    public void startColumnDefinition() throws SpedoException {
        this.start = true;
        this.end = false;
    }

    @Override
    public void defineColumns(String columnName) throws SpedoException {
        if (columnName == null) {
            throw new SpedoException("SpedoException: JDBCRowset.defineColumns() : invalid column name.");
        }
        if (!this.start) {
            throw new SpedoException("SpedoException: JDBCRowset.defineColumns() : startColumnDefinition() must be called first.");
        }
        if (this.tableCreated) {
            throw new SpedoException("SpedoException: JDBCRowset.defineColumns() : createTable() has been called.");
        }
        this.columnNames = this.columnNames == null ? columnName : this.columnNames + new String(", " + columnName.trim());
    }

    @Override
    public void endColumnDefinition() throws SpedoException {
        this.start = false;
        this.end = true;
    }

    @Override
    public int addColumn(String columnName) throws SpedoException {
        if (!this.dso.getTableStatus(this.tableName)) {
            throw new SpedoException("SpedoException: JDBCRowset.addColumn : cannot add column. table does not exist.");
        }
        int updateCount = 0;
        String query = "alter table " + this.dso.dso + "." + this.tableName + " modify " + columnName + ";";
        try {
            this.statement = this.connection.createStatement();
            updateCount = this.statement.executeUpdate(query);
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCRowset.addColumn() : " + ex.getMessage());
        }
        return updateCount;
    }

    @Override
    public int addRow(String[] columnValue) throws SpedoException {
        if (!this.dso.getTableStatus(this.tableName)) {
            throw new SpedoException("SpedoException: JDBCRowset.addRow : cannot add row. table does not exist.");
        }
        int updateCount = 0;
        String columnValues = null;
        int i = 0;
        while (columnValue[i] != null) {
            columnValues = columnValues + new String(", '" + columnValue[i] + "'");
            ++i;
        }
        String query = "insert into " + this.dso.dso + "." + this.tableName + " values(" + columnValues + " );";
        try {
            this.statement = this.connection.createStatement();
            updateCount = this.statement.executeUpdate(query);
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCRowset.addRow() : " + ex.getMessage());
        }
        return updateCount;
    }

    @Override
    public int deleteColumn(String columnName) throws SpedoException {
        if (!this.dso.getTableStatus(this.tableName)) {
            throw new SpedoException("SpedoException: JDBCRowset.deleteColumn : cannot delete column. table does not exist.");
        }
        int updateCount = 0;
        String query = "alter table " + this.dso.dso + "." + this.tableName + " drop " + columnName + ";";
        try {
            this.statement = this.connection.createStatement();
            updateCount = this.statement.executeUpdate(query);
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCRowset.deleteColumn() : " + ex.getMessage());
        }
        return updateCount;
    }

    @Override
    public int deleteRow() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.deleteRow() : method not supported.");
    }

    @Override
    public int setCell(Object cell) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.setCell : method not yet implemented.");
    }

    @Override
    public int setColumn(Object columnValue) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.setColumn : method not yet implemented.");
    }

    @Override
    public int setRow(Object row) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.setRow : method not yet implemented.");
    }

    @Override
    public void getQueryResults(String query) throws SpedoException {
        try {
            this.statement = this.connection.createStatement();
            this.rs = this.statement.executeQuery(query);
            this.rsmd = this.rs.getMetaData();
            this.isOpen = true;
            this.query = query;
            this.getQueryResultsCalled = true;
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCRowset.getQueryResults() : " + ex.getMessage());
        }
    }

    public int executeUpdate(String tableName, String query) throws SpedoException {
        int updateCount = 0;
        try {
            this.statement = this.connection.createStatement();
            updateCount = this.statement.executeUpdate(query);
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCRowset.executeUpdate() : " + ex.getMessage());
        }
        return updateCount;
    }

    @Override
    public void createTable(String optionString) throws SpedoException {
        if (this.columnNames == null) {
            throw new SpedoException("SpedoException: JDBCRowset.createTable() : column names must be pre-defined.");
        }
        try {
            this.statement = this.connection.createStatement();
            String query = "create table " + this.dso.dso + "." + this.tableName + "(" + this.columnNames + ")";
            int n = this.statement.executeUpdate(query);
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCRowset.createTable() : " + ex.getMessage());
        }
        this.tableCreated = true;
    }

    @Override
    public IBookmark getBookmark() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.getBookmark() : This method is not supported.");
    }

    @Override
    public void applyUpdates() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.applyUpdates() : This method is not supported.");
    }

    @Override
    public void cancelUpdates() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.cancelUpdates() : This method is not supported.");
    }

    @Override
    public void setByStatement(String text, boolean appendFlag) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.setByStatement : This method is not supported.");
    }

    @Override
    public void setOrderByStatement(String text, boolean appendFlag) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCRowset.setOrderByStatement() : SpedoRowset already open. Cannot set BY statement.");
        }
        if (text != null && text.length() != 0) {
            this.orderByText = appendFlag ? this.orderByText + new String(", " + text.trim()) : text;
        }
    }

    @Override
    public ISpedoRowset getByGroup() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCRowset.getByGroup() : This method is not supported.");
    }

    @Override
    public void setWhereClause(String text, boolean appendFlag) throws SpedoException {
        if (this.isOpen) {
            throw new SpedoException("SpedoException: JDBCRowset.setWhereClause() : SpedoRowset already open. Cannot set WHERE clause.");
        }
        if (text != null && text.length() != 0) {
            this.whereText = appendFlag ? this.whereText + new String(" and " + text.trim()) : text;
        }
    }

    @Override
    public boolean supportsAddRow() throws SpedoException {
        return false;
    }

    @Override
    public boolean supportsAddColumn() throws SpedoException {
        return true;
    }

    @Override
    public boolean supportsDeleteRow() throws SpedoException {
        return true;
    }

    @Override
    public boolean supportsDeleteColumn() throws SpedoException {
        return true;
    }

    @Override
    public boolean supportsUpdate() throws SpedoException {
        return true;
    }

    @Override
    public boolean supportsDelayedUpdate() throws SpedoException {
        return false;
    }

    @Override
    public boolean supportsBookmark() throws SpedoException {
        return false;
    }

    @Override
    public boolean supportsCreateTable() throws SpedoException {
        return true;
    }
}

