/*
 * Decompiled with CFR 0.152.
 */
package com.sas.spedo.jdbc;

import com.sas.net.sharenet.ShareNetConnection;
import com.sas.spedo.ISpedoDSO;
import com.sas.spedo.ISpedoRowset;
import com.sas.spedo.ISpedoSchemaRowset;
import com.sas.spedo.SpedoException;
import com.sas.spedo.jdbc.JDBCRowset;
import com.sas.spedo.jdbc.JDBCSchemaRowset;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class JDBCDSO
implements ISpedoDSO {
    String provider = null;
    String dso = null;
    Statement statement = null;
    String tableName = null;
    ResultSet resultset = null;
    ResultSet rs = null;
    String user = null;
    String passwd = null;
    String server = null;
    String optionString = null;
    boolean connected = false;
    Connection connection;
    boolean tableStatus = false;
    Properties info = new Properties();

    public JDBCDSO() throws SpedoException {
        this.provider = new String("SASADBAS");
        this.dso = new String("");
        this.user = new String("");
        this.passwd = new String("");
        this.server = new String("");
        this.optionString = new String("");
    }

    @Override
    public void setProvider(String provider) throws SpedoException {
        this.provider = provider;
    }

    @Override
    public String getProvider() throws SpedoException {
        return this.provider;
    }

    @Override
    public void setSpedoDSO(String dso) throws SpedoException {
        this.dso = dso;
    }

    @Override
    public String getSpedoDSO() throws SpedoException {
        return this.dso;
    }

    @Override
    public void setUser(String user) throws SpedoException {
        this.user = user;
    }

    @Override
    public String getUser() throws SpedoException {
        return this.user;
    }

    @Override
    public void setPassword(String passwd) throws SpedoException {
        this.passwd = passwd;
    }

    @Override
    public String getPassword() throws SpedoException {
        return this.passwd;
    }

    @Override
    public void setServer(String server) throws SpedoException {
        this.server = server;
    }

    @Override
    public String getServer() throws SpedoException {
        return this.server;
    }

    @Override
    public void setOptionString(String optionString) throws SpedoException {
        this.optionString = optionString;
    }

    @Override
    public String getOptionString() throws SpedoException {
        return this.optionString;
    }

    public void setConnection(Object connection) throws SpedoException {
        if (!(connection instanceof Connection)) {
            throw new SpedoException("SpedoException: JDBCDSO.setConnection: Invalid connection object");
        }
        this.connection = (Connection)connection;
    }

    public Connection getConnection() throws SpedoException {
        return this.connection;
    }

    @Override
    public void setProperty(int count, Properties properties) throws SpedoException {
        String temp = properties.getProperty("provider");
        this.info.put("provider", temp);
        temp = properties.getProperty("dso");
        this.info.put("dso", temp);
        temp = properties.getProperty("user");
        this.info.put("user", temp);
        temp = properties.getProperty("passwd");
        this.info.put("passwd", temp);
        temp = properties.getProperty("server");
        this.info.put("server", temp);
        temp = properties.getProperty("optionString");
        this.info.put("optionString", temp);
    }

    @Override
    public String getProperty(String propertyName) throws SpedoException {
        return this.info.getProperty(propertyName);
    }

    public DriverPropertyInfo[] getPropertyInfo(int count, Properties info) {
        DriverPropertyInfo[] dsoProperties = new DriverPropertyInfo[count];
        dsoProperties[0] = new DriverPropertyInfo("provider", "");
        dsoProperties[1] = new DriverPropertyInfo("dso", "");
        dsoProperties[2] = new DriverPropertyInfo("user", "");
        dsoProperties[3] = new DriverPropertyInfo("passwd", "");
        dsoProperties[4] = new DriverPropertyInfo("server", "");
        dsoProperties[5] = new DriverPropertyInfo("optionString", "");
        return dsoProperties;
    }

    @Override
    public boolean supportsTableCreation() throws SpedoException {
        return false;
    }

    @Override
    public void connect() throws SpedoException {
        if (this.dso == null) {
            throw new SpedoException("No dso specified");
        }
        String Stmt = new String("LIBNAME " + this.dso);
        if (this.connection instanceof ShareNetConnection && this.optionString.indexOf("alreadyExists") == -1) {
            try {
                this.statement = this.connection.createStatement();
                this.statement.execute(Stmt);
            }
            catch (SQLException se) {
                throw new SpedoException("SpedoException: JDBCDSO.connect() : " + se.getMessage());
            }
        }
        this.connected = true;
    }

    @Override
    public void connect(Object connect) throws SpedoException {
        this.connection = (Connection)connect;
        if (this.dso == null) {
            throw new SpedoException("SpedoException: JDBCDSO.connect: No dso specified");
        }
        this.connected = true;
    }

    public void disconnect() throws SpedoException {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        try {
            if (this.connection instanceof ShareNetConnection && this.optionString.indexOf("alreadyExists") == -1) {
                return;
            }
            this.connection.close();
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCDSO.disconnect() : " + se.getMessage());
        }
    }

    @Override
    public ISpedoSchemaRowset getTableRowset() throws SpedoException {
        try {
            String query = "select memname as table from dictionary.tables where libname='" + this.dso.trim().toUpperCase() + "';";
            this.statement = this.connection.createStatement();
            this.rs = this.statement.executeQuery(query);
            JDBCSchemaRowset mdrs = new JDBCSchemaRowset(this.statement, this.rs, 1);
            return mdrs;
        }
        catch (SQLException se) {
            throw new SpedoException("SpedoException: JDBCDSO.getTableRowset() : " + se.getMessage());
        }
    }

    @Override
    public ISpedoSchemaRowset getColumnRowset(String tableName) throws SpedoException {
        try {
            JDBCSchemaRowset mdrs = new JDBCSchemaRowset(tableName, this);
            mdrs.open();
            return mdrs;
        }
        catch (SpedoException se) {
            throw new SpedoException("SpedoException: JDBCDSO.getColumnRowset() : " + se.getMessage());
        }
    }

    @Override
    public ISpedoSchemaRowset getColumnRowset(String tableName, String password) throws SpedoException {
        try {
            JDBCSchemaRowset mdrs = new JDBCSchemaRowset(tableName, password, this);
            mdrs.open();
            return mdrs;
        }
        catch (SpedoException se) {
            throw new SpedoException("SpedoException: JDBCDSO.getColumnRowset() : " + se.getMessage());
        }
    }

    @Override
    public ISpedoSchemaRowset getDSOSchemaRowset() throws SpedoException {
        throw new SpedoException("SpedoException: JDBCDSO.getDSOSchemaRowset() : method not supported.");
    }

    public boolean getTableStatus(String tableName) throws SpedoException {
        JDBCSchemaRowset rsmd = (JDBCSchemaRowset)this.getTableRowset();
        boolean b = rsmd.positionCursor();
        while (b) {
            String s1 = rsmd.getString(1);
            if (s1.equals(tableName.trim().toUpperCase())) {
                rsmd.close();
                return true;
            }
            b = rsmd.positionCursor();
        }
        rsmd.close();
        return false;
    }

    @Override
    public ISpedoRowset createRowset(String tableName, String password, String className) throws SpedoException {
        this.tableName = tableName;
        JDBCRowset jdbc_rs = new JDBCRowset(tableName, password, this);
        return jdbc_rs;
    }

    @Override
    public ISpedoRowset createRowset(String tableName, String className) throws SpedoException {
        this.tableName = tableName;
        JDBCRowset jdbc_rs = new JDBCRowset(tableName, this);
        return jdbc_rs;
    }

    @Override
    public boolean deleteTable(String tableName) throws SpedoException {
        int updateCount = 0;
        String query = "drop table " + this.dso + "." + tableName + ";";
        try {
            this.statement = this.connection.createStatement();
            updateCount = this.statement.executeUpdate(query);
        }
        catch (SQLException ex) {
            throw new SpedoException("SpedoException: JDBCDSO.deleteTable() : " + ex.getMessage());
        }
        return updateCount == 0;
    }

    @Override
    public Object getFormats(String formatName, int formatID) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCDSO.getFormats: This method is not yet supported");
    }

    @Override
    public int formatToId(String formatName) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCDSO.formatToId: This method is not yet supported");
    }

    @Override
    public String idToFormat(int formatID) throws SpedoException {
        throw new SpedoException("SpedoException: JDBCDSO.idToFormat: This method is not yet supported");
    }
}

