/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.tree;

import com.sas.beans.PropertyChangeListenerList;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.rmi.Connection;
import com.sas.sasserver.SASListDelegate;
import com.sas.sasserver.tree.ServerNodeInterface;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.awt.MediaTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

public class NodeDelegate
extends SASListDelegate
implements TreeInterface,
NodeInterface,
NodeIconInterface {
    transient ServerNodeInterface remoteNode;
    protected transient OrderedCollectionInterface children;
    protected transient Connection connection;
    protected transient String text;
    protected transient String expText;
    protected transient String nodeType;
    protected transient String iconName;
    protected transient String expIconName;
    protected transient String selIconName;
    protected transient String expSelIconName;
    protected transient String className;
    protected transient int iconNum;
    protected transient int expIconNum;
    protected transient int selIconNum;
    protected transient int expSelIconNum;
    protected transient int otherIconsNum;
    protected transient IconInterface icon;
    protected transient IconInterface expIcon;
    protected transient IconInterface selIcon;
    protected transient IconInterface expSelIcon;
    protected transient int id;
    protected transient int parentID;
    protected transient Boolean isLeaf = Boolean.FALSE;
    private transient PropertyChangeListenerList allPropertyChangeListeners;
    HListInterface initializationParams = new HList();
    private static Hashtable icons;

    NodeDelegate() {
    }

    NodeDelegate(Connection connection, HListInterface params) {
        this();
        this.initializationParams.addItems(params.getItems());
        this.connection = connection;
        this.parseParams(params);
    }

    protected OrderedCollectionInterface getChildren() {
        if (this.children == null) {
            this.children = new OrderedCollection();
        }
        return this.children;
    }

    @Override
    protected synchronized void resubmitQuery() {
    }

    protected void parseParams(HListInterface params) {
        this.text = this.parseStringParam(params, "TEXT");
        this.expText = this.parseStringParam(params, "EXPANDEDTEXT");
        this.nodeType = this.parseStringParam(params, "TYPE");
        this.iconNum = this.parseIntParam(params, "ICON");
        this.expIconNum = this.parseIntParam(params, "EXPANDEDICON");
        this.selIconNum = this.parseIntParam(params, "SELECTEDICON");
        this.expSelIconNum = this.parseIntParam(params, "EXPANDEDSELECTEDICON");
        this.otherIconsNum = this.parseIntParam(params, "OTHERICONS");
        this.className = this.parseStringParam(params, "CLASS");
        int leaf = this.parseIntParam(params, "LEAF");
        this.parentID = this.parseIntParam(params, "PARENTID");
        this.isLeaf = leaf > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.id = this.parseIntParam(params, "ID");
        if (this.otherIconsNum > 0) {
            if (this.expIconNum == 0) {
                this.expIconNum = this.otherIconsNum;
            }
            if (this.expSelIconNum == 0) {
                this.expSelIconNum = this.otherIconsNum;
            }
            if (this.selIconNum == 0) {
                this.selIconNum = this.otherIconsNum;
            }
        }
        this.iconName = this.createImageString(this.iconNum);
        this.expIconName = this.createImageString(this.expIconNum);
        this.expSelIconName = this.createImageString(this.expSelIconNum);
        this.selIconName = this.createImageString(this.selIconNum);
    }

    private String createImageString(int iconNumber) {
        if (iconNumber >= 1000) {
            return "icon" + iconNumber + "_16";
        }
        if (iconNumber >= 100) {
            return "icon0" + iconNumber + "_16";
        }
        if (iconNumber >= 10) {
            return "icon00" + iconNumber + "_16";
        }
        if (iconNumber > 0) {
            return "icon000" + iconNumber + "_16";
        }
        return null;
    }

    protected String parseStringParam(HListInterface params, String key) {
        int index = params.find(key, 1, 0);
        String s = index >= 0 ? params.getString(index) : "";
        return s;
    }

    protected int parseIntParam(HListInterface params, String key) {
        int index = params.find(key, 1, 0);
        int i = index >= 0 ? (int)params.getDouble(index) : 0;
        return i;
    }

    protected void reset() {
        this.text = null;
        this.expText = null;
        this.nodeType = null;
        this.iconName = null;
        this.expIconName = null;
        this.selIconName = null;
        this.expSelIconName = null;
        this.className = null;
        this.icon = null;
        this.expIcon = null;
        this.selIcon = null;
        this.expSelIcon = null;
        this.isLeaf = null;
    }

    protected void initialize(HListInterface params) {
        this.reset();
        this.parseParams(params);
        this.remoteNode()._initialize(params, this.parentID, 0);
    }

    protected void setRemoteNode(ServerNodeInterface rNode) {
        if (this.remoteNode != null) {
            throw new IllegalStateException("Remote node already assigned.");
        }
        this.remoteNode = rNode;
    }

    protected ServerNodeInterface remoteNode() {
        if (this.remoteNode != null) {
            return this.remoteNode;
        }
        try {
            this.setRemoteNode((ServerNodeInterface)this.connection.getClassFactory().newInstance(ServerNodeInterface.class, this.connection, this.className, this.id));
            this.initialize(this.initializationParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.remoteNode;
    }

    public IconInterface getDefaultIcon() {
        if (this.icon == null) {
            if (this.iconName == null) {
                int iNum = this.remoteNode()._getDefaultIcon();
                this.iconName = this.createImageString(iNum);
            }
            this.icon = this.loadIcon(this.iconName, "Invalid");
        }
        return this.icon;
    }

    public void setDefaultIcon(int iNum) {
        if (iNum == this.iconNum) {
            return;
        }
        this.iconName = this.createImageString(iNum);
        this.iconNum = iNum;
        this.icon = this.loadIcon(this.iconName, "Invalid");
        this.initializationParams.setItem("ICON", (double)this.iconNum);
        if (this.remoteNode != null) {
            this.remoteNode._setDefaultIcon(this.iconNum);
        }
    }

    public IconInterface getExpandedIcon() {
        if (this.expIcon == null) {
            if (this.expIconName == null) {
                this.expIconNum = this.remoteNode()._getExpandedIcon();
                this.expIconName = this.createImageString(this.expIconNum);
                if (this.expIconName == null && this.iconName != null && this.iconName.trim().length() > 0) {
                    this.expIconName = this.iconName;
                }
            }
            this.expIcon = this.loadIcon(this.expIconName, "Invalid");
        }
        return this.expIcon;
    }

    public void setExpandedIcon(int iNum) {
        if (this.expIconNum == iNum) {
            return;
        }
        this.expIconNum = iNum;
        this.expIconName = this.createImageString(this.expIconNum);
        this.expIcon = this.loadIcon(this.expIconName, "Invalid");
        this.initializationParams.setItem("EXPANDEDICON", (double)this.expIconNum);
        if (this.remoteNode != null) {
            this.remoteNode._setExpandedIcon(this.expIconNum);
        }
    }

    public IconInterface getExpandedSelectedIcon() {
        if (this.expSelIcon == null) {
            if (this.expSelIconName == null) {
                this.expSelIconNum = this.remoteNode()._getExpandedSelectedIcon();
                this.expSelIconName = this.createImageString(this.expSelIconNum);
                if (this.expSelIconName == null && this.expIconName != null && this.expIconName.trim().length() > 0) {
                    this.expSelIconName = this.expIconName;
                } else if (this.expSelIconName == null && this.iconName != null && this.iconName.trim().length() > 0) {
                    this.expSelIconName = this.iconName;
                }
            }
            this.expSelIcon = this.loadIcon(this.expSelIconName, "Invalid");
        }
        return this.expSelIcon;
    }

    public void setExpandedSelectedIcon(int iNum) {
        if (this.expSelIconNum == iNum) {
            return;
        }
        this.expSelIconNum = iNum;
        this.expSelIconName = this.createImageString(this.expSelIconNum);
        this.expSelIcon = this.loadIcon(this.expSelIconName, "Invalid");
        this.initializationParams.setItem("EXPANDEDSELECTEDICON", (double)this.expSelIconNum);
        if (this.remoteNode != null) {
            this.remoteNode._setExpandedSelectedIcon(this.expSelIconNum);
        }
    }

    public IconInterface getSelectedIcon() {
        if (this.selIcon == null) {
            if (this.selIconName == null) {
                this.selIconNum = this.remoteNode()._getSelectedIcon();
                this.selIconName = this.createImageString(this.selIconNum);
                if (this.selIconName == null && this.iconName != null && this.iconName.trim().length() > 0) {
                    this.selIconName = this.iconName;
                }
            }
            this.selIcon = this.loadIcon(this.selIconName, "Invalid");
        }
        return this.selIcon;
    }

    public void setSelectedIcon(int iNum) {
        if (this.selIconNum == iNum) {
            return;
        }
        this.selIconNum = iNum;
        this.selIconName = this.createImageString(iNum);
        this.selIcon = this.loadIcon(this.iconName, "Invalid");
        this.initializationParams.setItem("SELECTEDICON", (double)this.selIconNum);
        if (this.remoteNode != null) {
            this.remoteNode._setSelectedIcon(this.selIconNum);
        }
    }

    protected IconInterface loadIcon(String iconName) {
        ImageView icon = null;
        if (iconName != null && Strings.trimmedLength((String)iconName) != 0) {
            try {
                if (icons != null && (icon = (ImageView)icons.get(iconName)) != null) {
                    return icon;
                }
                ImageView image = new ImageView(Resources.getImage((String)iconName));
                MediaTracker tracker = image.getMediaTracker();
                icon = image;
                tracker.waitForAll();
            }
            catch (InterruptedException image) {
            }
            catch (Exception e) {
                return null;
            }
        }
        if (icons == null) {
            icons = new Hashtable();
        }
        icons.put(iconName, icon);
        return icon;
    }

    protected IconInterface loadIcon(String iconName, String defaultImageName) {
        IconInterface icon = this.loadIcon(iconName);
        if (icon == null) {
            icon = this.loadIcon(defaultImageName);
        }
        return icon;
    }

    public String getNodeExpandedText() {
        if (this.expText != null) {
            return this.expText;
        }
        this.expText = this.remoteNode()._getNodeExpandedText();
        if (this.expText == null) {
            this.expText = this.getNodeText();
        }
        return this.expText;
    }

    public void setNodeExpandedText(String text) {
        if (Util.equal((Object)this.getNodeExpandedText(), (Object)text)) {
            return;
        }
        this.expText = text;
        this.initializationParams.setItem("EXPANDEDTEXT", this.iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setNodeExpandedText(text);
        }
    }

    public String getNodeText() {
        if (this.text != null) {
            return this.text;
        }
        this.text = this.remoteNode()._getNodeText();
        return this.text;
    }

    public void setNodeText(String text) {
        if (Util.equal((Object)this.getNodeText(), (Object)text)) {
            return;
        }
        this.text = text;
        this.initializationParams.setItem("TEXT", this.iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setNodeText(text);
        }
    }

    public String getNodeType() {
        if (this.nodeType != null) {
            return this.nodeType;
        }
        this.nodeType = this.remoteNode()._getNodeType();
        return this.nodeType;
    }

    public void setNodeType(String type) {
        if (Util.equal((Object)this.getNodeType(), (Object)type)) {
            return;
        }
        this.nodeType = type;
        this.initializationParams.setItem("TYPE", this.iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setNodeType(type);
        }
    }

    public int countNodeChildren(int maxCount) {
        if (this.isLeafNode()) {
            return 0;
        }
        int cnt = this.remoteNode()._countNodeChildren(maxCount);
        if (cnt == 0) {
            this.isLeaf = Boolean.TRUE;
            this.firePropertyChange("leafNode", Boolean.FALSE, this.isLeaf);
        }
        return cnt;
    }

    public SimpleNodeInterface getNodeChild(int nodeIndex) {
        if (this.isLeafNode()) {
            return null;
        }
        SimpleNodeInterface[] nc = this.getNodeChildren(nodeIndex, 1);
        if (nc.length > 0) {
            return nc[0];
        }
        return null;
    }

    public int getNodeChildCount() {
        if (this.isLeafNode()) {
            return 0;
        }
        int cnt = this.remoteNode()._getNodeChildCount();
        if (cnt == 0) {
            this.isLeaf = Boolean.TRUE;
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return cnt;
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        SimpleNodeInterface[] childNodes = new SimpleNodeInterface[count];
        OrderedCollectionInterface kids = this.getChildren();
        int i = startIndex;
        int j = 0;
        while (count > 0) {
            int nKids = kids.count();
            if (i >= nKids) {
                if (i > nKids) {
                    kids.setSize(i);
                }
                HListInterface childNodesList = this.remoteNode()._getNodeChildren(startIndex + 1, count);
                for (int c = 0; c < childNodesList.count(); ++c) {
                    HListInterface childDesc = childNodesList.getList(c);
                    kids.add((Object)new NodeDelegate(this.connection, childDesc));
                }
                if (i == kids.count()) {
                    return (SimpleNodeInterface[])Util.copyArray((Object)childNodes, (int)0, (int)i);
                }
            }
            childNodes[j] = (SimpleNodeInterface)kids.get(i);
            ++i;
            ++j;
            --count;
        }
        return childNodes;
    }

    public boolean isLeafNode() {
        if (this.isLeaf != null) {
            return this.isLeaf;
        }
        boolean b = this.remoteNode()._isLeafNode();
        Boolean bl = this.isLeaf = b ? Boolean.TRUE : Boolean.FALSE;
        if (b) {
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return b;
    }

    void _removeNodeChild(int index) {
        this.remoteNode()._removeNodeChild(index + 1);
    }

    public NodeInterface getRoot() {
        if (this.isDesignTime() || this.isLeafNode()) {
            return null;
        }
        return this.remoteNode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        this.notifyPropertyChange(event);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.notifyPropertyChange(event);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners == null) {
            this.allPropertyChangeListeners = new PropertyChangeListenerList();
        }
        this.allPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners != null) {
            this.allPropertyChangeListeners.remove(listener);
        }
    }

    protected void notifyPropertyChange(PropertyChangeEvent event) {
        if (this.allPropertyChangeListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.allPropertyChangeListeners.getListeners()) {
            listener.propertyChange(event);
        }
    }
}

