/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.sasfilelist;

import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.Node;
import com.sas.models.SimpleNodeInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.SASListNodeDelegate;
import com.sas.sasserver.catalogentrylist.SASCatalogEntryListNode;
import com.sas.sasserver.dataset.SASDataSetNode;
import com.sas.sasserver.sasfilelist.RB;
import com.sas.sasserver.sasfilelist.SASFileListInterface;
import com.sas.sasserver.sclfuncs.SclfuncsV2Interface;
import com.sas.text.Message;
import com.sas.util.SystemLog;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;

public class SASFileListDelegate
extends SASListNodeDelegate {
    private transient SASFileListInterface m_remoteObject;
    private transient SclfuncsV2Interface sclfuncs;
    protected transient String rootText;
    protected transient String library;
    protected transient String pendingLibrary;
    protected transient String typeFilter;
    protected transient int levelCount;
    protected transient boolean SASFileDisplayed;
    protected transient boolean labelDisplayed;
    protected transient boolean typeDisplayed;
    boolean leafNode;
    protected transient boolean dataSetColumnsDisplayed;
    protected transient boolean catalogEntriesDisplayed;

    @Override
    public void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.m_remoteObject = (SASFileListInterface)this.remoteObject();
    }

    private String getLabel(String fileName) {
        int fileNameLength;
        if (this.sclfuncs == null) {
            RemoteBaseClient rbc = (RemoteBaseClient)((Object)this.m_remoteObject);
            Connection rocfContext = rbc._RemoteObject_getContext();
            Rocf classFactory = rbc._RemoteObject_getClassFactory();
            try {
                this.sclfuncs = (SclfuncsV2Interface)classFactory.getInstance(SclfuncsV2Interface.class, rocfContext);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if ((fileNameLength = fileName.length()) > 0) {
            int tableId = this.sclfuncs.open(fileName.substring(0, fileNameLength - 1), "I");
            String desc = this.sclfuncs.attrc(tableId, "LABEL");
            this.sclfuncs.close(tableId);
            return desc;
        }
        return "";
    }

    protected synchronized String parseItem(HListInterface membersList, int index, boolean SASFileDisplayed, boolean labelDisplayed, boolean typeDisplayed, int levelCount) {
        HListInterface subList = membersList.getList(index);
        String stringItem = "";
        String libraryName = subList.getString("LIBNAME");
        String memberName = subList.getString("MEMNAME");
        String sasFullFileName = libraryName.trim() + "." + memberName.trim() + ".";
        if (SASFileDisplayed) {
            int sasFileNameLength;
            String sasFileName = "";
            String typeName = subList.getString("MEMTYPE");
            if (levelCount >= 2) {
                sasFileName = sasFileName + libraryName.trim() + ".";
            }
            if (levelCount >= 1) {
                sasFileName = sasFileName + memberName.trim() + ".";
            }
            if (levelCount >= 3) {
                sasFileName = sasFileName + typeName.trim() + ".";
            }
            if ((sasFileNameLength = sasFileName.length()) > 0) {
                stringItem = stringItem + sasFileName.substring(0, sasFileNameLength - 1) + " ";
            }
        }
        String typeName = subList.getString("MEMTYPE");
        if (labelDisplayed && (typeName.equals("DATA") || typeName.equals("VIEW"))) {
            String desc = "";
            desc = subList.find("LABEL", 1, 0) != -1 ? subList.getString("LABEL") : this.getLabel(sasFullFileName);
            stringItem = stringItem + desc + " ";
        }
        if (typeDisplayed) {
            stringItem = stringItem + subList.getString("TYPE") + " ";
        }
        stringItem = stringItem.trim();
        return stringItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void parseList(HListInterface membersList, OrderedCollectionInterface parsedList) {
        OrderedCollectionInterface orderedCollectionInterface = parsedList;
        synchronized (orderedCollectionInterface) {
            parsedList.removeAll();
            boolean SASFileDisplayed = this.isSASFileDisplayed();
            boolean labelDisplayed = this.isLabelDisplayed();
            boolean typeDisplayed = this.isTypeDisplayed();
            int levelCount = this.getLevelCount();
            int count = membersList.count();
            for (int i = 0; i < count; ++i) {
                parsedList.add((Object)this.parseItem(membersList, i, SASFileDisplayed, labelDisplayed, typeDisplayed, levelCount));
            }
        }
    }

    public synchronized String getLibrary() {
        return this.library;
    }

    public synchronized void setLibrary(String library) {
        String previousLibrary = this.getLibrary();
        if (!(previousLibrary != null && previousLibrary.length() != 0 || library != null && library.length() != 0)) {
            return;
        }
        if (!Util.equal((Object)library, (Object)previousLibrary)) {
            int rc = this.m_remoteObject._setLibrary(library);
            if (rc != 0 && rc != -70008) {
                String message = RB.getStringResource("SASFileListDelegate.invalidLibrary.ex.txt");
                throw new IllegalArgumentException(Message.format((String)message, (Object)library));
            }
            if (rc == -70008) {
                SystemLog.logNote((String)("Library " + library + " does not exist"));
                this.libExists = false;
            } else {
                this.libExists = true;
            }
            this.library = library;
            this.pendingLibrary = library;
            this.fireContentsChanged();
            this.firePropertyChange("library", previousLibrary, library);
        }
    }

    public synchronized void setPendingLibrary(String library) {
        this.pendingLibrary = library;
    }

    public synchronized String getTypeFilter() {
        return this.typeFilter;
    }

    public synchronized void setTypeFilter(String typeFilter) {
        String previousTypeFilter = this.getTypeFilter();
        if (!Util.equal((Object)typeFilter, (Object)previousTypeFilter)) {
            this.typeFilter = typeFilter;
            this.m_remoteObject._setTypeFilter(this.getCatalogTypeFilter(typeFilter));
            this.fireContentsChanged();
            this.firePropertyChange("typeFilter", previousTypeFilter, typeFilter);
        }
    }

    private String getCatalogTypeFilter(String typeFilter) {
        int parenIndex = typeFilter.indexOf(40);
        if (parenIndex == -1) {
            return typeFilter;
        }
        String catalogTypeFilter = typeFilter.substring(0, parenIndex);
        return catalogTypeFilter;
    }

    private String getCatalogEntryTypeFilter(String typeFilter) {
        int parenIndex = typeFilter.indexOf(40);
        if (parenIndex == -1) {
            return null;
        }
        String catalogEntryTypeFilter = typeFilter.substring(parenIndex + 1, typeFilter.length());
        int closingParenIndex = catalogEntryTypeFilter.indexOf(41);
        if (closingParenIndex != -1) {
            catalogEntryTypeFilter = catalogEntryTypeFilter.substring(0, closingParenIndex);
        }
        return catalogEntryTypeFilter;
    }

    public synchronized int getLevelCount() {
        return this.levelCount;
    }

    public synchronized void setLevelCount(int levelCount) {
        int previousLevelCount = this.getLevelCount();
        if (previousLevelCount != levelCount) {
            if (levelCount < 1 || levelCount > 4) {
                throw new IllegalArgumentException(Util.getCommonStringResource((String)"InvalidLevelCount.ex.txt"));
            }
            this.levelCount = levelCount;
            this.fireContentsChanged();
            this.firePropertyChange("levelCount", new Integer(previousLevelCount), new Integer(levelCount));
        }
    }

    public synchronized boolean isSASFileDisplayed() {
        return this.SASFileDisplayed;
    }

    public synchronized void setSASFileDisplayed(boolean SASFileDisplayed) {
        if (this.isSASFileDisplayed() != SASFileDisplayed) {
            this.SASFileDisplayed = SASFileDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("SASFileDisplayed", SASFileDisplayed ? Boolean.FALSE : Boolean.TRUE, SASFileDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getSASFile(int index, int levelCount) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, true, false, false, levelCount);
    }

    public synchronized boolean isLabelDisplayed() {
        return this.labelDisplayed;
    }

    public synchronized void setLabelDisplayed(boolean labelDisplayed) {
        if (this.isLabelDisplayed() != labelDisplayed) {
            this.labelDisplayed = labelDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("labelDisplayed", labelDisplayed ? Boolean.FALSE : Boolean.TRUE, labelDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getLabel(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, false, true, false, 0);
    }

    public synchronized boolean isTypeDisplayed() {
        return this.typeDisplayed;
    }

    public synchronized void setTypeDisplayed(boolean typeDisplayed) {
        if (this.isTypeDisplayed() != typeDisplayed) {
            this.typeDisplayed = typeDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("typeDisplayed", typeDisplayed ? Boolean.FALSE : Boolean.TRUE, typeDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getType(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, false, false, true, 0);
    }

    @Override
    public synchronized int getNodeChildCount() {
        int childCount;
        if (this.pendingLibrary != null && !this.pendingLibrary.equalsIgnoreCase(this.getLibrary())) {
            this.setLibrary(this.pendingLibrary);
        }
        if ((childCount = this.count()) == 0 && this.hasChildren) {
            this.hasChildren = false;
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return childCount;
    }

    @Override
    public synchronized SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        int nodeChildCount = this.getNodeChildCount();
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        if (nodeChildCount == 0) {
            return childrenArray;
        }
        RemoteBaseClient rbc = (RemoteBaseClient)((Object)this.m_remoteObject);
        Connection rocfContext = rbc._RemoteObject_getContext();
        Rocf classFactory = rbc._RemoteObject_getClassFactory();
        for (int index = startIndex; index < startIndex + count && index < startIndex + nodeChildCount; ++index) {
            String sasFileName = this.getSASFile(index, 3);
            int dataSetPos = -1;
            if (sasFileName.endsWith(".DATA")) {
                dataSetPos = sasFileName.lastIndexOf(".DATA");
            }
            int viewPos = -1;
            if (sasFileName.endsWith(".VIEW")) {
                viewPos = sasFileName.lastIndexOf(".VIEW");
            }
            int catalogPos = -1;
            if (sasFileName.endsWith(".CATALOG")) {
                catalogPos = sasFileName.lastIndexOf(".CATALOG");
            }
            if (dataSetPos > 0) {
                SASDataSetNode dataSet = new SASDataSetNode((String)this.get(index), this.getSASFile(index, 2), null);
                dataSet.setRocfInfo(rocfContext, classFactory);
                dataSet.setLeafNode(!this.dataSetColumnsDisplayed);
                childrenArray[index - startIndex] = dataSet;
                continue;
            }
            if (viewPos > 0) {
                SASDataSetNode dataSet = new SASDataSetNode((String)this.get(index), this.getSASFile(index, 2), null);
                dataSet.setRocfInfo(rocfContext, classFactory);
                dataSet.setLeafNode(!this.dataSetColumnsDisplayed);
                childrenArray[index - startIndex] = dataSet;
                continue;
            }
            if (catalogPos > 0) {
                SASCatalogEntryListNode catalogEntryList = new SASCatalogEntryListNode((String)this.get(index), this.getSASFile(index, 2), null);
                catalogEntryList.setRocfInfo(rocfContext, classFactory);
                catalogEntryList.setLeafNode(!this.catalogEntriesDisplayed);
                if (this.typeFilter != null && this.typeFilter.length() > 0) {
                    catalogEntryList.setTypeFilter(this.getCatalogEntryTypeFilter(this.typeFilter));
                }
                childrenArray[index - startIndex] = catalogEntryList;
                continue;
            }
            int dotPos = sasFileName.lastIndexOf(46);
            Node node = new Node((String)this.get(index));
            node.setNodeExpandedText(sasFileName.substring(0, dotPos));
            childrenArray[index - startIndex] = node;
        }
        return childrenArray;
    }

    @Override
    public synchronized boolean isLeafNode() {
        if (this.leafNode) {
            return true;
        }
        if (this.pendingLibrary != null && !this.pendingLibrary.equalsIgnoreCase(this.getLibrary())) {
            if (this.pendingLibrary.trim().length() == 0) {
                this.hasChildren = false;
            }
        } else if (this.getLibrary() == null || this.getLibrary().trim().length() == 0) {
            this.hasChildren = false;
        }
        return !this.hasChildren;
    }

    public void setLeafNode(boolean leafNode) {
        this.leafNode = leafNode;
    }

    @Override
    public synchronized String getNodeText() {
        if (this.rootText == null) {
            return this.pendingLibrary;
        }
        return this.rootText;
    }

    @Override
    public synchronized IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"Library"));
    }

    @Override
    public synchronized IconInterface getExpandedIcon() {
        return new ImageView(Resources.getImage((String)"LibraryExpanded"));
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.SASFileDisplayed = true;
        this.levelCount = 2;
        this.dataSetColumnsDisplayed = true;
        this.catalogEntriesDisplayed = true;
    }

    public synchronized void setDataSetColumnsDisplayed(boolean dataSetColumnsDisplayed) {
        this.dataSetColumnsDisplayed = dataSetColumnsDisplayed;
    }

    public synchronized void setCatalogEntriesDisplayed(boolean catalogEntriesDisplayed) {
        this.catalogEntriesDisplayed = catalogEntriesDisplayed;
    }

    public synchronized void setRootText(String rootText) {
        String oldRootText = this.rootText;
        if (!Util.equal((Object)oldRootText, (Object)rootText)) {
            this.rootText = rootText;
            this.firePropertyChange("rootText", oldRootText, rootText);
        }
    }
}

