/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.profiler;

public class ProfStat {
    String m_fullName = "";
    String m_package = "";
    String m_className = "";
    String m_methodName = "";
    boolean m_active;
    int m_index;
    long m_n;
    long m_mean;
    long m_sum;
    long m_min;
    long m_max;

    public ProfStat(String c, String m) {
        this.m_fullName = c;
        int li = this.m_fullName.lastIndexOf(".");
        if (li == -1) {
            this.m_package = "";
            this.m_className = this.m_fullName;
        } else {
            this.m_package = this.m_fullName.substring(0, li);
            this.m_className = this.m_fullName.substring(li + 1);
        }
        this.m_methodName = m;
    }

    public ProfStat() {
    }

    void traceEnter() {
        this.m_active = true;
    }

    void traceExit(long l) {
        ++this.m_n;
        this.m_sum += l;
        this.m_mean = this.m_sum / this.m_n;
        if (this.m_n == 1L) {
            this.m_min = l;
            this.m_max = l;
        }
        if (l < this.m_min) {
            this.m_min = l;
        }
        if (l > this.m_max) {
            this.m_max = l;
        }
        this.m_active = false;
    }

    void dump() {
        System.out.println("PACKAGE=" + this.m_package);
        System.out.println("CLASS=" + this.m_className);
        System.out.println("METHOD=" + this.m_methodName);
        System.out.println("N=" + this.m_n);
        System.out.println("MEAN=" + this.m_mean);
        System.out.println("MIN=" + this.m_min);
        System.out.println("MAX=" + this.m_max);
        System.out.println("SUM=" + this.m_sum);
    }
}

