/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.parentchild;

import com.sas.beans.PropertyChangeListenerList;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.lang.ObjectDataInterface;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.sasserver.SASListDelegate;
import com.sas.sasserver.parentchild.ParentChildNodeInterface;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.awt.MediaTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

class LocalParentChildNodeDelegate
extends SASListDelegate
implements TreeInterface,
NodeInterface,
NodeIconInterface,
ObjectDataInterface {
    transient ParentChildNodeInterface remoteNode;
    protected transient OrderedCollectionInterface children;
    protected transient Connection connection;
    protected transient String text;
    protected transient String expText;
    protected transient String nodeType;
    protected transient String iconName;
    protected transient String expIconName;
    protected transient String selIconName;
    protected transient String expSelIconName;
    protected transient String className;
    protected int iconPathType;
    protected int expIconPathType;
    protected int expSelIconPathType;
    protected int selIconPathType;
    protected transient IconInterface icon;
    protected transient IconInterface expIcon;
    protected transient IconInterface selIcon;
    protected transient IconInterface expSelIcon;
    protected transient int id;
    protected transient int iconLocationType;
    protected transient Boolean isLeaf;
    protected transient HListInterface nodeData;
    private transient PropertyChangeListenerList allPropertyChangeListeners;
    private static Hashtable icons;
    private static String dIcon;
    private static String eIcon;
    HListInterface initializationParams = new HList();

    LocalParentChildNodeDelegate() {
    }

    LocalParentChildNodeDelegate(Connection connection, HListInterface params) {
        this();
        this.initializationParams.addItems(params.getItems());
        this.connection = connection;
        this.parseParams(params);
    }

    protected OrderedCollectionInterface getChildren() {
        if (this.children == null) {
            this.children = new OrderedCollection();
        }
        return this.children;
    }

    @Override
    protected synchronized void resubmitQuery() {
    }

    protected void parseParams(HListInterface params) {
        this.text = this.parseStringParam(params, "TEXT");
        this.expText = this.parseStringParam(params, "EXPTEXT");
        this.nodeType = this.parseStringParam(params, "TYPE");
        this.iconName = this.parseStringParam(params, "ICON");
        this.iconPathType = this.parseIntParam(params, "ICONPATHTYPE");
        this.expIconName = this.parseStringParam(params, "EXPICON");
        this.expIconPathType = this.parseIntParam(params, "EXPICONPATHTYPE");
        this.selIconName = this.parseStringParam(params, "SELICON");
        this.selIconPathType = this.parseIntParam(params, "SELICONPATHTYPE");
        this.expSelIconName = this.parseStringParam(params, "EXPSELICON");
        this.expSelIconPathType = this.parseIntParam(params, "EXPSELICONPATHTYPE");
        this.className = this.parseStringParam(params, "CLASS");
        int leaf = this.parseIntParam(params, "LEAF");
        this.isLeaf = leaf > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.id = this.parseIntParam(params, "ID");
        this.nodeData = this.parseListParam(params, "OBJECTDATA");
    }

    protected String parseStringParam(HListInterface params, String key) {
        int index = params.find(key, 1, 0);
        String s = index >= 0 ? params.getString(index) : null;
        return s;
    }

    protected int parseIntParam(HListInterface params, String key) {
        int index = params.find(key, 1, 0);
        int i = index >= 0 ? (int)params.getDouble(index) : 0;
        return i;
    }

    protected HListInterface parseListParam(HListInterface params, String Key2) {
        int index = params.find(Key2, 1, 0);
        HListInterface hl = index >= 0 ? params.getList(index) : null;
        return hl;
    }

    protected void reset() {
        this.text = null;
        this.expText = null;
        this.nodeType = null;
        this.iconName = null;
        this.expIconName = null;
        this.selIconName = null;
        this.expSelIconName = null;
        this.className = null;
        this.icon = null;
        this.iconPathType = 0;
        this.expIcon = null;
        this.expIconPathType = 0;
        this.selIcon = null;
        this.selIconPathType = 0;
        this.expSelIcon = null;
        this.expSelIconPathType = 0;
        this.isLeaf = null;
        this.nodeData = null;
    }

    protected void initialize(HListInterface params) {
        this.reset();
        this.remoteNode()._initialize(params);
        this.parseParams(params);
    }

    protected void setRemoteNode(ParentChildNodeInterface rNode) {
        if (this.remoteNode != null) {
            throw new IllegalStateException("Remote node already assigned.");
        }
        this.remoteNode = rNode;
        this.remoteNode._setRemoteStatus(true);
    }

    public ParentChildNodeInterface remoteNode() {
        if (this.remoteNode != null) {
            return this.remoteNode;
        }
        try {
            this.setRemoteNode((ParentChildNodeInterface)this.connection.getClassFactory().newInstance(ParentChildNodeInterface.class, this.connection, this.className, this.id));
            this.initialize(this.initializationParams);
            this.addPropertyChangeListener((PropertyChangeListener)((Object)this.remoteNode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.remoteNode;
    }

    public Object getObjectData() {
        if (this.nodeData != null) {
            return this.nodeData;
        }
        return this.remoteNode._getObjectData();
    }

    public void setObjectData(Object hl) {
        if (Util.equal((Object)this.getObjectData(), (Object)hl)) {
            return;
        }
        this.nodeData = (HListInterface)hl;
        this.initializationParams.setItem("OBJECTDATA", this.nodeData);
        if (this.remoteNode != null) {
            this.remoteNode._setObjectData(this.nodeData);
        }
    }

    public IconInterface getDefaultIcon() {
        if (this.icon == null) {
            if (this.iconName == null) {
                this.iconName = this.remoteNode()._getDefaultIcon();
                this.iconPathType = this.remoteNode()._getDefaultPathType();
            }
            this.icon = this.loadIcon(this.iconName, "res/Folder.gif", this.iconPathType);
        }
        return this.icon;
    }

    public void setDefaultIcon(String defaultIconName) {
        if (Util.equal((Object)this.getDefaultIcon(), (Object)defaultIconName)) {
            return;
        }
        this.iconName = defaultIconName;
        this.icon = this.loadIcon(this.iconName, dIcon, this.iconPathType);
        this.initializationParams.setItem("ICON", this.iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setDefaultIcon(this.iconName);
        }
    }

    public int getDefaultIconType() {
        return this.iconPathType;
    }

    public void setDefaultIconPathType(int pathType) {
        if (this.iconPathType == pathType) {
            return;
        }
        this.iconPathType = pathType;
        this.icon = this.loadIcon(this.iconName, dIcon, pathType);
        this.initializationParams.setItem("ICONPATHTYPE", (double)pathType);
        if (this.remoteNode != null) {
            this.remoteNode._setDefaultPathType(pathType);
        }
    }

    public IconInterface getExpandedIcon() {
        if (this.expIcon == null) {
            if (this.expIconName == null) {
                this.expIconName = this.remoteNode()._getExpandedIcon();
                this.expIconPathType = this.remoteNode()._getExpandedPathType();
            }
            this.expIcon = this.loadIcon(this.expIconName, eIcon, this.expIconPathType);
        }
        return this.expIcon;
    }

    public void setExpandedIcon(String iconName) {
        if (Util.equal((Object)this.getExpandedIcon(), (Object)iconName)) {
            return;
        }
        this.expIconName = iconName;
        this.expIcon = this.loadIcon(this.expIconName, eIcon, this.expIconPathType);
        this.initializationParams.setItem("EXPICON", iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setExpandedIcon(this.expIconName);
        }
    }

    public int getExpandedIconPathType() {
        return this.expIconPathType;
    }

    public void setExpandedIconPathType(int pathType) {
        if (this.expIconPathType == pathType) {
            return;
        }
        this.expIconPathType = pathType;
        this.expIcon = this.loadIcon(this.expIconName, eIcon, this.expIconPathType);
        this.initializationParams.setItem("EXPICONPATHTYPE", (double)this.expIconPathType);
        if (this.remoteNode != null) {
            this.remoteNode._setExpandedPathType(this.expIconPathType);
        }
    }

    public IconInterface getExpandedSelectedIcon() {
        if (this.expSelIcon == null) {
            if (this.expSelIconName == null) {
                this.expSelIconName = this.remoteNode()._getExpandedSelectedIcon();
                this.expSelIconPathType = this.remoteNode()._getExpandedSelectedPathType();
            }
            this.expSelIcon = this.loadIcon(this.expSelIconName, eIcon, this.expSelIconPathType);
        }
        return this.expSelIcon;
    }

    public void setExpandedSelectedIcon(String iconName) {
        if (Util.equal((Object)this.getExpandedSelectedIcon(), (Object)iconName)) {
            return;
        }
        this.expSelIconName = iconName;
        this.expSelIcon = this.loadIcon(this.expSelIconName, eIcon, this.expSelIconPathType);
        this.initializationParams.setItem("EXPSELICON", iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setExpandedSelectedIcon(this.expSelIconName);
        }
    }

    public int getExpandedSelectedIconPathType() {
        return this.expSelIconPathType;
    }

    public void setExpandedSelectedIconPathType(int pathType) {
        if (this.expSelIconPathType == pathType) {
            return;
        }
        this.expSelIconPathType = pathType;
        this.expSelIcon = this.loadIcon(this.expSelIconName, eIcon, this.expSelIconPathType);
        this.initializationParams.setItem("EXPSELICONPATHTYPE", (double)this.expSelIconPathType);
        if (this.remoteNode != null) {
            this.remoteNode._setExpandedSelectedPathType(this.expSelIconPathType);
        }
    }

    public IconInterface getSelectedIcon() {
        if (this.selIcon == null) {
            if (this.selIconName == null) {
                this.selIconName = this.remoteNode()._getSelectedIcon();
                this.selIconPathType = this.remoteNode()._getSelectedPathType();
            }
            this.selIcon = this.loadIcon(this.selIconName, dIcon, this.selIconPathType);
        }
        return this.selIcon;
    }

    public void setSelectedIcon(String iconName) {
        if (Util.equal((Object)this.getSelectedIcon(), (Object)iconName)) {
            return;
        }
        this.selIconName = iconName;
        this.selIcon = this.loadIcon(iconName, dIcon, this.selIconPathType);
        this.initializationParams.setItem("SELICON", iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setSelectedIcon(iconName);
        }
    }

    public int getSelectedIconPathType() {
        return this.selIconPathType;
    }

    public void setSelectedIconPathType(int pathType) {
        if (this.selIconPathType == pathType) {
            return;
        }
        this.selIconPathType = pathType;
        this.selIcon = this.loadIcon(this.selIconName, "res/Folder.gif", this.selIconPathType);
        this.initializationParams.setItem("SELICONPATHTYPE", (double)this.selIconPathType);
        if (this.remoteNode != null) {
            this.remoteNode._setSelectedPathType(this.selIconPathType);
        }
    }

    protected IconInterface loadIcon(String iconName, String defaultImageName, int iconLocationType) {
        ImageView icon = null;
        if (iconName != null && Strings.trimmedLength((String)iconName) != 0) {
            try {
                if (icons != null && (icon = (ImageView)icons.get(iconName)) != null) {
                    return icon;
                }
                switch (iconLocationType) {
                    case 3: {
                        try {
                            icon = new ImageView(new URL(iconName));
                        }
                        catch (MalformedURLException ue) {
                            icon = new ImageView(iconName);
                        }
                        break;
                    }
                    case 0: {
                        icon = new ImageView(iconName);
                        break;
                    }
                    case 1: {
                        icon = new ImageView(iconName);
                        icon.setSourceAppletRelative(true);
                        break;
                    }
                    case 2: {
                        Class<?> c;
                        int i = iconName.indexOf(44);
                        if (i <= -1 || (c = Class.forName(iconName.substring(0, i))) == null) break;
                        icon = new ImageView(c, iconName.substring(i + 1));
                        break;
                    }
                }
                MediaTracker tracker = icon.getMediaTracker();
                tracker.waitForAll();
            }
            catch (InterruptedException tracker) {
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
        if (icon == null && icons != null && (icon = (ImageView)icons.get(defaultImageName)) != null) {
            return icon;
        }
        if (icon == null) {
            icon = new ImageView(Resources.getImage((String)defaultImageName));
            iconName = defaultImageName;
        }
        if (icons == null) {
            icons = new Hashtable();
        }
        icons.put(iconName, icon);
        return icon;
    }

    public String getNodeExpandedText() {
        if (this.expText != null) {
            return this.expText;
        }
        this.expText = this.remoteNode()._getNodeExpandedText();
        if (this.expText == null) {
            this.expText = this.getNodeText();
        }
        return this.expText;
    }

    public void setNodeExpandedText(String text) {
        if (Util.equal((Object)this.getNodeExpandedText(), (Object)text)) {
            return;
        }
        this.expText = text;
        this.initializationParams.setItem("EXPTEXT", this.iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setNodeExpandedText(text);
        }
    }

    public String getNodeText() {
        if (this.text != null) {
            return this.text;
        }
        this.text = this.remoteNode()._getNodeText();
        return this.text;
    }

    public void setNodeText(String text) {
        if (Util.equal((Object)this.getNodeText(), (Object)text)) {
            return;
        }
        this.text = text;
        this.initializationParams.setItem("TEXT", this.iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setNodeText(text);
        }
    }

    public String getNodeType() {
        if (this.nodeType != null) {
            return this.nodeType;
        }
        this.nodeType = this.remoteNode()._getNodeType();
        return this.nodeType;
    }

    public void setNodeType(String type) {
        if (Util.equal((Object)this.getNodeType(), (Object)type)) {
            return;
        }
        this.nodeType = type;
        this.initializationParams.setItem("TYPE", this.iconName);
        if (this.remoteNode != null) {
            this.remoteNode._setNodeType(type);
        }
    }

    public int countNodeChildren(int maxCount) {
        if (this.isLeafNode()) {
            return 0;
        }
        int cnt = this.remoteNode()._countNodeChildren(maxCount);
        if (cnt == 0) {
            this.isLeaf = Boolean.TRUE;
            this.firePropertyChange("leafNode", Boolean.FALSE, this.isLeaf);
        }
        return cnt;
    }

    public SimpleNodeInterface getNodeChild(int nodeIndex) {
        if (this.isLeafNode()) {
            return null;
        }
        SimpleNodeInterface[] nc = this.getNodeChildren(nodeIndex, 1);
        if (nc.length > 0) {
            return nc[0];
        }
        return null;
    }

    public int getNodeChildCount() {
        if (this.isLeafNode()) {
            return 0;
        }
        int cnt = this.remoteNode()._getNodeChildCount();
        if (cnt == 0) {
            this.isLeaf = Boolean.TRUE;
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return cnt;
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        SimpleNodeInterface[] childNodes = new SimpleNodeInterface[count];
        OrderedCollectionInterface kids = this.getChildren();
        int i = startIndex;
        int j = 0;
        while (count > 0) {
            int nKids = kids.count();
            if (i >= nKids) {
                if (i > nKids) {
                    kids.setSize(i);
                }
                HListInterface childNodesList = this.remoteNode()._getNodeChildren(startIndex + 1, count);
                for (int c = 0; c < childNodesList.count(); ++c) {
                    HListInterface childDesc = childNodesList.getList(c);
                    kids.add((Object)new LocalParentChildNodeDelegate(this.connection, childDesc));
                }
                if (i == kids.count()) {
                    return (SimpleNodeInterface[])Util.copyArray((Object)childNodes, (int)0, (int)i);
                }
            }
            childNodes[j] = (SimpleNodeInterface)kids.get(i);
            ++i;
            ++j;
            --count;
        }
        return childNodes;
    }

    public boolean isLeafNode() {
        if (this.isLeaf != null) {
            return this.isLeaf;
        }
        boolean b = this.remoteNode()._isLeafNode();
        Boolean bl = this.isLeaf = b ? Boolean.TRUE : Boolean.FALSE;
        if (b) {
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return b;
    }

    public NodeInterface getRoot() {
        if (this.isDesignTime() || this.isLeafNode()) {
            return null;
        }
        return this.remoteNode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        this.notifyPropertyChange(event);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.notifyPropertyChange(event);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners == null) {
            this.allPropertyChangeListeners = new PropertyChangeListenerList();
        }
        this.allPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.allPropertyChangeListeners != null) {
            this.allPropertyChangeListeners.remove(listener);
        }
    }

    protected void notifyPropertyChange(PropertyChangeEvent event) {
        if (this.allPropertyChangeListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.allPropertyChangeListeners.getListeners()) {
            listener.propertyChange(event);
        }
    }

    public void removeAll() {
        OrderedCollection kids = (OrderedCollection)this.getChildren();
        for (int i = 0; i < kids.count(); ++i) {
            LocalParentChildNodeDelegate kid = (LocalParentChildNodeDelegate)kids.get(i);
            if (kid.remoteNode == null) continue;
            kid.removeAll();
            RemoteBaseClient remoteKid = (RemoteBaseClient)((Object)kid.remoteNode());
            if (remoteKid != null) {
                remoteKid.stop();
            }
            kid.remoteNode = null;
        }
        if (kids != null) {
            kids.removeAll();
        }
    }

    static {
        dIcon = "res/Folder.gif";
        eIcon = "res/FolderOpen.gif";
    }
}

