/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.dialogs;

import com.sas.awt.Dialog;
import com.sas.awt.Label;
import com.sas.awt.Panel;
import com.sas.awt.TextField;
import com.sas.sasserver.mdtable.dialogs.RB;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class RenameComputedValueDialog
extends Dialog {
    public static final String RB_KEY = "RenameComputedValueDialog.";
    static final int ENTRYBOXWIDTH = 35;
    protected TextField _nameField;
    protected boolean _wasCancelled;

    public RenameComputedValueDialog(Frame parent, String name) {
        super(parent, RB.getStringResource(RB_KEY, "title.txt"), true);
        this.setLayout(new BorderLayout(0, 12));
        this.setInsets(new Insets(12, 12, 12, 12));
        Panel panel = new Panel(new BorderLayout());
        panel.initialize();
        panel.add("North", new Label(RB.getStringResource(RB_KEY, "newName.txt")));
        this._nameField = new TextField(35);
        panel.add("South", this._nameField);
        this._nameField.initialize();
        this.setOldName(name);
        this._nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RenameComputedValueDialog.this.onOK();
                }
            }
        });
        this.add("Center", panel);
        Panel buttonPanel = new Panel(new FlowLayout(2, 8, 0));
        buttonPanel.initialize();
        buttonPanel.add(this.getOKButton());
        buttonPanel.add(this.getCancelButton());
        this.add("South", buttonPanel);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this._wasCancelled = false;
        }
        super.setVisible(visible);
    }

    public void finish() {
        this.dispose();
    }

    public boolean wasCancelled() {
        return this._wasCancelled;
    }

    public String getNewName() {
        return this._nameField.getText().trim();
    }

    public void setOldName(String oldname) {
        this._nameField.setText(oldname);
        this._nameField.selectAll();
        this._nameField.requestFocus();
    }

    private Button getOKButton() {
        Button btn = new Button(Message.format((String)com.sas.visuals.RB.getStringResource((String)"okButton.txt"), (Object)"   ", (Object)"   "));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameComputedValueDialog.this.onOK();
            }
        });
        return btn;
    }

    private Button getCancelButton() {
        Button btn = new Button(Message.format((String)com.sas.visuals.RB.getStringResource((String)"cancelButton.txt"), (Object)"", (Object)""));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameComputedValueDialog.this.onCancel();
            }
        });
        return btn;
    }

    private void onCancel() {
        this._wasCancelled = true;
        this.setVisible(false);
    }

    private void onOK() {
        this.setVisible(false);
    }
}

