/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.commands;

import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.commands.NameCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.sasserver.mdtable.commands.SortCommand;
import com.sas.text.Message;
import com.sas.util.Command;

class SortNameCommand
extends NameCommand {
    transient Level _level;
    transient Member _member;
    protected static final String RB_KEY = "SortNameCommand.";
    private static String ASCENDING = RB.getStringResource("ascending.txt");
    private static String DESCENDING = RB.getStringResource("descending.txt");
    private static String RESET = RB.getStringResource("reset.txt");

    SortNameCommand(Level level) {
        if (level.isStatisticLevel()) {
            this.setText(Message.format((String)RB.getStringResource("dataSort.txt"), (Object)level.getLabel()));
        } else {
            this.setText(Message.format((String)RB.getStringResource("labelSort.txt"), (Object)level.getLabel()));
        }
        this._level = level;
    }

    SortNameCommand(Member member) {
        this._member = member;
        this._level = (Level)member.getLevel();
        if (this._level.isStatisticLevel()) {
            this.setText(Message.format((String)RB.getStringResource("dataSort.txt"), (Object)this._level.getLabel()));
        } else {
            this.setText(Message.format((String)RB.getStringResource("labelSort.txt"), (Object)this._level.getLabel()));
        }
    }

    @Override
    public Command[] getCommands() {
        String direction = RESET;
        if (this._member == null) {
            String[] sortNames = this.validSortNames(this._level.getSortDirection());
            Command[] commands = new Command[sortNames.length];
            for (int i = 0; i < sortNames.length; ++i) {
                commands[i] = new SortCommand(sortNames[i], this._level);
            }
            return commands;
        }
        direction = this._member.getSortDirection();
        String[] sortNames = this.validSortNames(direction);
        Command[] commands = new Command[sortNames.length];
        for (int i = 0; i < sortNames.length; ++i) {
            commands[i] = new SortCommand(sortNames[i], this._member);
        }
        return commands;
    }

    private String[] validSortNames(String sortDirection) {
        String[] sortNames = new String[]{ASCENDING, DESCENDING, RESET};
        return sortNames;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new SortNameCommand(this._level);
    }
}

