/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.commands;

import com.sas.GlobalInfoTable;
import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.collection.Pair;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.commands.MDCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.sasserver.mdtable.dialogs.DetailDataDialog;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.text.Message;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.util.Enumeration;

public class ShowDetailCommand
extends MDCommand {
    protected static DetailDataDialog dd;
    protected static DataSetInterface dsi;
    protected transient DataSetInterface newdsi;
    public static final String RB_KEY = "ShowDetailCommand.";
    protected static int appletID;
    protected HList _tupleList;

    public ShowDetailCommand(String name, Member member) {
        super(name, member);
    }

    public ShowDetailCommand(Member member) {
        super(1L, member);
    }

    public ShowDetailCommand(Level level) {
        super(1L, level);
    }

    public ShowDetailCommand(MultidimensionalTableInterface imddb) {
        super(com.sas.sasserver.mdtable.RB.getStringResource("showDetail.txt"), imddb);
    }

    public ShowDetailCommand(String name, int ordinal, MultidimensionalTableV2Interface imddb) {
        super(1L, (MultidimensionalTableInterface)imddb);
        if (name != null) {
            this._commandName = name;
        }
        try {
            int[] cellOrdinal = this._imddb.getAxisCoordinates(ordinal);
            AxisLabelInterface[] rowLabels = this._imddb.getAxis(1).getLabels(cellOrdinal[1]);
            this._tupleList = Member.tupleToHList((ParentNode)((Object)rowLabels[rowLabels.length - 1]));
            AxisLabelInterface[] colLabels = this._imddb.getAxis(0).getLabels(cellOrdinal[0]);
            HList clist = Member.tupleToHList((ParentNode)((Object)colLabels[colLabels.length - 1]));
            for (int i = 0; i < clist.count(); ++i) {
                this._tupleList.addItem(clist.getItem(i));
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    @Override
    public void performAction() throws TableException {
        String label = this.getLabel();
        if (label != null) {
            label.trim();
        }
        String datasetName = this.getDatasetName();
        if (this._view != null) {
            this.refreshDialog(label, datasetName);
        }
    }

    private String getLabel() throws TableException {
        StringBuffer label = new StringBuffer();
        if (this._member == null && this._level != null) {
            return label.toString();
        }
        AssociationList asl = new AssociationList();
        DimensionInterface[] di = null;
        if (this._member == null) {
            DimensionInterface[] di1 = this._imddb.getAxis(0).getDimensions(0, -1);
            DimensionInterface[] di2 = this._imddb.getAxis(1).getDimensions(0, -1);
            di = new DimensionInterface[di1.length + di2.length];
            System.arraycopy(di1, 0, di, 0, di1.length);
            System.arraycopy(di2, 0, di, di1.length, di2.length);
        } else {
            di = this._axis.getDimensions(0, -1);
        }
        for (int k = 0; k < di.length; ++k) {
            HierarchyInterface[] hi = di[k].getHierarchies(0, -1);
            LevelInterface[] li = null;
            for (int i = 0; i < hi.length; ++i) {
                li = hi[i].getLevels(0, -1);
                for (int j = 0; j < li.length; ++j) {
                    if (this._level != null && this._level.equals(li[j]) && !(this._level.isAnalysisLevel() || this._level.isStatisticLevel())) {
                        asl.add(asl.count(), (Object)this._level.getLabel().trim(), (Object)this._member.getLabel().trim());
                        continue;
                    }
                    Object[] drill = ((Level)li[j]).getDrillSubset();
                    if (drill != null && drill.length > 0) {
                        asl.add(asl.count(), (Object)li[j].getLabel().trim(), (Object)((String)drill[0]).trim());
                        continue;
                    }
                    asl.add(asl.count(), (Object)li[j].getLabel().trim(), null);
                }
            }
        }
        if (this._member != null) {
            ParentNode n;
            Level l = (Level)((Member)n).getLevel();
            for (n = this._member; n != null; n = (ParentNode)n.getParent()) {
                Member prevn = n;
                l = (Level)((Member)n).getLevel();
                if (prevn != n) {
                    if (l.isAnalysisLevel() || l.isStatisticLevel()) continue;
                    asl.set((Object)l.getLabel().trim(), (Object)n.getLabel().trim());
                    continue;
                }
                break;
            }
        } else if (this._tupleList != null) {
            for (int i = 0; i < this._tupleList.count(); ++i) {
                if (this._tupleList.getName(i).equals("_ANLSYS_") || this._tupleList.getName(i).equals("_STATS_")) continue;
                asl.set((Object)this._tupleList.getName(i), (Object)this._tupleList.getString(i).trim());
            }
        }
        asl.removeAll(null);
        return this.aslToString(asl);
    }

    private String aslToString(AssociationList asl) {
        Enumeration aslEnum = asl.getPairs();
        String listString = null;
        while (aslEnum.hasMoreElements()) {
            Pair aslPair = (Pair)aslEnum.nextElement();
            String pairString = Message.format((String)RB.getStringResource(RB_KEY, "pair.txt"), (Object)aslPair.getFirst(), (Object)aslPair.getSecond());
            if (listString == null) {
                listString = pairString;
                continue;
            }
            listString = Message.format((String)RB.getStringResource(RB_KEY, "list.txt"), (Object)listString, (Object)pairString);
        }
        return listString;
    }

    public String getDatasetName() throws TableException {
        int axis = -1;
        if (this._tupleList == null) {
            if (this._member != null) {
                this._tupleList = Member.tupleToHList(this._member);
                Axis a = (Axis)this._member.getDelegate().getRootParent();
                axis = a.getOrdinal();
            } else {
                this._tupleList = new HList();
            }
        }
        HListInterface info = null;
        info = this._imddb instanceof MultidimensionalTableV3Interface && (this._commandMask & 1L) != 0L ? ((MultidimensionalTableV3Interface)this._imddb)._performMaskAction(this._commandMask, axis, (HListInterface)this._tupleList) : this._imddb._performAction(this._commandName, axis, (HListInterface)this._tupleList);
        if (info.find("DETAILDS", 1, 0) < 0) {
            throw new TableException(info.getList(0).getString(0));
        }
        return info.getString("DETAILDS");
    }

    public void refreshDialog(String label, String dataSetName) throws TableException {
        if (this.newdsi == null) {
            RemoteBaseClient rbc = (RemoteBaseClient)((Object)this._imddb);
            Rocf rocf = rbc._RemoteObject_getClassFactory();
            try {
                this.newdsi = (DataSetInterface)rocf.newInstance(DataSetInterface.class, rbc._RemoteObject_getContext());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } else {
            Object immdbWorkspace;
            Object dsiWorkspace = ((RemoteBaseClient)((Object)this.newdsi))._RemoteObject_getContext()._getWorkspace();
            if (dsiWorkspace != (immdbWorkspace = ((RemoteBaseClient)((Object)this._imddb))._RemoteObject_getContext()._getWorkspace()) || ((RemoteBaseClient)((Object)this.newdsi))._RemoteObject_getContext()._getWorkspace() == null) {
                this.newdsi = null;
            } else {
                this.newdsi.setDataSet("");
            }
        }
        if (dataSetName != null && !dataSetName.equals("")) {
            this.newdsi.setDataSet(dataSetName);
            this.newdsi.setColumnInfoUsed("LABEL");
        }
        if (dd == null) {
            Frame f = this._view != null ? Util.getParentFrame(this._view) : new Frame();
            dd = new ReusableDetailDataDialog(f, (StaticTableInterface)this.newdsi);
            try {
                Util.centerOverWindow(dd, f);
            }
            catch (IllegalComponentStateException e) {
                Dimension size = dd.getSize();
                Dimension screenSize = dd.getToolkit().getScreenSize();
                dd.setLocation(screenSize.width - size.width, 0);
            }
        } else {
            dd.setPanelModel((StaticTableInterface)this.newdsi);
        }
        dd.updateLabel(label);
        dd.setSize(new Dimension(500, 300));
        dd.setVisible(true);
        dd.toFront();
    }

    public int getAppletID() {
        Object applet = GlobalInfoTable.getObject();
        if (applet != null) {
            return System.identityHashCode(applet);
        }
        return 0;
    }

    @Override
    public long getMask() {
        return 1L;
    }

    @Override
    public String getText() {
        return this._commandName != null ? this._commandName : RB.getStringResource("showDetail.txt");
    }

    private final class ReusableDetailDataDialog
    extends DetailDataDialog {
        public ReusableDetailDataDialog(Frame f, StaticTableInterface table) {
            super(f, table);
        }

        @Override
        public void dispose() {
            dd = null;
            if (ShowDetailCommand.this.newdsi != null && ((RemoteBaseClient)((Object)ShowDetailCommand.this.newdsi))._RemoteObject_getContext().isConnected()) {
                ShowDetailCommand.this.newdsi.close();
            }
            super.dispose();
        }
    }
}

