/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.mdtable.commands;

import com.sas.awt.util.ChangeCursorCommand;
import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.collection.Dictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.Hierarchy;
import com.sas.sasserver.mdtable.Level;
import com.sas.sasserver.mdtable.Member;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.MultidimensionalTableV2Interface;
import com.sas.sasserver.mdtable.MultidimensionalTableV3Interface;
import com.sas.sasserver.mdtable.ParentNode;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.sasserver.mdtable.commands.ComputedValuesCommand;
import com.sas.sasserver.mdtable.commands.ExportToExcelCommand;
import com.sas.sasserver.mdtable.commands.FindCommand;
import com.sas.sasserver.mdtable.commands.QueryCommand;
import com.sas.sasserver.mdtable.commands.RB;
import com.sas.sasserver.mdtable.commands.RangeTypesCommand;
import com.sas.sasserver.mdtable.commands.ShowDetailCommand;
import com.sas.sasserver.mdtable.commands.SortNameCommand;
import com.sas.sasserver.mdtable.commands.SubsetsCommand;
import com.sas.sasserver.mdtable.commands.TopNCommand;
import com.sas.sasserver.mdtable.commands.TotalsCommand;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.ApplyInterface;
import com.sas.util.Command;
import com.sas.util.CommandManager;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.MessageBoxErrorHandler;
import com.sas.util.errorhandlers.PrintlnErrorHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Enumeration;

public class MDCommand
implements Command {
    public static final long SHOW_DETAIL_DATA_COMMAND = 1L;
    public static final long COMPUTED_VALUES_COMMAND = 2L;
    public static final long TOTALS_COMMAND = 4L;
    public static final long SUBSETS_COMMAND = 8L;
    public static final long EXCEPTION_HIGHLIGHTING_COMMAND = 16L;
    public static final long EXPORT_TO_EXCEL_COMMAND = 32L;
    public static final long SORT_COMMAND = 8192L;
    public static final long SORT_LABELS_COMMAND = 16384L;
    public static final long RANK_COMMAND = 262144L;
    public static final long FIND_LABEL_COMMAND = 32768L;
    public static final long QUERY_COMMAND = 65536L;
    public static final long CUSTOM_COMMANDS_MASK = 524288L;
    public static final long COLLAPSE_COMMAND = 64L;
    public static final long DOWN_COMMAND = 128L;
    public static final long DRILLDOWN_COMMAND = 256L;
    public static final long EXPAND_COMMAND = 512L;
    public static final long LEFT_COMMAND = 1024L;
    public static final long RIGHT_COMMAND = 2048L;
    public static final long UP_COMMAND = 4096L;
    public static final long NAVIGATION_COMMANDS_MASK = 8128L;
    public static final long ALL_COMMANDS_MASK = 917503L;
    private static final long CLIENT_COMMANDS_MASK = 385084L;
    protected long _commandMask;
    protected String _commandName;
    protected Member _member;
    protected MultidimensionalTableInterface _imddb;
    protected Component _view;
    protected AssociationList _pairs;
    protected Axis _axis;
    private transient Level _prevLevel;
    private transient Level _nextLevel;
    private transient int[] _preDrillMagnitude;
    protected transient Level _level;
    protected transient ChangeCursorCommand changeCursorCommand;
    protected static final String RB_KEY = "MDCommand.";
    private static String LINESEPARATOR = System.getProperty("line.separator");

    public static Command[] getCommands(Level level) {
        Command[] commands = CommandManager.getEmptyCommandArray();
        try {
            MultidimensionalTableInterface mddb = level.getImddb();
            if (mddb instanceof MultidimensionalTableV3Interface) {
                long masks = ((MultidimensionalTableV3Interface)mddb).getCommandsMask();
                long[] serverMasks = new long[]{0L};
                Axis axis = null;
                DimensionInterface d = level.getDimension();
                if (d != null) {
                    axis = (Axis)d.getAxis();
                }
                int ordinal = -1;
                if (axis != null) {
                    LevelInterface[] l = axis.getLevels();
                    for (int i = 0; i < l.length; ++i) {
                        if (!l[i].equals(level)) continue;
                        ordinal = i;
                        break;
                    }
                }
                if (axis != null) {
                    long[][] m = ((MultidimensionalTableV3Interface)mddb).getCommandsMasks(axis.getOrdinal(), -1, -1);
                    if (m.length == 1) {
                        ordinal = 0;
                    }
                    long[] sm = m[ordinal];
                    serverMasks[0] = sm[0];
                }
                if (serverMasks[0] < 0L) {
                    serverMasks[0] = 0L;
                }
                serverMasks[0] = serverMasks[0] | 0x5E03CL;
                commands = MDCommand.validCommands(level, masks &= serverMasks[0]);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return commands;
    }

    private static Command[] validCommands(Level level, long masks) {
        int cnt;
        int i;
        HList hl;
        OrderedCollection oc = new OrderedCollection();
        MultidimensionalTableInterface mddb = level.getImddb();
        if ((masks & 0x100L) != 0L) {
            oc.add((Object)new MDCommand(256L, level));
        }
        if ((masks & 0x80L) != 0L) {
            oc.add((Object)new MDCommand(128L, level));
        }
        if ((masks & 0x1000L) != 0L) {
            oc.add((Object)new MDCommand(4096L, level));
        }
        if ((masks & 0x200L) != 0L) {
            oc.add((Object)new MDCommand(512L, level));
        }
        if ((masks & 0x40L) != 0L) {
            oc.add((Object)new MDCommand(64L, level));
        }
        if ((masks & 0x400L) != 0L) {
            oc.add((Object)new MDCommand(1024L, level));
        }
        if ((masks & 0x800L) != 0L) {
            oc.add((Object)new MDCommand(2048L, level));
        }
        if ((masks & 1L) != 0L) {
            oc.add((Object)new ShowDetailCommand(level));
        }
        if (!level.isStatisticLevel() && !level.isAnalysisLevel()) {
            if ((masks & 0x4000L) != 0L) {
                oc.add((Object)new SortNameCommand(level));
            }
            if ((masks & 0x8000L) != 0L) {
                oc.add((Object)new FindCommand(level));
            }
        }
        if ((masks & 0x80000L) != 0L && (hl = (HList)mddb._getCustomizations("CUSTOMACTIONSLIST")).itemExists("CUSTOMACTIONSLIST", 1, 0)) {
            HList customActionsList = (HList)hl.getList("CUSTOMACTIONSLIST");
            for (i = 0; i < customActionsList.count(); ++i) {
                oc.add((Object)new MDCommand(customActionsList.getString(i), level));
            }
        }
        if (oc.count() > 0) {
            oc.add((Object)MenuSeparatorCommand.instance());
        }
        if ((masks & 2L) != 0L) {
            oc.add((Object)new ComputedValuesCommand(level));
        }
        if ((masks & 4L) != 0L) {
            oc.add((Object)new TotalsCommand(mddb));
        }
        if ((masks & 8L) != 0L) {
            oc.add((Object)new SubsetsCommand(level));
        }
        if ((masks & 0x10L) != 0L) {
            oc.add((Object)new RangeTypesCommand(mddb));
        }
        if ((masks & 0x10000L) != 0L) {
            oc.add((Object)new QueryCommand(mddb));
        }
        if (ExportToExcelCommand.isExportAllowed() && (masks & 0x20L) != 0L) {
            oc.add((Object)new ExportToExcelCommand(mddb));
        }
        if ((cnt = oc.count()) > 0 && (Command)oc.get(cnt - 1) instanceof MenuSeparatorCommand) {
            Command c = (Command)oc.removeAt(cnt - 1);
            --cnt;
        }
        Command[] commands = new Command[cnt];
        for (i = 0; i < cnt; ++i) {
            commands[i] = (Command)oc.get(i);
        }
        return commands;
    }

    public static Command[] getCommands(Member member) {
        Command[] commands = CommandManager.getEmptyCommandArray();
        try {
            MultidimensionalTableInterface mddb = member.getImddb();
            if (mddb instanceof MultidimensionalTableV3Interface) {
                long masks = ((MultidimensionalTableV3Interface)mddb).getCommandsMask();
                long[] serverMasks = new long[]{0L};
                Axis axis = (Axis)member.getAxis();
                HList hlist = Member.tupleToHList(member);
                int coord = axis.getAxisCoordinate(HList.toStringArray((HListInterface)hlist));
                int ordinal = member.getOrdinal();
                if (axis != null) {
                    long[][] m = ((MultidimensionalTableV3Interface)mddb).getCommandsMasks(axis.getOrdinal(), coord, 1);
                    long[] sm = m[0];
                    serverMasks[0] = sm[ordinal];
                }
                if (serverMasks[0] < 0L) {
                    serverMasks[0] = 0L;
                }
                serverMasks[0] = serverMasks[0] | 0x5E03CL;
                commands = MDCommand.validCommands(member, masks &= serverMasks[0]);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return commands;
    }

    private static Command[] validCommands(Member member, long masks) {
        int cnt;
        int i;
        HList hl;
        Level l;
        OrderedCollection oc = new OrderedCollection();
        MultidimensionalTableInterface mddb = member.getImddb();
        if ((masks & 0x100L) != 0L) {
            oc.add((Object)new MDCommand(256L, member));
        }
        if ((masks & 0x80L) != 0L) {
            oc.add((Object)new MDCommand(128L, member));
        }
        if ((masks & 0x1000L) != 0L) {
            oc.add((Object)new MDCommand(4096L, member));
        }
        if ((masks & 0x200L) != 0L) {
            oc.add((Object)new MDCommand(512L, member));
        }
        if ((masks & 0x40L) != 0L) {
            oc.add((Object)new MDCommand(64L, member));
        }
        if ((masks & 0x400L) != 0L) {
            oc.add((Object)new MDCommand(1024L, member));
        }
        if ((masks & 0x800L) != 0L) {
            oc.add((Object)new MDCommand(2048L, member));
        }
        if ((masks & 1L) != 0L) {
            oc.add((Object)new ShowDetailCommand(member));
        }
        if ((l = (Level)member.getLevel()).isStatisticLevel()) {
            if (MDCommand.isSortAllowed(member)) {
                if ((masks & 0x2000L) != 0L) {
                    oc.add((Object)new SortNameCommand(member));
                }
                if ((masks & 0x40000L) != 0L) {
                    oc.add((Object)new TopNCommand(262144L, member));
                }
            }
            if ((masks & 0x8000L) != 0L) {
                oc.add((Object)new FindCommand(member));
            }
        } else if (!l.isStatisticLevel() && !l.isAnalysisLevel()) {
            if ((masks & 0x4000L) != 0L) {
                oc.add((Object)new SortNameCommand(member));
            }
            if ((masks & 0x8000L) != 0L) {
                oc.add((Object)new FindCommand(member));
            }
        }
        if ((masks & 0x80000L) != 0L && (hl = (HList)mddb._getCustomizations("CUSTOMACTIONSLIST")).itemExists("CUSTOMACTIONSLIST", 1, 0)) {
            HList customActionsList = (HList)hl.getList("CUSTOMACTIONSLIST");
            for (i = 0; i < customActionsList.count(); ++i) {
                oc.add((Object)new MDCommand(customActionsList.getString(i), member));
            }
        }
        if (oc.count() > 0) {
            oc.add((Object)MenuSeparatorCommand.instance());
        }
        if ((masks & 2L) != 0L) {
            oc.add((Object)new ComputedValuesCommand(member));
        }
        if ((masks & 4L) != 0L) {
            oc.add((Object)new TotalsCommand(mddb));
        }
        if ((masks & 8L) != 0L) {
            oc.add((Object)new SubsetsCommand(member));
        }
        if ((masks & 0x10L) != 0L) {
            oc.add((Object)new RangeTypesCommand(mddb));
        }
        if ((masks & 0x10000L) != 0L) {
            oc.add((Object)new QueryCommand(mddb));
        }
        if (ExportToExcelCommand.isExportAllowed() && (masks & 0x20L) != 0L) {
            oc.add((Object)new ExportToExcelCommand(mddb));
        }
        if ((cnt = oc.count()) > 0 && (Command)oc.get(cnt - 1) instanceof MenuSeparatorCommand) {
            Command c = (Command)oc.removeAt(cnt - 1);
            --cnt;
        }
        Command[] commands = new Command[cnt];
        for (i = 0; i < cnt; ++i) {
            commands[i] = (Command)oc.get(i);
        }
        return commands;
    }

    public static Command[] getCommands(MultidimensionalTableInterface mddb) throws TableException {
        return MDCommand.getCommands(mddb, -1);
    }

    public static Command[] getCommands(MultidimensionalTableInterface mddb, int ordinal) {
        Command[] commands = CommandManager.getEmptyCommandArray();
        try {
            if (mddb instanceof MultidimensionalTableV3Interface) {
                long masks = ((MultidimensionalTableV3Interface)mddb).getCommandsMask();
                long[] serverMasks = new long[]{0L};
                int axisOrdinal = -1;
                long[][] m = ((MultidimensionalTableV3Interface)mddb).getCommandsMasks(axisOrdinal, ordinal, 1);
                long[] sm = m[0];
                serverMasks[0] = sm[0];
                if (serverMasks[0] < 0L) {
                    serverMasks[0] = 0L;
                }
                serverMasks[0] = serverMasks[0] | 0x5E03CL;
                commands = MDCommand.validCommands(mddb, ordinal, masks &= serverMasks[0]);
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return commands;
    }

    private static Command[] validCommands(MultidimensionalTableInterface mddb, int ordinal, long masks) {
        int cnt;
        OrderedCollection oc = new OrderedCollection();
        Command[] commands = CommandManager.getEmptyCommandArray();
        try {
            if (ordinal >= 0) {
                int[] cellOrdinal = mddb.getAxisCoordinates(ordinal);
                AxisLabelInterface[] colLabels = mddb.getAxis(0).getLabels(cellOrdinal[0]);
                Member m = (Member)colLabels[colLabels.length - 1];
                Level l = (Level)m.getLevel();
                if (l.isAnalysisLevel()) {
                    Member statLabel = new Member(mddb);
                    statLabel.setDelegate(MDCommand.getHiddenStatMember(mddb));
                    statLabel.setParent((ParentNode)((Object)colLabels[colLabels.length - 1]));
                    statLabel.setOrdinal(colLabels.length);
                    m = statLabel;
                    l = (Level)m.getLevel();
                }
                if (l.isStatisticLevel()) {
                    Command[] c = MDCommand.validCommands(m, masks & 0xD7FFEL);
                    if ((masks & 1L) != 0L) {
                        boolean iscv = false;
                        for (int i = 0; i < colLabels.length; ++i) {
                            Level lev = (Level)((Member)colLabels[i]).getLevel();
                            if (lev.isAnalysisLevel() || lev.isStatisticLevel() || !((Member)colLabels[i]).isComputedValue()) continue;
                            iscv = true;
                            break;
                        }
                        if (!iscv) {
                            if (ordinal >= 0) {
                                oc.add((Object)new ShowDetailCommand(null, ordinal, (MultidimensionalTableV3Interface)mddb));
                            } else {
                                oc.add((Object)new ShowDetailCommand(mddb));
                            }
                        }
                    }
                    for (int i = 0; i < c.length; ++i) {
                        oc.add((Object)c[i]);
                    }
                }
            }
        }
        catch (TableException cellOrdinal) {
            // empty catch block
        }
        if ((cnt = oc.count()) > 0 && (Command)oc.get(cnt - 1) instanceof MenuSeparatorCommand) {
            Command c = (Command)oc.removeAt(cnt - 1);
            --cnt;
        }
        commands = new Command[cnt];
        for (int i = 0; i < cnt; ++i) {
            commands[i] = (Command)oc.get(i);
        }
        return commands;
    }

    private static HListInterface ordinalToHList(MultidimensionalTableInterface mddb, int ordinal) {
        HList _tupleList = new HList();
        try {
            int[] cellOrdinal = mddb.getAxisCoordinates(ordinal);
            AxisLabelInterface[] rowLabels = mddb.getAxis(1).getLabels(cellOrdinal[1]);
            _tupleList = Member.tupleToHList((ParentNode)((Object)rowLabels[rowLabels.length - 1]));
            AxisLabelInterface[] colLabels = mddb.getAxis(0).getLabels(cellOrdinal[0]);
            HList clist = Member.tupleToHList((ParentNode)((Object)colLabels[colLabels.length - 1]));
            for (int i = 0; i < clist.count(); ++i) {
                _tupleList.addItem(clist.getItem(i));
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
        return _tupleList;
    }

    public static Member getHiddenStatMember(MultidimensionalTableInterface mddb) throws TableException {
        Dictionary levels = mddb.getAllLevels();
        Enumeration enumer = levels.getItems();
        Level level = null;
        Member statistic = null;
        while (enumer.hasMoreElements()) {
            level = (Level)enumer.nextElement();
            if (!level.isStatisticLevel()) continue;
            statistic = (Member)level.getMember(0);
            break;
        }
        return statistic;
    }

    public static Command[] getCommands(MultidimensionalTableInterface mddb, AssociationList asl, long inclusionMask) throws TableException {
        int coord;
        int count = asl.count();
        if (count == 0) {
            return CommandManager.getEmptyCommandArray();
        }
        String levelName = (String)asl.getKey(0);
        Axis axis = MDCommand.getAxis(mddb, levelName);
        if (axis == null) {
            return CommandManager.getEmptyCommandArray();
        }
        LevelInterface[] levels = axis.getLevels();
        LevelInterface[] tempLevels = new LevelInterface[levels.length];
        System.arraycopy(levels, 0, tempLevels, 0, levels.length);
        levels = tempLevels;
        String[] members = new String[levels.length];
        for (int i = 0; i < members.length; ++i) {
            members[i] = levels[i].getMember(0).getLabel();
        }
        boolean showAllDetailData = false;
        int maxLevel = -1;
        for (int i = 0; i < count; ++i) {
            int l;
            levelName = (String)asl.getKey(i);
            for (l = 0; l < levels.length; ++l) {
                LevelInterface level = levels[l];
                if (level == null || !level.getName().equals(levelName) && !level.getLabel().equals(levelName)) continue;
                levels[l] = null;
                break;
            }
            if (l == levels.length) {
                return CommandManager.getEmptyCommandArray();
            }
            members[l] = (String)asl.get(i);
            if (l <= maxLevel) continue;
            maxLevel = l;
        }
        int tupleLength = maxLevel + 1;
        if (tupleLength < members.length) {
            String[] temp = new String[tupleLength];
            System.arraycopy(members, 0, temp, 0, tupleLength);
            members = temp;
        }
        for (int l = 0; l < tupleLength; ++l) {
            if (levels[l] == null) continue;
            showAllDetailData = true;
            break;
        }
        if ((coord = axis.getAxisCoordinate(members)) < 0) {
            return CommandManager.getEmptyCommandArray();
        }
        AxisLabelInterface[] labels = axis.getLabels(coord);
        if (labels != null && labels.length >= count) {
            Command[] cmds = MDCommand.getCommands(labels[tupleLength - 1], inclusionMask);
            if (showAllDetailData && (inclusionMask & 1L) != 0L && cmds != null) {
                for (int i = 0; i < cmds.length; ++i) {
                    if (!(cmds[i] instanceof ShowDetailCommand)) continue;
                    cmds[i] = new ShowDetailCommand(mddb);
                    break;
                }
            }
            return cmds;
        }
        return CommandManager.getEmptyCommandArray();
    }

    private static Command[] getCommands(AxisLabelInterface axisLabel, long inclusionMask) throws TableException {
        Command[] commands = CommandManager.getEmptyCommandArray();
        if (axisLabel != null && axisLabel instanceof Member) {
            MultidimensionalTableInterface mddb = ((Member)axisLabel).getImddb();
            long masks = ((MultidimensionalTableV3Interface)mddb).getCommandsMask();
            long[] serverMasks = new long[]{0L};
            Axis axis = (Axis)axisLabel.getAxis();
            HList hlist = Member.tupleToHList((Member)axisLabel);
            int coord = axis.getAxisCoordinate(HList.toStringArray((HListInterface)hlist));
            int ordinal = ((Member)axisLabel).getOrdinal();
            if (axis != null) {
                long[][] m = ((MultidimensionalTableV3Interface)mddb).getCommandsMasks(axis.getOrdinal(), coord, 1);
                long[] sm = m[0];
                serverMasks[0] = sm[ordinal];
            }
            if (serverMasks[0] < 0L) {
                serverMasks[0] = 0L;
            }
            serverMasks[0] = serverMasks[0] | 0x5E03CL;
            inclusionMask &= serverMasks[0];
            commands = MDCommand.validCommands((Member)axisLabel, inclusionMask &= masks);
        }
        return commands;
    }

    private static Axis getAxis(MultidimensionalTableInterface mddb, String levelName) throws TableException {
        int cnt = mddb.getAxisCount();
        Axis a = null;
        boolean found = false;
        for (int i = 0; i < cnt; ++i) {
            a = (Axis)mddb.getAxis(i);
            LevelInterface[] levels = a.getLevels();
            for (int j = 0; j < levels.length; ++j) {
                LevelInterface l = levels[j];
                if (!l.getName().equals(levelName) && !l.getLabel().equals(levelName)) continue;
                return a;
            }
        }
        return a;
    }

    private static boolean isSortAllowed(Member member) {
        Level level = (Level)member.getLevel();
        if (level != null && level.isStatisticLevel()) {
            boolean isV8 = ((MultidimensionalTableV2Interface)level.getImddb()).isStatisticsPerMeasureSupported();
            if (!isV8) {
                try {
                    Axis a = (Axis)level.getImddb().getAxis(1);
                    LevelInterface[] levels = a.getLevels();
                    if (a != null && levels != null && levels.length > 1) {
                        return false;
                    }
                }
                catch (TableException te) {
                    return false;
                }
                return level != null && !level.isAnalysisLevel();
            }
            Member meas = (Member)member.getParent();
            Level measLevel = (Level)meas.getLevel();
            return !measLevel.isAnalysisLevel() || !meas.isComputedValue();
        }
        return false;
    }

    public MDCommand() {
    }

    public MDCommand(MultidimensionalTableInterface imddb) {
        this._imddb = imddb;
    }

    public MDCommand(long mask, MultidimensionalTableInterface imddb) {
        this(imddb);
        this._commandMask = mask;
    }

    public MDCommand(long mask, Level level) {
        this(mask, level != null ? level.getImddb() : null);
        DimensionInterface d;
        this._level = level;
        if (level != null && (d = level.getDimension()) != null) {
            this._axis = (Axis)d.getAxis();
        }
    }

    public MDCommand(long mask, Member member) {
        this(mask, member != null ? (Level)member.getLevel() : null);
        this._member = member;
    }

    public MDCommand(Axis axis, long mask, AssociationList tupleList) {
        this._axis = axis;
        this._imddb = axis.getImddb();
        this._pairs = tupleList;
        this._commandMask = mask;
        this.setLevel(tupleList);
    }

    public MDCommand(String name, MultidimensionalTableInterface imddb) {
        this._commandName = name;
        this._imddb = imddb;
        this.setCommandMask();
    }

    public MDCommand(String name, Member member) {
        this(name, member != null ? (Level)member.getLevel() : null);
        this._member = member;
    }

    public MDCommand(String name, Level level) {
        this(name, level != null ? level.getImddb() : null);
        DimensionInterface d;
        this._level = level;
        if (level != null && (d = level.getDimension()) != null) {
            this._axis = (Axis)d.getAxis();
        }
    }

    public MDCommand(Axis axis, String commandName, AssociationList tupleList) {
        this._axis = axis;
        this._imddb = axis.getImddb();
        this._pairs = tupleList;
        this._commandName = commandName;
        this.setLevel(tupleList);
    }

    public void setView(Component view) {
        this._view = view;
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object data) {
        this.changeCursorCommand = null;
        try {
            if (data != null && data instanceof Component) {
                this.setView((Component)data);
                Container c = MDCommand.getTopParent((Component)data);
                this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
                Util.apply(c, (ApplyInterface)this.changeCursorCommand);
            }
            this.performAction();
        }
        catch (TableException te) {
            ErrorHandlerInterface eh = this._view != null ? new MessageBoxErrorHandler(Util.getParentFrame(this._view)) : new PrintlnErrorHandler();
            eh.handleError(this._imddb, new Message(te.getMessage()), "");
        }
        finally {
            if (this.changeCursorCommand != null) {
                this.changeCursorCommand.undoAll();
            }
        }
    }

    protected void resetCursor() {
    }

    public static Container getTopParent(Component comp) {
        while (!(comp instanceof Frame) && comp.getParent() != null) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public String getText() {
        if (this._commandMask == 256L) {
            this._commandName = RB.getStringResource("drilldown.txt");
        }
        if (this._commandMask == 128L) {
            this._commandName = RB.getStringResource("down.txt");
        }
        if (this._commandMask == 4096L) {
            this._commandName = RB.getStringResource("up.txt");
        }
        if (this._commandMask == 512L) {
            this._commandName = RB.getStringResource("expand.txt");
        }
        if (this._commandMask == 64L) {
            this._commandName = RB.getStringResource("collapse.txt");
        }
        if (this._commandMask == 1024L) {
            this._commandName = RB.getStringResource("left.txt");
        }
        if (this._commandMask == 2048L) {
            this._commandName = RB.getStringResource("right.txt");
        }
        return this._commandName;
    }

    private String maskName() {
        if (this._commandMask == 256L) {
            this._commandName = RB.getStringResource("drilldown.txt");
        }
        if (this._commandMask == 128L) {
            this._commandName = RB.getStringResource("down.txt");
        }
        if (this._commandMask == 4096L) {
            this._commandName = RB.getStringResource("up.txt");
        }
        if (this._commandMask == 512L) {
            this._commandName = RB.getStringResource("expand.txt");
        }
        if (this._commandMask == 64L) {
            this._commandName = RB.getStringResource("collapse.txt");
        }
        if (this._commandMask == 1024L) {
            this._commandName = RB.getStringResource("left.txt");
        }
        if (this._commandMask == 2048L) {
            this._commandName = RB.getStringResource("right.txt");
        }
        return this._commandName;
    }

    public void setText(String text) {
        this._commandName = text;
    }

    public long getMask() {
        if (this._commandMask == 0L) {
            this.setCommandMask();
        }
        return this._commandMask;
    }

    private String getMessage(HListInterface info) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < info.getList(0).count(); ++i) {
            sbuf.append(info.getList(0).getString(i));
            sbuf.append(LINESEPARATOR);
        }
        return sbuf.toString();
    }

    public synchronized void performAction() throws TableException {
        if (this._commandName != null && this._commandName == RB.getStringResource("totalsOn.txt") || this._commandName == RB.getStringResource("totalsOff.txt")) {
            this._level.setTotalState(!this._level.getTotalState());
            this._imddb.setTotals();
            this._imddb.refreshTable(this._axis, null);
        } else if (this._axis != null) {
            this.setPreDrillMagnitude();
            HList tupleList = null;
            if (this._pairs != null) {
                tupleList = this.AssociationListToHList(this._pairs);
            } else if (this._member == null && this._level != null) {
                tupleList = Level.tupleToHList(this._level);
            } else if (this._member != null) {
                tupleList = Member.tupleToHList(this._member);
            }
            if (this._commandMask > 0L && (this._commandMask & 0x80L) != 0L || this._commandName != null && this._commandName.equalsIgnoreCase(RB.getStringResource(RB_KEY, "down.txt"))) {
                this._level.setDrillSubset(new String[]{SubsetInterface.Down});
                this._level._isDown = true;
            }
            HListInterface info = null;
            info = this._imddb instanceof MultidimensionalTableV3Interface && this._commandMask > 0L && (this._commandMask & 0xFFFFFFFFFFF7FFFFL) != 0L ? ((MultidimensionalTableV3Interface)this._imddb)._performMaskAction(this._commandMask, this._axis.getOrdinal(), (HListInterface)tupleList) : this._imddb._performAction(this._commandName, this._axis.getOrdinal(), (HListInterface)tupleList);
            if (info != null && info.find("ERROR", 1, 0) >= 0) {
                this._imddb.refreshTable();
                throw new TableException(this.getMessage(info));
            }
            this.setModelChanged(this._axis, info);
        }
    }

    public void setModelChanged(Axis a, HListInterface info) {
        if (info == null) {
            return;
        }
        if (this._axis == null) {
            this._axis = a;
        }
        try {
            AxisInterface[] axes = this._imddb.getAxes(0, -1);
            if (info.getItem("AXISCHANGED") != null) {
                double d = info.getDouble("AXISCHANGED");
                MemberInterface toMember = null;
                if (d == 0.0) {
                    this._imddb.refreshTable();
                } else if (d == 7.0) {
                    for (int i = 0; i < axes.length; ++i) {
                        if (axes[i].equals(a)) continue;
                        this._imddb.refreshTable((Axis)axes[i], null);
                    }
                } else if (d == 6.0) {
                    this._imddb.refreshTable(a, null);
                    if (this._commandName == RB.getStringResource("totalsOn.txt")) {
                        this._level.setTotalState(true);
                    } else {
                        this._level.setTotalState(false);
                    }
                } else if (d == 3.0) {
                    Level pl = this.getPrevLevel(this._level);
                    AxisLabelInterface toDrillMember = null;
                    if (pl != null) {
                        toDrillMember = this.getToDrillMember(pl);
                        pl.reset();
                        if (toDrillMember != null) {
                            String memLabel = toDrillMember.getLabel();
                            toMember = this.getMember(memLabel, pl);
                            if (toMember != null) {
                                ((Member)toDrillMember).setDelegate((Member)toMember);
                                ((Member)toDrillMember).setName(null);
                                ((Member)toDrillMember).setLabel(null);
                            } else {
                                toDrillMember = null;
                            }
                        }
                        this._imddb.getSubsets();
                        if (pl._upMember != null) {
                            pl._upMember = null;
                        } else {
                            if (pl.getMemberCount() >= 0) {
                                toMember = pl.getMember(0);
                            }
                            if (pl._isDown) {
                                pl.setDrillSubset(new String[]{null});
                                pl._isDown = false;
                            }
                        }
                    }
                    if (toDrillMember != null) {
                        toMember = toDrillMember.getMember();
                    }
                    this._imddb.refreshTable(null, toDrillMember);
                } else if (d == 1.0 || d == 2.0 || d == 4.0 || d == 5.0) {
                    this._imddb.getSubsets();
                    if ((d == 1.0 || d == 2.0) && d == 1.0) {
                        this._level._upMember = this._member;
                    }
                    this._imddb.refreshTable(null, null);
                    toMember = d == 1.0 || d == 2.0 ? this.getToMember(this._axis, this._level) : this.getToMember(this._axis, this.getPrevLevel(this._level));
                }
                this._imddb.refreshTable((int)d, this._member, toMember);
            } else if (info != null && info.getItem("AXISLABELCHANGED") != null) {
                double how = info.getDouble("AXISLABELCHANGED");
                if (this._member == null) {
                    this._imddb.refreshTable(a, null);
                } else {
                    this._imddb.refreshTable(this._member, (int)how);
                }
            }
        }
        catch (TableException te) {
            te.printStackTrace();
        }
    }

    private void setCommandMask() {
        if (this._commandName != null) {
            if (this._commandName.equalsIgnoreCase("expand")) {
                this._commandMask = 512L;
            } else if (this._commandName.equalsIgnoreCase("drilldown")) {
                this._commandMask = 256L;
            } else if (this._commandName.equalsIgnoreCase("down")) {
                this._commandMask = 128L;
            } else if (this._commandName.equalsIgnoreCase("up")) {
                this._commandMask = 4096L;
            } else if (this._commandName.equalsIgnoreCase("collapse")) {
                this._commandMask = 64L;
            } else if (this._commandName.equalsIgnoreCase("left")) {
                this._commandMask = 1024L;
            } else if (this._commandName.equalsIgnoreCase("right")) {
                this._commandMask = 2048L;
            } else if (this._commandName.indexOf("Show Detail") >= 0) {
                this._commandMask = 1L;
            }
        }
    }

    private void setLevel(AssociationList asl) {
        if (asl == null || asl.count() <= 0) {
            return;
        }
        try {
            if (this._imddb instanceof MultidimensionalTableV3Interface) {
                this._level = ((MultidimensionalTableV3Interface)this._imddb).findLevel((String)asl.getKey(0));
            } else {
                Dictionary levels = this._imddb.getAllLevels();
                this._level = (Level)levels.get(asl.getKey(0));
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    private void setPreDrillMagnitude() {
        try {
            AxisInterface[] axes = this._imddb.getAxes(0, -1);
            this._preDrillMagnitude = new int[axes.length];
            for (int i = 0; i < axes.length; ++i) {
                this._preDrillMagnitude[i] = axes[i].getMagnitude();
            }
        }
        catch (TableException te) {
            te.printStackTrace();
        }
    }

    private boolean refreshAllAxes(AxisInterface[] axes) {
        try {
            for (int i = 0; axes != null && i < axes.length; ++i) {
                if (axes[i].equals(this._axis)) continue;
                ((Axis)axes[i]).reset();
                if (this._preDrillMagnitude[i] == axes[i].getMagnitude()) continue;
                return true;
            }
        }
        catch (TableException te) {
            return false;
        }
        return false;
    }

    private MemberInterface getMember(String memberLabel, Level l) throws TableException {
        MemberInterface member = null;
        if (this._imddb instanceof MultidimensionalTableV2Interface) {
            MultidimensionalTableV2Interface v2Imddb = (MultidimensionalTableV2Interface)this._imddb;
            int index = -1;
            index = v2Imddb.findMember(l.getName(), memberLabel, true);
            if (index != -1) {
                member = l.getMember(index);
            }
        } else {
            try {
                int numKids = l.getMemberCount();
                for (int j = 0; j < numKids && !memberLabel.equals((member = l.getMember(j)).getLabel()); ++j) {
                    member = null;
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        return member;
    }

    protected HList AssociationListToHList(AssociationList asl) {
        HList hList = new HList();
        int cnt = asl.count();
        for (int i = 0; i < cnt; ++i) {
            String key = (String)asl.getKey(i);
            hList.addItem((String)asl.get((Object)key), 0, key);
        }
        return hList;
    }

    private Level getPrevLevel(Level level) {
        if (this._prevLevel == null || level != this._level) {
            this.setLevel(level);
        }
        return this._prevLevel;
    }

    private Level getNextLevel(Level level) {
        if (this._nextLevel == null || level != this._level) {
            this.setLevel(level);
        }
        return this._nextLevel;
    }

    private void setLevel(Level level) {
        Hierarchy h = (Hierarchy)level.getParent();
        try {
            LevelInterface[] la = h.getLevels(0, -1);
            boolean found = false;
            for (int i = 0; !found && i < la.length; ++i) {
                if (la[i] != level) continue;
                if (i > 0) {
                    this._prevLevel = (Level)la[i - 1];
                }
                if (i + 1 < la.length) {
                    this._nextLevel = (Level)la[i + 1];
                }
                found = true;
                break;
            }
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    private MemberInterface getToMember(Axis a, Level pl) {
        Level l;
        Member m = null;
        if (pl != null && (l = this.getNextLevel(pl)) != null) {
            try {
                AxisLabelInterface[] ali = a.getLabels(0);
                int offset = l.getAxisOffset();
                if (offset >= 0 && offset < ali.length) {
                    m = (Member)ali[offset].getMember();
                }
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        return m;
    }

    private AxisLabelInterface getToDrillMember(Level pl) {
        AxisLabelInterface toDrillMember = null;
        if (pl != null) {
            Level prevLevel = pl;
            while (pl != null && pl._isDown && prevLevel != (pl = this.getPrevLevel(prevLevel))) {
                prevLevel = pl;
            }
            Object[] subs = pl.getDrillSubset();
            String drill = null;
            if (subs != null) {
                drill = (String)subs[0];
            }
            if (pl._upMember != null && ((Member)pl._upMember).getDelegate() != null && !((Member)((Member)pl._upMember).getDelegate()).getLabel().equals(drill)) {
                Member m = new Member(pl, this._imddb);
                m.setName(null);
                m.setLabel(drill);
                ((Member)pl._upMember).setDelegate(m);
                ((Member)pl._upMember).setName(m.getName());
                ((Member)pl._upMember).setLabel(m.getLabel());
                toDrillMember = pl._upMember;
            } else {
                toDrillMember = pl._upMember;
            }
        }
        return toDrillMember;
    }

    public Object clone() throws CloneNotSupportedException {
        return new MDCommand(this._commandName, this._member);
    }
}

